-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bs = require 'mc.bitstring'
local CX5 = require 'hardware_config.CX5'


local BF2 = {
    protocol_dependencies = { ncsi_standard = { endpoint = nil }, ncsi_mellanox = { endpoint = nil } },
    properties = {
        GetOSStatus = {
            protocol = 'ncsi_mellanox',
            action = 'on_schedule',
            period_in_sec = 2,
            request = {
                channel_id = 0x1F,
                cmd_mellanox = 0x00,
                mellanox_cmd_id = 0x13,
                parameter = 0x17,
                extra_cmd = 0x00
            },
            response = function(data)
                local r = bs.new([[<<
                    _:32,
                    os_status:8
                >>]]):unpack(data, true)
                return r.os_status
            end
        }
    }

}
return {
    smbus = nil,
    mctp = function(endpoint)
        local bf2 = CX5.mctp(endpoint)
        for k, v in pairs(BF2.properties) do
            bf2.properties[k] = v
        end
        return bf2
    end
}