-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 定义模块需要的通用常量和方法
local dirty_test_def = {}
dirty_test_def.cmd = {
    GET_CAPABILITY = 0,
    GET_RESULT = 1,
    INIT = 2,
    START = 3,
    CLOSE = 4,
    GET_FFT = 5,
    SET_FFT = 6
}

dirty_test_def.rsp_code = {
    SUCCESS = 0,
    FAIL = 1,
    UNSUPPORT = 2
}

dirty_test_def.dirty_support_type = {
    NOT_SUPPORT = 0,    -- 不支持
    SUPPORT = 1     -- 支持
}

dirty_test_def.run_code = {
    [0] = 'UNINITIALIZED',
    [1] = 'INITIALIZED',
    [2] = 'RUNNING'
}

dirty_test_def.result_code = {
    [0] = 'RUNNING',
    [1] = 'PENDING',
    [2] = 'ABNORMAL'
}

dirty_test_def.dirty_state = {
    UNINITIALIZED = 'Uninitialized',
    INITIALIZED = 'Initialized',
    PENDING = 'Pending',
    RUNNING = 'Running',
    UNKNOWN = 'Unknown',
    ABNORMAL = 'Abnormal'
}

return dirty_test_def