-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local log = require 'mc.logging'
local skynet = require 'skynet'

local c_optical_channel = c_object('OpticalModuleChannel')

local default_optical_channel_value<const> = {
    BiasCurrentMilliAmps = 0,
    RXPowerMilliWatts = 0,
    TXPowerMilliWatts = 0
}

function c_optical_channel:ctor()
end

function c_optical_channel.before_add_object(object)
    return false
end

function c_optical_channel:init()
    self:register_mdb_objects()
    c_optical_channel.super.init(self)
end

function c_optical_channel:update_prop_single(prop_name, v, alarm)
    if v ~= nil then
        self[prop_name] = v + alarm
    end
end

function c_optical_channel:reset_diagnostic_info()
    for prop_name, v in pairs(default_optical_channel_value) do
        self[prop_name] = v
    end
end

return c_optical_channel
