-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local port_npu = require 'device.class.nic_mgmt.port.port_npu'
local port_mac = require 'device.class.nic_mgmt.port.port_mac'
local port_property_listen = require 'device.class.nic_mgmt.port.port_property_listen'

local port_manage = {}

function port_manage.init_npu_port(orm_obj)
    port_npu.init(orm_obj)
end

function port_manage.register_property_changed_callback(orm_obj, bus)
    port_property_listen.register_property_changed_callback(orm_obj, bus)
end

function port_manage.update_mac_addr_from_db(orm_obj)
    port_mac.update_mac_addr_from_db(orm_obj)
end

return port_manage