-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local optical_module_npu = require 'device.class.nic_mgmt.om.om_npu'
local property_listen = require 'device.class.nic_mgmt.om.om_property_listen'
local optical_module_cpu = require 'device.class.nic_mgmt.om.om_cpu'

local optical_module_manage = {}

function optical_module_manage.init_npu_optical(orm_obj, npu_id)
    optical_module_npu.init(orm_obj, npu_id)
end

function optical_module_manage.register_property_changed_callback(orm_obj)
    property_listen.register_property_changed_callback(orm_obj)
end

function optical_module_manage.start_get_optical_info_task(orm_obj)
    optical_module_cpu.start_get_optical_info_task(orm_obj)
end

return optical_module_manage