-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local port_defs = require 'device.class.nic_mgmt.port.port_defs'
local optical_module_manage = require 'device.class.nic_mgmt.om.om_manage'

local optical_obj_init = {}

function optical_obj_init.init(orm_obj)
    log:notice('optical module orm obj init start, NetworkAdapterId(%s), PortID(%s)',
        orm_obj.NetworkAdapterId, orm_obj.PortID)
    local port_orm_obj = orm_obj.parent
    orm_obj.channel_num = port_orm_obj.PortID + 1
    local card_orm_obj = port_orm_obj.parent
    if card_orm_obj.Model == port_defs.NPU_MODEL then
        log:notice('[NPU] get_info_from_imu start, slot = %s, npuid = %s',
            card_orm_obj.SlotNumber, port_orm_obj.NpuID)
        optical_module_manage.init_npu_optical(orm_obj, port_orm_obj.NpuID)
    else
        optical_module_manage.register_property_changed_callback(orm_obj)
        optical_module_manage.start_get_optical_info_task(orm_obj)
    end
    log:notice('optical module orm obj init success, NetworkAdapterId(%s), PortID(%s)',
        orm_obj.NetworkAdapterId, orm_obj.PortID)
end

return optical_obj_init