-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local card_init_id = require 'device.class.nic_mgmt.card.card_init_id'
local card_asset_data = require 'device.class.nic_mgmt.card.card_asset_data'
local card_hot_pluggable = require 'device.class.nic_mgmt.card.card_hot_pluggable'
local card_listen_callback = require 'device.class.nic_mgmt.card.card_listen_callback'
local card_npu = require 'device.class.nic_mgmt.card.card_npu'
local card_update_identifier = require 'device.class.nic_mgmt.card.card_update_identifier'

local card_manage = {}

function card_manage.init_asset_data_info(orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_asset_data.init_asset_data_info(orm_obj)
end

function card_manage.update_asset_uuid_info(orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_asset_data.update_asset_uuid_info(orm_obj)
end

function card_manage.register_listen_callback(orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_listen_callback.register_listen_callback(orm_obj)
end

function card_manage.init_id(orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_init_id.init_id(orm_obj)
end

function card_manage.update_1822_port_bdf(ports, orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_update_identifier.update_1822_port_bdf(ports, orm_obj)
end

function card_manage.update_port_bdf(ports, orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_update_identifier.update_port_bdf(ports, orm_obj)
end

function card_manage.update_quater_info(orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_update_identifier.update_quater_info(orm_obj)
end

function card_manage.set_attention_on_bios(orm_obj, bios_state)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    card_hot_pluggable.set_attention_on_bios(orm_obj, bios_state)
end

function card_manage.init_npu_proc(orm_obj)
    if not orm_obj then
        log:error("orm_obj is nil")
        return
    end
    if not orm_obj.Model or not string.match(orm_obj.Model, 'NPU') then
        return
    end
    card_npu.init_npu_proc(orm_obj)
end

return card_manage