-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'

local card_hot_pluggable = {}

local HOTPLUG_STATE<const> = {
    Inoperable = 0, -- 不可操作
    Removable = 1, -- 可拔出
    Uninstalling = 3, -- 卸载中
    Uninstalled = 4 -- 卸载完成
}

local BIOS_STARTUP_POST_STAGE_FINISH<const> = 0xFE -- BIOS启动完成
local NETWORK_POWER_OFF<const> = 0 -- 网卡电源关闭
local SLOT_POWER_OFF<const> = 'Off' -- PCIe槽位电源关闭


-- 根据bios的状态设置属性
function card_hot_pluggable.set_attention_on_bios(orm_obj, bios_state)
    if bios_state == BIOS_STARTUP_POST_STAGE_FINISH then
        if (orm_obj.SlotPowerState == "" and orm_obj.CardPowerGood == NETWORK_POWER_OFF) or
            orm_obj.SlotPowerState == SLOT_POWER_OFF then
            orm_obj.AttentionHotPlugState = HOTPLUG_STATE.Uninstalled
        else
            orm_obj.AttentionHotPlugState = HOTPLUG_STATE.Removable
        end
    else
        orm_obj.AttentionHotPlugState = HOTPLUG_STATE.Inoperable
    end
    log:notice('bios_state:%s, set %s AttentionHotPlugState %s success',
        bios_state, orm_obj.NodeId, orm_obj.AttentionHotPlugState)
end

return card_hot_pluggable