-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local log = require 'mc.logging'
local c_object_manage = require 'mc.orm.object_manage'

local c_bridge_port = c_object('NetworkBridgePort')

function c_bridge_port:ctor()
end

function c_bridge_port:init()
    self.super.init(self)
end

function c_bridge_port.create_mdb_object(value)
    local app = c_object_manage.get_instance().app
    return app:CreateNetworkBridgePort(1, value.BridgeId, value.Id,function (obj)
        log:debug("create network bridge port id(%s port%d), NodeId(%s)", value.BridgeId, value.Id, value.NodeId)
        obj.NodeId = value.NodeId
        obj.BridgeId = value.BridgeId
        obj.Id = value.Id
        obj.Name = value.Name
    end)
end

function c_bridge_port.insert_or_update(value)
    local obj = c_bridge_port.collection:find({BridgeId = value.BridgeId, Id = value.Id})
    if obj then
        obj.NodeId = value.NodeId
        obj.BridgeId = value.BridgeId
        obj.Id = value.Id
        obj.Name = value.Name
    end
    return obj or c_bridge_port.__table(value)
end

function c_bridge_port.get_bridge_port(bridge_id)
    return c_bridge_port.collection:fetch({BridgeId = bridge_id})
end

return c_bridge_port