-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local c_object = require 'mc.orm.object'
local log = require 'mc.logging'
local c_object_manage = require 'mc.orm.object_manage'

local c_bonding_port = c_object('NetworkBondingPort')

function c_bonding_port:ctor()
end

function c_bonding_port:init()
    self.super.init(self)
end

function c_bonding_port.create_mdb_object(value)
    local app = c_object_manage.get_instance().app
    return app:CreateNetworkBondingPort(1, value.TeamId, value.Id,function (obj)
        log:debug("create network bonding port id(%s port%d), NodeId(%s)", value.TeamId, value.Id, value.NodeId)
        obj.NodeId = value.NodeId
        obj.TeamId = value.TeamId
        obj.Id = value.Id
        obj.Name = value.Name
    end)
end

function c_bonding_port.insert_or_update(value)
    local obj = c_bonding_port.collection:find({TeamId = value.TeamId, Id = value.Id})
    if obj then
        obj.NodeId = value.NodeId
        obj.TeamId = value.TeamId
        obj.Id = value.Id
        obj.Name = value.Name
    end
    return obj or c_bonding_port.__table(value)
end

function c_bonding_port.get_bonding_port(team_id)
    return c_bonding_port.collection:fetch({TeamId = team_id})
end

return c_bonding_port