-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

local cont = class()

function cont:ctor(cont_num, default_val)
    self.cont_num = cont_num or 5
    self.stable_val = default_val or '' -- 稳定值
    self.unstable_val = '' -- 未稳定值
    self.unstable_val_cnt = 0 -- 未稳定次数
end

function cont:get_debounced_val(new_val)
    if self.stable_val ~= new_val then
        self.unstable_val = new_val
        self.unstable_val_cnt = self.unstable_val_cnt + 1
    else
        self.unstable_val_cnt = 0
    end

    if self.unstable_val_cnt > self.cont_num then
        self.stable_val = self.unstable_val
        self.unstable_val_cnt = 0
    end

    return self.stable_val
end

return cont
