-- Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--

local bs = require 'mc.bitstring'

local bs_helper = {}

bs_helper.MAC_ADDRESS = bs.new([[<<mac_address:6/string as to_mac_addr>>]], {
    to_mac_addr = function(v)
        return v:gsub('.', function(c)
            return string.format('%02X:', c:byte())
        end):sub(1, -2)
    end
})

bs_helper.IPV4 = bs.new([[<<ipv4:4/string as to_ipv4>>]], {
    to_ipv4 = function(v)
        return v:gsub('.', function(c)
            return string.format('%d.', c:byte())
        end):sub(1, -2)
    end
})

return bs_helper
