-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local VLANs = {}

---@class VLANs.CreateVLANRsp
---@field TaskId integer
local TCreateVLANRsp = {}
TCreateVLANRsp.__index = TCreateVLANRsp
TCreateVLANRsp.group = {}

local function TCreateVLANRsp_from_obj(obj)
    return setmetatable(obj, TCreateVLANRsp)
end

function TCreateVLANRsp.new(TaskId)
    return TCreateVLANRsp_from_obj({TaskId = TaskId})
end
---@param obj VLANs.CreateVLANRsp
function TCreateVLANRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCreateVLANRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVLANRsp.group)
end

TCreateVLANRsp.from_obj = TCreateVLANRsp_from_obj

TCreateVLANRsp.proto_property = {'TaskId'}

TCreateVLANRsp.default = {0}

TCreateVLANRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCreateVLANRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCreateVLANRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVLANRsp.proto_property, errs, need_convert)
    return self
end

function TCreateVLANRsp:unpack(_)
    return self.TaskId
end

VLANs.CreateVLANRsp = TCreateVLANRsp

---@class VLANs.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj VLANs.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

VLANs.Object = TObject

---@class VLANs.CreateVLANReq
---@field Request VLANs.Object
local TCreateVLANReq = {}
TCreateVLANReq.__index = TCreateVLANReq
TCreateVLANReq.group = {}

local function TCreateVLANReq_from_obj(obj)
    return setmetatable(obj, TCreateVLANReq)
end

function TCreateVLANReq.new(Request)
    return TCreateVLANReq_from_obj({Request = Request})
end
---@param obj VLANs.CreateVLANReq
function TCreateVLANReq:init_from_obj(obj)
    self.Request = obj.Request
end

function TCreateVLANReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVLANReq.group)
end

TCreateVLANReq.from_obj = TCreateVLANReq_from_obj

TCreateVLANReq.proto_property = {'Request'}

TCreateVLANReq.default = {VLANs.Object.default}

TCreateVLANReq.struct = {{name = 'Request', is_array = false, struct = VLANs.Object.struct}}

function TCreateVLANReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    VLANs.Object.new(self.Request):validate(prefix, errs, need_convert)

    TCreateVLANReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVLANReq.proto_property, errs, need_convert)
    return self
end

function TCreateVLANReq:unpack(_)
    return self.Request
end

VLANs.CreateVLANReq = TCreateVLANReq

VLANs.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.VLANs', {},
    {CreateVLAN = {'a{ss}a{ss}', 'u', TCreateVLANReq, TCreateVLANRsp}}, {})

return VLANs
