-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Status = {}

---@class Status.FaultCode
---@field FaultCode string
local TFaultCode = {}
TFaultCode.__index = TFaultCode
TFaultCode.group = {}

local function TFaultCode_from_obj(obj)
    return setmetatable(obj, TFaultCode)
end

function TFaultCode.new(FaultCode)
    return TFaultCode_from_obj({FaultCode = FaultCode})
end
---@param obj Status.FaultCode
function TFaultCode:init_from_obj(obj)
    self.FaultCode = obj.FaultCode
end

function TFaultCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultCode.group)
end

TFaultCode.from_obj = TFaultCode_from_obj

TFaultCode.proto_property = {'FaultCode'}

TFaultCode.default = {''}

TFaultCode.struct = {{name = 'FaultCode', is_array = false, struct = nil}}

function TFaultCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultCode', self.FaultCode, 'string', true, errs, need_convert)

    TFaultCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultCode.proto_property, errs, need_convert)
    return self
end

function TFaultCode:unpack(_)
    return self.FaultCode
end

Status.FaultCode = TFaultCode

---@class Status.PowerStatus
---@field PowerStatus integer
local TPowerStatus = {}
TPowerStatus.__index = TPowerStatus
TPowerStatus.group = {}

local function TPowerStatus_from_obj(obj)
    return setmetatable(obj, TPowerStatus)
end

function TPowerStatus.new(PowerStatus)
    return TPowerStatus_from_obj({PowerStatus = PowerStatus or 255})
end
---@param obj Status.PowerStatus
function TPowerStatus:init_from_obj(obj)
    self.PowerStatus = obj.PowerStatus or 255
end

function TPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerStatus.group)
end

TPowerStatus.from_obj = TPowerStatus_from_obj

TPowerStatus.proto_property = {'PowerStatus'}

TPowerStatus.default = {0}

TPowerStatus.struct = {{name = 'PowerStatus', is_array = false, struct = nil}}

function TPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerStatus', self.PowerStatus, 'uint8', true, errs, need_convert)

    TPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerStatus.proto_property, errs, need_convert)
    return self
end

function TPowerStatus:unpack(_)
    return self.PowerStatus
end

Status.PowerStatus = TPowerStatus

---@class Status.FaultState
---@field FaultState integer
local TFaultState = {}
TFaultState.__index = TFaultState
TFaultState.group = {}

local function TFaultState_from_obj(obj)
    return setmetatable(obj, TFaultState)
end

function TFaultState.new(FaultState)
    return TFaultState_from_obj({FaultState = FaultState})
end
---@param obj Status.FaultState
function TFaultState:init_from_obj(obj)
    self.FaultState = obj.FaultState
end

function TFaultState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultState.group)
end

TFaultState.from_obj = TFaultState_from_obj

TFaultState.proto_property = {'FaultState'}

TFaultState.default = {0}

TFaultState.struct = {{name = 'FaultState', is_array = false, struct = nil}}

function TFaultState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultState', self.FaultState, 'uint32', true, errs, need_convert)

    TFaultState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultState.proto_property, errs, need_convert)
    return self
end

function TFaultState:unpack(_)
    return self.FaultState
end

Status.FaultState = TFaultState

---@class Status.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj Status.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

Status.Health = THealth

Status.interface = mdb.register_interface('bmc.kepler.Systems.NetworkAdapter.Status', {
    Health = {'y', nil, true, nil},
    FaultState = {'u', nil, true, nil},
    PowerStatus = {'y', nil, true, 255},
    FaultCode = {'s', nil, true, nil}
}, {}, {})

return Status
