-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Sms = {}

---@class Sms.SetCdevChannelEnabledRsp
local TSetCdevChannelEnabledRsp = {}
TSetCdevChannelEnabledRsp.__index = TSetCdevChannelEnabledRsp
TSetCdevChannelEnabledRsp.group = {}

local function TSetCdevChannelEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetCdevChannelEnabledRsp)
end

function TSetCdevChannelEnabledRsp.new()
    return TSetCdevChannelEnabledRsp_from_obj({})
end
---@param obj Sms.SetCdevChannelEnabledRsp
function TSetCdevChannelEnabledRsp:init_from_obj(obj)

end

function TSetCdevChannelEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCdevChannelEnabledRsp.group)
end

TSetCdevChannelEnabledRsp.from_obj = TSetCdevChannelEnabledRsp_from_obj

TSetCdevChannelEnabledRsp.proto_property = {}

TSetCdevChannelEnabledRsp.default = {}

TSetCdevChannelEnabledRsp.struct = {}

function TSetCdevChannelEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCdevChannelEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCdevChannelEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetCdevChannelEnabledRsp:unpack(_)
end

Sms.SetCdevChannelEnabledRsp = TSetCdevChannelEnabledRsp

---@class Sms.SetCdevChannelEnabledReq
---@field Enabled boolean
local TSetCdevChannelEnabledReq = {}
TSetCdevChannelEnabledReq.__index = TSetCdevChannelEnabledReq
TSetCdevChannelEnabledReq.group = {}

local function TSetCdevChannelEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetCdevChannelEnabledReq)
end

function TSetCdevChannelEnabledReq.new(Enabled)
    return TSetCdevChannelEnabledReq_from_obj({Enabled = Enabled})
end
---@param obj Sms.SetCdevChannelEnabledReq
function TSetCdevChannelEnabledReq:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TSetCdevChannelEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCdevChannelEnabledReq.group)
end

TSetCdevChannelEnabledReq.from_obj = TSetCdevChannelEnabledReq_from_obj

TSetCdevChannelEnabledReq.proto_property = {'Enabled'}

TSetCdevChannelEnabledReq.default = {false}

TSetCdevChannelEnabledReq.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TSetCdevChannelEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TSetCdevChannelEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCdevChannelEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetCdevChannelEnabledReq:unpack(_)
    return self.Enabled
end

Sms.SetCdevChannelEnabledReq = TSetCdevChannelEnabledReq

---@class Sms.GetChannelTypeRsp
---@field ChannelType integer
local TGetChannelTypeRsp = {}
TGetChannelTypeRsp.__index = TGetChannelTypeRsp
TGetChannelTypeRsp.group = {}

local function TGetChannelTypeRsp_from_obj(obj)
    return setmetatable(obj, TGetChannelTypeRsp)
end

function TGetChannelTypeRsp.new(ChannelType)
    return TGetChannelTypeRsp_from_obj({ChannelType = ChannelType})
end
---@param obj Sms.GetChannelTypeRsp
function TGetChannelTypeRsp:init_from_obj(obj)
    self.ChannelType = obj.ChannelType
end

function TGetChannelTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChannelTypeRsp.group)
end

TGetChannelTypeRsp.from_obj = TGetChannelTypeRsp_from_obj

TGetChannelTypeRsp.proto_property = {'ChannelType'}

TGetChannelTypeRsp.default = {0}

TGetChannelTypeRsp.struct = {{name = 'ChannelType', is_array = false, struct = nil}}

function TGetChannelTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelType', self.ChannelType, 'uint8', false, errs, need_convert)

    TGetChannelTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChannelTypeRsp.proto_property, errs, need_convert)
    return self
end

function TGetChannelTypeRsp:unpack(_)
    return self.ChannelType
end

Sms.GetChannelTypeRsp = TGetChannelTypeRsp

---@class Sms.GetChannelTypeReq
---@field IsPowerOffPer boolean
local TGetChannelTypeReq = {}
TGetChannelTypeReq.__index = TGetChannelTypeReq
TGetChannelTypeReq.group = {}

local function TGetChannelTypeReq_from_obj(obj)
    return setmetatable(obj, TGetChannelTypeReq)
end

function TGetChannelTypeReq.new(IsPowerOffPer)
    return TGetChannelTypeReq_from_obj({IsPowerOffPer = IsPowerOffPer})
end
---@param obj Sms.GetChannelTypeReq
function TGetChannelTypeReq:init_from_obj(obj)
    self.IsPowerOffPer = obj.IsPowerOffPer
end

function TGetChannelTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetChannelTypeReq.group)
end

TGetChannelTypeReq.from_obj = TGetChannelTypeReq_from_obj

TGetChannelTypeReq.proto_property = {'IsPowerOffPer'}

TGetChannelTypeReq.default = {false}

TGetChannelTypeReq.struct = {{name = 'IsPowerOffPer', is_array = false, struct = nil}}

function TGetChannelTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsPowerOffPer', self.IsPowerOffPer, 'bool', false, errs, need_convert)

    TGetChannelTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetChannelTypeReq.proto_property, errs, need_convert)
    return self
end

function TGetChannelTypeReq:unpack(_)
    return self.IsPowerOffPer
end

Sms.GetChannelTypeReq = TGetChannelTypeReq

---@class Sms.SetChannelTypeRsp
local TSetChannelTypeRsp = {}
TSetChannelTypeRsp.__index = TSetChannelTypeRsp
TSetChannelTypeRsp.group = {}

local function TSetChannelTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetChannelTypeRsp)
end

function TSetChannelTypeRsp.new()
    return TSetChannelTypeRsp_from_obj({})
end
---@param obj Sms.SetChannelTypeRsp
function TSetChannelTypeRsp:init_from_obj(obj)

end

function TSetChannelTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChannelTypeRsp.group)
end

TSetChannelTypeRsp.from_obj = TSetChannelTypeRsp_from_obj

TSetChannelTypeRsp.proto_property = {}

TSetChannelTypeRsp.default = {}

TSetChannelTypeRsp.struct = {}

function TSetChannelTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetChannelTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChannelTypeRsp.proto_property, errs, need_convert)
    return self
end

function TSetChannelTypeRsp:unpack(_)
end

Sms.SetChannelTypeRsp = TSetChannelTypeRsp

---@class Sms.SetChannelTypeReq
---@field ChannelType integer
---@field IsPowerOffPer boolean
local TSetChannelTypeReq = {}
TSetChannelTypeReq.__index = TSetChannelTypeReq
TSetChannelTypeReq.group = {}

local function TSetChannelTypeReq_from_obj(obj)
    return setmetatable(obj, TSetChannelTypeReq)
end

function TSetChannelTypeReq.new(ChannelType, IsPowerOffPer)
    return TSetChannelTypeReq_from_obj({ChannelType = ChannelType, IsPowerOffPer = IsPowerOffPer})
end
---@param obj Sms.SetChannelTypeReq
function TSetChannelTypeReq:init_from_obj(obj)
    self.ChannelType = obj.ChannelType
    self.IsPowerOffPer = obj.IsPowerOffPer
end

function TSetChannelTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChannelTypeReq.group)
end

TSetChannelTypeReq.from_obj = TSetChannelTypeReq_from_obj

TSetChannelTypeReq.proto_property = {'ChannelType', 'IsPowerOffPer'}

TSetChannelTypeReq.default = {0, false}

TSetChannelTypeReq.struct = {
    {name = 'ChannelType', is_array = false, struct = nil}, {name = 'IsPowerOffPer', is_array = false, struct = nil}
}

function TSetChannelTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelType', self.ChannelType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IsPowerOffPer', self.IsPowerOffPer, 'bool', false, errs, need_convert)

    TSetChannelTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChannelTypeReq.proto_property, errs, need_convert)
    return self
end

function TSetChannelTypeReq:unpack(_)
    return self.ChannelType, self.IsPowerOffPer
end

Sms.SetChannelTypeReq = TSetChannelTypeReq

---@class Sms.UpdateSpecificResourceRsp
---@field Response string
local TUpdateSpecificResourceRsp = {}
TUpdateSpecificResourceRsp.__index = TUpdateSpecificResourceRsp
TUpdateSpecificResourceRsp.group = {}

local function TUpdateSpecificResourceRsp_from_obj(obj)
    return setmetatable(obj, TUpdateSpecificResourceRsp)
end

function TUpdateSpecificResourceRsp.new(Response)
    return TUpdateSpecificResourceRsp_from_obj({Response = Response})
end
---@param obj Sms.UpdateSpecificResourceRsp
function TUpdateSpecificResourceRsp:init_from_obj(obj)
    self.Response = obj.Response
end

function TUpdateSpecificResourceRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateSpecificResourceRsp.group)
end

TUpdateSpecificResourceRsp.from_obj = TUpdateSpecificResourceRsp_from_obj

TUpdateSpecificResourceRsp.proto_property = {'Response'}

TUpdateSpecificResourceRsp.default = {''}

TUpdateSpecificResourceRsp.struct = {{name = 'Response', is_array = false, struct = nil}}

function TUpdateSpecificResourceRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Response', self.Response, 'string', false, errs, need_convert)

    TUpdateSpecificResourceRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateSpecificResourceRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateSpecificResourceRsp:unpack(_)
    return self.Response
end

Sms.UpdateSpecificResourceRsp = TUpdateSpecificResourceRsp

---@class Sms.UpdateSpecificResourceReq
---@field ResourceType string
local TUpdateSpecificResourceReq = {}
TUpdateSpecificResourceReq.__index = TUpdateSpecificResourceReq
TUpdateSpecificResourceReq.group = {}

local function TUpdateSpecificResourceReq_from_obj(obj)
    return setmetatable(obj, TUpdateSpecificResourceReq)
end

function TUpdateSpecificResourceReq.new(ResourceType)
    return TUpdateSpecificResourceReq_from_obj({ResourceType = ResourceType})
end
---@param obj Sms.UpdateSpecificResourceReq
function TUpdateSpecificResourceReq:init_from_obj(obj)
    self.ResourceType = obj.ResourceType
end

function TUpdateSpecificResourceReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateSpecificResourceReq.group)
end

TUpdateSpecificResourceReq.from_obj = TUpdateSpecificResourceReq_from_obj

TUpdateSpecificResourceReq.proto_property = {'ResourceType'}

TUpdateSpecificResourceReq.default = {''}

TUpdateSpecificResourceReq.struct = {{name = 'ResourceType', is_array = false, struct = nil}}

function TUpdateSpecificResourceReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResourceType', self.ResourceType, 'string', false, errs, need_convert)

    TUpdateSpecificResourceReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateSpecificResourceReq.proto_property, errs, need_convert)
    return self
end

function TUpdateSpecificResourceReq:unpack(_)
    return self.ResourceType
end

Sms.UpdateSpecificResourceReq = TUpdateSpecificResourceReq

---@class Sms.ForwardEventRsp
---@field ResponseStatusCode integer
local TForwardEventRsp = {}
TForwardEventRsp.__index = TForwardEventRsp
TForwardEventRsp.group = {}

local function TForwardEventRsp_from_obj(obj)
    return setmetatable(obj, TForwardEventRsp)
end

function TForwardEventRsp.new(ResponseStatusCode)
    return TForwardEventRsp_from_obj({ResponseStatusCode = ResponseStatusCode})
end
---@param obj Sms.ForwardEventRsp
function TForwardEventRsp:init_from_obj(obj)
    self.ResponseStatusCode = obj.ResponseStatusCode
end

function TForwardEventRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForwardEventRsp.group)
end

TForwardEventRsp.from_obj = TForwardEventRsp_from_obj

TForwardEventRsp.proto_property = {'ResponseStatusCode'}

TForwardEventRsp.default = {0}

TForwardEventRsp.struct = {{name = 'ResponseStatusCode', is_array = false, struct = nil}}

function TForwardEventRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResponseStatusCode', self.ResponseStatusCode, 'uint32', false, errs, need_convert)

    TForwardEventRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForwardEventRsp.proto_property, errs, need_convert)
    return self
end

function TForwardEventRsp:unpack(_)
    return self.ResponseStatusCode
end

Sms.ForwardEventRsp = TForwardEventRsp

---@class Sms.ForwardEventReq
---@field RequestMethod string
---@field RequestToken string
---@field RequestBody string
local TForwardEventReq = {}
TForwardEventReq.__index = TForwardEventReq
TForwardEventReq.group = {}

local function TForwardEventReq_from_obj(obj)
    return setmetatable(obj, TForwardEventReq)
end

function TForwardEventReq.new(RequestMethod, RequestToken, RequestBody)
    return TForwardEventReq_from_obj({
        RequestMethod = RequestMethod,
        RequestToken = RequestToken,
        RequestBody = RequestBody
    })
end
---@param obj Sms.ForwardEventReq
function TForwardEventReq:init_from_obj(obj)
    self.RequestMethod = obj.RequestMethod
    self.RequestToken = obj.RequestToken
    self.RequestBody = obj.RequestBody
end

function TForwardEventReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForwardEventReq.group)
end

TForwardEventReq.from_obj = TForwardEventReq_from_obj

TForwardEventReq.proto_property = {'RequestMethod', 'RequestToken', 'RequestBody'}

TForwardEventReq.default = {'', '', ''}

TForwardEventReq.struct = {
    {name = 'RequestMethod', is_array = false, struct = nil}, {name = 'RequestToken', is_array = false, struct = nil},
    {name = 'RequestBody', is_array = false, struct = nil}
}

function TForwardEventReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RequestMethod', self.RequestMethod, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RequestToken', self.RequestToken, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RequestBody', self.RequestBody, 'string', false, errs, need_convert)

    TForwardEventReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForwardEventReq.proto_property, errs, need_convert)
    return self
end

function TForwardEventReq:unpack(_)
    return self.RequestMethod, self.RequestToken, self.RequestBody
end

Sms.ForwardEventReq = TForwardEventReq

---@class Sms.ForwardRequestRsp
---@field Response string
local TForwardRequestRsp = {}
TForwardRequestRsp.__index = TForwardRequestRsp
TForwardRequestRsp.group = {}

local function TForwardRequestRsp_from_obj(obj)
    return setmetatable(obj, TForwardRequestRsp)
end

function TForwardRequestRsp.new(Response)
    return TForwardRequestRsp_from_obj({Response = Response})
end
---@param obj Sms.ForwardRequestRsp
function TForwardRequestRsp:init_from_obj(obj)
    self.Response = obj.Response
end

function TForwardRequestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForwardRequestRsp.group)
end

TForwardRequestRsp.from_obj = TForwardRequestRsp_from_obj

TForwardRequestRsp.proto_property = {'Response'}

TForwardRequestRsp.default = {''}

TForwardRequestRsp.struct = {{name = 'Response', is_array = false, struct = nil}}

function TForwardRequestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Response', self.Response, 'string', false, errs, need_convert)

    TForwardRequestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForwardRequestRsp.proto_property, errs, need_convert)
    return self
end

function TForwardRequestRsp:unpack(_)
    return self.Response
end

Sms.ForwardRequestRsp = TForwardRequestRsp

---@class Sms.ForwardRequestReq
---@field Request string
---@field RetryTimes integer
local TForwardRequestReq = {}
TForwardRequestReq.__index = TForwardRequestReq
TForwardRequestReq.group = {}

local function TForwardRequestReq_from_obj(obj)
    return setmetatable(obj, TForwardRequestReq)
end

function TForwardRequestReq.new(Request, RetryTimes)
    return TForwardRequestReq_from_obj({Request = Request, RetryTimes = RetryTimes})
end
---@param obj Sms.ForwardRequestReq
function TForwardRequestReq:init_from_obj(obj)
    self.Request = obj.Request
    self.RetryTimes = obj.RetryTimes
end

function TForwardRequestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForwardRequestReq.group)
end

TForwardRequestReq.from_obj = TForwardRequestReq_from_obj

TForwardRequestReq.proto_property = {'Request', 'RetryTimes'}

TForwardRequestReq.default = {'', 0}

TForwardRequestReq.struct = {
    {name = 'Request', is_array = false, struct = nil}, {name = 'RetryTimes', is_array = false, struct = nil}
}

function TForwardRequestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Request', self.Request, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RetryTimes', self.RetryTimes, 'uint8', false, errs, need_convert)

    TForwardRequestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForwardRequestReq.proto_property, errs, need_convert)
    return self
end

function TForwardRequestReq:unpack(_)
    return self.Request, self.RetryTimes
end

Sms.ForwardRequestReq = TForwardRequestReq

---@class Sms.SetForwardWhiteListRsp
---@field Response string
local TSetForwardWhiteListRsp = {}
TSetForwardWhiteListRsp.__index = TSetForwardWhiteListRsp
TSetForwardWhiteListRsp.group = {}

local function TSetForwardWhiteListRsp_from_obj(obj)
    return setmetatable(obj, TSetForwardWhiteListRsp)
end

function TSetForwardWhiteListRsp.new(Response)
    return TSetForwardWhiteListRsp_from_obj({Response = Response})
end
---@param obj Sms.SetForwardWhiteListRsp
function TSetForwardWhiteListRsp:init_from_obj(obj)
    self.Response = obj.Response
end

function TSetForwardWhiteListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetForwardWhiteListRsp.group)
end

TSetForwardWhiteListRsp.from_obj = TSetForwardWhiteListRsp_from_obj

TSetForwardWhiteListRsp.proto_property = {'Response'}

TSetForwardWhiteListRsp.default = {''}

TSetForwardWhiteListRsp.struct = {{name = 'Response', is_array = false, struct = nil}}

function TSetForwardWhiteListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Response', self.Response, 'string', false, errs, need_convert)

    TSetForwardWhiteListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetForwardWhiteListRsp.proto_property, errs, need_convert)
    return self
end

function TSetForwardWhiteListRsp:unpack(_)
    return self.Response
end

Sms.SetForwardWhiteListRsp = TSetForwardWhiteListRsp

---@class Sms.SetForwardWhiteListReq
---@field Request string
local TSetForwardWhiteListReq = {}
TSetForwardWhiteListReq.__index = TSetForwardWhiteListReq
TSetForwardWhiteListReq.group = {}

local function TSetForwardWhiteListReq_from_obj(obj)
    return setmetatable(obj, TSetForwardWhiteListReq)
end

function TSetForwardWhiteListReq.new(Request)
    return TSetForwardWhiteListReq_from_obj({Request = Request})
end
---@param obj Sms.SetForwardWhiteListReq
function TSetForwardWhiteListReq:init_from_obj(obj)
    self.Request = obj.Request
end

function TSetForwardWhiteListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetForwardWhiteListReq.group)
end

TSetForwardWhiteListReq.from_obj = TSetForwardWhiteListReq_from_obj

TSetForwardWhiteListReq.proto_property = {'Request'}

TSetForwardWhiteListReq.default = {''}

TSetForwardWhiteListReq.struct = {{name = 'Request', is_array = false, struct = nil}}

function TSetForwardWhiteListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Request', self.Request, 'string', false, errs, need_convert)

    TSetForwardWhiteListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetForwardWhiteListReq.proto_property, errs, need_convert)
    return self
end

function TSetForwardWhiteListReq:unpack(_)
    return self.Request
end

Sms.SetForwardWhiteListReq = TSetForwardWhiteListReq

Sms.interface = mdb.register_interface('bmc.kepler.Systems.Sms', {
    ChannelType = {'y', nil, true, nil},
    Id = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Registered = {'b', nil, true, nil},
    Name = {'s', nil, true, nil},
    Version = {'s', nil, true, nil},
    Type = {'s', nil, true, nil},
    IsSupported = {'b', {['emitsChangedSignal'] = 'false'}, true, nil},
    WhiteList = {'s', {['emitsChangedSignal'] = 'true'}, true, nil},
    DriverVersion = {'s', nil, true, nil},
    CdevChannelEnabled = {'b', nil, true, nil}
}, {
    SetForwardWhiteList = {'a{ss}s', 's', TSetForwardWhiteListReq, TSetForwardWhiteListRsp},
    ForwardRequest = {'a{ss}sy', 's', TForwardRequestReq, TForwardRequestRsp},
    ForwardEvent = {'a{ss}sss', 'u', TForwardEventReq, TForwardEventRsp},
    UpdateSpecificResource = {'a{ss}s', 's', TUpdateSpecificResourceReq, TUpdateSpecificResourceRsp},
    SetChannelType = {'a{ss}yb', '', TSetChannelTypeReq, TSetChannelTypeRsp},
    GetChannelType = {'a{ss}b', 'y', TGetChannelTypeReq, TGetChannelTypeRsp},
    SetCdevChannelEnabled = {'a{ss}b', '', TSetCdevChannelEnabledReq, TSetCdevChannelEnabledRsp}
}, {})

return Sms
