-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeSlot = {}

---@class PCIeSlot.PowerControlRsp
local TPowerControlRsp = {}
TPowerControlRsp.__index = TPowerControlRsp
TPowerControlRsp.group = {}

local function TPowerControlRsp_from_obj(obj)
    return setmetatable(obj, TPowerControlRsp)
end

function TPowerControlRsp.new()
    return TPowerControlRsp_from_obj({})
end
---@param obj PCIeSlot.PowerControlRsp
function TPowerControlRsp:init_from_obj(obj)

end

function TPowerControlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerControlRsp.group)
end

TPowerControlRsp.from_obj = TPowerControlRsp_from_obj

TPowerControlRsp.proto_property = {}

TPowerControlRsp.default = {}

TPowerControlRsp.struct = {}

function TPowerControlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TPowerControlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerControlRsp.proto_property, errs, need_convert)
    return self
end

function TPowerControlRsp:unpack(_)
end

PCIeSlot.PowerControlRsp = TPowerControlRsp

---@class PCIeSlot.PowerControlReq
---@field PowerState string
local TPowerControlReq = {}
TPowerControlReq.__index = TPowerControlReq
TPowerControlReq.group = {}

local function TPowerControlReq_from_obj(obj)
    return setmetatable(obj, TPowerControlReq)
end

function TPowerControlReq.new(PowerState)
    return TPowerControlReq_from_obj({PowerState = PowerState})
end
---@param obj PCIeSlot.PowerControlReq
function TPowerControlReq:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerControlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerControlReq.group)
end

TPowerControlReq.from_obj = TPowerControlReq_from_obj

TPowerControlReq.proto_property = {'PowerState'}

TPowerControlReq.default = {''}

TPowerControlReq.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerControlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'string', false, errs, need_convert)

    TPowerControlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerControlReq.proto_property, errs, need_convert)
    return self
end

function TPowerControlReq:unpack(_)
    return self.PowerState
end

PCIeSlot.PowerControlReq = TPowerControlReq

PCIeSlot.interface = mdb.register_interface('bmc.kepler.Systems.PCIeSlot', {
    SlotId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    SupportedComponentTypes = {'ay', {['emitsChangedSignal'] = 'false'}, true, nil},
    PowerState = {'s', {['emitsChangedSignal'] = 'true'}, true, 'Off'}
}, {PowerControl = {'a{ss}s', '', TPowerControlReq, TPowerControlRsp}}, {})

return PCIeSlot
