-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local OpticalModules = {}

---@class OpticalModules.ExtremeValueLogIntervalSeconds
---@field ExtremeValueLogIntervalSeconds integer
local TExtremeValueLogIntervalSeconds = {}
TExtremeValueLogIntervalSeconds.__index = TExtremeValueLogIntervalSeconds
TExtremeValueLogIntervalSeconds.group = {}

local function TExtremeValueLogIntervalSeconds_from_obj(obj)
    return setmetatable(obj, TExtremeValueLogIntervalSeconds)
end

function TExtremeValueLogIntervalSeconds.new(ExtremeValueLogIntervalSeconds)
    return TExtremeValueLogIntervalSeconds_from_obj({
        ExtremeValueLogIntervalSeconds = ExtremeValueLogIntervalSeconds or 3600
    })
end
---@param obj OpticalModules.ExtremeValueLogIntervalSeconds
function TExtremeValueLogIntervalSeconds:init_from_obj(obj)
    self.ExtremeValueLogIntervalSeconds = obj.ExtremeValueLogIntervalSeconds or 3600
end

function TExtremeValueLogIntervalSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExtremeValueLogIntervalSeconds.group)
end

TExtremeValueLogIntervalSeconds.from_obj = TExtremeValueLogIntervalSeconds_from_obj

TExtremeValueLogIntervalSeconds.proto_property = {'ExtremeValueLogIntervalSeconds'}

TExtremeValueLogIntervalSeconds.default = {0}

TExtremeValueLogIntervalSeconds.struct = {{name = 'ExtremeValueLogIntervalSeconds', is_array = false, struct = nil}}

function TExtremeValueLogIntervalSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExtremeValueLogIntervalSeconds', self.ExtremeValueLogIntervalSeconds, 'uint16', false,
        errs, need_convert)

    if self.ExtremeValueLogIntervalSeconds ~= nil then
        validate.ranges(prefix .. 'ExtremeValueLogIntervalSeconds', self.ExtremeValueLogIntervalSeconds, 15, 3600, errs,
            need_convert)
    end

    TExtremeValueLogIntervalSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExtremeValueLogIntervalSeconds.proto_property, errs, need_convert)
    return self
end

function TExtremeValueLogIntervalSeconds:unpack(_)
    return self.ExtremeValueLogIntervalSeconds
end

OpticalModules.ExtremeValueLogIntervalSeconds = TExtremeValueLogIntervalSeconds

OpticalModules.interface = mdb.register_interface('bmc.kepler.Debug.Systems.OpticalModules',
    {ExtremeValueLogIntervalSeconds = {'q', {}, false, 3600}}, {}, {})

return OpticalModules
