-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local OpticalModuleRelatedItems = {}

---@class OpticalModuleRelatedItems.RelatedNetworkPortLane
---@field NetworkPortId integer
---@field NetworkPortLaneId integer
local TRelatedNetworkPortLane = {}
TRelatedNetworkPortLane.__index = TRelatedNetworkPortLane
TRelatedNetworkPortLane.group = {}

local function TRelatedNetworkPortLane_from_obj(obj)
    return setmetatable(obj, TRelatedNetworkPortLane)
end

function TRelatedNetworkPortLane.new(NetworkPortId, NetworkPortLaneId)
    return TRelatedNetworkPortLane_from_obj({NetworkPortId = NetworkPortId, NetworkPortLaneId = NetworkPortLaneId})
end
---@param obj OpticalModuleRelatedItems.RelatedNetworkPortLane
function TRelatedNetworkPortLane:init_from_obj(obj)
    self.NetworkPortId = obj.NetworkPortId
    self.NetworkPortLaneId = obj.NetworkPortLaneId
end

function TRelatedNetworkPortLane:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedNetworkPortLane.group)
end

TRelatedNetworkPortLane.from_obj = TRelatedNetworkPortLane_from_obj

TRelatedNetworkPortLane.proto_property = {'NetworkPortId', 'NetworkPortLaneId'}

TRelatedNetworkPortLane.default = {0, 0}

TRelatedNetworkPortLane.struct = {
    {name = 'NetworkPortId', is_array = false, struct = nil},
    {name = 'NetworkPortLaneId', is_array = false, struct = nil}
}

function TRelatedNetworkPortLane:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkPortId', self.NetworkPortId, 'uint8', true, errs, need_convert)
    validate.Optional(prefix .. 'NetworkPortLaneId', self.NetworkPortLaneId, 'uint8', true, errs, need_convert)

    TRelatedNetworkPortLane:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedNetworkPortLane.proto_property, errs, need_convert)
    return self
end

function TRelatedNetworkPortLane:unpack(_)
    return self.NetworkPortId, self.NetworkPortLaneId
end

OpticalModuleRelatedItems.RelatedNetworkPortLane = TRelatedNetworkPortLane

---@class OpticalModuleRelatedItems.NetworkPortLanes
---@field NetworkPortLanes OpticalModuleRelatedItems.RelatedNetworkPortLane[]
local TNetworkPortLanes = {}
TNetworkPortLanes.__index = TNetworkPortLanes
TNetworkPortLanes.group = {}

local function TNetworkPortLanes_from_obj(obj)
    obj.NetworkPortLanes = utils.from_obj(OpticalModuleRelatedItems.RelatedNetworkPortLane, obj.NetworkPortLanes, true)
    return setmetatable(obj, TNetworkPortLanes)
end

function TNetworkPortLanes.new(NetworkPortLanes)
    return TNetworkPortLanes_from_obj({NetworkPortLanes = NetworkPortLanes})
end
---@param obj OpticalModuleRelatedItems.NetworkPortLanes
function TNetworkPortLanes:init_from_obj(obj)
    self.NetworkPortLanes = obj.NetworkPortLanes
end

function TNetworkPortLanes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkPortLanes.group)
end

TNetworkPortLanes.from_obj = TNetworkPortLanes_from_obj

TNetworkPortLanes.proto_property = {'NetworkPortLanes'}

TNetworkPortLanes.default = {{}}

TNetworkPortLanes.struct = {
    {name = 'NetworkPortLanes', is_array = true, struct = OpticalModuleRelatedItems.RelatedNetworkPortLane.struct}
}

function TNetworkPortLanes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.NetworkPortLanes) do
        OpticalModuleRelatedItems.RelatedNetworkPortLane.new(v.NetworkPortId, v.NetworkPortLaneId):validate(prefix,
            errs, need_convert)
    end

    TNetworkPortLanes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkPortLanes.proto_property, errs, need_convert)
    return self
end

function TNetworkPortLanes:unpack(raw)
    return utils.unpack(raw, self.NetworkPortLanes, true)
end

OpticalModuleRelatedItems.NetworkPortLanes = TNetworkPortLanes

OpticalModuleRelatedItems.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.RelatedItems',
    {NetworkPortLanes = {'a(yy)', {}, true, nil}}, {}, {})

return OpticalModuleRelatedItems
