-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local OpticalModule = {}

---@class OpticalModule.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText})
end
---@param obj OpticalModule.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', true, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

OpticalModule.SilkText = TSilkText

---@class OpticalModule.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 255})
end
---@param obj OpticalModule.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 255
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

OpticalModule.Id = TId

---@class OpticalModule.RelatedNetworkPorts
---@field RelatedNetworkPorts integer[]
local TRelatedNetworkPorts = {}
TRelatedNetworkPorts.__index = TRelatedNetworkPorts
TRelatedNetworkPorts.group = {}

local function TRelatedNetworkPorts_from_obj(obj)
    return setmetatable(obj, TRelatedNetworkPorts)
end

function TRelatedNetworkPorts.new(RelatedNetworkPorts)
    return TRelatedNetworkPorts_from_obj({RelatedNetworkPorts = RelatedNetworkPorts})
end
---@param obj OpticalModule.RelatedNetworkPorts
function TRelatedNetworkPorts:init_from_obj(obj)
    self.RelatedNetworkPorts = obj.RelatedNetworkPorts
end

function TRelatedNetworkPorts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedNetworkPorts.group)
end

TRelatedNetworkPorts.from_obj = TRelatedNetworkPorts_from_obj

TRelatedNetworkPorts.proto_property = {'RelatedNetworkPorts'}

TRelatedNetworkPorts.default = {{}}

TRelatedNetworkPorts.struct = {{name = 'RelatedNetworkPorts', is_array = true, struct = nil}}

function TRelatedNetworkPorts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RelatedNetworkPorts', self.RelatedNetworkPorts, 'uint8', true, errs, need_convert)

    TRelatedNetworkPorts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedNetworkPorts.proto_property, errs, need_convert)
    return self
end

function TRelatedNetworkPorts:unpack(_)
    return self.RelatedNetworkPorts
end

OpticalModule.RelatedNetworkPorts = TRelatedNetworkPorts

---@class OpticalModule.ChannelNum
---@field ChannelNum integer
local TChannelNum = {}
TChannelNum.__index = TChannelNum
TChannelNum.group = {}

local function TChannelNum_from_obj(obj)
    return setmetatable(obj, TChannelNum)
end

function TChannelNum.new(ChannelNum)
    return TChannelNum_from_obj({ChannelNum = ChannelNum})
end
---@param obj OpticalModule.ChannelNum
function TChannelNum:init_from_obj(obj)
    self.ChannelNum = obj.ChannelNum
end

function TChannelNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannelNum.group)
end

TChannelNum.from_obj = TChannelNum_from_obj

TChannelNum.proto_property = {'ChannelNum'}

TChannelNum.default = {0}

TChannelNum.struct = {{name = 'ChannelNum', is_array = false, struct = nil}}

function TChannelNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelNum', self.ChannelNum, 'uint8', true, errs, need_convert)

    TChannelNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannelNum.proto_property, errs, need_convert)
    return self
end

function TChannelNum:unpack(_)
    return self.ChannelNum
end

OpticalModule.ChannelNum = TChannelNum

---@class OpticalModule.ModuleState
---@field ModuleState integer
local TModuleState = {}
TModuleState.__index = TModuleState
TModuleState.group = {}

local function TModuleState_from_obj(obj)
    return setmetatable(obj, TModuleState)
end

function TModuleState.new(ModuleState)
    return TModuleState_from_obj({ModuleState = ModuleState or 255})
end
---@param obj OpticalModule.ModuleState
function TModuleState:init_from_obj(obj)
    self.ModuleState = obj.ModuleState or 255
end

function TModuleState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TModuleState.group)
end

TModuleState.from_obj = TModuleState_from_obj

TModuleState.proto_property = {'ModuleState'}

TModuleState.default = {0}

TModuleState.struct = {{name = 'ModuleState', is_array = false, struct = nil}}

function TModuleState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ModuleState', self.ModuleState, 'uint8', true, errs, need_convert)

    TModuleState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TModuleState.proto_property, errs, need_convert)
    return self
end

function TModuleState:unpack(_)
    return self.ModuleState
end

OpticalModule.ModuleState = TModuleState

---@class OpticalModule.Accessible
---@field Accessible integer
local TAccessible = {}
TAccessible.__index = TAccessible
TAccessible.group = {}

local function TAccessible_from_obj(obj)
    return setmetatable(obj, TAccessible)
end

function TAccessible.new(Accessible)
    return TAccessible_from_obj({Accessible = Accessible})
end
---@param obj OpticalModule.Accessible
function TAccessible:init_from_obj(obj)
    self.Accessible = obj.Accessible
end

function TAccessible:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccessible.group)
end

TAccessible.from_obj = TAccessible_from_obj

TAccessible.proto_property = {'Accessible'}

TAccessible.default = {0}

TAccessible.struct = {{name = 'Accessible', is_array = false, struct = nil}}

function TAccessible:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Accessible', self.Accessible, 'uint8', true, errs, need_convert)

    TAccessible:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccessible.proto_property, errs, need_convert)
    return self
end

function TAccessible:unpack(_)
    return self.Accessible
end

OpticalModule.Accessible = TAccessible

---@class OpticalModule.RxSNR
---@field RxSNR number[]
local TRxSNR = {}
TRxSNR.__index = TRxSNR
TRxSNR.group = {}

local function TRxSNR_from_obj(obj)
    return setmetatable(obj, TRxSNR)
end

function TRxSNR.new(RxSNR)
    return TRxSNR_from_obj({RxSNR = RxSNR})
end
---@param obj OpticalModule.RxSNR
function TRxSNR:init_from_obj(obj)
    self.RxSNR = obj.RxSNR
end

function TRxSNR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRxSNR.group)
end

TRxSNR.from_obj = TRxSNR_from_obj

TRxSNR.proto_property = {'RxSNR'}

TRxSNR.default = {{}}

TRxSNR.struct = {{name = 'RxSNR', is_array = true, struct = nil}}

function TRxSNR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RxSNR', self.RxSNR, 'double', true, errs, need_convert)

    TRxSNR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRxSNR.proto_property, errs, need_convert)
    return self
end

function TRxSNR:unpack(_)
    return self.RxSNR
end

OpticalModule.RxSNR = TRxSNR

---@class OpticalModule.MediaSNR
---@field MediaSNR number[]
local TMediaSNR = {}
TMediaSNR.__index = TMediaSNR
TMediaSNR.group = {}

local function TMediaSNR_from_obj(obj)
    return setmetatable(obj, TMediaSNR)
end

function TMediaSNR.new(MediaSNR)
    return TMediaSNR_from_obj({MediaSNR = MediaSNR})
end
---@param obj OpticalModule.MediaSNR
function TMediaSNR:init_from_obj(obj)
    self.MediaSNR = obj.MediaSNR
end

function TMediaSNR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediaSNR.group)
end

TMediaSNR.from_obj = TMediaSNR_from_obj

TMediaSNR.proto_property = {'MediaSNR'}

TMediaSNR.default = {{}}

TMediaSNR.struct = {{name = 'MediaSNR', is_array = true, struct = nil}}

function TMediaSNR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'MediaSNR', self.MediaSNR, 'double', true, errs, need_convert)

    TMediaSNR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediaSNR.proto_property, errs, need_convert)
    return self
end

function TMediaSNR:unpack(_)
    return self.MediaSNR
end

OpticalModule.MediaSNR = TMediaSNR

---@class OpticalModule.HostSNR
---@field HostSNR number[]
local THostSNR = {}
THostSNR.__index = THostSNR
THostSNR.group = {}

local function THostSNR_from_obj(obj)
    return setmetatable(obj, THostSNR)
end

function THostSNR.new(HostSNR)
    return THostSNR_from_obj({HostSNR = HostSNR})
end
---@param obj OpticalModule.HostSNR
function THostSNR:init_from_obj(obj)
    self.HostSNR = obj.HostSNR
end

function THostSNR:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THostSNR.group)
end

THostSNR.from_obj = THostSNR_from_obj

THostSNR.proto_property = {'HostSNR'}

THostSNR.default = {{}}

THostSNR.struct = {{name = 'HostSNR', is_array = true, struct = nil}}

function THostSNR:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'HostSNR', self.HostSNR, 'double', true, errs, need_convert)

    THostSNR:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THostSNR.proto_property, errs, need_convert)
    return self
end

function THostSNR:unpack(_)
    return self.HostSNR
end

OpticalModule.HostSNR = THostSNR

---@class OpticalModule.IsSupportedType
---@field IsSupportedType integer
local TIsSupportedType = {}
TIsSupportedType.__index = TIsSupportedType
TIsSupportedType.group = {}

local function TIsSupportedType_from_obj(obj)
    return setmetatable(obj, TIsSupportedType)
end

function TIsSupportedType.new(IsSupportedType)
    return TIsSupportedType_from_obj({IsSupportedType = IsSupportedType})
end
---@param obj OpticalModule.IsSupportedType
function TIsSupportedType:init_from_obj(obj)
    self.IsSupportedType = obj.IsSupportedType
end

function TIsSupportedType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsSupportedType.group)
end

TIsSupportedType.from_obj = TIsSupportedType_from_obj

TIsSupportedType.proto_property = {'IsSupportedType'}

TIsSupportedType.default = {0}

TIsSupportedType.struct = {{name = 'IsSupportedType', is_array = false, struct = nil}}

function TIsSupportedType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsSupportedType', self.IsSupportedType, 'uint8', true, errs, need_convert)

    TIsSupportedType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsSupportedType.proto_property, errs, need_convert)
    return self
end

function TIsSupportedType:unpack(_)
    return self.IsSupportedType
end

OpticalModule.IsSupportedType = TIsSupportedType

---@class OpticalModule.PowerState
---@field PowerState integer
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj OpticalModule.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {0}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', true, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

OpticalModule.PowerState = TPowerState

---@class OpticalModule.TemperatureCelsius
---@field TemperatureCelsius number
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius or 65535})
end
---@param obj OpticalModule.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius or 65535
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'double', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

OpticalModule.TemperatureCelsius = TTemperatureCelsius

---@class OpticalModule.FaultState
---@field FaultState integer
local TFaultState = {}
TFaultState.__index = TFaultState
TFaultState.group = {}

local function TFaultState_from_obj(obj)
    return setmetatable(obj, TFaultState)
end

function TFaultState.new(FaultState)
    return TFaultState_from_obj({FaultState = FaultState})
end
---@param obj OpticalModule.FaultState
function TFaultState:init_from_obj(obj)
    self.FaultState = obj.FaultState
end

function TFaultState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultState.group)
end

TFaultState.from_obj = TFaultState_from_obj

TFaultState.proto_property = {'FaultState'}

TFaultState.default = {0}

TFaultState.struct = {{name = 'FaultState', is_array = false, struct = nil}}

function TFaultState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultState', self.FaultState, 'uint32', true, errs, need_convert)

    TFaultState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultState.proto_property, errs, need_convert)
    return self
end

function TFaultState:unpack(_)
    return self.FaultState
end

OpticalModule.FaultState = TFaultState

---@class OpticalModule.SpeedMatch
---@field SpeedMatch boolean
local TSpeedMatch = {}
TSpeedMatch.__index = TSpeedMatch
TSpeedMatch.group = {}

local function TSpeedMatch_from_obj(obj)
    return setmetatable(obj, TSpeedMatch)
end

function TSpeedMatch.new(SpeedMatch)
    return TSpeedMatch_from_obj({SpeedMatch = SpeedMatch == nil and true or SpeedMatch})
end
---@param obj OpticalModule.SpeedMatch
function TSpeedMatch:init_from_obj(obj)
    self.SpeedMatch = obj.SpeedMatch == nil and true or obj.SpeedMatch
end

function TSpeedMatch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedMatch.group)
end

TSpeedMatch.from_obj = TSpeedMatch_from_obj

TSpeedMatch.proto_property = {'SpeedMatch'}

TSpeedMatch.default = {false}

TSpeedMatch.struct = {{name = 'SpeedMatch', is_array = false, struct = nil}}

function TSpeedMatch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedMatch', self.SpeedMatch, 'bool', true, errs, need_convert)

    TSpeedMatch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedMatch.proto_property, errs, need_convert)
    return self
end

function TSpeedMatch:unpack(_)
    return self.SpeedMatch
end

OpticalModule.SpeedMatch = TSpeedMatch

---@class OpticalModule.TypeMatch
---@field TypeMatch boolean
local TTypeMatch = {}
TTypeMatch.__index = TTypeMatch
TTypeMatch.group = {}

local function TTypeMatch_from_obj(obj)
    return setmetatable(obj, TTypeMatch)
end

function TTypeMatch.new(TypeMatch)
    return TTypeMatch_from_obj({TypeMatch = TypeMatch == nil and true or TypeMatch})
end
---@param obj OpticalModule.TypeMatch
function TTypeMatch:init_from_obj(obj)
    self.TypeMatch = obj.TypeMatch == nil and true or obj.TypeMatch
end

function TTypeMatch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTypeMatch.group)
end

TTypeMatch.from_obj = TTypeMatch_from_obj

TTypeMatch.proto_property = {'TypeMatch'}

TTypeMatch.default = {false}

TTypeMatch.struct = {{name = 'TypeMatch', is_array = false, struct = nil}}

function TTypeMatch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TypeMatch', self.TypeMatch, 'bool', true, errs, need_convert)

    TTypeMatch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTypeMatch.proto_property, errs, need_convert)
    return self
end

function TTypeMatch:unpack(_)
    return self.TypeMatch
end

OpticalModule.TypeMatch = TTypeMatch

---@class OpticalModule.TxFaultState
---@field TxFaultState boolean
local TTxFaultState = {}
TTxFaultState.__index = TTxFaultState
TTxFaultState.group = {}

local function TTxFaultState_from_obj(obj)
    return setmetatable(obj, TTxFaultState)
end

function TTxFaultState.new(TxFaultState)
    return TTxFaultState_from_obj({TxFaultState = TxFaultState})
end
---@param obj OpticalModule.TxFaultState
function TTxFaultState:init_from_obj(obj)
    self.TxFaultState = obj.TxFaultState
end

function TTxFaultState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxFaultState.group)
end

TTxFaultState.from_obj = TTxFaultState_from_obj

TTxFaultState.proto_property = {'TxFaultState'}

TTxFaultState.default = {false}

TTxFaultState.struct = {{name = 'TxFaultState', is_array = false, struct = nil}}

function TTxFaultState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxFaultState', self.TxFaultState, 'bool', true, errs, need_convert)

    TTxFaultState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxFaultState.proto_property, errs, need_convert)
    return self
end

function TTxFaultState:unpack(_)
    return self.TxFaultState
end

OpticalModule.TxFaultState = TTxFaultState

---@class OpticalModule.TxLossState
---@field TxLossState boolean
local TTxLossState = {}
TTxLossState.__index = TTxLossState
TTxLossState.group = {}

local function TTxLossState_from_obj(obj)
    return setmetatable(obj, TTxLossState)
end

function TTxLossState.new(TxLossState)
    return TTxLossState_from_obj({TxLossState = TxLossState})
end
---@param obj OpticalModule.TxLossState
function TTxLossState:init_from_obj(obj)
    self.TxLossState = obj.TxLossState
end

function TTxLossState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxLossState.group)
end

TTxLossState.from_obj = TTxLossState_from_obj

TTxLossState.proto_property = {'TxLossState'}

TTxLossState.default = {false}

TTxLossState.struct = {{name = 'TxLossState', is_array = false, struct = nil}}

function TTxLossState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxLossState', self.TxLossState, 'bool', true, errs, need_convert)

    TTxLossState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxLossState.proto_property, errs, need_convert)
    return self
end

function TTxLossState:unpack(_)
    return self.TxLossState
end

OpticalModule.TxLossState = TTxLossState

---@class OpticalModule.RxLossState
---@field RxLossState boolean
local TRxLossState = {}
TRxLossState.__index = TRxLossState
TRxLossState.group = {}

local function TRxLossState_from_obj(obj)
    return setmetatable(obj, TRxLossState)
end

function TRxLossState.new(RxLossState)
    return TRxLossState_from_obj({RxLossState = RxLossState})
end
---@param obj OpticalModule.RxLossState
function TRxLossState:init_from_obj(obj)
    self.RxLossState = obj.RxLossState
end

function TRxLossState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRxLossState.group)
end

TRxLossState.from_obj = TRxLossState_from_obj

TRxLossState.proto_property = {'RxLossState'}

TRxLossState.default = {false}

TRxLossState.struct = {{name = 'RxLossState', is_array = false, struct = nil}}

function TRxLossState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RxLossState', self.RxLossState, 'bool', true, errs, need_convert)

    TRxLossState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRxLossState.proto_property, errs, need_convert)
    return self
end

function TRxLossState:unpack(_)
    return self.RxLossState
end

OpticalModule.RxLossState = TRxLossState

---@class OpticalModule.TransmissionDistance
---@field TransmissionDistance string
local TTransmissionDistance = {}
TTransmissionDistance.__index = TTransmissionDistance
TTransmissionDistance.group = {}

local function TTransmissionDistance_from_obj(obj)
    return setmetatable(obj, TTransmissionDistance)
end

function TTransmissionDistance.new(TransmissionDistance)
    return TTransmissionDistance_from_obj({TransmissionDistance = TransmissionDistance})
end
---@param obj OpticalModule.TransmissionDistance
function TTransmissionDistance:init_from_obj(obj)
    self.TransmissionDistance = obj.TransmissionDistance
end

function TTransmissionDistance:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransmissionDistance.group)
end

TTransmissionDistance.from_obj = TTransmissionDistance_from_obj

TTransmissionDistance.proto_property = {'TransmissionDistance'}

TTransmissionDistance.default = {''}

TTransmissionDistance.struct = {{name = 'TransmissionDistance', is_array = false, struct = nil}}

function TTransmissionDistance:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TransmissionDistance', self.TransmissionDistance, 'string', true, errs, need_convert)

    TTransmissionDistance:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransmissionDistance.proto_property, errs, need_convert)
    return self
end

function TTransmissionDistance:unpack(_)
    return self.TransmissionDistance
end

OpticalModule.TransmissionDistance = TTransmissionDistance

---@class OpticalModule.MediumType
---@field MediumType string
local TMediumType = {}
TMediumType.__index = TMediumType
TMediumType.group = {}

local function TMediumType_from_obj(obj)
    return setmetatable(obj, TMediumType)
end

function TMediumType.new(MediumType)
    return TMediumType_from_obj({MediumType = MediumType})
end
---@param obj OpticalModule.MediumType
function TMediumType:init_from_obj(obj)
    self.MediumType = obj.MediumType
end

function TMediumType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediumType.group)
end

TMediumType.from_obj = TMediumType_from_obj

TMediumType.proto_property = {'MediumType'}

TMediumType.default = {''}

TMediumType.struct = {{name = 'MediumType', is_array = false, struct = nil}}

function TMediumType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediumType', self.MediumType, 'string', true, errs, need_convert)

    if self.MediumType ~= nil then
        validate.Enum(prefix .. 'MediumType', self.MediumType, '',
            {'Optical', 'Electric', 'Copper', 'Aoc', 'Interface', 'Baset', ''}, errs, need_convert)
    end

    TMediumType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediumType.proto_property, errs, need_convert)
    return self
end

function TMediumType:unpack(_)
    return self.MediumType
end

OpticalModule.MediumType = TMediumType

---@class OpticalModule.ConnectorType
---@field ConnectorType string
local TConnectorType = {}
TConnectorType.__index = TConnectorType
TConnectorType.group = {}

local function TConnectorType_from_obj(obj)
    return setmetatable(obj, TConnectorType)
end

function TConnectorType.new(ConnectorType)
    return TConnectorType_from_obj({ConnectorType = ConnectorType})
end
---@param obj OpticalModule.ConnectorType
function TConnectorType:init_from_obj(obj)
    self.ConnectorType = obj.ConnectorType
end

function TConnectorType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectorType.group)
end

TConnectorType.from_obj = TConnectorType_from_obj

TConnectorType.proto_property = {'ConnectorType'}

TConnectorType.default = {''}

TConnectorType.struct = {{name = 'ConnectorType', is_array = false, struct = nil}}

function TConnectorType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConnectorType', self.ConnectorType, 'string', true, errs, need_convert)

    TConnectorType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectorType.proto_property, errs, need_convert)
    return self
end

function TConnectorType:unpack(_)
    return self.ConnectorType
end

OpticalModule.ConnectorType = TConnectorType

---@class OpticalModule.Identifier
---@field Identifier string
local TIdentifier = {}
TIdentifier.__index = TIdentifier
TIdentifier.group = {}

local function TIdentifier_from_obj(obj)
    return setmetatable(obj, TIdentifier)
end

function TIdentifier.new(Identifier)
    return TIdentifier_from_obj({Identifier = Identifier})
end
---@param obj OpticalModule.Identifier
function TIdentifier:init_from_obj(obj)
    self.Identifier = obj.Identifier
end

function TIdentifier:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdentifier.group)
end

TIdentifier.from_obj = TIdentifier_from_obj

TIdentifier.proto_property = {'Identifier'}

TIdentifier.default = {''}

TIdentifier.struct = {{name = 'Identifier', is_array = false, struct = nil}}

function TIdentifier:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Identifier', self.Identifier, 'string', true, errs, need_convert)

    TIdentifier:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdentifier.proto_property, errs, need_convert)
    return self
end

function TIdentifier:unpack(_)
    return self.Identifier
end

OpticalModule.Identifier = TIdentifier

---@class OpticalModule.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj OpticalModule.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

OpticalModule.Health = THealth

---@class OpticalModule.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj OpticalModule.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', true, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

OpticalModule.Presence = TPresence

---@class OpticalModule.SupportedSpeedsMbps
---@field SupportedSpeedsMbps number[]
local TSupportedSpeedsMbps = {}
TSupportedSpeedsMbps.__index = TSupportedSpeedsMbps
TSupportedSpeedsMbps.group = {}

local function TSupportedSpeedsMbps_from_obj(obj)
    return setmetatable(obj, TSupportedSpeedsMbps)
end

function TSupportedSpeedsMbps.new(SupportedSpeedsMbps)
    return TSupportedSpeedsMbps_from_obj({SupportedSpeedsMbps = SupportedSpeedsMbps})
end
---@param obj OpticalModule.SupportedSpeedsMbps
function TSupportedSpeedsMbps:init_from_obj(obj)
    self.SupportedSpeedsMbps = obj.SupportedSpeedsMbps
end

function TSupportedSpeedsMbps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedSpeedsMbps.group)
end

TSupportedSpeedsMbps.from_obj = TSupportedSpeedsMbps_from_obj

TSupportedSpeedsMbps.proto_property = {'SupportedSpeedsMbps'}

TSupportedSpeedsMbps.default = {{}}

TSupportedSpeedsMbps.struct = {{name = 'SupportedSpeedsMbps', is_array = true, struct = nil}}

function TSupportedSpeedsMbps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedSpeedsMbps', self.SupportedSpeedsMbps, 'double', true, errs, need_convert)

    TSupportedSpeedsMbps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedSpeedsMbps.proto_property, errs, need_convert)
    return self
end

function TSupportedSpeedsMbps:unpack(_)
    return self.SupportedSpeedsMbps
end

OpticalModule.SupportedSpeedsMbps = TSupportedSpeedsMbps

---@class OpticalModule.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj OpticalModule.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

OpticalModule.Type = TType

---@class OpticalModule.WaveLengthNanometer
---@field WaveLengthNanometer string
local TWaveLengthNanometer = {}
TWaveLengthNanometer.__index = TWaveLengthNanometer
TWaveLengthNanometer.group = {}

local function TWaveLengthNanometer_from_obj(obj)
    return setmetatable(obj, TWaveLengthNanometer)
end

function TWaveLengthNanometer.new(WaveLengthNanometer)
    return TWaveLengthNanometer_from_obj({WaveLengthNanometer = WaveLengthNanometer})
end
---@param obj OpticalModule.WaveLengthNanometer
function TWaveLengthNanometer:init_from_obj(obj)
    self.WaveLengthNanometer = obj.WaveLengthNanometer
end

function TWaveLengthNanometer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWaveLengthNanometer.group)
end

TWaveLengthNanometer.from_obj = TWaveLengthNanometer_from_obj

TWaveLengthNanometer.proto_property = {'WaveLengthNanometer'}

TWaveLengthNanometer.default = {''}

TWaveLengthNanometer.struct = {{name = 'WaveLengthNanometer', is_array = false, struct = nil}}

function TWaveLengthNanometer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WaveLengthNanometer', self.WaveLengthNanometer, 'string', true, errs, need_convert)

    TWaveLengthNanometer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWaveLengthNanometer.proto_property, errs, need_convert)
    return self
end

function TWaveLengthNanometer:unpack(_)
    return self.WaveLengthNanometer
end

OpticalModule.WaveLengthNanometer = TWaveLengthNanometer

---@class OpticalModule.FiberConnectionType
---@field FiberConnectionType string
local TFiberConnectionType = {}
TFiberConnectionType.__index = TFiberConnectionType
TFiberConnectionType.group = {}

local function TFiberConnectionType_from_obj(obj)
    return setmetatable(obj, TFiberConnectionType)
end

function TFiberConnectionType.new(FiberConnectionType)
    return TFiberConnectionType_from_obj({FiberConnectionType = FiberConnectionType})
end
---@param obj OpticalModule.FiberConnectionType
function TFiberConnectionType:init_from_obj(obj)
    self.FiberConnectionType = obj.FiberConnectionType
end

function TFiberConnectionType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFiberConnectionType.group)
end

TFiberConnectionType.from_obj = TFiberConnectionType_from_obj

TFiberConnectionType.proto_property = {'FiberConnectionType'}

TFiberConnectionType.default = {''}

TFiberConnectionType.struct = {{name = 'FiberConnectionType', is_array = false, struct = nil}}

function TFiberConnectionType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FiberConnectionType', self.FiberConnectionType, 'string', true, errs, need_convert)

    TFiberConnectionType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFiberConnectionType.proto_property, errs, need_convert)
    return self
end

function TFiberConnectionType:unpack(_)
    return self.FiberConnectionType
end

OpticalModule.FiberConnectionType = TFiberConnectionType

---@class OpticalModule.TransceiverType
---@field TransceiverType string
local TTransceiverType = {}
TTransceiverType.__index = TTransceiverType
TTransceiverType.group = {}

local function TTransceiverType_from_obj(obj)
    return setmetatable(obj, TTransceiverType)
end

function TTransceiverType.new(TransceiverType)
    return TTransceiverType_from_obj({TransceiverType = TransceiverType})
end
---@param obj OpticalModule.TransceiverType
function TTransceiverType:init_from_obj(obj)
    self.TransceiverType = obj.TransceiverType
end

function TTransceiverType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTransceiverType.group)
end

TTransceiverType.from_obj = TTransceiverType_from_obj

TTransceiverType.proto_property = {'TransceiverType'}

TTransceiverType.default = {''}

TTransceiverType.struct = {{name = 'TransceiverType', is_array = false, struct = nil}}

function TTransceiverType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TransceiverType', self.TransceiverType, 'string', true, errs, need_convert)

    TTransceiverType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTransceiverType.proto_property, errs, need_convert)
    return self
end

function TTransceiverType:unpack(_)
    return self.TransceiverType
end

OpticalModule.TransceiverType = TTransceiverType

---@class OpticalModule.ProductionDate
---@field ProductionDate string
local TProductionDate = {}
TProductionDate.__index = TProductionDate
TProductionDate.group = {}

local function TProductionDate_from_obj(obj)
    return setmetatable(obj, TProductionDate)
end

function TProductionDate.new(ProductionDate)
    return TProductionDate_from_obj({ProductionDate = ProductionDate})
end
---@param obj OpticalModule.ProductionDate
function TProductionDate:init_from_obj(obj)
    self.ProductionDate = obj.ProductionDate
end

function TProductionDate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProductionDate.group)
end

TProductionDate.from_obj = TProductionDate_from_obj

TProductionDate.proto_property = {'ProductionDate'}

TProductionDate.default = {''}

TProductionDate.struct = {{name = 'ProductionDate', is_array = false, struct = nil}}

function TProductionDate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProductionDate', self.ProductionDate, 'string', true, errs, need_convert)

    TProductionDate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProductionDate.proto_property, errs, need_convert)
    return self
end

function TProductionDate:unpack(_)
    return self.ProductionDate
end

OpticalModule.ProductionDate = TProductionDate

---@class OpticalModule.RevisionNumber
---@field RevisionNumber string
local TRevisionNumber = {}
TRevisionNumber.__index = TRevisionNumber
TRevisionNumber.group = {}

local function TRevisionNumber_from_obj(obj)
    return setmetatable(obj, TRevisionNumber)
end

function TRevisionNumber.new(RevisionNumber)
    return TRevisionNumber_from_obj({RevisionNumber = RevisionNumber})
end
---@param obj OpticalModule.RevisionNumber
function TRevisionNumber:init_from_obj(obj)
    self.RevisionNumber = obj.RevisionNumber
end

function TRevisionNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRevisionNumber.group)
end

TRevisionNumber.from_obj = TRevisionNumber_from_obj

TRevisionNumber.proto_property = {'RevisionNumber'}

TRevisionNumber.default = {''}

TRevisionNumber.struct = {{name = 'RevisionNumber', is_array = false, struct = nil}}

function TRevisionNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RevisionNumber', self.RevisionNumber, 'string', true, errs, need_convert)

    TRevisionNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRevisionNumber.proto_property, errs, need_convert)
    return self
end

function TRevisionNumber:unpack(_)
    return self.RevisionNumber
end

OpticalModule.RevisionNumber = TRevisionNumber

---@class OpticalModule.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj OpticalModule.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

OpticalModule.SerialNumber = TSerialNumber

---@class OpticalModule.PartNumber
---@field PartNumber string
local TPartNumber = {}
TPartNumber.__index = TPartNumber
TPartNumber.group = {}

local function TPartNumber_from_obj(obj)
    return setmetatable(obj, TPartNumber)
end

function TPartNumber.new(PartNumber)
    return TPartNumber_from_obj({PartNumber = PartNumber})
end
---@param obj OpticalModule.PartNumber
function TPartNumber:init_from_obj(obj)
    self.PartNumber = obj.PartNumber
end

function TPartNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPartNumber.group)
end

TPartNumber.from_obj = TPartNumber_from_obj

TPartNumber.proto_property = {'PartNumber'}

TPartNumber.default = {''}

TPartNumber.struct = {{name = 'PartNumber', is_array = false, struct = nil}}

function TPartNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PartNumber', self.PartNumber, 'string', true, errs, need_convert)

    TPartNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPartNumber.proto_property, errs, need_convert)
    return self
end

function TPartNumber:unpack(_)
    return self.PartNumber
end

OpticalModule.PartNumber = TPartNumber

---@class OpticalModule.Manufacturer
---@field Manufacturer string
local TManufacturer = {}
TManufacturer.__index = TManufacturer
TManufacturer.group = {}

local function TManufacturer_from_obj(obj)
    return setmetatable(obj, TManufacturer)
end

function TManufacturer.new(Manufacturer)
    return TManufacturer_from_obj({Manufacturer = Manufacturer})
end
---@param obj OpticalModule.Manufacturer
function TManufacturer:init_from_obj(obj)
    self.Manufacturer = obj.Manufacturer
end

function TManufacturer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManufacturer.group)
end

TManufacturer.from_obj = TManufacturer_from_obj

TManufacturer.proto_property = {'Manufacturer'}

TManufacturer.default = {''}

TManufacturer.struct = {{name = 'Manufacturer', is_array = false, struct = nil}}

function TManufacturer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', true, errs, need_convert)

    TManufacturer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManufacturer.proto_property, errs, need_convert)
    return self
end

function TManufacturer:unpack(_)
    return self.Manufacturer
end

OpticalModule.Manufacturer = TManufacturer

---@class OpticalModule.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj OpticalModule.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

OpticalModule.Name = TName

OpticalModule.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule', {
    Name = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    RevisionNumber = {'s', nil, true, nil},
    ProductionDate = {'s', nil, true, nil},
    TransceiverType = {'s', nil, true, nil},
    FiberConnectionType = {'s', nil, true, nil},
    WaveLengthNanometer = {'s', nil, true, nil},
    Type = {'s', nil, true, nil},
    SupportedSpeedsMbps = {'ad', nil, true, nil},
    Presence = {'y', nil, true, nil},
    Health = {'y', nil, true, nil},
    Identifier = {'s', nil, true, nil},
    ConnectorType = {'s', nil, true, nil},
    MediumType = {'s', nil, true, nil},
    TransmissionDistance = {'s', nil, true, nil},
    RxLossState = {'b', nil, true, nil},
    TxLossState = {'b', nil, true, nil},
    TxFaultState = {'b', nil, true, nil},
    TypeMatch = {'b', nil, true, true},
    SpeedMatch = {'b', nil, true, true},
    FaultState = {'u', nil, true, nil},
    TemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, 65535},
    PowerState = {'y', nil, true, nil},
    IsSupportedType = {'y', nil, true, nil},
    HostSNR = {'ad', {}, true, nil},
    MediaSNR = {'ad', {}, true, nil},
    RxSNR = {'ad', {}, true, nil},
    Accessible = {'y', {'EMIT_CHANGE'}, true, nil},
    ModuleState = {'y', nil, true, 255},
    ChannelNum = {'y', nil, true, nil},
    RelatedNetworkPorts = {'ay', {}, true, nil},
    Id = {'y', {}, true, 255},
    SilkText = {'s', {}, true, nil}
}, {}, {})

return OpticalModule
