-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local MgmtPort = {}

MgmtPort.interface = mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.MgmtPort', {
    Id = {'y', nil, true, nil},
    EthId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    DeviceId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    DevicePortId = {'y', nil, true, nil},
    Silkscreen = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Type = {'s', nil, true, nil},
    AdaptiveFlag = {'b', nil, false, nil},
    LinkStatus = {'s', nil, false, nil},
    Mac = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    VLANEnabled = {'b', nil, true, false},
    VLANId = {'q', nil, true, 0},
    MinVLANId = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    MaxVLANId = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    NegotiatedSpeedMbps = {'y', nil, false, nil},
    OriginalGroupId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    CurrentGroupId = {'y', {['emitsChangedSignal'] = 'false'}, false, nil}
}, {}, {})

return MgmtPort
