-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Metrics = {}

---@class Metrics.BandwidthUsagePercent
---@field BandwidthUsagePercent number
local TBandwidthUsagePercent = {}
TBandwidthUsagePercent.__index = TBandwidthUsagePercent
TBandwidthUsagePercent.group = {}

local function TBandwidthUsagePercent_from_obj(obj)
    return setmetatable(obj, TBandwidthUsagePercent)
end

function TBandwidthUsagePercent.new(BandwidthUsagePercent)
    return TBandwidthUsagePercent_from_obj({BandwidthUsagePercent = BandwidthUsagePercent})
end
---@param obj Metrics.BandwidthUsagePercent
function TBandwidthUsagePercent:init_from_obj(obj)
    self.BandwidthUsagePercent = obj.BandwidthUsagePercent
end

function TBandwidthUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBandwidthUsagePercent.group)
end

TBandwidthUsagePercent.from_obj = TBandwidthUsagePercent_from_obj

TBandwidthUsagePercent.proto_property = {'BandwidthUsagePercent'}

TBandwidthUsagePercent.default = {0}

TBandwidthUsagePercent.struct = {{name = 'BandwidthUsagePercent', is_array = false, struct = nil}}

function TBandwidthUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthUsagePercent', self.BandwidthUsagePercent, 'double', true, errs, need_convert)

    TBandwidthUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBandwidthUsagePercent.proto_property, errs, need_convert)
    return self
end

function TBandwidthUsagePercent:unpack(_)
    return self.BandwidthUsagePercent
end

Metrics.BandwidthUsagePercent = TBandwidthUsagePercent

---@class Metrics.RXFalseCarrierErrors
---@field RXFalseCarrierErrors integer
local TRXFalseCarrierErrors = {}
TRXFalseCarrierErrors.__index = TRXFalseCarrierErrors
TRXFalseCarrierErrors.group = {}

local function TRXFalseCarrierErrors_from_obj(obj)
    return setmetatable(obj, TRXFalseCarrierErrors)
end

function TRXFalseCarrierErrors.new(RXFalseCarrierErrors)
    return TRXFalseCarrierErrors_from_obj({RXFalseCarrierErrors = RXFalseCarrierErrors})
end
---@param obj Metrics.RXFalseCarrierErrors
function TRXFalseCarrierErrors:init_from_obj(obj)
    self.RXFalseCarrierErrors = obj.RXFalseCarrierErrors
end

function TRXFalseCarrierErrors:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXFalseCarrierErrors.group)
end

TRXFalseCarrierErrors.from_obj = TRXFalseCarrierErrors_from_obj

TRXFalseCarrierErrors.proto_property = {'RXFalseCarrierErrors'}

TRXFalseCarrierErrors.default = {0}

TRXFalseCarrierErrors.struct = {{name = 'RXFalseCarrierErrors', is_array = false, struct = nil}}

function TRXFalseCarrierErrors:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXFalseCarrierErrors', self.RXFalseCarrierErrors, 'uint64', true, errs, need_convert)

    TRXFalseCarrierErrors:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXFalseCarrierErrors.proto_property, errs, need_convert)
    return self
end

function TRXFalseCarrierErrors:unpack(_)
    return self.RXFalseCarrierErrors
end

Metrics.RXFalseCarrierErrors = TRXFalseCarrierErrors

---@class Metrics.TXPauseXONFrames
---@field TXPauseXONFrames integer
local TTXPauseXONFrames = {}
TTXPauseXONFrames.__index = TTXPauseXONFrames
TTXPauseXONFrames.group = {}

local function TTXPauseXONFrames_from_obj(obj)
    return setmetatable(obj, TTXPauseXONFrames)
end

function TTXPauseXONFrames.new(TXPauseXONFrames)
    return TTXPauseXONFrames_from_obj({TXPauseXONFrames = TXPauseXONFrames})
end
---@param obj Metrics.TXPauseXONFrames
function TTXPauseXONFrames:init_from_obj(obj)
    self.TXPauseXONFrames = obj.TXPauseXONFrames
end

function TTXPauseXONFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXPauseXONFrames.group)
end

TTXPauseXONFrames.from_obj = TTXPauseXONFrames_from_obj

TTXPauseXONFrames.proto_property = {'TXPauseXONFrames'}

TTXPauseXONFrames.default = {0}

TTXPauseXONFrames.struct = {{name = 'TXPauseXONFrames', is_array = false, struct = nil}}

function TTXPauseXONFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXPauseXONFrames', self.TXPauseXONFrames, 'uint64', true, errs, need_convert)

    TTXPauseXONFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXPauseXONFrames.proto_property, errs, need_convert)
    return self
end

function TTXPauseXONFrames:unpack(_)
    return self.TXPauseXONFrames
end

Metrics.TXPauseXONFrames = TTXPauseXONFrames

---@class Metrics.TXPauseXOFFFrames
---@field TXPauseXOFFFrames integer
local TTXPauseXOFFFrames = {}
TTXPauseXOFFFrames.__index = TTXPauseXOFFFrames
TTXPauseXOFFFrames.group = {}

local function TTXPauseXOFFFrames_from_obj(obj)
    return setmetatable(obj, TTXPauseXOFFFrames)
end

function TTXPauseXOFFFrames.new(TXPauseXOFFFrames)
    return TTXPauseXOFFFrames_from_obj({TXPauseXOFFFrames = TXPauseXOFFFrames})
end
---@param obj Metrics.TXPauseXOFFFrames
function TTXPauseXOFFFrames:init_from_obj(obj)
    self.TXPauseXOFFFrames = obj.TXPauseXOFFFrames
end

function TTXPauseXOFFFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXPauseXOFFFrames.group)
end

TTXPauseXOFFFrames.from_obj = TTXPauseXOFFFrames_from_obj

TTXPauseXOFFFrames.proto_property = {'TXPauseXOFFFrames'}

TTXPauseXOFFFrames.default = {0}

TTXPauseXOFFFrames.struct = {{name = 'TXPauseXOFFFrames', is_array = false, struct = nil}}

function TTXPauseXOFFFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXPauseXOFFFrames', self.TXPauseXOFFFrames, 'uint64', true, errs, need_convert)

    TTXPauseXOFFFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXPauseXOFFFrames.proto_property, errs, need_convert)
    return self
end

function TTXPauseXOFFFrames:unpack(_)
    return self.TXPauseXOFFFrames
end

Metrics.TXPauseXOFFFrames = TTXPauseXOFFFrames

---@class Metrics.RXPauseXONFrames
---@field RXPauseXONFrames integer
local TRXPauseXONFrames = {}
TRXPauseXONFrames.__index = TRXPauseXONFrames
TRXPauseXONFrames.group = {}

local function TRXPauseXONFrames_from_obj(obj)
    return setmetatable(obj, TRXPauseXONFrames)
end

function TRXPauseXONFrames.new(RXPauseXONFrames)
    return TRXPauseXONFrames_from_obj({RXPauseXONFrames = RXPauseXONFrames})
end
---@param obj Metrics.RXPauseXONFrames
function TRXPauseXONFrames:init_from_obj(obj)
    self.RXPauseXONFrames = obj.RXPauseXONFrames
end

function TRXPauseXONFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXPauseXONFrames.group)
end

TRXPauseXONFrames.from_obj = TRXPauseXONFrames_from_obj

TRXPauseXONFrames.proto_property = {'RXPauseXONFrames'}

TRXPauseXONFrames.default = {0}

TRXPauseXONFrames.struct = {{name = 'RXPauseXONFrames', is_array = false, struct = nil}}

function TRXPauseXONFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXPauseXONFrames', self.RXPauseXONFrames, 'uint64', true, errs, need_convert)

    TRXPauseXONFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXPauseXONFrames.proto_property, errs, need_convert)
    return self
end

function TRXPauseXONFrames:unpack(_)
    return self.RXPauseXONFrames
end

Metrics.RXPauseXONFrames = TRXPauseXONFrames

---@class Metrics.RXPauseXOFFFrames
---@field RXPauseXOFFFrames integer
local TRXPauseXOFFFrames = {}
TRXPauseXOFFFrames.__index = TRXPauseXOFFFrames
TRXPauseXOFFFrames.group = {}

local function TRXPauseXOFFFrames_from_obj(obj)
    return setmetatable(obj, TRXPauseXOFFFrames)
end

function TRXPauseXOFFFrames.new(RXPauseXOFFFrames)
    return TRXPauseXOFFFrames_from_obj({RXPauseXOFFFrames = RXPauseXOFFFrames})
end
---@param obj Metrics.RXPauseXOFFFrames
function TRXPauseXOFFFrames:init_from_obj(obj)
    self.RXPauseXOFFFrames = obj.RXPauseXOFFFrames
end

function TRXPauseXOFFFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXPauseXOFFFrames.group)
end

TRXPauseXOFFFrames.from_obj = TRXPauseXOFFFrames_from_obj

TRXPauseXOFFFrames.proto_property = {'RXPauseXOFFFrames'}

TRXPauseXOFFFrames.default = {0}

TRXPauseXOFFFrames.struct = {{name = 'RXPauseXOFFFrames', is_array = false, struct = nil}}

function TRXPauseXOFFFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXPauseXOFFFrames', self.RXPauseXOFFFrames, 'uint64', true, errs, need_convert)

    TRXPauseXOFFFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXPauseXOFFFrames.proto_property, errs, need_convert)
    return self
end

function TRXPauseXOFFFrames:unpack(_)
    return self.RXPauseXOFFFrames
end

Metrics.RXPauseXOFFFrames = TRXPauseXOFFFrames

---@class Metrics.RXFrameAlignmentErrors
---@field RXFrameAlignmentErrors string
local TRXFrameAlignmentErrors = {}
TRXFrameAlignmentErrors.__index = TRXFrameAlignmentErrors
TRXFrameAlignmentErrors.group = {}

local function TRXFrameAlignmentErrors_from_obj(obj)
    return setmetatable(obj, TRXFrameAlignmentErrors)
end

function TRXFrameAlignmentErrors.new(RXFrameAlignmentErrors)
    return TRXFrameAlignmentErrors_from_obj({RXFrameAlignmentErrors = RXFrameAlignmentErrors})
end
---@param obj Metrics.RXFrameAlignmentErrors
function TRXFrameAlignmentErrors:init_from_obj(obj)
    self.RXFrameAlignmentErrors = obj.RXFrameAlignmentErrors
end

function TRXFrameAlignmentErrors:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXFrameAlignmentErrors.group)
end

TRXFrameAlignmentErrors.from_obj = TRXFrameAlignmentErrors_from_obj

TRXFrameAlignmentErrors.proto_property = {'RXFrameAlignmentErrors'}

TRXFrameAlignmentErrors.default = {''}

TRXFrameAlignmentErrors.struct = {{name = 'RXFrameAlignmentErrors', is_array = false, struct = nil}}

function TRXFrameAlignmentErrors:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXFrameAlignmentErrors', self.RXFrameAlignmentErrors, 'string', true, errs,
        need_convert)

    TRXFrameAlignmentErrors:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXFrameAlignmentErrors.proto_property, errs, need_convert)
    return self
end

function TRXFrameAlignmentErrors:unpack(_)
    return self.RXFrameAlignmentErrors
end

Metrics.RXFrameAlignmentErrors = TRXFrameAlignmentErrors

---@class Metrics.TXExcessiveCollisions
---@field TXExcessiveCollisions string
local TTXExcessiveCollisions = {}
TTXExcessiveCollisions.__index = TTXExcessiveCollisions
TTXExcessiveCollisions.group = {}

local function TTXExcessiveCollisions_from_obj(obj)
    return setmetatable(obj, TTXExcessiveCollisions)
end

function TTXExcessiveCollisions.new(TXExcessiveCollisions)
    return TTXExcessiveCollisions_from_obj({TXExcessiveCollisions = TXExcessiveCollisions})
end
---@param obj Metrics.TXExcessiveCollisions
function TTXExcessiveCollisions:init_from_obj(obj)
    self.TXExcessiveCollisions = obj.TXExcessiveCollisions
end

function TTXExcessiveCollisions:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXExcessiveCollisions.group)
end

TTXExcessiveCollisions.from_obj = TTXExcessiveCollisions_from_obj

TTXExcessiveCollisions.proto_property = {'TXExcessiveCollisions'}

TTXExcessiveCollisions.default = {''}

TTXExcessiveCollisions.struct = {{name = 'TXExcessiveCollisions', is_array = false, struct = nil}}

function TTXExcessiveCollisions:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXExcessiveCollisions', self.TXExcessiveCollisions, 'string', true, errs, need_convert)

    TTXExcessiveCollisions:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXExcessiveCollisions.proto_property, errs, need_convert)
    return self
end

function TTXExcessiveCollisions:unpack(_)
    return self.TXExcessiveCollisions
end

Metrics.TXExcessiveCollisions = TTXExcessiveCollisions

---@class Metrics.TXLateCollisions
---@field TXLateCollisions string
local TTXLateCollisions = {}
TTXLateCollisions.__index = TTXLateCollisions
TTXLateCollisions.group = {}

local function TTXLateCollisions_from_obj(obj)
    return setmetatable(obj, TTXLateCollisions)
end

function TTXLateCollisions.new(TXLateCollisions)
    return TTXLateCollisions_from_obj({TXLateCollisions = TXLateCollisions})
end
---@param obj Metrics.TXLateCollisions
function TTXLateCollisions:init_from_obj(obj)
    self.TXLateCollisions = obj.TXLateCollisions
end

function TTXLateCollisions:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXLateCollisions.group)
end

TTXLateCollisions.from_obj = TTXLateCollisions_from_obj

TTXLateCollisions.proto_property = {'TXLateCollisions'}

TTXLateCollisions.default = {''}

TTXLateCollisions.struct = {{name = 'TXLateCollisions', is_array = false, struct = nil}}

function TTXLateCollisions:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXLateCollisions', self.TXLateCollisions, 'string', true, errs, need_convert)

    TTXLateCollisions:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXLateCollisions.proto_property, errs, need_convert)
    return self
end

function TTXLateCollisions:unpack(_)
    return self.TXLateCollisions
end

Metrics.TXLateCollisions = TTXLateCollisions

---@class Metrics.TXMultipleCollisions
---@field TXMultipleCollisions string
local TTXMultipleCollisions = {}
TTXMultipleCollisions.__index = TTXMultipleCollisions
TTXMultipleCollisions.group = {}

local function TTXMultipleCollisions_from_obj(obj)
    return setmetatable(obj, TTXMultipleCollisions)
end

function TTXMultipleCollisions.new(TXMultipleCollisions)
    return TTXMultipleCollisions_from_obj({TXMultipleCollisions = TXMultipleCollisions})
end
---@param obj Metrics.TXMultipleCollisions
function TTXMultipleCollisions:init_from_obj(obj)
    self.TXMultipleCollisions = obj.TXMultipleCollisions
end

function TTXMultipleCollisions:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXMultipleCollisions.group)
end

TTXMultipleCollisions.from_obj = TTXMultipleCollisions_from_obj

TTXMultipleCollisions.proto_property = {'TXMultipleCollisions'}

TTXMultipleCollisions.default = {''}

TTXMultipleCollisions.struct = {{name = 'TXMultipleCollisions', is_array = false, struct = nil}}

function TTXMultipleCollisions:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXMultipleCollisions', self.TXMultipleCollisions, 'string', true, errs, need_convert)

    TTXMultipleCollisions:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXMultipleCollisions.proto_property, errs, need_convert)
    return self
end

function TTXMultipleCollisions:unpack(_)
    return self.TXMultipleCollisions
end

Metrics.TXMultipleCollisions = TTXMultipleCollisions

---@class Metrics.TXSingleCollisions
---@field TXSingleCollisions string
local TTXSingleCollisions = {}
TTXSingleCollisions.__index = TTXSingleCollisions
TTXSingleCollisions.group = {}

local function TTXSingleCollisions_from_obj(obj)
    return setmetatable(obj, TTXSingleCollisions)
end

function TTXSingleCollisions.new(TXSingleCollisions)
    return TTXSingleCollisions_from_obj({TXSingleCollisions = TXSingleCollisions})
end
---@param obj Metrics.TXSingleCollisions
function TTXSingleCollisions:init_from_obj(obj)
    self.TXSingleCollisions = obj.TXSingleCollisions
end

function TTXSingleCollisions:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXSingleCollisions.group)
end

TTXSingleCollisions.from_obj = TTXSingleCollisions_from_obj

TTXSingleCollisions.proto_property = {'TXSingleCollisions'}

TTXSingleCollisions.default = {''}

TTXSingleCollisions.struct = {{name = 'TXSingleCollisions', is_array = false, struct = nil}}

function TTXSingleCollisions:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXSingleCollisions', self.TXSingleCollisions, 'string', true, errs, need_convert)

    TTXSingleCollisions:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXSingleCollisions.proto_property, errs, need_convert)
    return self
end

function TTXSingleCollisions:unpack(_)
    return self.TXSingleCollisions
end

Metrics.TXSingleCollisions = TTXSingleCollisions

---@class Metrics.RXOversizeFrames
---@field RXOversizeFrames string
local TRXOversizeFrames = {}
TRXOversizeFrames.__index = TRXOversizeFrames
TRXOversizeFrames.group = {}

local function TRXOversizeFrames_from_obj(obj)
    return setmetatable(obj, TRXOversizeFrames)
end

function TRXOversizeFrames.new(RXOversizeFrames)
    return TRXOversizeFrames_from_obj({RXOversizeFrames = RXOversizeFrames})
end
---@param obj Metrics.RXOversizeFrames
function TRXOversizeFrames:init_from_obj(obj)
    self.RXOversizeFrames = obj.RXOversizeFrames
end

function TRXOversizeFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXOversizeFrames.group)
end

TRXOversizeFrames.from_obj = TRXOversizeFrames_from_obj

TRXOversizeFrames.proto_property = {'RXOversizeFrames'}

TRXOversizeFrames.default = {''}

TRXOversizeFrames.struct = {{name = 'RXOversizeFrames', is_array = false, struct = nil}}

function TRXOversizeFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXOversizeFrames', self.RXOversizeFrames, 'string', true, errs, need_convert)

    TRXOversizeFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXOversizeFrames.proto_property, errs, need_convert)
    return self
end

function TRXOversizeFrames:unpack(_)
    return self.RXOversizeFrames
end

Metrics.RXOversizeFrames = TRXOversizeFrames

---@class Metrics.RXUndersizeFrames
---@field RXUndersizeFrames string
local TRXUndersizeFrames = {}
TRXUndersizeFrames.__index = TRXUndersizeFrames
TRXUndersizeFrames.group = {}

local function TRXUndersizeFrames_from_obj(obj)
    return setmetatable(obj, TRXUndersizeFrames)
end

function TRXUndersizeFrames.new(RXUndersizeFrames)
    return TRXUndersizeFrames_from_obj({RXUndersizeFrames = RXUndersizeFrames})
end
---@param obj Metrics.RXUndersizeFrames
function TRXUndersizeFrames:init_from_obj(obj)
    self.RXUndersizeFrames = obj.RXUndersizeFrames
end

function TRXUndersizeFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXUndersizeFrames.group)
end

TRXUndersizeFrames.from_obj = TRXUndersizeFrames_from_obj

TRXUndersizeFrames.proto_property = {'RXUndersizeFrames'}

TRXUndersizeFrames.default = {''}

TRXUndersizeFrames.struct = {{name = 'RXUndersizeFrames', is_array = false, struct = nil}}

function TRXUndersizeFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXUndersizeFrames', self.RXUndersizeFrames, 'string', true, errs, need_convert)

    TRXUndersizeFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXUndersizeFrames.proto_property, errs, need_convert)
    return self
end

function TRXUndersizeFrames:unpack(_)
    return self.RXUndersizeFrames
end

Metrics.RXUndersizeFrames = TRXUndersizeFrames

---@class Metrics.RXFCSErrors
---@field RXFCSErrors string
local TRXFCSErrors = {}
TRXFCSErrors.__index = TRXFCSErrors
TRXFCSErrors.group = {}

local function TRXFCSErrors_from_obj(obj)
    return setmetatable(obj, TRXFCSErrors)
end

function TRXFCSErrors.new(RXFCSErrors)
    return TRXFCSErrors_from_obj({RXFCSErrors = RXFCSErrors})
end
---@param obj Metrics.RXFCSErrors
function TRXFCSErrors:init_from_obj(obj)
    self.RXFCSErrors = obj.RXFCSErrors
end

function TRXFCSErrors:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXFCSErrors.group)
end

TRXFCSErrors.from_obj = TRXFCSErrors_from_obj

TRXFCSErrors.proto_property = {'RXFCSErrors'}

TRXFCSErrors.default = {''}

TRXFCSErrors.struct = {{name = 'RXFCSErrors', is_array = false, struct = nil}}

function TRXFCSErrors:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXFCSErrors', self.RXFCSErrors, 'string', true, errs, need_convert)

    TRXFCSErrors:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXFCSErrors.proto_property, errs, need_convert)
    return self
end

function TRXFCSErrors:unpack(_)
    return self.RXFCSErrors
end

Metrics.RXFCSErrors = TRXFCSErrors

---@class Metrics.TXBroadcastFrames
---@field TXBroadcastFrames string
local TTXBroadcastFrames = {}
TTXBroadcastFrames.__index = TTXBroadcastFrames
TTXBroadcastFrames.group = {}

local function TTXBroadcastFrames_from_obj(obj)
    return setmetatable(obj, TTXBroadcastFrames)
end

function TTXBroadcastFrames.new(TXBroadcastFrames)
    return TTXBroadcastFrames_from_obj({TXBroadcastFrames = TXBroadcastFrames})
end
---@param obj Metrics.TXBroadcastFrames
function TTXBroadcastFrames:init_from_obj(obj)
    self.TXBroadcastFrames = obj.TXBroadcastFrames
end

function TTXBroadcastFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBroadcastFrames.group)
end

TTXBroadcastFrames.from_obj = TTXBroadcastFrames_from_obj

TTXBroadcastFrames.proto_property = {'TXBroadcastFrames'}

TTXBroadcastFrames.default = {''}

TTXBroadcastFrames.struct = {{name = 'TXBroadcastFrames', is_array = false, struct = nil}}

function TTXBroadcastFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBroadcastFrames', self.TXBroadcastFrames, 'string', true, errs, need_convert)

    TTXBroadcastFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBroadcastFrames.proto_property, errs, need_convert)
    return self
end

function TTXBroadcastFrames:unpack(_)
    return self.TXBroadcastFrames
end

Metrics.TXBroadcastFrames = TTXBroadcastFrames

---@class Metrics.TXMulticastFrames
---@field TXMulticastFrames string
local TTXMulticastFrames = {}
TTXMulticastFrames.__index = TTXMulticastFrames
TTXMulticastFrames.group = {}

local function TTXMulticastFrames_from_obj(obj)
    return setmetatable(obj, TTXMulticastFrames)
end

function TTXMulticastFrames.new(TXMulticastFrames)
    return TTXMulticastFrames_from_obj({TXMulticastFrames = TXMulticastFrames})
end
---@param obj Metrics.TXMulticastFrames
function TTXMulticastFrames:init_from_obj(obj)
    self.TXMulticastFrames = obj.TXMulticastFrames
end

function TTXMulticastFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXMulticastFrames.group)
end

TTXMulticastFrames.from_obj = TTXMulticastFrames_from_obj

TTXMulticastFrames.proto_property = {'TXMulticastFrames'}

TTXMulticastFrames.default = {''}

TTXMulticastFrames.struct = {{name = 'TXMulticastFrames', is_array = false, struct = nil}}

function TTXMulticastFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXMulticastFrames', self.TXMulticastFrames, 'string', true, errs, need_convert)

    TTXMulticastFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXMulticastFrames.proto_property, errs, need_convert)
    return self
end

function TTXMulticastFrames:unpack(_)
    return self.TXMulticastFrames
end

Metrics.TXMulticastFrames = TTXMulticastFrames

---@class Metrics.TXUnicastFrames
---@field TXUnicastFrames string
local TTXUnicastFrames = {}
TTXUnicastFrames.__index = TTXUnicastFrames
TTXUnicastFrames.group = {}

local function TTXUnicastFrames_from_obj(obj)
    return setmetatable(obj, TTXUnicastFrames)
end

function TTXUnicastFrames.new(TXUnicastFrames)
    return TTXUnicastFrames_from_obj({TXUnicastFrames = TXUnicastFrames})
end
---@param obj Metrics.TXUnicastFrames
function TTXUnicastFrames:init_from_obj(obj)
    self.TXUnicastFrames = obj.TXUnicastFrames
end

function TTXUnicastFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXUnicastFrames.group)
end

TTXUnicastFrames.from_obj = TTXUnicastFrames_from_obj

TTXUnicastFrames.proto_property = {'TXUnicastFrames'}

TTXUnicastFrames.default = {''}

TTXUnicastFrames.struct = {{name = 'TXUnicastFrames', is_array = false, struct = nil}}

function TTXUnicastFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXUnicastFrames', self.TXUnicastFrames, 'string', true, errs, need_convert)

    TTXUnicastFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXUnicastFrames.proto_property, errs, need_convert)
    return self
end

function TTXUnicastFrames:unpack(_)
    return self.TXUnicastFrames
end

Metrics.TXUnicastFrames = TTXUnicastFrames

---@class Metrics.RXBroadcastFrames
---@field RXBroadcastFrames string
local TRXBroadcastFrames = {}
TRXBroadcastFrames.__index = TRXBroadcastFrames
TRXBroadcastFrames.group = {}

local function TRXBroadcastFrames_from_obj(obj)
    return setmetatable(obj, TRXBroadcastFrames)
end

function TRXBroadcastFrames.new(RXBroadcastFrames)
    return TRXBroadcastFrames_from_obj({RXBroadcastFrames = RXBroadcastFrames})
end
---@param obj Metrics.RXBroadcastFrames
function TRXBroadcastFrames:init_from_obj(obj)
    self.RXBroadcastFrames = obj.RXBroadcastFrames
end

function TRXBroadcastFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXBroadcastFrames.group)
end

TRXBroadcastFrames.from_obj = TRXBroadcastFrames_from_obj

TRXBroadcastFrames.proto_property = {'RXBroadcastFrames'}

TRXBroadcastFrames.default = {''}

TRXBroadcastFrames.struct = {{name = 'RXBroadcastFrames', is_array = false, struct = nil}}

function TRXBroadcastFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXBroadcastFrames', self.RXBroadcastFrames, 'string', true, errs, need_convert)

    TRXBroadcastFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXBroadcastFrames.proto_property, errs, need_convert)
    return self
end

function TRXBroadcastFrames:unpack(_)
    return self.RXBroadcastFrames
end

Metrics.RXBroadcastFrames = TRXBroadcastFrames

---@class Metrics.RXMulticastFrames
---@field RXMulticastFrames string
local TRXMulticastFrames = {}
TRXMulticastFrames.__index = TRXMulticastFrames
TRXMulticastFrames.group = {}

local function TRXMulticastFrames_from_obj(obj)
    return setmetatable(obj, TRXMulticastFrames)
end

function TRXMulticastFrames.new(RXMulticastFrames)
    return TRXMulticastFrames_from_obj({RXMulticastFrames = RXMulticastFrames})
end
---@param obj Metrics.RXMulticastFrames
function TRXMulticastFrames:init_from_obj(obj)
    self.RXMulticastFrames = obj.RXMulticastFrames
end

function TRXMulticastFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXMulticastFrames.group)
end

TRXMulticastFrames.from_obj = TRXMulticastFrames_from_obj

TRXMulticastFrames.proto_property = {'RXMulticastFrames'}

TRXMulticastFrames.default = {''}

TRXMulticastFrames.struct = {{name = 'RXMulticastFrames', is_array = false, struct = nil}}

function TRXMulticastFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXMulticastFrames', self.RXMulticastFrames, 'string', true, errs, need_convert)

    TRXMulticastFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXMulticastFrames.proto_property, errs, need_convert)
    return self
end

function TRXMulticastFrames:unpack(_)
    return self.RXMulticastFrames
end

Metrics.RXMulticastFrames = TRXMulticastFrames

---@class Metrics.RXUnicastFrames
---@field RXUnicastFrames string
local TRXUnicastFrames = {}
TRXUnicastFrames.__index = TRXUnicastFrames
TRXUnicastFrames.group = {}

local function TRXUnicastFrames_from_obj(obj)
    return setmetatable(obj, TRXUnicastFrames)
end

function TRXUnicastFrames.new(RXUnicastFrames)
    return TRXUnicastFrames_from_obj({RXUnicastFrames = RXUnicastFrames})
end
---@param obj Metrics.RXUnicastFrames
function TRXUnicastFrames:init_from_obj(obj)
    self.RXUnicastFrames = obj.RXUnicastFrames
end

function TRXUnicastFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXUnicastFrames.group)
end

TRXUnicastFrames.from_obj = TRXUnicastFrames_from_obj

TRXUnicastFrames.proto_property = {'RXUnicastFrames'}

TRXUnicastFrames.default = {''}

TRXUnicastFrames.struct = {{name = 'RXUnicastFrames', is_array = false, struct = nil}}

function TRXUnicastFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXUnicastFrames', self.RXUnicastFrames, 'string', true, errs, need_convert)

    TRXUnicastFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXUnicastFrames.proto_property, errs, need_convert)
    return self
end

function TRXUnicastFrames:unpack(_)
    return self.RXUnicastFrames
end

Metrics.RXUnicastFrames = TRXUnicastFrames

---@class Metrics.PacketsDropped
---@field PacketsDropped integer
local TPacketsDropped = {}
TPacketsDropped.__index = TPacketsDropped
TPacketsDropped.group = {}

local function TPacketsDropped_from_obj(obj)
    return setmetatable(obj, TPacketsDropped)
end

function TPacketsDropped.new(PacketsDropped)
    return TPacketsDropped_from_obj({PacketsDropped = PacketsDropped})
end
---@param obj Metrics.PacketsDropped
function TPacketsDropped:init_from_obj(obj)
    self.PacketsDropped = obj.PacketsDropped
end

function TPacketsDropped:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPacketsDropped.group)
end

TPacketsDropped.from_obj = TPacketsDropped_from_obj

TPacketsDropped.proto_property = {'PacketsDropped'}

TPacketsDropped.default = {0}

TPacketsDropped.struct = {{name = 'PacketsDropped', is_array = false, struct = nil}}

function TPacketsDropped:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PacketsDropped', self.PacketsDropped, 'uint64', true, errs, need_convert)

    TPacketsDropped:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPacketsDropped.proto_property, errs, need_convert)
    return self
end

function TPacketsDropped:unpack(_)
    return self.PacketsDropped
end

Metrics.PacketsDropped = TPacketsDropped

---@class Metrics.TXFrames
---@field TXFrames string
local TTXFrames = {}
TTXFrames.__index = TTXFrames
TTXFrames.group = {}

local function TTXFrames_from_obj(obj)
    return setmetatable(obj, TTXFrames)
end

function TTXFrames.new(TXFrames)
    return TTXFrames_from_obj({TXFrames = TXFrames})
end
---@param obj Metrics.TXFrames
function TTXFrames:init_from_obj(obj)
    self.TXFrames = obj.TXFrames
end

function TTXFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXFrames.group)
end

TTXFrames.from_obj = TTXFrames_from_obj

TTXFrames.proto_property = {'TXFrames'}

TTXFrames.default = {''}

TTXFrames.struct = {{name = 'TXFrames', is_array = false, struct = nil}}

function TTXFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXFrames', self.TXFrames, 'string', true, errs, need_convert)

    TTXFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXFrames.proto_property, errs, need_convert)
    return self
end

function TTXFrames:unpack(_)
    return self.TXFrames
end

Metrics.TXFrames = TTXFrames

---@class Metrics.RXFrames
---@field RXFrames string
local TRXFrames = {}
TRXFrames.__index = TRXFrames
TRXFrames.group = {}

local function TRXFrames_from_obj(obj)
    return setmetatable(obj, TRXFrames)
end

function TRXFrames.new(RXFrames)
    return TRXFrames_from_obj({RXFrames = RXFrames})
end
---@param obj Metrics.RXFrames
function TRXFrames:init_from_obj(obj)
    self.RXFrames = obj.RXFrames
end

function TRXFrames:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXFrames.group)
end

TRXFrames.from_obj = TRXFrames_from_obj

TRXFrames.proto_property = {'RXFrames'}

TRXFrames.default = {''}

TRXFrames.struct = {{name = 'RXFrames', is_array = false, struct = nil}}

function TRXFrames:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXFrames', self.RXFrames, 'string', true, errs, need_convert)

    TRXFrames:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXFrames.proto_property, errs, need_convert)
    return self
end

function TRXFrames:unpack(_)
    return self.RXFrames
end

Metrics.RXFrames = TRXFrames

Metrics.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.Metrics', {
    RXFrames = {'s', {'VOLATILE'}, true, nil},
    TXFrames = {'s', {'VOLATILE'}, true, nil},
    PacketsDropped = {'t', {'VOLATILE'}, true, nil},
    RXUnicastFrames = {'s', {'VOLATILE'}, true, nil},
    RXMulticastFrames = {'s', {'VOLATILE'}, true, nil},
    RXBroadcastFrames = {'s', {'VOLATILE'}, true, nil},
    TXUnicastFrames = {'s', {'VOLATILE'}, true, nil},
    TXMulticastFrames = {'s', {'VOLATILE'}, true, nil},
    TXBroadcastFrames = {'s', {'VOLATILE'}, true, nil},
    RXFCSErrors = {'s', {'VOLATILE'}, true, nil},
    RXUndersizeFrames = {'s', {'VOLATILE'}, true, nil},
    RXOversizeFrames = {'s', {'VOLATILE'}, true, nil},
    TXSingleCollisions = {'s', {'VOLATILE'}, true, nil},
    TXMultipleCollisions = {'s', {'VOLATILE'}, true, nil},
    TXLateCollisions = {'s', {'VOLATILE'}, true, nil},
    TXExcessiveCollisions = {'s', {'VOLATILE'}, true, nil},
    RXFrameAlignmentErrors = {'s', {'VOLATILE'}, true, nil},
    RXPauseXOFFFrames = {'t', {'VOLATILE'}, true, nil},
    RXPauseXONFrames = {'t', {'VOLATILE'}, true, nil},
    TXPauseXOFFFrames = {'t', {'VOLATILE'}, true, nil},
    TXPauseXONFrames = {'t', {'VOLATILE'}, true, nil},
    RXFalseCarrierErrors = {'t', {'VOLATILE'}, true, nil},
    BandwidthUsagePercent = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil}
}, {}, {})

return Metrics
