-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local IPv4Address = {}

---@class IPv4Address.AddressOrigin
---@field AddressOrigin string
local TAddressOrigin = {}
TAddressOrigin.__index = TAddressOrigin
TAddressOrigin.group = {}

local function TAddressOrigin_from_obj(obj)
    return setmetatable(obj, TAddressOrigin)
end

function TAddressOrigin.new(AddressOrigin)
    return TAddressOrigin_from_obj({AddressOrigin = AddressOrigin})
end
---@param obj IPv4Address.AddressOrigin
function TAddressOrigin:init_from_obj(obj)
    self.AddressOrigin = obj.AddressOrigin
end

function TAddressOrigin:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddressOrigin.group)
end

TAddressOrigin.from_obj = TAddressOrigin_from_obj

TAddressOrigin.proto_property = {'AddressOrigin'}

TAddressOrigin.default = {''}

TAddressOrigin.struct = {{name = 'AddressOrigin', is_array = false, struct = nil}}

function TAddressOrigin:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AddressOrigin', self.AddressOrigin, 'string', true, errs, need_convert)

    if self.AddressOrigin ~= nil then
        validate.Enum(prefix .. 'AddressOrigin', self.AddressOrigin, '', {'Static', 'DHCP'}, errs, need_convert)
    end

    TAddressOrigin:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddressOrigin.proto_property, errs, need_convert)
    return self
end

function TAddressOrigin:unpack(_)
    return self.AddressOrigin
end

IPv4Address.AddressOrigin = TAddressOrigin

---@class IPv4Address.Gateway
---@field Gateway string
local TGateway = {}
TGateway.__index = TGateway
TGateway.group = {}

local function TGateway_from_obj(obj)
    return setmetatable(obj, TGateway)
end

function TGateway.new(Gateway)
    return TGateway_from_obj({Gateway = Gateway})
end
---@param obj IPv4Address.Gateway
function TGateway:init_from_obj(obj)
    self.Gateway = obj.Gateway
end

function TGateway:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGateway.group)
end

TGateway.from_obj = TGateway_from_obj

TGateway.proto_property = {'Gateway'}

TGateway.default = {''}

TGateway.struct = {{name = 'Gateway', is_array = false, struct = nil}}

function TGateway:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Gateway', self.Gateway, 'string', true, errs, need_convert)

    TGateway:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGateway.proto_property, errs, need_convert)
    return self
end

function TGateway:unpack(_)
    return self.Gateway
end

IPv4Address.Gateway = TGateway

---@class IPv4Address.SubnetMask
---@field SubnetMask string
local TSubnetMask = {}
TSubnetMask.__index = TSubnetMask
TSubnetMask.group = {}

local function TSubnetMask_from_obj(obj)
    return setmetatable(obj, TSubnetMask)
end

function TSubnetMask.new(SubnetMask)
    return TSubnetMask_from_obj({SubnetMask = SubnetMask})
end
---@param obj IPv4Address.SubnetMask
function TSubnetMask:init_from_obj(obj)
    self.SubnetMask = obj.SubnetMask
end

function TSubnetMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubnetMask.group)
end

TSubnetMask.from_obj = TSubnetMask_from_obj

TSubnetMask.proto_property = {'SubnetMask'}

TSubnetMask.default = {''}

TSubnetMask.struct = {{name = 'SubnetMask', is_array = false, struct = nil}}

function TSubnetMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubnetMask', self.SubnetMask, 'string', true, errs, need_convert)

    TSubnetMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubnetMask.proto_property, errs, need_convert)
    return self
end

function TSubnetMask:unpack(_)
    return self.SubnetMask
end

IPv4Address.SubnetMask = TSubnetMask

---@class IPv4Address.Address
---@field Address string
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address})
end
---@param obj IPv4Address.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {''}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Address', self.Address, 'string', true, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

IPv4Address.Address = TAddress

IPv4Address.interface = mdb.register_interface('bmc.kepler.Systems.IPv4Address', {
    Address = {'s', nil, true, nil},
    SubnetMask = {'s', nil, true, nil},
    Gateway = {'s', nil, true, nil},
    AddressOrigin = {'s', nil, true, nil}
}, {}, {})

return IPv4Address
