-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Diagnose = {}

---@class Diagnose.ContaminationDetectionSupported
---@field ContaminationDetectionSupported boolean
local TContaminationDetectionSupported = {}
TContaminationDetectionSupported.__index = TContaminationDetectionSupported
TContaminationDetectionSupported.group = {}

local function TContaminationDetectionSupported_from_obj(obj)
    return setmetatable(obj, TContaminationDetectionSupported)
end

function TContaminationDetectionSupported.new(ContaminationDetectionSupported)
    return
        TContaminationDetectionSupported_from_obj({ContaminationDetectionSupported = ContaminationDetectionSupported})
end
---@param obj Diagnose.ContaminationDetectionSupported
function TContaminationDetectionSupported:init_from_obj(obj)
    self.ContaminationDetectionSupported = obj.ContaminationDetectionSupported
end

function TContaminationDetectionSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContaminationDetectionSupported.group)
end

TContaminationDetectionSupported.from_obj = TContaminationDetectionSupported_from_obj

TContaminationDetectionSupported.proto_property = {'ContaminationDetectionSupported'}

TContaminationDetectionSupported.default = {false}

TContaminationDetectionSupported.struct = {{name = 'ContaminationDetectionSupported', is_array = false, struct = nil}}

function TContaminationDetectionSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContaminationDetectionSupported', self.ContaminationDetectionSupported, 'bool', true,
        errs, need_convert)

    TContaminationDetectionSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContaminationDetectionSupported.proto_property, errs, need_convert)
    return self
end

function TContaminationDetectionSupported:unpack(_)
    return self.ContaminationDetectionSupported
end

Diagnose.ContaminationDetectionSupported = TContaminationDetectionSupported

---@class Diagnose.FiberLoosenessDetected
---@field FiberLoosenessDetected boolean
local TFiberLoosenessDetected = {}
TFiberLoosenessDetected.__index = TFiberLoosenessDetected
TFiberLoosenessDetected.group = {}

local function TFiberLoosenessDetected_from_obj(obj)
    return setmetatable(obj, TFiberLoosenessDetected)
end

function TFiberLoosenessDetected.new(FiberLoosenessDetected)
    return TFiberLoosenessDetected_from_obj({FiberLoosenessDetected = FiberLoosenessDetected})
end
---@param obj Diagnose.FiberLoosenessDetected
function TFiberLoosenessDetected:init_from_obj(obj)
    self.FiberLoosenessDetected = obj.FiberLoosenessDetected
end

function TFiberLoosenessDetected:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFiberLoosenessDetected.group)
end

TFiberLoosenessDetected.from_obj = TFiberLoosenessDetected_from_obj

TFiberLoosenessDetected.proto_property = {'FiberLoosenessDetected'}

TFiberLoosenessDetected.default = {false}

TFiberLoosenessDetected.struct = {{name = 'FiberLoosenessDetected', is_array = false, struct = nil}}

function TFiberLoosenessDetected:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FiberLoosenessDetected', self.FiberLoosenessDetected, 'bool', false, errs, need_convert)

    TFiberLoosenessDetected:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFiberLoosenessDetected.proto_property, errs, need_convert)
    return self
end

function TFiberLoosenessDetected:unpack(_)
    return self.FiberLoosenessDetected
end

Diagnose.FiberLoosenessDetected = TFiberLoosenessDetected

---@class Diagnose.FiberDirtyDetected
---@field FiberDirtyDetected boolean
local TFiberDirtyDetected = {}
TFiberDirtyDetected.__index = TFiberDirtyDetected
TFiberDirtyDetected.group = {}

local function TFiberDirtyDetected_from_obj(obj)
    return setmetatable(obj, TFiberDirtyDetected)
end

function TFiberDirtyDetected.new(FiberDirtyDetected)
    return TFiberDirtyDetected_from_obj({FiberDirtyDetected = FiberDirtyDetected})
end
---@param obj Diagnose.FiberDirtyDetected
function TFiberDirtyDetected:init_from_obj(obj)
    self.FiberDirtyDetected = obj.FiberDirtyDetected
end

function TFiberDirtyDetected:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFiberDirtyDetected.group)
end

TFiberDirtyDetected.from_obj = TFiberDirtyDetected_from_obj

TFiberDirtyDetected.proto_property = {'FiberDirtyDetected'}

TFiberDirtyDetected.default = {false}

TFiberDirtyDetected.struct = {{name = 'FiberDirtyDetected', is_array = false, struct = nil}}

function TFiberDirtyDetected:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FiberDirtyDetected', self.FiberDirtyDetected, 'bool', false, errs, need_convert)

    TFiberDirtyDetected:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFiberDirtyDetected.proto_property, errs, need_convert)
    return self
end

function TFiberDirtyDetected:unpack(_)
    return self.FiberDirtyDetected
end

Diagnose.FiberDirtyDetected = TFiberDirtyDetected

---@class Diagnose.PRBSTestSupported
---@field PRBSTestSupported boolean
local TPRBSTestSupported = {}
TPRBSTestSupported.__index = TPRBSTestSupported
TPRBSTestSupported.group = {}

local function TPRBSTestSupported_from_obj(obj)
    return setmetatable(obj, TPRBSTestSupported)
end

function TPRBSTestSupported.new(PRBSTestSupported)
    return TPRBSTestSupported_from_obj({PRBSTestSupported = PRBSTestSupported})
end
---@param obj Diagnose.PRBSTestSupported
function TPRBSTestSupported:init_from_obj(obj)
    self.PRBSTestSupported = obj.PRBSTestSupported
end

function TPRBSTestSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPRBSTestSupported.group)
end

TPRBSTestSupported.from_obj = TPRBSTestSupported_from_obj

TPRBSTestSupported.proto_property = {'PRBSTestSupported'}

TPRBSTestSupported.default = {false}

TPRBSTestSupported.struct = {{name = 'PRBSTestSupported', is_array = false, struct = nil}}

function TPRBSTestSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PRBSTestSupported', self.PRBSTestSupported, 'bool', true, errs, need_convert)

    TPRBSTestSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPRBSTestSupported.proto_property, errs, need_convert)
    return self
end

function TPRBSTestSupported:unpack(_)
    return self.PRBSTestSupported
end

Diagnose.PRBSTestSupported = TPRBSTestSupported

---@class Diagnose.TxFault
---@field TxFault integer
local TTxFault = {}
TTxFault.__index = TTxFault
TTxFault.group = {}

local function TTxFault_from_obj(obj)
    return setmetatable(obj, TTxFault)
end

function TTxFault.new(TxFault)
    return TTxFault_from_obj({TxFault = TxFault})
end
---@param obj Diagnose.TxFault
function TTxFault:init_from_obj(obj)
    self.TxFault = obj.TxFault
end

function TTxFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxFault.group)
end

TTxFault.from_obj = TTxFault_from_obj

TTxFault.proto_property = {'TxFault'}

TTxFault.default = {0}

TTxFault.struct = {{name = 'TxFault', is_array = false, struct = nil}}

function TTxFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxFault', self.TxFault, 'uint32', true, errs, need_convert)

    TTxFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxFault.proto_property, errs, need_convert)
    return self
end

function TTxFault:unpack(_)
    return self.TxFault
end

Diagnose.TxFault = TTxFault

---@class Diagnose.TxLoS
---@field TxLoS integer
local TTxLoS = {}
TTxLoS.__index = TTxLoS
TTxLoS.group = {}

local function TTxLoS_from_obj(obj)
    return setmetatable(obj, TTxLoS)
end

function TTxLoS.new(TxLoS)
    return TTxLoS_from_obj({TxLoS = TxLoS})
end
---@param obj Diagnose.TxLoS
function TTxLoS:init_from_obj(obj)
    self.TxLoS = obj.TxLoS
end

function TTxLoS:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxLoS.group)
end

TTxLoS.from_obj = TTxLoS_from_obj

TTxLoS.proto_property = {'TxLoS'}

TTxLoS.default = {0}

TTxLoS.struct = {{name = 'TxLoS', is_array = false, struct = nil}}

function TTxLoS:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxLoS', self.TxLoS, 'uint32', true, errs, need_convert)

    TTxLoS:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxLoS.proto_property, errs, need_convert)
    return self
end

function TTxLoS:unpack(_)
    return self.TxLoS
end

Diagnose.TxLoS = TTxLoS

---@class Diagnose.RxLoS
---@field RxLoS integer
local TRxLoS = {}
TRxLoS.__index = TRxLoS
TRxLoS.group = {}

local function TRxLoS_from_obj(obj)
    return setmetatable(obj, TRxLoS)
end

function TRxLoS.new(RxLoS)
    return TRxLoS_from_obj({RxLoS = RxLoS})
end
---@param obj Diagnose.RxLoS
function TRxLoS:init_from_obj(obj)
    self.RxLoS = obj.RxLoS
end

function TRxLoS:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRxLoS.group)
end

TRxLoS.from_obj = TRxLoS_from_obj

TRxLoS.proto_property = {'RxLoS'}

TRxLoS.default = {0}

TRxLoS.struct = {{name = 'RxLoS', is_array = false, struct = nil}}

function TRxLoS:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RxLoS', self.RxLoS, 'uint32', true, errs, need_convert)

    TRxLoS:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRxLoS.proto_property, errs, need_convert)
    return self
end

function TRxLoS:unpack(_)
    return self.RxLoS
end

Diagnose.RxLoS = TRxLoS

---@class Diagnose.HostInterfaceFaultStatus
---@field HostInterfaceFaultStatus integer
local THostInterfaceFaultStatus = {}
THostInterfaceFaultStatus.__index = THostInterfaceFaultStatus
THostInterfaceFaultStatus.group = {}

local function THostInterfaceFaultStatus_from_obj(obj)
    return setmetatable(obj, THostInterfaceFaultStatus)
end

function THostInterfaceFaultStatus.new(HostInterfaceFaultStatus)
    return THostInterfaceFaultStatus_from_obj({HostInterfaceFaultStatus = HostInterfaceFaultStatus})
end
---@param obj Diagnose.HostInterfaceFaultStatus
function THostInterfaceFaultStatus:init_from_obj(obj)
    self.HostInterfaceFaultStatus = obj.HostInterfaceFaultStatus
end

function THostInterfaceFaultStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THostInterfaceFaultStatus.group)
end

THostInterfaceFaultStatus.from_obj = THostInterfaceFaultStatus_from_obj

THostInterfaceFaultStatus.proto_property = {'HostInterfaceFaultStatus'}

THostInterfaceFaultStatus.default = {0}

THostInterfaceFaultStatus.struct = {{name = 'HostInterfaceFaultStatus', is_array = false, struct = nil}}

function THostInterfaceFaultStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HostInterfaceFaultStatus', self.HostInterfaceFaultStatus, 'uint16', true, errs,
        need_convert)

    THostInterfaceFaultStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THostInterfaceFaultStatus.proto_property, errs, need_convert)
    return self
end

function THostInterfaceFaultStatus:unpack(_)
    return self.HostInterfaceFaultStatus
end

Diagnose.HostInterfaceFaultStatus = THostInterfaceFaultStatus

---@class Diagnose.MediaInterfaceFaultStatus
---@field MediaInterfaceFaultStatus integer
local TMediaInterfaceFaultStatus = {}
TMediaInterfaceFaultStatus.__index = TMediaInterfaceFaultStatus
TMediaInterfaceFaultStatus.group = {}

local function TMediaInterfaceFaultStatus_from_obj(obj)
    return setmetatable(obj, TMediaInterfaceFaultStatus)
end

function TMediaInterfaceFaultStatus.new(MediaInterfaceFaultStatus)
    return TMediaInterfaceFaultStatus_from_obj({MediaInterfaceFaultStatus = MediaInterfaceFaultStatus})
end
---@param obj Diagnose.MediaInterfaceFaultStatus
function TMediaInterfaceFaultStatus:init_from_obj(obj)
    self.MediaInterfaceFaultStatus = obj.MediaInterfaceFaultStatus
end

function TMediaInterfaceFaultStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediaInterfaceFaultStatus.group)
end

TMediaInterfaceFaultStatus.from_obj = TMediaInterfaceFaultStatus_from_obj

TMediaInterfaceFaultStatus.proto_property = {'MediaInterfaceFaultStatus'}

TMediaInterfaceFaultStatus.default = {0}

TMediaInterfaceFaultStatus.struct = {{name = 'MediaInterfaceFaultStatus', is_array = false, struct = nil}}

function TMediaInterfaceFaultStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediaInterfaceFaultStatus', self.MediaInterfaceFaultStatus, 'uint16', true, errs,
        need_convert)

    TMediaInterfaceFaultStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediaInterfaceFaultStatus.proto_property, errs, need_convert)
    return self
end

function TMediaInterfaceFaultStatus:unpack(_)
    return self.MediaInterfaceFaultStatus
end

Diagnose.MediaInterfaceFaultStatus = TMediaInterfaceFaultStatus

---@class Diagnose.SelfTestStatus
---@field SelfTestStatus integer
local TSelfTestStatus = {}
TSelfTestStatus.__index = TSelfTestStatus
TSelfTestStatus.group = {}

local function TSelfTestStatus_from_obj(obj)
    return setmetatable(obj, TSelfTestStatus)
end

function TSelfTestStatus.new(SelfTestStatus)
    return TSelfTestStatus_from_obj({SelfTestStatus = SelfTestStatus})
end
---@param obj Diagnose.SelfTestStatus
function TSelfTestStatus:init_from_obj(obj)
    self.SelfTestStatus = obj.SelfTestStatus
end

function TSelfTestStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSelfTestStatus.group)
end

TSelfTestStatus.from_obj = TSelfTestStatus_from_obj

TSelfTestStatus.proto_property = {'SelfTestStatus'}

TSelfTestStatus.default = {0}

TSelfTestStatus.struct = {{name = 'SelfTestStatus', is_array = false, struct = nil}}

function TSelfTestStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SelfTestStatus', self.SelfTestStatus, 'uint64', true, errs, need_convert)

    TSelfTestStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSelfTestStatus.proto_property, errs, need_convert)
    return self
end

function TSelfTestStatus:unpack(_)
    return self.SelfTestStatus
end

Diagnose.SelfTestStatus = TSelfTestStatus

---@class Diagnose.OdspHighTempRuntimeSeconds
---@field OdspHighTempRuntimeSeconds integer
local TOdspHighTempRuntimeSeconds = {}
TOdspHighTempRuntimeSeconds.__index = TOdspHighTempRuntimeSeconds
TOdspHighTempRuntimeSeconds.group = {}

local function TOdspHighTempRuntimeSeconds_from_obj(obj)
    return setmetatable(obj, TOdspHighTempRuntimeSeconds)
end

function TOdspHighTempRuntimeSeconds.new(OdspHighTempRuntimeSeconds)
    return TOdspHighTempRuntimeSeconds_from_obj({OdspHighTempRuntimeSeconds = OdspHighTempRuntimeSeconds})
end
---@param obj Diagnose.OdspHighTempRuntimeSeconds
function TOdspHighTempRuntimeSeconds:init_from_obj(obj)
    self.OdspHighTempRuntimeSeconds = obj.OdspHighTempRuntimeSeconds
end

function TOdspHighTempRuntimeSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOdspHighTempRuntimeSeconds.group)
end

TOdspHighTempRuntimeSeconds.from_obj = TOdspHighTempRuntimeSeconds_from_obj

TOdspHighTempRuntimeSeconds.proto_property = {'OdspHighTempRuntimeSeconds'}

TOdspHighTempRuntimeSeconds.default = {0}

TOdspHighTempRuntimeSeconds.struct = {{name = 'OdspHighTempRuntimeSeconds', is_array = false, struct = nil}}

function TOdspHighTempRuntimeSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OdspHighTempRuntimeSeconds', self.OdspHighTempRuntimeSeconds, 'uint32', true, errs,
        need_convert)

    TOdspHighTempRuntimeSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOdspHighTempRuntimeSeconds.proto_property, errs, need_convert)
    return self
end

function TOdspHighTempRuntimeSeconds:unpack(_)
    return self.OdspHighTempRuntimeSeconds
end

Diagnose.OdspHighTempRuntimeSeconds = TOdspHighTempRuntimeSeconds

---@class Diagnose.OdspDieTemperatureCelsius
---@field OdspDieTemperatureCelsius number
local TOdspDieTemperatureCelsius = {}
TOdspDieTemperatureCelsius.__index = TOdspDieTemperatureCelsius
TOdspDieTemperatureCelsius.group = {}

local function TOdspDieTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TOdspDieTemperatureCelsius)
end

function TOdspDieTemperatureCelsius.new(OdspDieTemperatureCelsius)
    return TOdspDieTemperatureCelsius_from_obj({OdspDieTemperatureCelsius = OdspDieTemperatureCelsius})
end
---@param obj Diagnose.OdspDieTemperatureCelsius
function TOdspDieTemperatureCelsius:init_from_obj(obj)
    self.OdspDieTemperatureCelsius = obj.OdspDieTemperatureCelsius
end

function TOdspDieTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOdspDieTemperatureCelsius.group)
end

TOdspDieTemperatureCelsius.from_obj = TOdspDieTemperatureCelsius_from_obj

TOdspDieTemperatureCelsius.proto_property = {'OdspDieTemperatureCelsius'}

TOdspDieTemperatureCelsius.default = {0}

TOdspDieTemperatureCelsius.struct = {{name = 'OdspDieTemperatureCelsius', is_array = false, struct = nil}}

function TOdspDieTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OdspDieTemperatureCelsius', self.OdspDieTemperatureCelsius, 'double', true, errs,
        need_convert)

    TOdspDieTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOdspDieTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TOdspDieTemperatureCelsius:unpack(_)
    return self.OdspDieTemperatureCelsius
end

Diagnose.OdspDieTemperatureCelsius = TOdspDieTemperatureCelsius

---@class Diagnose.PowerStatus
---@field PowerStatus integer
local TPowerStatus = {}
TPowerStatus.__index = TPowerStatus
TPowerStatus.group = {}

local function TPowerStatus_from_obj(obj)
    return setmetatable(obj, TPowerStatus)
end

function TPowerStatus.new(PowerStatus)
    return TPowerStatus_from_obj({PowerStatus = PowerStatus})
end
---@param obj Diagnose.PowerStatus
function TPowerStatus:init_from_obj(obj)
    self.PowerStatus = obj.PowerStatus
end

function TPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerStatus.group)
end

TPowerStatus.from_obj = TPowerStatus_from_obj

TPowerStatus.proto_property = {'PowerStatus'}

TPowerStatus.default = {0}

TPowerStatus.struct = {{name = 'PowerStatus', is_array = false, struct = nil}}

function TPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerStatus', self.PowerStatus, 'uint16', true, errs, need_convert)

    TPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerStatus.proto_property, errs, need_convert)
    return self
end

function TPowerStatus:unpack(_)
    return self.PowerStatus
end

Diagnose.PowerStatus = TPowerStatus

---@class Diagnose.UptimeSeconds
---@field UptimeSeconds integer
local TUptimeSeconds = {}
TUptimeSeconds.__index = TUptimeSeconds
TUptimeSeconds.group = {}

local function TUptimeSeconds_from_obj(obj)
    return setmetatable(obj, TUptimeSeconds)
end

function TUptimeSeconds.new(UptimeSeconds)
    return TUptimeSeconds_from_obj({UptimeSeconds = UptimeSeconds})
end
---@param obj Diagnose.UptimeSeconds
function TUptimeSeconds:init_from_obj(obj)
    self.UptimeSeconds = obj.UptimeSeconds
end

function TUptimeSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUptimeSeconds.group)
end

TUptimeSeconds.from_obj = TUptimeSeconds_from_obj

TUptimeSeconds.proto_property = {'UptimeSeconds'}

TUptimeSeconds.default = {0}

TUptimeSeconds.struct = {{name = 'UptimeSeconds', is_array = false, struct = nil}}

function TUptimeSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UptimeSeconds', self.UptimeSeconds, 'uint32', true, errs, need_convert)

    TUptimeSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUptimeSeconds.proto_property, errs, need_convert)
    return self
end

function TUptimeSeconds:unpack(_)
    return self.UptimeSeconds
end

Diagnose.UptimeSeconds = TUptimeSeconds

---@class Diagnose.PowerOnCount
---@field PowerOnCount integer
local TPowerOnCount = {}
TPowerOnCount.__index = TPowerOnCount
TPowerOnCount.group = {}

local function TPowerOnCount_from_obj(obj)
    return setmetatable(obj, TPowerOnCount)
end

function TPowerOnCount.new(PowerOnCount)
    return TPowerOnCount_from_obj({PowerOnCount = PowerOnCount})
end
---@param obj Diagnose.PowerOnCount
function TPowerOnCount:init_from_obj(obj)
    self.PowerOnCount = obj.PowerOnCount
end

function TPowerOnCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnCount.group)
end

TPowerOnCount.from_obj = TPowerOnCount_from_obj

TPowerOnCount.proto_property = {'PowerOnCount'}

TPowerOnCount.default = {0}

TPowerOnCount.struct = {{name = 'PowerOnCount', is_array = false, struct = nil}}

function TPowerOnCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnCount', self.PowerOnCount, 'uint16', true, errs, need_convert)

    TPowerOnCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnCount.proto_property, errs, need_convert)
    return self
end

function TPowerOnCount:unpack(_)
    return self.PowerOnCount
end

Diagnose.PowerOnCount = TPowerOnCount

---@class Diagnose.LaserTemperatureCelsius
---@field LaserTemperatureCelsius number
local TLaserTemperatureCelsius = {}
TLaserTemperatureCelsius.__index = TLaserTemperatureCelsius
TLaserTemperatureCelsius.group = {}

local function TLaserTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TLaserTemperatureCelsius)
end

function TLaserTemperatureCelsius.new(LaserTemperatureCelsius)
    return TLaserTemperatureCelsius_from_obj({LaserTemperatureCelsius = LaserTemperatureCelsius})
end
---@param obj Diagnose.LaserTemperatureCelsius
function TLaserTemperatureCelsius:init_from_obj(obj)
    self.LaserTemperatureCelsius = obj.LaserTemperatureCelsius
end

function TLaserTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLaserTemperatureCelsius.group)
end

TLaserTemperatureCelsius.from_obj = TLaserTemperatureCelsius_from_obj

TLaserTemperatureCelsius.proto_property = {'LaserTemperatureCelsius'}

TLaserTemperatureCelsius.default = {0}

TLaserTemperatureCelsius.struct = {{name = 'LaserTemperatureCelsius', is_array = false, struct = nil}}

function TLaserTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LaserTemperatureCelsius', self.LaserTemperatureCelsius, 'double', true, errs,
        need_convert)

    TLaserTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLaserTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TLaserTemperatureCelsius:unpack(_)
    return self.LaserTemperatureCelsius
end

Diagnose.LaserTemperatureCelsius = TLaserTemperatureCelsius

---@class Diagnose.LaserRuntimeSeconds
---@field LaserRuntimeSeconds integer
local TLaserRuntimeSeconds = {}
TLaserRuntimeSeconds.__index = TLaserRuntimeSeconds
TLaserRuntimeSeconds.group = {}

local function TLaserRuntimeSeconds_from_obj(obj)
    return setmetatable(obj, TLaserRuntimeSeconds)
end

function TLaserRuntimeSeconds.new(LaserRuntimeSeconds)
    return TLaserRuntimeSeconds_from_obj({LaserRuntimeSeconds = LaserRuntimeSeconds})
end
---@param obj Diagnose.LaserRuntimeSeconds
function TLaserRuntimeSeconds:init_from_obj(obj)
    self.LaserRuntimeSeconds = obj.LaserRuntimeSeconds
end

function TLaserRuntimeSeconds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLaserRuntimeSeconds.group)
end

TLaserRuntimeSeconds.from_obj = TLaserRuntimeSeconds_from_obj

TLaserRuntimeSeconds.proto_property = {'LaserRuntimeSeconds'}

TLaserRuntimeSeconds.default = {0}

TLaserRuntimeSeconds.struct = {{name = 'LaserRuntimeSeconds', is_array = false, struct = nil}}

function TLaserRuntimeSeconds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LaserRuntimeSeconds', self.LaserRuntimeSeconds, 'uint32', true, errs, need_convert)

    TLaserRuntimeSeconds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLaserRuntimeSeconds.proto_property, errs, need_convert)
    return self
end

function TLaserRuntimeSeconds:unpack(_)
    return self.LaserRuntimeSeconds
end

Diagnose.LaserRuntimeSeconds = TLaserRuntimeSeconds

---@class Diagnose.TxLossOfLock
---@field TxLossOfLock integer
local TTxLossOfLock = {}
TTxLossOfLock.__index = TTxLossOfLock
TTxLossOfLock.group = {}

local function TTxLossOfLock_from_obj(obj)
    return setmetatable(obj, TTxLossOfLock)
end

function TTxLossOfLock.new(TxLossOfLock)
    return TTxLossOfLock_from_obj({TxLossOfLock = TxLossOfLock})
end
---@param obj Diagnose.TxLossOfLock
function TTxLossOfLock:init_from_obj(obj)
    self.TxLossOfLock = obj.TxLossOfLock
end

function TTxLossOfLock:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTxLossOfLock.group)
end

TTxLossOfLock.from_obj = TTxLossOfLock_from_obj

TTxLossOfLock.proto_property = {'TxLossOfLock'}

TTxLossOfLock.default = {0}

TTxLossOfLock.struct = {{name = 'TxLossOfLock', is_array = false, struct = nil}}

function TTxLossOfLock:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TxLossOfLock', self.TxLossOfLock, 'uint8', true, errs, need_convert)

    TTxLossOfLock:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTxLossOfLock.proto_property, errs, need_convert)
    return self
end

function TTxLossOfLock:unpack(_)
    return self.TxLossOfLock
end

Diagnose.TxLossOfLock = TTxLossOfLock

---@class Diagnose.RxLossOfLock
---@field RxLossOfLock integer
local TRxLossOfLock = {}
TRxLossOfLock.__index = TRxLossOfLock
TRxLossOfLock.group = {}

local function TRxLossOfLock_from_obj(obj)
    return setmetatable(obj, TRxLossOfLock)
end

function TRxLossOfLock.new(RxLossOfLock)
    return TRxLossOfLock_from_obj({RxLossOfLock = RxLossOfLock})
end
---@param obj Diagnose.RxLossOfLock
function TRxLossOfLock:init_from_obj(obj)
    self.RxLossOfLock = obj.RxLossOfLock
end

function TRxLossOfLock:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRxLossOfLock.group)
end

TRxLossOfLock.from_obj = TRxLossOfLock_from_obj

TRxLossOfLock.proto_property = {'RxLossOfLock'}

TRxLossOfLock.default = {0}

TRxLossOfLock.struct = {{name = 'RxLossOfLock', is_array = false, struct = nil}}

function TRxLossOfLock:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RxLossOfLock', self.RxLossOfLock, 'uint8', true, errs, need_convert)

    TRxLossOfLock:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRxLossOfLock.proto_property, errs, need_convert)
    return self
end

function TRxLossOfLock:unpack(_)
    return self.RxLossOfLock
end

Diagnose.RxLossOfLock = TRxLossOfLock

Diagnose.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.Diagnose', {
    RxLossOfLock = {'y', {'EMIT_CHANGE'}, true, nil},
    TxLossOfLock = {'y', {'EMIT_CHANGE'}, true, nil},
    LaserRuntimeSeconds = {'u', {}, true, nil},
    LaserTemperatureCelsius = {'d', {}, true, nil},
    PowerOnCount = {'q', {}, true, nil},
    UptimeSeconds = {'u', {}, true, nil},
    PowerStatus = {'q', {}, true, nil},
    OdspDieTemperatureCelsius = {'d', {}, true, nil},
    OdspHighTempRuntimeSeconds = {'u', {}, true, nil},
    SelfTestStatus = {'t', {'EMIT_CHANGE'}, true, nil},
    MediaInterfaceFaultStatus = {'q', {'EMIT_CHANGE'}, true, nil},
    HostInterfaceFaultStatus = {'q', {'EMIT_CHANGE'}, true, nil},
    RxLoS = {'u', {'EMIT_CHANGE'}, true, nil},
    TxLoS = {'u', {'EMIT_CHANGE'}, true, nil},
    TxFault = {'u', {'EMIT_CHANGE'}, true, nil},
    PRBSTestSupported = {'b', {'EMIT_CHANGE'}, true, nil},
    FiberDirtyDetected = {'b', nil, false, nil},
    FiberLoosenessDetected = {'b', nil, false, nil},
    ContaminationDetectionSupported = {'b', {}, true, nil}
}, {}, {})

return Diagnose
