-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DebugSystemsNetworkAdapters = {}

---@class DebugSystemsNetworkAdapters.DumpRsp
local TDumpRsp = {}
TDumpRsp.__index = TDumpRsp
TDumpRsp.group = {}

local function TDumpRsp_from_obj(obj)
    return setmetatable(obj, TDumpRsp)
end

function TDumpRsp.new()
    return TDumpRsp_from_obj({})
end
---@param obj DebugSystemsNetworkAdapters.DumpRsp
function TDumpRsp:init_from_obj(obj)

end

function TDumpRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpRsp.group)
end

TDumpRsp.from_obj = TDumpRsp_from_obj

TDumpRsp.proto_property = {}

TDumpRsp.default = {}

TDumpRsp.struct = {}

function TDumpRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDumpRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpRsp.proto_property, errs, need_convert)
    return self
end

function TDumpRsp:unpack(_)
end

DebugSystemsNetworkAdapters.DumpRsp = TDumpRsp

---@class DebugSystemsNetworkAdapters.DumpReq
local TDumpReq = {}
TDumpReq.__index = TDumpReq
TDumpReq.group = {}

local function TDumpReq_from_obj(obj)
    return setmetatable(obj, TDumpReq)
end

function TDumpReq.new()
    return TDumpReq_from_obj({})
end
---@param obj DebugSystemsNetworkAdapters.DumpReq
function TDumpReq:init_from_obj(obj)

end

function TDumpReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpReq.group)
end

TDumpReq.from_obj = TDumpReq_from_obj

TDumpReq.proto_property = {}

TDumpReq.default = {}

TDumpReq.struct = {}

function TDumpReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDumpReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpReq.proto_property, errs, need_convert)
    return self
end

function TDumpReq:unpack(_)
end

DebugSystemsNetworkAdapters.DumpReq = TDumpReq

DebugSystemsNetworkAdapters.interface = mdb.register_interface('bmc.kepler.Debug.Systems.NetworkAdapters', {},
    {Dump = {'a{ss}', '', TDumpReq, TDumpRsp}}, {})

return DebugSystemsNetworkAdapters
