-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ContaminationDetection = {}

---@class ContaminationDetection.ShutdownReq
---@field DetectorIds string[]
local TShutdownReq = {}
TShutdownReq.__index = TShutdownReq
TShutdownReq.group = {}

local function TShutdownReq_from_obj(obj)
    return setmetatable(obj, TShutdownReq)
end

function TShutdownReq.new(DetectorIds)
    return TShutdownReq_from_obj({DetectorIds = DetectorIds})
end
---@param obj ContaminationDetection.ShutdownReq
function TShutdownReq:init_from_obj(obj)
    self.DetectorIds = obj.DetectorIds
end

function TShutdownReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShutdownReq.group)
end

TShutdownReq.from_obj = TShutdownReq_from_obj

TShutdownReq.proto_property = {'DetectorIds'}

TShutdownReq.default = {{}}

TShutdownReq.struct = {{name = 'DetectorIds', is_array = true, struct = nil}}

function TShutdownReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DetectorIds', self.DetectorIds, 'string', false, errs, need_convert)

    TShutdownReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShutdownReq.proto_property, errs, need_convert)
    return self
end

function TShutdownReq:unpack(_)
    return self.DetectorIds
end

ContaminationDetection.ShutdownReq = TShutdownReq

---@class ContaminationDetection.GetResultsReq
---@field DetectorIds string[]
local TGetResultsReq = {}
TGetResultsReq.__index = TGetResultsReq
TGetResultsReq.group = {}

local function TGetResultsReq_from_obj(obj)
    return setmetatable(obj, TGetResultsReq)
end

function TGetResultsReq.new(DetectorIds)
    return TGetResultsReq_from_obj({DetectorIds = DetectorIds})
end
---@param obj ContaminationDetection.GetResultsReq
function TGetResultsReq:init_from_obj(obj)
    self.DetectorIds = obj.DetectorIds
end

function TGetResultsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultsReq.group)
end

TGetResultsReq.from_obj = TGetResultsReq_from_obj

TGetResultsReq.proto_property = {'DetectorIds'}

TGetResultsReq.default = {{}}

TGetResultsReq.struct = {{name = 'DetectorIds', is_array = true, struct = nil}}

function TGetResultsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DetectorIds', self.DetectorIds, 'string', false, errs, need_convert)

    TGetResultsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultsReq.proto_property, errs, need_convert)
    return self
end

function TGetResultsReq:unpack(_)
    return self.DetectorIds
end

ContaminationDetection.GetResultsReq = TGetResultsReq

---@class ContaminationDetection.Configuration
---@field DetectorId string
---@field DurationSeconds integer
local TConfiguration = {}
TConfiguration.__index = TConfiguration
TConfiguration.group = {}

local function TConfiguration_from_obj(obj)
    return setmetatable(obj, TConfiguration)
end

function TConfiguration.new(DetectorId, DurationSeconds)
    return TConfiguration_from_obj({DetectorId = DetectorId, DurationSeconds = DurationSeconds})
end
---@param obj ContaminationDetection.Configuration
function TConfiguration:init_from_obj(obj)
    self.DetectorId = obj.DetectorId
    self.DurationSeconds = obj.DurationSeconds
end

function TConfiguration:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfiguration.group)
end

TConfiguration.from_obj = TConfiguration_from_obj

TConfiguration.proto_property = {'DetectorId', 'DurationSeconds'}

TConfiguration.default = {'', 0}

TConfiguration.struct = {
    {name = 'DetectorId', is_array = false, struct = nil}, {name = 'DurationSeconds', is_array = false, struct = nil}
}

function TConfiguration:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DetectorId', self.DetectorId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'DurationSeconds', self.DurationSeconds, 'uint16', false, errs, need_convert)

    TConfiguration:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfiguration.proto_property, errs, need_convert)
    return self
end

function TConfiguration:unpack(_)
    return self.DetectorId, self.DurationSeconds
end

ContaminationDetection.Configuration = TConfiguration

---@class ContaminationDetection.InitiateReq
---@field Configuration ContaminationDetection.Configuration[]
local TInitiateReq = {}
TInitiateReq.__index = TInitiateReq
TInitiateReq.group = {}

local function TInitiateReq_from_obj(obj)
    obj.Configuration = utils.from_obj(ContaminationDetection.Configuration, obj.Configuration, true)
    return setmetatable(obj, TInitiateReq)
end

function TInitiateReq.new(Configuration)
    return TInitiateReq_from_obj({Configuration = Configuration})
end
---@param obj ContaminationDetection.InitiateReq
function TInitiateReq:init_from_obj(obj)
    self.Configuration = obj.Configuration
end

function TInitiateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitiateReq.group)
end

TInitiateReq.from_obj = TInitiateReq_from_obj

TInitiateReq.proto_property = {'Configuration'}

TInitiateReq.default = {{}}

TInitiateReq.struct = {{name = 'Configuration', is_array = true, struct = ContaminationDetection.Configuration.struct}}

function TInitiateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Configuration) do
        ContaminationDetection.Configuration.new(v.DetectorId, v.DurationSeconds):validate(prefix, errs, need_convert)
    end

    TInitiateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitiateReq.proto_property, errs, need_convert)
    return self
end

function TInitiateReq:unpack(raw)
    return utils.unpack(raw, self.Configuration, true)
end

ContaminationDetection.InitiateReq = TInitiateReq

---@class ContaminationDetection.OperationResults
---@field DetectorId string
---@field Result string
local TOperationResults = {}
TOperationResults.__index = TOperationResults
TOperationResults.group = {}

local function TOperationResults_from_obj(obj)
    return setmetatable(obj, TOperationResults)
end

function TOperationResults.new(DetectorId, Result)
    return TOperationResults_from_obj({DetectorId = DetectorId, Result = Result})
end
---@param obj ContaminationDetection.OperationResults
function TOperationResults:init_from_obj(obj)
    self.DetectorId = obj.DetectorId
    self.Result = obj.Result
end

function TOperationResults:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOperationResults.group)
end

TOperationResults.from_obj = TOperationResults_from_obj

TOperationResults.proto_property = {'DetectorId', 'Result'}

TOperationResults.default = {'', ''}

TOperationResults.struct = {
    {name = 'DetectorId', is_array = false, struct = nil}, {name = 'Result', is_array = false, struct = nil}
}

function TOperationResults:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DetectorId', self.DetectorId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Result', self.Result, 'string', false, errs, need_convert)

    TOperationResults:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOperationResults.proto_property, errs, need_convert)
    return self
end

function TOperationResults:unpack(_)
    return self.DetectorId, self.Result
end

ContaminationDetection.OperationResults = TOperationResults

---@class ContaminationDetection.ShutdownRsp
---@field OperationResults ContaminationDetection.OperationResults[]
local TShutdownRsp = {}
TShutdownRsp.__index = TShutdownRsp
TShutdownRsp.group = {}

local function TShutdownRsp_from_obj(obj)
    obj.OperationResults = utils.from_obj(ContaminationDetection.OperationResults, obj.OperationResults, true)
    return setmetatable(obj, TShutdownRsp)
end

function TShutdownRsp.new(OperationResults)
    return TShutdownRsp_from_obj({OperationResults = OperationResults})
end
---@param obj ContaminationDetection.ShutdownRsp
function TShutdownRsp:init_from_obj(obj)
    self.OperationResults = obj.OperationResults
end

function TShutdownRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShutdownRsp.group)
end

TShutdownRsp.from_obj = TShutdownRsp_from_obj

TShutdownRsp.proto_property = {'OperationResults'}

TShutdownRsp.default = {{}}

TShutdownRsp.struct = {
    {name = 'OperationResults', is_array = true, struct = ContaminationDetection.OperationResults.struct}
}

function TShutdownRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.OperationResults) do
        ContaminationDetection.OperationResults.new(v.DetectorId, v.Result):validate(prefix, errs, need_convert)
    end

    TShutdownRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShutdownRsp.proto_property, errs, need_convert)
    return self
end

function TShutdownRsp:unpack(raw)
    return utils.unpack(raw, self.OperationResults, true)
end

ContaminationDetection.ShutdownRsp = TShutdownRsp

---@class ContaminationDetection.StartRsp
---@field OperationResults ContaminationDetection.OperationResults[]
local TStartRsp = {}
TStartRsp.__index = TStartRsp
TStartRsp.group = {}

local function TStartRsp_from_obj(obj)
    obj.OperationResults = utils.from_obj(ContaminationDetection.OperationResults, obj.OperationResults, true)
    return setmetatable(obj, TStartRsp)
end

function TStartRsp.new(OperationResults)
    return TStartRsp_from_obj({OperationResults = OperationResults})
end
---@param obj ContaminationDetection.StartRsp
function TStartRsp:init_from_obj(obj)
    self.OperationResults = obj.OperationResults
end

function TStartRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRsp.group)
end

TStartRsp.from_obj = TStartRsp_from_obj

TStartRsp.proto_property = {'OperationResults'}

TStartRsp.default = {{}}

TStartRsp.struct = {
    {name = 'OperationResults', is_array = true, struct = ContaminationDetection.OperationResults.struct}
}

function TStartRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.OperationResults) do
        ContaminationDetection.OperationResults.new(v.DetectorId, v.Result):validate(prefix, errs, need_convert)
    end

    TStartRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRsp.proto_property, errs, need_convert)
    return self
end

function TStartRsp:unpack(raw)
    return utils.unpack(raw, self.OperationResults, true)
end

ContaminationDetection.StartRsp = TStartRsp

---@class ContaminationDetection.InitiateRsp
---@field OperationResults ContaminationDetection.OperationResults[]
local TInitiateRsp = {}
TInitiateRsp.__index = TInitiateRsp
TInitiateRsp.group = {}

local function TInitiateRsp_from_obj(obj)
    obj.OperationResults = utils.from_obj(ContaminationDetection.OperationResults, obj.OperationResults, true)
    return setmetatable(obj, TInitiateRsp)
end

function TInitiateRsp.new(OperationResults)
    return TInitiateRsp_from_obj({OperationResults = OperationResults})
end
---@param obj ContaminationDetection.InitiateRsp
function TInitiateRsp:init_from_obj(obj)
    self.OperationResults = obj.OperationResults
end

function TInitiateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitiateRsp.group)
end

TInitiateRsp.from_obj = TInitiateRsp_from_obj

TInitiateRsp.proto_property = {'OperationResults'}

TInitiateRsp.default = {{}}

TInitiateRsp.struct = {
    {name = 'OperationResults', is_array = true, struct = ContaminationDetection.OperationResults.struct}
}

function TInitiateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.OperationResults) do
        ContaminationDetection.OperationResults.new(v.DetectorId, v.Result):validate(prefix, errs, need_convert)
    end

    TInitiateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitiateRsp.proto_property, errs, need_convert)
    return self
end

function TInitiateRsp:unpack(raw)
    return utils.unpack(raw, self.OperationResults, true)
end

ContaminationDetection.InitiateRsp = TInitiateRsp

---@class ContaminationDetection.DetectionItem
---@field Key string
---@field Value string
local TDetectionItem = {}
TDetectionItem.__index = TDetectionItem
TDetectionItem.group = {}

local function TDetectionItem_from_obj(obj)
    return setmetatable(obj, TDetectionItem)
end

function TDetectionItem.new(Key, Value)
    return TDetectionItem_from_obj({Key = Key, Value = Value})
end
---@param obj ContaminationDetection.DetectionItem
function TDetectionItem:init_from_obj(obj)
    self.Key = obj.Key
    self.Value = obj.Value
end

function TDetectionItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDetectionItem.group)
end

TDetectionItem.from_obj = TDetectionItem_from_obj

TDetectionItem.proto_property = {'Key', 'Value'}

TDetectionItem.default = {'', ''}

TDetectionItem.struct = {
    {name = 'Key', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TDetectionItem:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Key', self.Key, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TDetectionItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDetectionItem.proto_property, errs, need_convert)
    return self
end

function TDetectionItem:unpack(_)
    return self.Key, self.Value
end

ContaminationDetection.DetectionItem = TDetectionItem

---@class ContaminationDetection.Detectors
---@field Detector ContaminationDetection.DetectionItem[]
local TDetectors = {}
TDetectors.__index = TDetectors
TDetectors.group = {}

local function TDetectors_from_obj(obj)
    obj.Detector = utils.from_obj(ContaminationDetection.DetectionItem, obj.Detector, true)
    return setmetatable(obj, TDetectors)
end

function TDetectors.new(Detector)
    return TDetectors_from_obj({Detector = Detector})
end
---@param obj ContaminationDetection.Detectors
function TDetectors:init_from_obj(obj)
    self.Detector = obj.Detector
end

function TDetectors:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDetectors.group)
end

TDetectors.from_obj = TDetectors_from_obj

TDetectors.proto_property = {'Detector'}

TDetectors.default = {{}}

TDetectors.struct = {{name = 'Detector', is_array = true, struct = ContaminationDetection.DetectionItem.struct}}

function TDetectors:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Detector) do
        ContaminationDetection.DetectionItem.new(v.Key, v.Value):validate(prefix, errs, need_convert)
    end

    TDetectors:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDetectors.proto_property, errs, need_convert)
    return self
end

function TDetectors:unpack(raw)
    return utils.unpack(raw, self.Detector, true)
end

ContaminationDetection.Detectors = TDetectors

---@class ContaminationDetection.StartReq
---@field Detectors ContaminationDetection.Detectors[]
local TStartReq = {}
TStartReq.__index = TStartReq
TStartReq.group = {}

local function TStartReq_from_obj(obj)
    obj.Detectors = utils.from_obj(ContaminationDetection.Detectors, obj.Detectors, true)
    return setmetatable(obj, TStartReq)
end

function TStartReq.new(Detectors)
    return TStartReq_from_obj({Detectors = Detectors})
end
---@param obj ContaminationDetection.StartReq
function TStartReq:init_from_obj(obj)
    self.Detectors = obj.Detectors
end

function TStartReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartReq.group)
end

TStartReq.from_obj = TStartReq_from_obj

TStartReq.proto_property = {'Detectors'}

TStartReq.default = {{}}

TStartReq.struct = {{name = 'Detectors', is_array = true, struct = ContaminationDetection.Detectors.struct}}

function TStartReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Detectors) do
        ContaminationDetection.Detectors.new(v.Detector):validate(prefix, errs, need_convert)
    end

    TStartReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartReq.proto_property, errs, need_convert)
    return self
end

function TStartReq:unpack(raw)
    return utils.unpack(raw, self.Detectors, true)
end

ContaminationDetection.StartReq = TStartReq

---@class ContaminationDetection.Detections
---@field Detection ContaminationDetection.DetectionItem[]
local TDetections = {}
TDetections.__index = TDetections
TDetections.group = {}

local function TDetections_from_obj(obj)
    obj.Detection = utils.from_obj(ContaminationDetection.DetectionItem, obj.Detection, true)
    return setmetatable(obj, TDetections)
end

function TDetections.new(Detection)
    return TDetections_from_obj({Detection = Detection})
end
---@param obj ContaminationDetection.Detections
function TDetections:init_from_obj(obj)
    self.Detection = obj.Detection
end

function TDetections:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDetections.group)
end

TDetections.from_obj = TDetections_from_obj

TDetections.proto_property = {'Detection'}

TDetections.default = {{}}

TDetections.struct = {{name = 'Detection', is_array = true, struct = ContaminationDetection.DetectionItem.struct}}

function TDetections:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Detection) do
        ContaminationDetection.DetectionItem.new(v.Key, v.Value):validate(prefix, errs, need_convert)
    end

    TDetections:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDetections.proto_property, errs, need_convert)
    return self
end

function TDetections:unpack(raw)
    return utils.unpack(raw, self.Detection, true)
end

ContaminationDetection.Detections = TDetections

---@class ContaminationDetection.GetResultsRsp
---@field Detections ContaminationDetection.Detections[]
local TGetResultsRsp = {}
TGetResultsRsp.__index = TGetResultsRsp
TGetResultsRsp.group = {}

local function TGetResultsRsp_from_obj(obj)
    obj.Detections = utils.from_obj(ContaminationDetection.Detections, obj.Detections, true)
    return setmetatable(obj, TGetResultsRsp)
end

function TGetResultsRsp.new(Detections)
    return TGetResultsRsp_from_obj({Detections = Detections})
end
---@param obj ContaminationDetection.GetResultsRsp
function TGetResultsRsp:init_from_obj(obj)
    self.Detections = obj.Detections
end

function TGetResultsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultsRsp.group)
end

TGetResultsRsp.from_obj = TGetResultsRsp_from_obj

TGetResultsRsp.proto_property = {'Detections'}

TGetResultsRsp.default = {{}}

TGetResultsRsp.struct = {{name = 'Detections', is_array = true, struct = ContaminationDetection.Detections.struct}}

function TGetResultsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.Detections) do
        ContaminationDetection.Detections.new(v.Detection):validate(prefix, errs, need_convert)
    end

    TGetResultsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultsRsp.proto_property, errs, need_convert)
    return self
end

function TGetResultsRsp:unpack(raw)
    return utils.unpack(raw, self.Detections, true)
end

ContaminationDetection.GetResultsRsp = TGetResultsRsp

ContaminationDetection.interface = mdb.register_interface(
    'bmc.kepler.Managers.DiagnosticService.ContaminationDetection', {}, {
        GetResults = {'a{ss}as', 'a(a(ss))', TGetResultsReq, TGetResultsRsp},
        Initiate = {'a{ss}a(sq)', 'a(ss)', TInitiateReq, TInitiateRsp},
        Start = {'a{ss}a(a(ss))', 'a(ss)', TStartReq, TStartRsp},
        Shutdown = {'a{ss}as', 'a(ss)', TShutdownReq, TShutdownRsp}
    }, {})

return ContaminationDetection
