-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Channel = {}

---@class Channel.TXPowerMilliWatts
---@field TXPowerMilliWatts number
local TTXPowerMilliWatts = {}
TTXPowerMilliWatts.__index = TTXPowerMilliWatts
TTXPowerMilliWatts.group = {}

local function TTXPowerMilliWatts_from_obj(obj)
    return setmetatable(obj, TTXPowerMilliWatts)
end

function TTXPowerMilliWatts.new(TXPowerMilliWatts)
    return TTXPowerMilliWatts_from_obj({TXPowerMilliWatts = TXPowerMilliWatts})
end
---@param obj Channel.TXPowerMilliWatts
function TTXPowerMilliWatts:init_from_obj(obj)
    self.TXPowerMilliWatts = obj.TXPowerMilliWatts
end

function TTXPowerMilliWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXPowerMilliWatts.group)
end

TTXPowerMilliWatts.from_obj = TTXPowerMilliWatts_from_obj

TTXPowerMilliWatts.proto_property = {'TXPowerMilliWatts'}

TTXPowerMilliWatts.default = {0}

TTXPowerMilliWatts.struct = {{name = 'TXPowerMilliWatts', is_array = false, struct = nil}}

function TTXPowerMilliWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXPowerMilliWatts', self.TXPowerMilliWatts, 'double', true, errs, need_convert)

    TTXPowerMilliWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXPowerMilliWatts.proto_property, errs, need_convert)
    return self
end

function TTXPowerMilliWatts:unpack(_)
    return self.TXPowerMilliWatts
end

Channel.TXPowerMilliWatts = TTXPowerMilliWatts

---@class Channel.RXPowerMilliWatts
---@field RXPowerMilliWatts number
local TRXPowerMilliWatts = {}
TRXPowerMilliWatts.__index = TRXPowerMilliWatts
TRXPowerMilliWatts.group = {}

local function TRXPowerMilliWatts_from_obj(obj)
    return setmetatable(obj, TRXPowerMilliWatts)
end

function TRXPowerMilliWatts.new(RXPowerMilliWatts)
    return TRXPowerMilliWatts_from_obj({RXPowerMilliWatts = RXPowerMilliWatts})
end
---@param obj Channel.RXPowerMilliWatts
function TRXPowerMilliWatts:init_from_obj(obj)
    self.RXPowerMilliWatts = obj.RXPowerMilliWatts
end

function TRXPowerMilliWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXPowerMilliWatts.group)
end

TRXPowerMilliWatts.from_obj = TRXPowerMilliWatts_from_obj

TRXPowerMilliWatts.proto_property = {'RXPowerMilliWatts'}

TRXPowerMilliWatts.default = {0}

TRXPowerMilliWatts.struct = {{name = 'RXPowerMilliWatts', is_array = false, struct = nil}}

function TRXPowerMilliWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXPowerMilliWatts', self.RXPowerMilliWatts, 'double', true, errs, need_convert)

    TRXPowerMilliWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXPowerMilliWatts.proto_property, errs, need_convert)
    return self
end

function TRXPowerMilliWatts:unpack(_)
    return self.RXPowerMilliWatts
end

Channel.RXPowerMilliWatts = TRXPowerMilliWatts

---@class Channel.BiasCurrentMilliAmps
---@field BiasCurrentMilliAmps number
local TBiasCurrentMilliAmps = {}
TBiasCurrentMilliAmps.__index = TBiasCurrentMilliAmps
TBiasCurrentMilliAmps.group = {}

local function TBiasCurrentMilliAmps_from_obj(obj)
    return setmetatable(obj, TBiasCurrentMilliAmps)
end

function TBiasCurrentMilliAmps.new(BiasCurrentMilliAmps)
    return TBiasCurrentMilliAmps_from_obj({BiasCurrentMilliAmps = BiasCurrentMilliAmps})
end
---@param obj Channel.BiasCurrentMilliAmps
function TBiasCurrentMilliAmps:init_from_obj(obj)
    self.BiasCurrentMilliAmps = obj.BiasCurrentMilliAmps
end

function TBiasCurrentMilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiasCurrentMilliAmps.group)
end

TBiasCurrentMilliAmps.from_obj = TBiasCurrentMilliAmps_from_obj

TBiasCurrentMilliAmps.proto_property = {'BiasCurrentMilliAmps'}

TBiasCurrentMilliAmps.default = {0}

TBiasCurrentMilliAmps.struct = {{name = 'BiasCurrentMilliAmps', is_array = false, struct = nil}}

function TBiasCurrentMilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiasCurrentMilliAmps', self.BiasCurrentMilliAmps, 'double', true, errs, need_convert)

    TBiasCurrentMilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiasCurrentMilliAmps.proto_property, errs, need_convert)
    return self
end

function TBiasCurrentMilliAmps:unpack(_)
    return self.BiasCurrentMilliAmps
end

Channel.BiasCurrentMilliAmps = TBiasCurrentMilliAmps

---@class Channel.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Channel.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Channel.Id = TId

Channel.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.Channel', {
    Id = {'y', {'CONST'}, true, nil},
    BiasCurrentMilliAmps = {'d', nil, true, nil},
    RXPowerMilliWatts = {'d', nil, true, nil},
    TXPowerMilliWatts = {'d', nil, true, nil}
}, {}, {})

return Channel
