-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local BiasCurrent = {}

---@class BiasCurrent.BiasCurrentTXLowerThresholdWarning
---@field BiasCurrentTXLowerThresholdWarning number
local TBiasCurrentTXLowerThresholdWarning = {}
TBiasCurrentTXLowerThresholdWarning.__index = TBiasCurrentTXLowerThresholdWarning
TBiasCurrentTXLowerThresholdWarning.group = {}

local function TBiasCurrentTXLowerThresholdWarning_from_obj(obj)
    return setmetatable(obj, TBiasCurrentTXLowerThresholdWarning)
end

function TBiasCurrentTXLowerThresholdWarning.new(BiasCurrentTXLowerThresholdWarning)
    return TBiasCurrentTXLowerThresholdWarning_from_obj({
        BiasCurrentTXLowerThresholdWarning = BiasCurrentTXLowerThresholdWarning or 65535
    })
end
---@param obj BiasCurrent.BiasCurrentTXLowerThresholdWarning
function TBiasCurrentTXLowerThresholdWarning:init_from_obj(obj)
    self.BiasCurrentTXLowerThresholdWarning = obj.BiasCurrentTXLowerThresholdWarning or 65535
end

function TBiasCurrentTXLowerThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiasCurrentTXLowerThresholdWarning.group)
end

TBiasCurrentTXLowerThresholdWarning.from_obj = TBiasCurrentTXLowerThresholdWarning_from_obj

TBiasCurrentTXLowerThresholdWarning.proto_property = {'BiasCurrentTXLowerThresholdWarning'}

TBiasCurrentTXLowerThresholdWarning.default = {0}

TBiasCurrentTXLowerThresholdWarning.struct = {
    {name = 'BiasCurrentTXLowerThresholdWarning', is_array = false, struct = nil}
}

function TBiasCurrentTXLowerThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiasCurrentTXLowerThresholdWarning', self.BiasCurrentTXLowerThresholdWarning, 'double',
        true, errs, need_convert)

    TBiasCurrentTXLowerThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiasCurrentTXLowerThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TBiasCurrentTXLowerThresholdWarning:unpack(_)
    return self.BiasCurrentTXLowerThresholdWarning
end

BiasCurrent.BiasCurrentTXLowerThresholdWarning = TBiasCurrentTXLowerThresholdWarning

---@class BiasCurrent.BiasCurrentTXUpperThresholdWarning
---@field BiasCurrentTXUpperThresholdWarning number
local TBiasCurrentTXUpperThresholdWarning = {}
TBiasCurrentTXUpperThresholdWarning.__index = TBiasCurrentTXUpperThresholdWarning
TBiasCurrentTXUpperThresholdWarning.group = {}

local function TBiasCurrentTXUpperThresholdWarning_from_obj(obj)
    return setmetatable(obj, TBiasCurrentTXUpperThresholdWarning)
end

function TBiasCurrentTXUpperThresholdWarning.new(BiasCurrentTXUpperThresholdWarning)
    return TBiasCurrentTXUpperThresholdWarning_from_obj({
        BiasCurrentTXUpperThresholdWarning = BiasCurrentTXUpperThresholdWarning or 65535
    })
end
---@param obj BiasCurrent.BiasCurrentTXUpperThresholdWarning
function TBiasCurrentTXUpperThresholdWarning:init_from_obj(obj)
    self.BiasCurrentTXUpperThresholdWarning = obj.BiasCurrentTXUpperThresholdWarning or 65535
end

function TBiasCurrentTXUpperThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiasCurrentTXUpperThresholdWarning.group)
end

TBiasCurrentTXUpperThresholdWarning.from_obj = TBiasCurrentTXUpperThresholdWarning_from_obj

TBiasCurrentTXUpperThresholdWarning.proto_property = {'BiasCurrentTXUpperThresholdWarning'}

TBiasCurrentTXUpperThresholdWarning.default = {0}

TBiasCurrentTXUpperThresholdWarning.struct = {
    {name = 'BiasCurrentTXUpperThresholdWarning', is_array = false, struct = nil}
}

function TBiasCurrentTXUpperThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiasCurrentTXUpperThresholdWarning', self.BiasCurrentTXUpperThresholdWarning, 'double',
        true, errs, need_convert)

    TBiasCurrentTXUpperThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiasCurrentTXUpperThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TBiasCurrentTXUpperThresholdWarning:unpack(_)
    return self.BiasCurrentTXUpperThresholdWarning
end

BiasCurrent.BiasCurrentTXUpperThresholdWarning = TBiasCurrentTXUpperThresholdWarning

---@class BiasCurrent.TXUpperThresholdCritical
---@field TXUpperThresholdCritical number
local TTXUpperThresholdCritical = {}
TTXUpperThresholdCritical.__index = TTXUpperThresholdCritical
TTXUpperThresholdCritical.group = {}

local function TTXUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TTXUpperThresholdCritical)
end

function TTXUpperThresholdCritical.new(TXUpperThresholdCritical)
    return TTXUpperThresholdCritical_from_obj({TXUpperThresholdCritical = TXUpperThresholdCritical or 65535})
end
---@param obj BiasCurrent.TXUpperThresholdCritical
function TTXUpperThresholdCritical:init_from_obj(obj)
    self.TXUpperThresholdCritical = obj.TXUpperThresholdCritical or 65535
end

function TTXUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXUpperThresholdCritical.group)
end

TTXUpperThresholdCritical.from_obj = TTXUpperThresholdCritical_from_obj

TTXUpperThresholdCritical.proto_property = {'TXUpperThresholdCritical'}

TTXUpperThresholdCritical.default = {0}

TTXUpperThresholdCritical.struct = {{name = 'TXUpperThresholdCritical', is_array = false, struct = nil}}

function TTXUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXUpperThresholdCritical', self.TXUpperThresholdCritical, 'double', true, errs,
        need_convert)

    TTXUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TTXUpperThresholdCritical:unpack(_)
    return self.TXUpperThresholdCritical
end

BiasCurrent.TXUpperThresholdCritical = TTXUpperThresholdCritical

---@class BiasCurrent.TXLowerThresholdCritical
---@field TXLowerThresholdCritical number
local TTXLowerThresholdCritical = {}
TTXLowerThresholdCritical.__index = TTXLowerThresholdCritical
TTXLowerThresholdCritical.group = {}

local function TTXLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TTXLowerThresholdCritical)
end

function TTXLowerThresholdCritical.new(TXLowerThresholdCritical)
    return TTXLowerThresholdCritical_from_obj({TXLowerThresholdCritical = TXLowerThresholdCritical or 65535})
end
---@param obj BiasCurrent.TXLowerThresholdCritical
function TTXLowerThresholdCritical:init_from_obj(obj)
    self.TXLowerThresholdCritical = obj.TXLowerThresholdCritical or 65535
end

function TTXLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXLowerThresholdCritical.group)
end

TTXLowerThresholdCritical.from_obj = TTXLowerThresholdCritical_from_obj

TTXLowerThresholdCritical.proto_property = {'TXLowerThresholdCritical'}

TTXLowerThresholdCritical.default = {0}

TTXLowerThresholdCritical.struct = {{name = 'TXLowerThresholdCritical', is_array = false, struct = nil}}

function TTXLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXLowerThresholdCritical', self.TXLowerThresholdCritical, 'double', true, errs,
        need_convert)

    TTXLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TTXLowerThresholdCritical:unpack(_)
    return self.TXLowerThresholdCritical
end

BiasCurrent.TXLowerThresholdCritical = TTXLowerThresholdCritical

---@class BiasCurrent.TXBiasCurrentStatus
---@field TXBiasCurrentStatus integer
local TTXBiasCurrentStatus = {}
TTXBiasCurrentStatus.__index = TTXBiasCurrentStatus
TTXBiasCurrentStatus.group = {}

local function TTXBiasCurrentStatus_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrentStatus)
end

function TTXBiasCurrentStatus.new(TXBiasCurrentStatus)
    return TTXBiasCurrentStatus_from_obj({TXBiasCurrentStatus = TXBiasCurrentStatus})
end
---@param obj BiasCurrent.TXBiasCurrentStatus
function TTXBiasCurrentStatus:init_from_obj(obj)
    self.TXBiasCurrentStatus = obj.TXBiasCurrentStatus
end

function TTXBiasCurrentStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrentStatus.group)
end

TTXBiasCurrentStatus.from_obj = TTXBiasCurrentStatus_from_obj

TTXBiasCurrentStatus.proto_property = {'TXBiasCurrentStatus'}

TTXBiasCurrentStatus.default = {0}

TTXBiasCurrentStatus.struct = {{name = 'TXBiasCurrentStatus', is_array = false, struct = nil}}

function TTXBiasCurrentStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrentStatus', self.TXBiasCurrentStatus, 'uint32', true, errs, need_convert)

    TTXBiasCurrentStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrentStatus.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrentStatus:unpack(_)
    return self.TXBiasCurrentStatus
end

BiasCurrent.TXBiasCurrentStatus = TTXBiasCurrentStatus

---@class BiasCurrent.TXBiasCurrent8MilliAmps
---@field TXBiasCurrent8MilliAmps number
local TTXBiasCurrent8MilliAmps = {}
TTXBiasCurrent8MilliAmps.__index = TTXBiasCurrent8MilliAmps
TTXBiasCurrent8MilliAmps.group = {}

local function TTXBiasCurrent8MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent8MilliAmps)
end

function TTXBiasCurrent8MilliAmps.new(TXBiasCurrent8MilliAmps)
    return TTXBiasCurrent8MilliAmps_from_obj({TXBiasCurrent8MilliAmps = TXBiasCurrent8MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent8MilliAmps
function TTXBiasCurrent8MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent8MilliAmps = obj.TXBiasCurrent8MilliAmps
end

function TTXBiasCurrent8MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent8MilliAmps.group)
end

TTXBiasCurrent8MilliAmps.from_obj = TTXBiasCurrent8MilliAmps_from_obj

TTXBiasCurrent8MilliAmps.proto_property = {'TXBiasCurrent8MilliAmps'}

TTXBiasCurrent8MilliAmps.default = {0}

TTXBiasCurrent8MilliAmps.struct = {{name = 'TXBiasCurrent8MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent8MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent8MilliAmps', self.TXBiasCurrent8MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent8MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent8MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent8MilliAmps:unpack(_)
    return self.TXBiasCurrent8MilliAmps
end

BiasCurrent.TXBiasCurrent8MilliAmps = TTXBiasCurrent8MilliAmps

---@class BiasCurrent.TXBiasCurrent7MilliAmps
---@field TXBiasCurrent7MilliAmps number
local TTXBiasCurrent7MilliAmps = {}
TTXBiasCurrent7MilliAmps.__index = TTXBiasCurrent7MilliAmps
TTXBiasCurrent7MilliAmps.group = {}

local function TTXBiasCurrent7MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent7MilliAmps)
end

function TTXBiasCurrent7MilliAmps.new(TXBiasCurrent7MilliAmps)
    return TTXBiasCurrent7MilliAmps_from_obj({TXBiasCurrent7MilliAmps = TXBiasCurrent7MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent7MilliAmps
function TTXBiasCurrent7MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent7MilliAmps = obj.TXBiasCurrent7MilliAmps
end

function TTXBiasCurrent7MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent7MilliAmps.group)
end

TTXBiasCurrent7MilliAmps.from_obj = TTXBiasCurrent7MilliAmps_from_obj

TTXBiasCurrent7MilliAmps.proto_property = {'TXBiasCurrent7MilliAmps'}

TTXBiasCurrent7MilliAmps.default = {0}

TTXBiasCurrent7MilliAmps.struct = {{name = 'TXBiasCurrent7MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent7MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent7MilliAmps', self.TXBiasCurrent7MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent7MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent7MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent7MilliAmps:unpack(_)
    return self.TXBiasCurrent7MilliAmps
end

BiasCurrent.TXBiasCurrent7MilliAmps = TTXBiasCurrent7MilliAmps

---@class BiasCurrent.TXBiasCurrent6MilliAmps
---@field TXBiasCurrent6MilliAmps number
local TTXBiasCurrent6MilliAmps = {}
TTXBiasCurrent6MilliAmps.__index = TTXBiasCurrent6MilliAmps
TTXBiasCurrent6MilliAmps.group = {}

local function TTXBiasCurrent6MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent6MilliAmps)
end

function TTXBiasCurrent6MilliAmps.new(TXBiasCurrent6MilliAmps)
    return TTXBiasCurrent6MilliAmps_from_obj({TXBiasCurrent6MilliAmps = TXBiasCurrent6MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent6MilliAmps
function TTXBiasCurrent6MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent6MilliAmps = obj.TXBiasCurrent6MilliAmps
end

function TTXBiasCurrent6MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent6MilliAmps.group)
end

TTXBiasCurrent6MilliAmps.from_obj = TTXBiasCurrent6MilliAmps_from_obj

TTXBiasCurrent6MilliAmps.proto_property = {'TXBiasCurrent6MilliAmps'}

TTXBiasCurrent6MilliAmps.default = {0}

TTXBiasCurrent6MilliAmps.struct = {{name = 'TXBiasCurrent6MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent6MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent6MilliAmps', self.TXBiasCurrent6MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent6MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent6MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent6MilliAmps:unpack(_)
    return self.TXBiasCurrent6MilliAmps
end

BiasCurrent.TXBiasCurrent6MilliAmps = TTXBiasCurrent6MilliAmps

---@class BiasCurrent.TXBiasCurrent5MilliAmps
---@field TXBiasCurrent5MilliAmps number
local TTXBiasCurrent5MilliAmps = {}
TTXBiasCurrent5MilliAmps.__index = TTXBiasCurrent5MilliAmps
TTXBiasCurrent5MilliAmps.group = {}

local function TTXBiasCurrent5MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent5MilliAmps)
end

function TTXBiasCurrent5MilliAmps.new(TXBiasCurrent5MilliAmps)
    return TTXBiasCurrent5MilliAmps_from_obj({TXBiasCurrent5MilliAmps = TXBiasCurrent5MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent5MilliAmps
function TTXBiasCurrent5MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent5MilliAmps = obj.TXBiasCurrent5MilliAmps
end

function TTXBiasCurrent5MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent5MilliAmps.group)
end

TTXBiasCurrent5MilliAmps.from_obj = TTXBiasCurrent5MilliAmps_from_obj

TTXBiasCurrent5MilliAmps.proto_property = {'TXBiasCurrent5MilliAmps'}

TTXBiasCurrent5MilliAmps.default = {0}

TTXBiasCurrent5MilliAmps.struct = {{name = 'TXBiasCurrent5MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent5MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent5MilliAmps', self.TXBiasCurrent5MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent5MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent5MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent5MilliAmps:unpack(_)
    return self.TXBiasCurrent5MilliAmps
end

BiasCurrent.TXBiasCurrent5MilliAmps = TTXBiasCurrent5MilliAmps

---@class BiasCurrent.TXBiasCurrent4MilliAmps
---@field TXBiasCurrent4MilliAmps number
local TTXBiasCurrent4MilliAmps = {}
TTXBiasCurrent4MilliAmps.__index = TTXBiasCurrent4MilliAmps
TTXBiasCurrent4MilliAmps.group = {}

local function TTXBiasCurrent4MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent4MilliAmps)
end

function TTXBiasCurrent4MilliAmps.new(TXBiasCurrent4MilliAmps)
    return TTXBiasCurrent4MilliAmps_from_obj({TXBiasCurrent4MilliAmps = TXBiasCurrent4MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent4MilliAmps
function TTXBiasCurrent4MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent4MilliAmps = obj.TXBiasCurrent4MilliAmps
end

function TTXBiasCurrent4MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent4MilliAmps.group)
end

TTXBiasCurrent4MilliAmps.from_obj = TTXBiasCurrent4MilliAmps_from_obj

TTXBiasCurrent4MilliAmps.proto_property = {'TXBiasCurrent4MilliAmps'}

TTXBiasCurrent4MilliAmps.default = {0}

TTXBiasCurrent4MilliAmps.struct = {{name = 'TXBiasCurrent4MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent4MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent4MilliAmps', self.TXBiasCurrent4MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent4MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent4MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent4MilliAmps:unpack(_)
    return self.TXBiasCurrent4MilliAmps
end

BiasCurrent.TXBiasCurrent4MilliAmps = TTXBiasCurrent4MilliAmps

---@class BiasCurrent.TXBiasCurrent3MilliAmps
---@field TXBiasCurrent3MilliAmps number
local TTXBiasCurrent3MilliAmps = {}
TTXBiasCurrent3MilliAmps.__index = TTXBiasCurrent3MilliAmps
TTXBiasCurrent3MilliAmps.group = {}

local function TTXBiasCurrent3MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent3MilliAmps)
end

function TTXBiasCurrent3MilliAmps.new(TXBiasCurrent3MilliAmps)
    return TTXBiasCurrent3MilliAmps_from_obj({TXBiasCurrent3MilliAmps = TXBiasCurrent3MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent3MilliAmps
function TTXBiasCurrent3MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent3MilliAmps = obj.TXBiasCurrent3MilliAmps
end

function TTXBiasCurrent3MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent3MilliAmps.group)
end

TTXBiasCurrent3MilliAmps.from_obj = TTXBiasCurrent3MilliAmps_from_obj

TTXBiasCurrent3MilliAmps.proto_property = {'TXBiasCurrent3MilliAmps'}

TTXBiasCurrent3MilliAmps.default = {0}

TTXBiasCurrent3MilliAmps.struct = {{name = 'TXBiasCurrent3MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent3MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent3MilliAmps', self.TXBiasCurrent3MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent3MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent3MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent3MilliAmps:unpack(_)
    return self.TXBiasCurrent3MilliAmps
end

BiasCurrent.TXBiasCurrent3MilliAmps = TTXBiasCurrent3MilliAmps

---@class BiasCurrent.TXBiasCurrent2MilliAmps
---@field TXBiasCurrent2MilliAmps number
local TTXBiasCurrent2MilliAmps = {}
TTXBiasCurrent2MilliAmps.__index = TTXBiasCurrent2MilliAmps
TTXBiasCurrent2MilliAmps.group = {}

local function TTXBiasCurrent2MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent2MilliAmps)
end

function TTXBiasCurrent2MilliAmps.new(TXBiasCurrent2MilliAmps)
    return TTXBiasCurrent2MilliAmps_from_obj({TXBiasCurrent2MilliAmps = TXBiasCurrent2MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent2MilliAmps
function TTXBiasCurrent2MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent2MilliAmps = obj.TXBiasCurrent2MilliAmps
end

function TTXBiasCurrent2MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent2MilliAmps.group)
end

TTXBiasCurrent2MilliAmps.from_obj = TTXBiasCurrent2MilliAmps_from_obj

TTXBiasCurrent2MilliAmps.proto_property = {'TXBiasCurrent2MilliAmps'}

TTXBiasCurrent2MilliAmps.default = {0}

TTXBiasCurrent2MilliAmps.struct = {{name = 'TXBiasCurrent2MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent2MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent2MilliAmps', self.TXBiasCurrent2MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent2MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent2MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent2MilliAmps:unpack(_)
    return self.TXBiasCurrent2MilliAmps
end

BiasCurrent.TXBiasCurrent2MilliAmps = TTXBiasCurrent2MilliAmps

---@class BiasCurrent.TXBiasCurrent1MilliAmps
---@field TXBiasCurrent1MilliAmps number
local TTXBiasCurrent1MilliAmps = {}
TTXBiasCurrent1MilliAmps.__index = TTXBiasCurrent1MilliAmps
TTXBiasCurrent1MilliAmps.group = {}

local function TTXBiasCurrent1MilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrent1MilliAmps)
end

function TTXBiasCurrent1MilliAmps.new(TXBiasCurrent1MilliAmps)
    return TTXBiasCurrent1MilliAmps_from_obj({TXBiasCurrent1MilliAmps = TXBiasCurrent1MilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrent1MilliAmps
function TTXBiasCurrent1MilliAmps:init_from_obj(obj)
    self.TXBiasCurrent1MilliAmps = obj.TXBiasCurrent1MilliAmps
end

function TTXBiasCurrent1MilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrent1MilliAmps.group)
end

TTXBiasCurrent1MilliAmps.from_obj = TTXBiasCurrent1MilliAmps_from_obj

TTXBiasCurrent1MilliAmps.proto_property = {'TXBiasCurrent1MilliAmps'}

TTXBiasCurrent1MilliAmps.default = {0}

TTXBiasCurrent1MilliAmps.struct = {{name = 'TXBiasCurrent1MilliAmps', is_array = false, struct = nil}}

function TTXBiasCurrent1MilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXBiasCurrent1MilliAmps', self.TXBiasCurrent1MilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrent1MilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrent1MilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrent1MilliAmps:unpack(_)
    return self.TXBiasCurrent1MilliAmps
end

BiasCurrent.TXBiasCurrent1MilliAmps = TTXBiasCurrent1MilliAmps

---@class BiasCurrent.TXBiasCurrentMilliAmps
---@field TXBiasCurrentMilliAmps number[]
local TTXBiasCurrentMilliAmps = {}
TTXBiasCurrentMilliAmps.__index = TTXBiasCurrentMilliAmps
TTXBiasCurrentMilliAmps.group = {}

local function TTXBiasCurrentMilliAmps_from_obj(obj)
    return setmetatable(obj, TTXBiasCurrentMilliAmps)
end

function TTXBiasCurrentMilliAmps.new(TXBiasCurrentMilliAmps)
    return TTXBiasCurrentMilliAmps_from_obj({TXBiasCurrentMilliAmps = TXBiasCurrentMilliAmps})
end
---@param obj BiasCurrent.TXBiasCurrentMilliAmps
function TTXBiasCurrentMilliAmps:init_from_obj(obj)
    self.TXBiasCurrentMilliAmps = obj.TXBiasCurrentMilliAmps
end

function TTXBiasCurrentMilliAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXBiasCurrentMilliAmps.group)
end

TTXBiasCurrentMilliAmps.from_obj = TTXBiasCurrentMilliAmps_from_obj

TTXBiasCurrentMilliAmps.proto_property = {'TXBiasCurrentMilliAmps'}

TTXBiasCurrentMilliAmps.default = {{}}

TTXBiasCurrentMilliAmps.struct = {{name = 'TXBiasCurrentMilliAmps', is_array = true, struct = nil}}

function TTXBiasCurrentMilliAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TXBiasCurrentMilliAmps', self.TXBiasCurrentMilliAmps, 'double', true, errs,
        need_convert)

    TTXBiasCurrentMilliAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXBiasCurrentMilliAmps.proto_property, errs, need_convert)
    return self
end

function TTXBiasCurrentMilliAmps:unpack(_)
    return self.TXBiasCurrentMilliAmps
end

BiasCurrent.TXBiasCurrentMilliAmps = TTXBiasCurrentMilliAmps

BiasCurrent.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.BiasCurrent', {
    TXBiasCurrentMilliAmps = {'ad', {'VOLATILE'}, true, nil},
    TXBiasCurrent1MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent2MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent3MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent4MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent5MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent6MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent7MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrent8MilliAmps = {'d', {'VOLATILE'}, true, nil},
    TXBiasCurrentStatus = {'u', {'VOLATILE', 'EMIT_CHANGE'}, true, nil},
    TXLowerThresholdCritical = {'d', nil, true, 65535},
    TXUpperThresholdCritical = {'d', nil, true, 65535},
    BiasCurrentTXUpperThresholdWarning = {'d', nil, true, 65535},
    BiasCurrentTXLowerThresholdWarning = {'d', nil, true, 65535}
}, {}, {})

return BiasCurrent
