--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetIPMCConfiguration = {}

---@class NetworkAdapterIpmiCmds.SetIPMCConfigurationReq
---@field ManuId integer
---@field Flag integer
---@field Reserved integer
---@field Offset integer
---@field Length integer
---@field Data integer[]
local TSetIPMCConfigurationReq = {}
TSetIPMCConfigurationReq.__index = TSetIPMCConfigurationReq
TSetIPMCConfigurationReq.group = {}

local function TSetIPMCConfigurationReq_from_obj(obj)
    return setmetatable(obj, TSetIPMCConfigurationReq)
end

function TSetIPMCConfigurationReq.new(ManuId, Flag, Reserved, Offset, Length, Data)
    return TSetIPMCConfigurationReq_from_obj({
        ManuId = ManuId,
        Flag = Flag,
        Reserved = Reserved,
        Offset = Offset,
        Length = Length,
        Data = Data
    })
end
---@param obj NetworkAdapterIpmiCmds.SetIPMCConfigurationReq
function TSetIPMCConfigurationReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.Flag = obj.Flag
    self.Reserved = obj.Reserved
    self.Offset = obj.Offset
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetIPMCConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIPMCConfigurationReq.group)
end

TSetIPMCConfigurationReq.from_obj = TSetIPMCConfigurationReq_from_obj

TSetIPMCConfigurationReq.proto_property = {'ManuId', 'Flag', 'Reserved', 'Offset', 'Length', 'Data'}

TSetIPMCConfigurationReq.default = {0, 0, 0, 0, 0, {}}

TSetIPMCConfigurationReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'Flag', is_array = false, struct = nil},
    {name = 'Reserved', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = true, struct = nil}
}

function TSetIPMCConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Flag', self.Flag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 4, 6, errs, need_convert)
    end

    TSetIPMCConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIPMCConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TSetIPMCConfigurationReq:unpack(_)
    return self.ManuId, self.Flag, self.Reserved, self.Offset, self.Length, self.Data
end

SetIPMCConfiguration.SetIPMCConfigurationReq = TSetIPMCConfigurationReq

---@class NetworkAdapterIpmiCmds.SetIPMCConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetIPMCConfigurationRsp = {}
TSetIPMCConfigurationRsp.__index = TSetIPMCConfigurationRsp
TSetIPMCConfigurationRsp.group = {}

local function TSetIPMCConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TSetIPMCConfigurationRsp)
end

function TSetIPMCConfigurationRsp.new(CompletionCode, ManufactureId)
    return TSetIPMCConfigurationRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj NetworkAdapterIpmiCmds.SetIPMCConfigurationRsp
function TSetIPMCConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetIPMCConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIPMCConfigurationRsp.group)
end

TSetIPMCConfigurationRsp.from_obj = TSetIPMCConfigurationRsp_from_obj

TSetIPMCConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetIPMCConfigurationRsp.default = {0, 0}

TSetIPMCConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetIPMCConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetIPMCConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIPMCConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TSetIPMCConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetIPMCConfiguration.SetIPMCConfigurationRsp = TSetIPMCConfigurationRsp

return SetIPMCConfiguration
