--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuMode = {}

---@class NetworkAdapterIpmiCmds.SetDpuModeReq
---@field Mode integer
local TSetDpuModeReq = {}
TSetDpuModeReq.__index = TSetDpuModeReq
TSetDpuModeReq.group = {}

local function TSetDpuModeReq_from_obj(obj)
    return setmetatable(obj, TSetDpuModeReq)
end

function TSetDpuModeReq.new(Mode)
    return TSetDpuModeReq_from_obj({Mode = Mode})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuModeReq
function TSetDpuModeReq:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TSetDpuModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuModeReq.group)
end

TSetDpuModeReq.from_obj = TSetDpuModeReq_from_obj

TSetDpuModeReq.proto_property = {'Mode'}

TSetDpuModeReq.default = {0}

TSetDpuModeReq.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TSetDpuModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)

    TSetDpuModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuModeReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuModeReq:unpack(_)
    return self.Mode
end

SetDpuMode.SetDpuModeReq = TSetDpuModeReq

---@class NetworkAdapterIpmiCmds.SetDpuModeRsp
---@field CompletionCode integer
local TSetDpuModeRsp = {}
TSetDpuModeRsp.__index = TSetDpuModeRsp
TSetDpuModeRsp.group = {}

local function TSetDpuModeRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuModeRsp)
end

function TSetDpuModeRsp.new(CompletionCode)
    return TSetDpuModeRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuModeRsp
function TSetDpuModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetDpuModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuModeRsp.group)
end

TSetDpuModeRsp.from_obj = TSetDpuModeRsp_from_obj

TSetDpuModeRsp.proto_property = {'CompletionCode'}

TSetDpuModeRsp.default = {0}

TSetDpuModeRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetDpuModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetDpuModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuModeRsp:unpack(_)
    return self.CompletionCode
end

SetDpuMode.SetDpuModeRsp = TSetDpuModeRsp

return SetDpuMode
