--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuHostAccess = {}

---@class NetworkAdapterIpmiCmds.SetDpuHostAccessReq
---@field Status integer
local TSetDpuHostAccessReq = {}
TSetDpuHostAccessReq.__index = TSetDpuHostAccessReq
TSetDpuHostAccessReq.group = {}

local function TSetDpuHostAccessReq_from_obj(obj)
    return setmetatable(obj, TSetDpuHostAccessReq)
end

function TSetDpuHostAccessReq.new(Status)
    return TSetDpuHostAccessReq_from_obj({Status = Status})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuHostAccessReq
function TSetDpuHostAccessReq:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetDpuHostAccessReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuHostAccessReq.group)
end

TSetDpuHostAccessReq.from_obj = TSetDpuHostAccessReq_from_obj

TSetDpuHostAccessReq.proto_property = {'Status'}

TSetDpuHostAccessReq.default = {0}

TSetDpuHostAccessReq.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetDpuHostAccessReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetDpuHostAccessReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuHostAccessReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuHostAccessReq:unpack(_)
    return self.Status
end

SetDpuHostAccess.SetDpuHostAccessReq = TSetDpuHostAccessReq

---@class NetworkAdapterIpmiCmds.SetDpuHostAccessRsp
---@field CompletionCode integer
local TSetDpuHostAccessRsp = {}
TSetDpuHostAccessRsp.__index = TSetDpuHostAccessRsp
TSetDpuHostAccessRsp.group = {}

local function TSetDpuHostAccessRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuHostAccessRsp)
end

function TSetDpuHostAccessRsp.new(CompletionCode)
    return TSetDpuHostAccessRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuHostAccessRsp
function TSetDpuHostAccessRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetDpuHostAccessRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuHostAccessRsp.group)
end

TSetDpuHostAccessRsp.from_obj = TSetDpuHostAccessRsp_from_obj

TSetDpuHostAccessRsp.proto_property = {'CompletionCode'}

TSetDpuHostAccessRsp.default = {0}

TSetDpuHostAccessRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetDpuHostAccessRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetDpuHostAccessRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuHostAccessRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuHostAccessRsp:unpack(_)
    return self.CompletionCode
end

SetDpuHostAccess.SetDpuHostAccessRsp = TSetDpuHostAccessRsp

return SetDpuHostAccess
