--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuExtendedHostPrivilege = {}

---@class NetworkAdapterIpmiCmds.SetDpuExtendedHostPrivilegeReq
---@field Status integer
local TSetDpuExtendedHostPrivilegeReq = {}
TSetDpuExtendedHostPrivilegeReq.__index = TSetDpuExtendedHostPrivilegeReq
TSetDpuExtendedHostPrivilegeReq.group = {}

local function TSetDpuExtendedHostPrivilegeReq_from_obj(obj)
    return setmetatable(obj, TSetDpuExtendedHostPrivilegeReq)
end

function TSetDpuExtendedHostPrivilegeReq.new(Status)
    return TSetDpuExtendedHostPrivilegeReq_from_obj({Status = Status})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuExtendedHostPrivilegeReq
function TSetDpuExtendedHostPrivilegeReq:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetDpuExtendedHostPrivilegeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuExtendedHostPrivilegeReq.group)
end

TSetDpuExtendedHostPrivilegeReq.from_obj = TSetDpuExtendedHostPrivilegeReq_from_obj

TSetDpuExtendedHostPrivilegeReq.proto_property = {'Status'}

TSetDpuExtendedHostPrivilegeReq.default = {0}

TSetDpuExtendedHostPrivilegeReq.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetDpuExtendedHostPrivilegeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetDpuExtendedHostPrivilegeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuExtendedHostPrivilegeReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuExtendedHostPrivilegeReq:unpack(_)
    return self.Status
end

SetDpuExtendedHostPrivilege.SetDpuExtendedHostPrivilegeReq = TSetDpuExtendedHostPrivilegeReq

---@class NetworkAdapterIpmiCmds.SetDpuExtendedHostPrivilegeRsp
---@field CompletionCode integer
local TSetDpuExtendedHostPrivilegeRsp = {}
TSetDpuExtendedHostPrivilegeRsp.__index = TSetDpuExtendedHostPrivilegeRsp
TSetDpuExtendedHostPrivilegeRsp.group = {}

local function TSetDpuExtendedHostPrivilegeRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuExtendedHostPrivilegeRsp)
end

function TSetDpuExtendedHostPrivilegeRsp.new(CompletionCode)
    return TSetDpuExtendedHostPrivilegeRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj NetworkAdapterIpmiCmds.SetDpuExtendedHostPrivilegeRsp
function TSetDpuExtendedHostPrivilegeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetDpuExtendedHostPrivilegeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuExtendedHostPrivilegeRsp.group)
end

TSetDpuExtendedHostPrivilegeRsp.from_obj = TSetDpuExtendedHostPrivilegeRsp_from_obj

TSetDpuExtendedHostPrivilegeRsp.proto_property = {'CompletionCode'}

TSetDpuExtendedHostPrivilegeRsp.default = {0}

TSetDpuExtendedHostPrivilegeRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetDpuExtendedHostPrivilegeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetDpuExtendedHostPrivilegeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuExtendedHostPrivilegeRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuExtendedHostPrivilegeRsp:unpack(_)
    return self.CompletionCode
end

SetDpuExtendedHostPrivilege.SetDpuExtendedHostPrivilegeRsp = TSetDpuExtendedHostPrivilegeRsp

return SetDpuExtendedHostPrivilege
