--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuMode = {}

---@class NetworkAdapterIpmiCmds.GetDpuModeReq
local TGetDpuModeReq = {}
TGetDpuModeReq.__index = TGetDpuModeReq
TGetDpuModeReq.group = {}

local function TGetDpuModeReq_from_obj(obj)
    return setmetatable(obj, TGetDpuModeReq)
end

function TGetDpuModeReq.new()
    return TGetDpuModeReq_from_obj({})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuModeReq
function TGetDpuModeReq:init_from_obj(obj)

end

function TGetDpuModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuModeReq.group)
end

TGetDpuModeReq.from_obj = TGetDpuModeReq_from_obj

TGetDpuModeReq.proto_property = {}

TGetDpuModeReq.default = {}

TGetDpuModeReq.struct = {}

function TGetDpuModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetDpuModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuModeReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuModeReq:unpack(_)
end

GetDpuMode.GetDpuModeReq = TGetDpuModeReq

---@class NetworkAdapterIpmiCmds.GetDpuModeRsp
---@field CompletionCode integer
---@field Mode integer
local TGetDpuModeRsp = {}
TGetDpuModeRsp.__index = TGetDpuModeRsp
TGetDpuModeRsp.group = {}

local function TGetDpuModeRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuModeRsp)
end

function TGetDpuModeRsp.new(CompletionCode, Mode)
    return TGetDpuModeRsp_from_obj({CompletionCode = CompletionCode, Mode = Mode})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuModeRsp
function TGetDpuModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Mode = obj.Mode
end

function TGetDpuModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuModeRsp.group)
end

TGetDpuModeRsp.from_obj = TGetDpuModeRsp_from_obj

TGetDpuModeRsp.proto_property = {'CompletionCode', 'Mode'}

TGetDpuModeRsp.default = {0, 0}

TGetDpuModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Mode', is_array = false, struct = nil}
}

function TGetDpuModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)

    TGetDpuModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuModeRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuModeRsp:unpack(_)
    return self.CompletionCode, self.Mode
end

GetDpuMode.GetDpuModeRsp = TGetDpuModeRsp

return GetDpuMode
