--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuHostAccess = {}

---@class NetworkAdapterIpmiCmds.GetDpuHostAccessReq
local TGetDpuHostAccessReq = {}
TGetDpuHostAccessReq.__index = TGetDpuHostAccessReq
TGetDpuHostAccessReq.group = {}

local function TGetDpuHostAccessReq_from_obj(obj)
    return setmetatable(obj, TGetDpuHostAccessReq)
end

function TGetDpuHostAccessReq.new()
    return TGetDpuHostAccessReq_from_obj({})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuHostAccessReq
function TGetDpuHostAccessReq:init_from_obj(obj)

end

function TGetDpuHostAccessReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuHostAccessReq.group)
end

TGetDpuHostAccessReq.from_obj = TGetDpuHostAccessReq_from_obj

TGetDpuHostAccessReq.proto_property = {}

TGetDpuHostAccessReq.default = {}

TGetDpuHostAccessReq.struct = {}

function TGetDpuHostAccessReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetDpuHostAccessReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuHostAccessReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuHostAccessReq:unpack(_)
end

GetDpuHostAccess.GetDpuHostAccessReq = TGetDpuHostAccessReq

---@class NetworkAdapterIpmiCmds.GetDpuHostAccessRsp
---@field CompletionCode integer
---@field Status integer
local TGetDpuHostAccessRsp = {}
TGetDpuHostAccessRsp.__index = TGetDpuHostAccessRsp
TGetDpuHostAccessRsp.group = {}

local function TGetDpuHostAccessRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuHostAccessRsp)
end

function TGetDpuHostAccessRsp.new(CompletionCode, Status)
    return TGetDpuHostAccessRsp_from_obj({CompletionCode = CompletionCode, Status = Status})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuHostAccessRsp
function TGetDpuHostAccessRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Status = obj.Status
end

function TGetDpuHostAccessRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuHostAccessRsp.group)
end

TGetDpuHostAccessRsp.from_obj = TGetDpuHostAccessRsp_from_obj

TGetDpuHostAccessRsp.proto_property = {'CompletionCode', 'Status'}

TGetDpuHostAccessRsp.default = {0, 0}

TGetDpuHostAccessRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TGetDpuHostAccessRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TGetDpuHostAccessRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuHostAccessRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuHostAccessRsp:unpack(_)
    return self.CompletionCode, self.Status
end

GetDpuHostAccess.GetDpuHostAccessRsp = TGetDpuHostAccessRsp

return GetDpuHostAccess
