--[[-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuExtendedHostPrivilege = {}

---@class NetworkAdapterIpmiCmds.GetDpuExtendedHostPrivilegeReq
local TGetDpuExtendedHostPrivilegeReq = {}
TGetDpuExtendedHostPrivilegeReq.__index = TGetDpuExtendedHostPrivilegeReq
TGetDpuExtendedHostPrivilegeReq.group = {}

local function TGetDpuExtendedHostPrivilegeReq_from_obj(obj)
    return setmetatable(obj, TGetDpuExtendedHostPrivilegeReq)
end

function TGetDpuExtendedHostPrivilegeReq.new()
    return TGetDpuExtendedHostPrivilegeReq_from_obj({})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuExtendedHostPrivilegeReq
function TGetDpuExtendedHostPrivilegeReq:init_from_obj(obj)

end

function TGetDpuExtendedHostPrivilegeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuExtendedHostPrivilegeReq.group)
end

TGetDpuExtendedHostPrivilegeReq.from_obj = TGetDpuExtendedHostPrivilegeReq_from_obj

TGetDpuExtendedHostPrivilegeReq.proto_property = {}

TGetDpuExtendedHostPrivilegeReq.default = {}

TGetDpuExtendedHostPrivilegeReq.struct = {}

function TGetDpuExtendedHostPrivilegeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetDpuExtendedHostPrivilegeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuExtendedHostPrivilegeReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuExtendedHostPrivilegeReq:unpack(_)
end

GetDpuExtendedHostPrivilege.GetDpuExtendedHostPrivilegeReq = TGetDpuExtendedHostPrivilegeReq

---@class NetworkAdapterIpmiCmds.GetDpuExtendedHostPrivilegeRsp
---@field CompletionCode integer
---@field Status integer
local TGetDpuExtendedHostPrivilegeRsp = {}
TGetDpuExtendedHostPrivilegeRsp.__index = TGetDpuExtendedHostPrivilegeRsp
TGetDpuExtendedHostPrivilegeRsp.group = {}

local function TGetDpuExtendedHostPrivilegeRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuExtendedHostPrivilegeRsp)
end

function TGetDpuExtendedHostPrivilegeRsp.new(CompletionCode, Status)
    return TGetDpuExtendedHostPrivilegeRsp_from_obj({CompletionCode = CompletionCode, Status = Status})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuExtendedHostPrivilegeRsp
function TGetDpuExtendedHostPrivilegeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Status = obj.Status
end

function TGetDpuExtendedHostPrivilegeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuExtendedHostPrivilegeRsp.group)
end

TGetDpuExtendedHostPrivilegeRsp.from_obj = TGetDpuExtendedHostPrivilegeRsp_from_obj

TGetDpuExtendedHostPrivilegeRsp.proto_property = {'CompletionCode', 'Status'}

TGetDpuExtendedHostPrivilegeRsp.default = {0, 0}

TGetDpuExtendedHostPrivilegeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TGetDpuExtendedHostPrivilegeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TGetDpuExtendedHostPrivilegeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuExtendedHostPrivilegeRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuExtendedHostPrivilegeRsp:unpack(_)
    return self.CompletionCode, self.Status
end

GetDpuExtendedHostPrivilege.GetDpuExtendedHostPrivilegeRsp = TGetDpuExtendedHostPrivilegeRsp

return GetDpuExtendedHostPrivilege
