-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local NetworkAdapter = require 'network_adapter.json_types.NetworkAdapter'
local NetworkPortRelatedItems = require 'network_adapter.json_types.NetworkPortRelatedItems'
local OpticalModuleRelatedItems = require 'network_adapter.json_types.OpticalModuleRelatedItems'

---@class NetworkAdapterTable: Table
---@field ID FieldBase
---@field NodeId FieldBase
---@field SystemID FieldBase
---@field SlotNumber FieldBase
---@field Name FieldBase
---@field DisplayName FieldBase
---@field Manufacturer FieldBase
---@field Description FieldBase
---@field Position FieldBase
---@field DeviceLocator FieldBase
---@field Type FieldBase
---@field NetworkPortCount FieldBase
---@field Model FieldBase
---@field ModelDescription FieldBase
---@field ChipManufacturer FieldBase
---@field ChipVendor FieldBase
---@field NetDevFuncCapabilities FieldBase
---@field RootBDF FieldBase
---@field FirmwareVersion FieldBase
---@field VendorID FieldBase
---@field DeviceID FieldBase
---@field SubsystemVendorID FieldBase
---@field SubsystemDeviceID FieldBase
---@field BoardID FieldBase
---@field BoardIDHex FieldBase
---@field ComponentUniqueID FieldBase
---@field PCBVersion FieldBase
---@field AssociatedResource FieldBase
---@field SupportedMctp FieldBase
---@field SupportedLLDP FieldBase
---@field HotPluggable FieldBase
---@field ReadyToRemove FieldBase
---@field AttentionHotPlugState FieldBase
---@field SerialNumber FieldBase
---@field PreviousSerialNumber FieldBase
---@field TemperatureCelsius FieldBase
---@field TemperatureStatus FieldBase
---@field MaxOperatingTemperatureCelsius FieldBase
---@field PredictiveFault FieldBase
---@field FruId FieldBase
---@field DiagnosticFault FieldBase
---@field ReplacedFlag FieldBase
---@field BandwidthThresholdPercent FieldBase
---@field ParentCardSlotId FieldBase
---@field PfMacInfo FieldBase
---@field BoardName FieldBase
---@field DriverName FieldBase
---@field DriverVersion FieldBase
---@field LLDPSupported FieldBase
---@field LinkSpeed FieldBase
---@field LinkSpeedCapability FieldBase
---@field LinkWidth FieldBase
---@field LinkWidthCapability FieldBase
---@field SFPMaxTemperatureCelsius FieldBase
---@field Health FieldBase
---@field FaultState FieldBase
---@field PowerStatus FieldBase
---@field FaultCode FieldBase
---@field AssetType FieldBase
---@field AssetName FieldBase
---@field InventorySerialNumber FieldBase
---@field InventoryFirmwareVersion FieldBase
---@field InventoryPCBVersion FieldBase
---@field InventoryManufacturer FieldBase
---@field AssetTag FieldBase
---@field PartNumber FieldBase
---@field ManufactureDate FieldBase
---@field Slot FieldBase
---@field UUID FieldBase
---@field InventoryModel FieldBase
---@field CardPowerGood FieldBase
---@field ReadyToRemoveValue FieldBase
---@field Segment FieldBase
---@field SocketId FieldBase
---@field Bus FieldBase
---@field Device FieldBase
---@field Function FieldBase
---@field DevBus FieldBase
---@field DevDevice FieldBase
---@field DevFunction FieldBase
---@field RefChip FieldBase
---@field SpecialPcieCard FieldBase
---@field RefFrudata FieldBase
---@field MPUBusyStatus FieldBase
---@field RefFruChip FieldBase
---@field RefCPLDChip FieldBase
---@field SystemLoadedStatus FieldBase
---@field CreatedByDeviceObject FieldBase
---@field PowerScanner FieldBase

---@class NetworkPortTable: Table
---@field SystemID FieldBase
---@field Name FieldBase
---@field Type FieldBase
---@field PortID FieldBase
---@field PermanentMACAddress FieldBase
---@field MACAddress FieldBase
---@field LinkStatus FieldBase
---@field OSLinkStatus FieldBase
---@field LinkStatusNumeric FieldBase
---@field IPv6DefaultGateway FieldBase
---@field WorkMode FieldBase
---@field FunctionType FieldBase
---@field BDF FieldBase
---@field AutoConnectOnBoot FieldBase
---@field NetDevFuncType FieldBase
---@field MediumType FieldBase
---@field SpeedMbps FieldBase
---@field FullDuplex FieldBase
---@field AutoSpeedNegotiation FieldBase
---@field FirmwareVersion FieldBase
---@field DriverName FieldBase
---@field DriverVersion FieldBase
---@field LLDPEnabled FieldBase
---@field SupportedLinkCapability FieldBase
---@field NetworkAdapterId FieldBase
---@field LinkMonitorPeriodMS FieldBase
---@field UUID FieldBase
---@field WorkloadType FieldBase
---@field MTUSize FieldBase
---@field NodeId FieldBase
---@field RXFrames FieldBase
---@field TXFrames FieldBase
---@field PacketsDropped FieldBase
---@field RXUnicastFrames FieldBase
---@field RXMulticastFrames FieldBase
---@field RXBroadcastFrames FieldBase
---@field TXUnicastFrames FieldBase
---@field TXMulticastFrames FieldBase
---@field TXBroadcastFrames FieldBase
---@field RXFCSErrors FieldBase
---@field RXUndersizeFrames FieldBase
---@field RXOversizeFrames FieldBase
---@field TXSingleCollisions FieldBase
---@field TXMultipleCollisions FieldBase
---@field TXLateCollisions FieldBase
---@field TXExcessiveCollisions FieldBase
---@field RXFrameAlignmentErrors FieldBase
---@field RXPauseXOFFFrames FieldBase
---@field RXPauseXONFrames FieldBase
---@field TXPauseXOFFFrames FieldBase
---@field TXPauseXONFrames FieldBase
---@field RXFalseCarrierErrors FieldBase
---@field BandwidthUsagePercent FieldBase
---@field Up2cos FieldBase
---@field Uppgid FieldBase
---@field Pgpct FieldBase
---@field PgStrict FieldBase
---@field Pfcmap FieldBase
---@field ChassisId FieldBase
---@field ChassisIdSubtype FieldBase
---@field LLDPReceivePortId FieldBase
---@field PortIdSubtype FieldBase
---@field SystemName FieldBase
---@field ManagementVlanId FieldBase
---@field FCId FieldBase
---@field WWNN FieldBase
---@field PermanentWWNN FieldBase
---@field WWPN FieldBase
---@field PermanentWWPN FieldBase
---@field SpeedGbps FieldBase
---@field LinkDown FieldBase
---@field TransceiverLanes FieldBase
---@field ProcessorPorts FieldBase
---@field LinkStatusValue FieldBase
---@field NpuID FieldBase
---@field PowerOn FieldBase
---@field AgentID FieldBase
---@field NetworkAdapterObjectName FieldBase
---@field CreatedByDeviceObject FieldBase
---@field PhysicalId FieldBase
---@field UdieId FieldBase
---@field PfId FieldBase
---@field NpuBoardSilkNumber FieldBase

---@class VLANTable: Table
---@field VLANId FieldBase
---@field VLANEnabled FieldBase
---@field VLANPriority FieldBase
---@field AutoConnectOnBoot FieldBase
---@field PortID FieldBase
---@field NetworkAdapterId FieldBase
---@field NetworkAdapterObjectName FieldBase
---@field NetworkPortObjectName FieldBase

---@class IPv4AddressTable: Table
---@field Address FieldBase
---@field SubnetMask FieldBase
---@field Gateway FieldBase
---@field AddressOrigin FieldBase
---@field PortID FieldBase
---@field NetworkAdapterId FieldBase
---@field NetworkAdapterObjectName FieldBase
---@field NetworkPortObjectName FieldBase

---@class IPv6AddressTable: Table
---@field Address FieldBase
---@field PrefixLength FieldBase
---@field AddressState FieldBase
---@field AddressOrigin FieldBase
---@field Gateway FieldBase
---@field PortID FieldBase
---@field NetworkAdapterId FieldBase
---@field NetworkAdapterObjectName FieldBase
---@field NetworkPortObjectName FieldBase

---@class VLANIPv4AddressTable: Table
---@field Address FieldBase
---@field SubnetMask FieldBase
---@field Gateway FieldBase
---@field AddressOrigin FieldBase
---@field PortID FieldBase
---@field NetworkAdapterId FieldBase
---@field VLANId FieldBase
---@field NetworkAdapterObjectName FieldBase
---@field NetworkPortObjectName FieldBase

---@class VLANIPv6AddressTable: Table
---@field Address FieldBase
---@field PrefixLength FieldBase
---@field AddressState FieldBase
---@field AddressOrigin FieldBase
---@field Gateway FieldBase
---@field PortID FieldBase
---@field NetworkAdapterId FieldBase
---@field VLANId FieldBase
---@field NetworkAdapterObjectName FieldBase
---@field NetworkPortObjectName FieldBase

---@class OpticalModuleTable: Table
---@field Name FieldBase
---@field Manufacturer FieldBase
---@field PartNumber FieldBase
---@field SerialNumber FieldBase
---@field RevisionNumber FieldBase
---@field ProductionDate FieldBase
---@field TransceiverType FieldBase
---@field FiberConnectionType FieldBase
---@field WaveLengthNanometer FieldBase
---@field Type FieldBase
---@field SupportedSpeedsMbps FieldBase
---@field Presence FieldBase
---@field Health FieldBase
---@field Identifier FieldBase
---@field ConnectorType FieldBase
---@field MediumType FieldBase
---@field TransmissionDistance FieldBase
---@field RxLossState FieldBase
---@field TxLossState FieldBase
---@field TxFaultState FieldBase
---@field TypeMatch FieldBase
---@field SpeedMatch FieldBase
---@field FaultState FieldBase
---@field TemperatureCelsius FieldBase
---@field PowerState FieldBase
---@field IsSupportedType FieldBase
---@field HostSNR FieldBase
---@field MediaSNR FieldBase
---@field RxSNR FieldBase
---@field Accessible FieldBase
---@field ModuleState FieldBase
---@field ChannelNum FieldBase
---@field RelatedNetworkPorts FieldBase
---@field Id FieldBase
---@field SilkText FieldBase
---@field TXBiasCurrentMilliAmps FieldBase
---@field TXBiasCurrent1MilliAmps FieldBase
---@field TXBiasCurrent2MilliAmps FieldBase
---@field TXBiasCurrent3MilliAmps FieldBase
---@field TXBiasCurrent4MilliAmps FieldBase
---@field TXBiasCurrent5MilliAmps FieldBase
---@field TXBiasCurrent6MilliAmps FieldBase
---@field TXBiasCurrent7MilliAmps FieldBase
---@field TXBiasCurrent8MilliAmps FieldBase
---@field TXBiasCurrentStatus FieldBase
---@field BC_TXLowerThresholdCritical FieldBase
---@field BC_TXUpperThresholdCritical FieldBase
---@field BiasCurrentTXUpperThresholdWarning FieldBase
---@field BiasCurrentTXLowerThresholdWarning FieldBase
---@field RXInputPowerMilliWatts FieldBase
---@field RXInputPowerStatus FieldBase
---@field RXLowerThresholdCritical FieldBase
---@field RXUpperThresholdCritical FieldBase
---@field TXOutputPowerMilliWatts FieldBase
---@field TXOutputPowerStatus FieldBase
---@field Power_TXLowerThresholdCritical FieldBase
---@field Power_TXUpperThresholdCritical FieldBase
---@field PowerTXUpperThresholdWarning FieldBase
---@field PowerTXLowerThresholdWarning FieldBase
---@field PowerRXUpperThresholdWarning FieldBase
---@field PowerRXLowerThresholdWarning FieldBase
---@field PowerClass FieldBase
---@field PowerCapacityWatts FieldBase
---@field ReadingCelsius FieldBase
---@field Temp_LowerThresholdCritical FieldBase
---@field Temp_UpperThresholdCritical FieldBase
---@field TemperatureLowerThresholdCritical FieldBase
---@field TemperatureUpperThresholdCritical FieldBase
---@field TemperatureLowerThresholdWarning FieldBase
---@field TemperatureUpperThresholdWarning FieldBase
---@field SupplyVoltage FieldBase
---@field Vol_LowerThresholdCritical FieldBase
---@field Vol_UpperThresholdCritical FieldBase
---@field VoltageLowerThresholdCritical FieldBase
---@field VoltageUpperThresholdCritical FieldBase
---@field VoltageLowerThresholdWarning FieldBase
---@field VoltageUpperThresholdWarning FieldBase
---@field RxLossOfLock FieldBase
---@field TxLossOfLock FieldBase
---@field LaserRuntimeSeconds FieldBase
---@field LaserTemperatureCelsius FieldBase
---@field PowerOnCount FieldBase
---@field UptimeSeconds FieldBase
---@field PowerStatus FieldBase
---@field OdspDieTemperatureCelsius FieldBase
---@field OdspHighTempRuntimeSeconds FieldBase
---@field SelfTestStatus FieldBase
---@field MediaInterfaceFaultStatus FieldBase
---@field HostInterfaceFaultStatus FieldBase
---@field RxLoS FieldBase
---@field TxLoS FieldBase
---@field TxFault FieldBase
---@field PRBSTestSupported FieldBase
---@field FiberDirtyDetected FieldBase
---@field FiberLoosenessDetected FieldBase
---@field ContaminationDetectionSupported FieldBase
---@field NetworkPortLanes FieldBase
---@field AssetType FieldBase
---@field AssetName FieldBase
---@field InventorySerialNumber FieldBase
---@field InventoryFirmwareVersion FieldBase
---@field PCBVersion FieldBase
---@field InventoryManufacturer FieldBase
---@field AssetTag FieldBase
---@field InventoryPartNumber FieldBase
---@field ManufactureDate FieldBase
---@field Slot FieldBase
---@field Model FieldBase
---@field UUID FieldBase
---@field PortID FieldBase
---@field NetworkAdapterId FieldBase
---@field PfID FieldBase
---@field CreatedByDeviceObject FieldBase
---@field LogicalId FieldBase

---@class OpticalModuleChannelTable: Table
---@field Id FieldBase
---@field BiasCurrentMilliAmps FieldBase
---@field RXPowerMilliWatts FieldBase
---@field TXPowerMilliWatts FieldBase

---@class NcsiNCInfoTable: Table
---@field Id FieldBase
---@field Enable FieldBase
---@field SystemId FieldBase
---@field SlotId FieldBase
---@field DeviceType FieldBase
---@field Type FieldBase
---@field EthId FieldBase
---@field ActiveStatus FieldBase
---@field PortNum FieldBase
---@field ActivePort FieldBase
---@field Mac FieldBase
---@field VlanState FieldBase
---@field VlanId FieldBase
---@field NcsiCablePresent FieldBase
---@field NcsiCableSwitch FieldBase
---@field MultiVlanState FieldBase
---@field NcsiEthId FieldBase

---@class NcsiNCPortInfoTable: Table
---@field NCId FieldBase
---@field PortId FieldBase
---@field PackageId FieldBase
---@field ChannelId FieldBase
---@field PortAvailable FieldBase
---@field LinkStatusSrc FieldBase
---@field LinkStatus FieldBase
---@field RxEnable FieldBase
---@field Type FieldBase
---@field Slikscreen FieldBase
---@field MgmtPortId FieldBase

---@class PortUsageHistoryTable: Table
---@field Id FieldBase
---@field NetworkAdapterId FieldBase
---@field PortID FieldBase
---@field Time FieldBase
---@field Percent FieldBase

---@class NetworkBridgeTable: Table
---@field Id FieldBase
---@field Name FieldBase
---@field Ports FieldBase

---@class NetworkBridgePortTable: Table
---@field NodeId FieldBase
---@field BridgeId FieldBase
---@field Id FieldBase
---@field Name FieldBase

---@class NetworkBondingTable: Table
---@field Id FieldBase
---@field Name FieldBase
---@field Ports FieldBase

---@class NetworkBondingPortTable: Table
---@field NodeId FieldBase
---@field TeamId FieldBase
---@field Id FieldBase
---@field Name FieldBase

---@class NCSIChannelMgmtTable: Table
---@field PCIePresence FieldBase
---@field OCP1Presence FieldBase
---@field OCP2Presence FieldBase
---@field NCSIChannel FieldBase
---@field Id FieldBase

---@class Network_adapterDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field NetworkAdapter NetworkAdapterTable
---@field NetworkPort NetworkPortTable
---@field VLAN VLANTable
---@field IPv4Address IPv4AddressTable
---@field IPv6Address IPv6AddressTable
---@field VLANIPv4Address VLANIPv4AddressTable
---@field VLANIPv6Address VLANIPv6AddressTable
---@field OpticalModule OpticalModuleTable
---@field OpticalModuleChannel OpticalModuleChannelTable
---@field NcsiNCInfo NcsiNCInfoTable
---@field NcsiNCPortInfo NcsiNCPortInfoTable
---@field PortUsageHistory PortUsageHistoryTable
---@field NetworkBridge NetworkBridgeTable
---@field NetworkBridgePort NetworkBridgePortTable
---@field NetworkBonding NetworkBondingTable
---@field NetworkBondingPort NetworkBondingPortTable
---@field NCSIChannelMgmt NCSIChannelMgmtTable
local Network_adapterDBDatabase = {}
Network_adapterDBDatabase.__index = Network_adapterDBDatabase

function Network_adapterDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.NetworkAdapter = db:Table('t_network_adapter', {
        ID = Col.TextField():cid(1):primary_key(),
        NodeId = Col.TextField():cid(2):primary_key(),
        SystemID = Col.IntegerField():cid(3):null():max_length(8),
        SlotNumber = Col.IntegerField():cid(4):null():max_length(8),
        Name = Col.TextField():cid(5):null(),
        DisplayName = Col.TextField():cid(6):null(),
        Manufacturer = Col.TextField():cid(7):null(),
        Description = Col.TextField():cid(8):null(),
        Position = Col.TextField():cid(9):null(),
        DeviceLocator = Col.TextField():cid(10):null(),
        Type = Col.IntegerField():cid(11):null():max_length(8),
        NetworkPortCount = Col.IntegerField():cid(12):null():max_length(8),
        Model = Col.TextField():cid(13):null(),
        ModelDescription = Col.TextField():cid(14):null(),
        ChipManufacturer = Col.TextField():cid(15):null(),
        ChipVendor = Col.TextField():cid(16):null(),
        NetDevFuncCapabilities = Col.IntegerField():cid(17):null():max_length(8),
        RootBDF = Col.TextField():cid(18):null(),
        FirmwareVersion = Col.TextField():cid(19):null(),
        VendorID = Col.TextField():cid(20):null():default('\'0xFFFF\''),
        DeviceID = Col.TextField():cid(21):null():default('\'0xFFFF\''),
        SubsystemVendorID = Col.TextField():cid(22):null():default('\'0xFFFF\''),
        SubsystemDeviceID = Col.TextField():cid(23):null():default('\'0xFFFF\''),
        BoardID = Col.IntegerField():cid(24):null():max_length(16):default(65535),
        BoardIDHex = Col.TextField():cid(25):null():default('\'0xFFFF\''),
        ComponentUniqueID = Col.TextField():cid(26):null(),
        PCBVersion = Col.TextField():cid(27):null(),
        AssociatedResource = Col.TextField():cid(28):null(),
        SupportedMctp = Col.BooleandField():cid(29):null(),
        SupportedLLDP = Col.BooleandField():cid(30):null(),
        HotPluggable = Col.BooleandField():cid(31):null(),
        ReadyToRemove = Col.BooleandField():cid(32):null(),
        AttentionHotPlugState = Col.IntegerField():cid(33):persistence_key('protect_reset'):null():max_length(8),
        SerialNumber = Col.TextField():cid(34):null(),
        PreviousSerialNumber = Col.TextField():cid(35):persistence_key('protect_power_off'):null(),
        TemperatureCelsius = Col.IntegerField():cid(36):null():max_length(16),
        TemperatureStatus = Col.IntegerField():cid(37):null():max_length(8),
        MaxOperatingTemperatureCelsius = Col.IntegerField():cid(38):null():max_length(16),
        PredictiveFault = Col.IntegerField():cid(39):null():max_length(8),
        FruId = Col.IntegerField():cid(40):null():max_length(8),
        DiagnosticFault = Col.IntegerField():cid(41):null():max_length(8),
        ReplacedFlag = Col.IntegerField():cid(42):null():max_length(8),
        BandwidthThresholdPercent = Col.IntegerField():cid(43):persistence_key('protect_power_off'):null()
            :max_length(16):default(100),
        ParentCardSlotId = Col.IntegerField():cid(44):null():max_length(8),
        PfMacInfo = Col.JsonField():cid(45):null(),
        BoardName = Col.TextField():cid(46):null(),
        DriverName = Col.TextField():cid(47):null(),
        DriverVersion = Col.TextField():cid(48):null(),
        LLDPSupported = Col.BooleandField():cid(49):null(),
        LinkSpeed = Col.TextField():cid(50):null(),
        LinkSpeedCapability = Col.TextField():cid(51):null(),
        LinkWidth = Col.TextField():cid(52):null(),
        LinkWidthCapability = Col.TextField():cid(53):null(),
        SFPMaxTemperatureCelsius = Col.IntegerField():cid(54):null():max_length(16),
        Health = Col.IntegerField():cid(55):null():max_length(8),
        FaultState = Col.IntegerField():cid(56):null():max_length(32),
        PowerStatus = Col.IntegerField():cid(57):null():max_length(8):default(255),
        FaultCode = Col.TextField():cid(58):null(),
        AssetType = Col.TextField():cid(59):null(),
        AssetName = Col.TextField():cid(60):null(),
        InventorySerialNumber = Col.TextField():cid(61):null(),
        InventoryFirmwareVersion = Col.TextField():cid(62):null(),
        InventoryPCBVersion = Col.TextField():cid(63):null(),
        InventoryManufacturer = Col.TextField():cid(64):null(),
        AssetTag = Col.TextField():cid(65):null(),
        PartNumber = Col.TextField():cid(66):null(),
        ManufactureDate = Col.TextField():cid(67):null(),
        Slot = Col.TextField():cid(68):null(),
        UUID = Col.TextField():cid(69):null(),
        InventoryModel = Col.TextField():cid(70):null(),
        CardPowerGood = Col.IntegerField():cid(71):null():max_length(8),
        ReadyToRemoveValue = Col.IntegerField():cid(72):null():max_length(8),
        Segment = Col.IntegerField():cid(73):null():max_length(8):default(0),
        SocketId = Col.IntegerField():cid(74):null():max_length(8):default(0),
        Bus = Col.IntegerField():cid(75):null():max_length(8),
        Device = Col.IntegerField():cid(76):null():max_length(8),
        Function = Col.IntegerField():cid(77):null():max_length(8),
        DevBus = Col.IntegerField():cid(78):null():max_length(8),
        DevDevice = Col.IntegerField():cid(79):null():max_length(8),
        DevFunction = Col.IntegerField():cid(80):null():max_length(8),
        RefChip = Col.JsonField():cid(81):null(),
        SpecialPcieCard = Col.BooleandField():cid(82):null():default(false),
        RefFrudata = Col.JsonField():cid(83):null(),
        MPUBusyStatus = Col.IntegerField():cid(84):null():max_length(8),
        RefFruChip = Col.JsonField():cid(85):null(),
        RefCPLDChip = Col.JsonField():cid(86):null(),
        SystemLoadedStatus = Col.IntegerField():cid(87):persistence_key('protect_reset'):null():max_length(8),
        CreatedByDeviceObject = Col.BooleandField():cid(88):null():default(false),
        PowerScanner = Col.IntegerField():cid(89):null():max_length(8):default(255)
    }):create_if_not_exist(datas and datas['t_network_adapter'])
    obj.NetworkPort = db:Table('t_network_port', {
        SystemID = Col.IntegerField():cid(1):persistence_key('protect_power_off_retain'):null():max_length(8),
        Name = Col.TextField():cid(2):null(),
        Type = Col.IntegerField():cid(3):null():max_length(8),
        PortID = Col.IntegerField():cid(4):primary_key():max_length(8),
        PermanentMACAddress = Col.TextField():cid(5):persistence_key('protect_permanent'):null():default(
            '\'00:00:00:00:00:00\''),
        MACAddress = Col.TextField():cid(6):persistence_key('protect_power_off_retain'):null():default(
            '\'00:00:00:00:00:00\''),
        LinkStatus = Col.TextField():cid(7):null(),
        OSLinkStatus = Col.TextField():cid(8):null(),
        LinkStatusNumeric = Col.IntegerField():cid(9):null():max_length(8):default(255),
        IPv6DefaultGateway = Col.TextField():cid(10):null(),
        WorkMode = Col.TextField():cid(11):null():default('\'NonLoop\''),
        FunctionType = Col.TextField():cid(12):null():default('\'Physical\''),
        BDF = Col.TextField():cid(13):null(),
        AutoConnectOnBoot = Col.BooleandField():cid(14):null(),
        NetDevFuncType = Col.IntegerField():cid(15):null():max_length(8):default(1),
        MediumType = Col.TextField():cid(16):null():default('\'Copper\''),
        SpeedMbps = Col.IntegerField():cid(17):null():max_length(32):default(4294967295),
        FullDuplex = Col.BooleandField():cid(18):null(),
        AutoSpeedNegotiation = Col.BooleandField():cid(19):null(),
        FirmwareVersion = Col.TextField():cid(20):null(),
        DriverName = Col.TextField():cid(21):null(),
        DriverVersion = Col.TextField():cid(22):null(),
        LLDPEnabled = Col.BooleandField():cid(23):null(),
        SupportedLinkCapability = Col.TextField():cid(24):null(),
        NetworkAdapterId = Col.TextField():cid(25):primary_key(),
        LinkMonitorPeriodMS = Col.IntegerField():cid(26):null():max_length(32),
        UUID = Col.TextField():cid(27):null(),
        WorkloadType = Col.IntegerField():cid(28):null():max_length(8),
        MTUSize = Col.IntegerField():cid(29):null():max_length(16),
        NodeId = Col.TextField():cid(30):null(),
        RXFrames = Col.TextField():cid(31):null(),
        TXFrames = Col.TextField():cid(32):null(),
        PacketsDropped = Col.IntegerField():cid(33):null():max_length(64),
        RXUnicastFrames = Col.TextField():cid(34):null(),
        RXMulticastFrames = Col.TextField():cid(35):null(),
        RXBroadcastFrames = Col.TextField():cid(36):null(),
        TXUnicastFrames = Col.TextField():cid(37):null(),
        TXMulticastFrames = Col.TextField():cid(38):null(),
        TXBroadcastFrames = Col.TextField():cid(39):null(),
        RXFCSErrors = Col.TextField():cid(40):null(),
        RXUndersizeFrames = Col.TextField():cid(41):null(),
        RXOversizeFrames = Col.TextField():cid(42):null(),
        TXSingleCollisions = Col.TextField():cid(43):null(),
        TXMultipleCollisions = Col.TextField():cid(44):null(),
        TXLateCollisions = Col.TextField():cid(45):null(),
        TXExcessiveCollisions = Col.TextField():cid(46):null(),
        RXFrameAlignmentErrors = Col.TextField():cid(47):null(),
        RXPauseXOFFFrames = Col.IntegerField():cid(48):null():max_length(64),
        RXPauseXONFrames = Col.IntegerField():cid(49):null():max_length(64),
        TXPauseXOFFFrames = Col.IntegerField():cid(50):null():max_length(64),
        TXPauseXONFrames = Col.IntegerField():cid(51):null():max_length(64),
        RXFalseCarrierErrors = Col.IntegerField():cid(52):null():max_length(64),
        BandwidthUsagePercent = Col.RealField():cid(53):null(),
        Up2cos = Col.JsonField():cid(54):null(),
        Uppgid = Col.JsonField():cid(55):null(),
        Pgpct = Col.JsonField():cid(56):null(),
        PgStrict = Col.JsonField():cid(57):null(),
        Pfcmap = Col.IntegerField():cid(58):null():max_length(8),
        ChassisId = Col.TextField():cid(59):null(),
        ChassisIdSubtype = Col.TextField():cid(60):null(),
        LLDPReceivePortId = Col.TextField():cid(61):null(),
        PortIdSubtype = Col.TextField():cid(62):null(),
        SystemName = Col.TextField():cid(63):null(),
        ManagementVlanId = Col.IntegerField():cid(64):null():max_length(16),
        FCId = Col.TextField():cid(65):null(),
        WWNN = Col.TextField():cid(66):null(),
        PermanentWWNN = Col.TextField():cid(67):null(),
        WWPN = Col.TextField():cid(68):null(),
        PermanentWWPN = Col.TextField():cid(69):null(),
        SpeedGbps = Col.IntegerField():cid(70):null():max_length(32),
        LinkDown = Col.IntegerField():cid(71):null():max_length(8),
        TransceiverLanes = Col.JsonField():cid(72):null(),
        ProcessorPorts = Col.JsonField():cid(73):null(),
        LinkStatusValue = Col.IntegerField():cid(74):null():max_length(8),
        NpuID = Col.IntegerField():cid(75):null():max_length(8),
        PowerOn = Col.IntegerField():cid(76):null():max_length(8),
        AgentID = Col.TextField():cid(77):null():default('\'\''),
        NetworkAdapterObjectName = Col.TextField():cid(78):null():default('\'\''),
        CreatedByDeviceObject = Col.BooleandField():cid(79):null():default(false),
        PhysicalId = Col.IntegerField():cid(80):null():max_length(8):default(255),
        UdieId = Col.IntegerField():cid(81):null():max_length(8):default(255),
        PfId = Col.IntegerField():cid(82):null():max_length(8):default(255),
        NpuBoardSilkNumber = Col.IntegerField():cid(83):null():max_length(8):default(255)
    }):create_if_not_exist(datas and datas['t_network_port'])
    obj.VLAN = db:Table('t_network_vlan', {
        VLANId = Col.IntegerField():cid(1):primary_key():max_length(16),
        VLANEnabled = Col.BooleandField():cid(2):null(),
        VLANPriority = Col.IntegerField():cid(3):null():max_length(8),
        AutoConnectOnBoot = Col.BooleandField():cid(4):null(),
        PortID = Col.IntegerField():cid(5):primary_key():max_length(8),
        NetworkAdapterId = Col.TextField():cid(6):primary_key(),
        NetworkAdapterObjectName = Col.TextField():cid(7):null():default('\'\''),
        NetworkPortObjectName = Col.TextField():cid(8):null():default('\'\'')
    }):create_if_not_exist(datas and datas['t_network_vlan'])
    obj.IPv4Address = db:Table('t_network_ipv4_address', {
        Address = Col.TextField():cid(1):primary_key(),
        SubnetMask = Col.TextField():cid(2):null(),
        Gateway = Col.TextField():cid(3):null(),
        AddressOrigin = Col.TextField():cid(4):null(),
        PortID = Col.IntegerField():cid(5):primary_key():max_length(8),
        NetworkAdapterId = Col.TextField():cid(6):primary_key(),
        NetworkAdapterObjectName = Col.TextField():cid(7):null():default('\'\''),
        NetworkPortObjectName = Col.TextField():cid(8):null():default('\'\'')
    }):create_if_not_exist(datas and datas['t_network_ipv4_address'])
    obj.IPv6Address = db:Table('t_network_ipv6_address', {
        Address = Col.TextField():cid(1):primary_key(),
        PrefixLength = Col.TextField():cid(2):null(),
        AddressState = Col.TextField():cid(3):null(),
        AddressOrigin = Col.TextField():cid(4):null(),
        Gateway = Col.JsonField():cid(5):null(),
        PortID = Col.IntegerField():cid(6):primary_key():max_length(8),
        NetworkAdapterId = Col.TextField():cid(7):primary_key(),
        NetworkAdapterObjectName = Col.TextField():cid(8):null():default('\'\''),
        NetworkPortObjectName = Col.TextField():cid(9):null():default('\'\'')
    }):create_if_not_exist(datas and datas['t_network_ipv6_address'])
    obj.VLANIPv4Address = db:Table('t_network_vlan_ipv4_address', {
        Address = Col.TextField():cid(1):primary_key(),
        SubnetMask = Col.TextField():cid(2):null(),
        Gateway = Col.TextField():cid(3):null(),
        AddressOrigin = Col.TextField():cid(4):null(),
        PortID = Col.IntegerField():cid(5):primary_key():max_length(8),
        NetworkAdapterId = Col.TextField():cid(6):primary_key(),
        VLANId = Col.IntegerField():cid(7):primary_key():max_length(16),
        NetworkAdapterObjectName = Col.TextField():cid(8):null():default('\'\''),
        NetworkPortObjectName = Col.TextField():cid(9):null():default('\'\'')
    }):create_if_not_exist(datas and datas['t_network_vlan_ipv4_address'])
    obj.VLANIPv6Address = db:Table('t_network_vlan_ipv6_address', {
        Address = Col.TextField():cid(1):primary_key(),
        PrefixLength = Col.TextField():cid(2):null(),
        AddressState = Col.TextField():cid(3):null(),
        AddressOrigin = Col.TextField():cid(4):null(),
        Gateway = Col.JsonField():cid(5):null(),
        PortID = Col.IntegerField():cid(6):primary_key():max_length(8),
        NetworkAdapterId = Col.TextField():cid(7):primary_key(),
        VLANId = Col.IntegerField():cid(8):primary_key():max_length(16),
        NetworkAdapterObjectName = Col.TextField():cid(9):null():default('\'\''),
        NetworkPortObjectName = Col.TextField():cid(10):null():default('\'\'')
    }):create_if_not_exist(datas and datas['t_network_vlan_ipv6_address'])
    obj.OpticalModule = db:Table('t_optical_module', {
        Name = Col.TextField():cid(1):null(),
        Manufacturer = Col.TextField():cid(2):null(),
        PartNumber = Col.TextField():cid(3):null(),
        SerialNumber = Col.TextField():cid(4):null(),
        RevisionNumber = Col.TextField():cid(5):null(),
        ProductionDate = Col.TextField():cid(6):null(),
        TransceiverType = Col.TextField():cid(7):null(),
        FiberConnectionType = Col.TextField():cid(8):null(),
        WaveLengthNanometer = Col.TextField():cid(9):null(),
        Type = Col.TextField():cid(10):null(),
        SupportedSpeedsMbps = Col.JsonField():cid(11):null(),
        Presence = Col.IntegerField():cid(12):persistence_key('protect_reset'):null():max_length(8),
        Health = Col.IntegerField():cid(13):null():max_length(8),
        Identifier = Col.TextField():cid(14):null(),
        ConnectorType = Col.TextField():cid(15):null(),
        MediumType = Col.TextField():cid(16):null(),
        TransmissionDistance = Col.TextField():cid(17):null(),
        RxLossState = Col.BooleandField():cid(18):null(),
        TxLossState = Col.BooleandField():cid(19):null(),
        TxFaultState = Col.BooleandField():cid(20):null(),
        TypeMatch = Col.BooleandField():cid(21):null():default(true),
        SpeedMatch = Col.BooleandField():cid(22):null():default(true),
        FaultState = Col.IntegerField():cid(23):null():max_length(32),
        TemperatureCelsius = Col.RealField():cid(24):null():default(65535),
        PowerState = Col.IntegerField():cid(25):null():max_length(8),
        IsSupportedType = Col.IntegerField():cid(26):null():max_length(8),
        HostSNR = Col.JsonField():cid(27):null(),
        MediaSNR = Col.JsonField():cid(28):null(),
        RxSNR = Col.JsonField():cid(29):null(),
        Accessible = Col.IntegerField():cid(30):null():max_length(8),
        ModuleState = Col.IntegerField():cid(31):null():max_length(8):default(255),
        ChannelNum = Col.IntegerField():cid(32):null():max_length(8),
        RelatedNetworkPorts = Col.JsonField():cid(33):null(),
        Id = Col.IntegerField():cid(34):null():max_length(8):default(255),
        SilkText = Col.TextField():cid(35):null(),
        TXBiasCurrentMilliAmps = Col.JsonField():cid(36):null(),
        TXBiasCurrent1MilliAmps = Col.RealField():cid(37):null(),
        TXBiasCurrent2MilliAmps = Col.RealField():cid(38):null(),
        TXBiasCurrent3MilliAmps = Col.RealField():cid(39):null(),
        TXBiasCurrent4MilliAmps = Col.RealField():cid(40):null(),
        TXBiasCurrent5MilliAmps = Col.RealField():cid(41):null(),
        TXBiasCurrent6MilliAmps = Col.RealField():cid(42):null(),
        TXBiasCurrent7MilliAmps = Col.RealField():cid(43):null(),
        TXBiasCurrent8MilliAmps = Col.RealField():cid(44):null(),
        TXBiasCurrentStatus = Col.IntegerField():cid(45):null():max_length(32),
        BC_TXLowerThresholdCritical = Col.RealField():cid(46):null():default(65535),
        BC_TXUpperThresholdCritical = Col.RealField():cid(47):null():default(65535),
        BiasCurrentTXUpperThresholdWarning = Col.RealField():cid(48):null():default(65535),
        BiasCurrentTXLowerThresholdWarning = Col.RealField():cid(49):null():default(65535),
        RXInputPowerMilliWatts = Col.JsonField():cid(50):null(),
        RXInputPowerStatus = Col.IntegerField():cid(51):null():max_length(32),
        RXLowerThresholdCritical = Col.RealField():cid(52):null():default(65535),
        RXUpperThresholdCritical = Col.RealField():cid(53):null():default(65535),
        TXOutputPowerMilliWatts = Col.JsonField():cid(54):null(),
        TXOutputPowerStatus = Col.IntegerField():cid(55):null():max_length(32),
        Power_TXLowerThresholdCritical = Col.RealField():cid(56):null():default(65535),
        Power_TXUpperThresholdCritical = Col.RealField():cid(57):null():default(65535),
        PowerTXUpperThresholdWarning = Col.RealField():cid(58):null():default(65535),
        PowerTXLowerThresholdWarning = Col.RealField():cid(59):null():default(65535),
        PowerRXUpperThresholdWarning = Col.RealField():cid(60):null():default(65535),
        PowerRXLowerThresholdWarning = Col.RealField():cid(61):null():default(65535),
        PowerClass = Col.IntegerField():cid(62):null():max_length(8):default(255),
        PowerCapacityWatts = Col.RealField():cid(63):null(),
        ReadingCelsius = Col.RealField():cid(64):null():default(65535),
        Temp_LowerThresholdCritical = Col.RealField():cid(65):null():default(65535),
        Temp_UpperThresholdCritical = Col.RealField():cid(66):null():default(65535),
        TemperatureLowerThresholdCritical = Col.RealField():cid(67):null():default(65535),
        TemperatureUpperThresholdCritical = Col.RealField():cid(68):null():default(65535),
        TemperatureLowerThresholdWarning = Col.RealField():cid(69):null():default(65535),
        TemperatureUpperThresholdWarning = Col.RealField():cid(70):null():default(65535),
        SupplyVoltage = Col.RealField():cid(71):null():default(65535),
        Vol_LowerThresholdCritical = Col.RealField():cid(72):null():default(65535),
        Vol_UpperThresholdCritical = Col.RealField():cid(73):null():default(65535),
        VoltageLowerThresholdCritical = Col.RealField():cid(74):null():default(65535),
        VoltageUpperThresholdCritical = Col.RealField():cid(75):null():default(65535),
        VoltageLowerThresholdWarning = Col.RealField():cid(76):null():default(65535),
        VoltageUpperThresholdWarning = Col.RealField():cid(77):null():default(65535),
        RxLossOfLock = Col.IntegerField():cid(78):null():max_length(8),
        TxLossOfLock = Col.IntegerField():cid(79):null():max_length(8),
        LaserRuntimeSeconds = Col.IntegerField():cid(80):null():max_length(32),
        LaserTemperatureCelsius = Col.RealField():cid(81):null(),
        PowerOnCount = Col.IntegerField():cid(82):null():max_length(16),
        UptimeSeconds = Col.IntegerField():cid(83):null():max_length(32),
        PowerStatus = Col.IntegerField():cid(84):null():max_length(16),
        OdspDieTemperatureCelsius = Col.RealField():cid(85):null(),
        OdspHighTempRuntimeSeconds = Col.IntegerField():cid(86):null():max_length(32),
        SelfTestStatus = Col.IntegerField():cid(87):null():max_length(64),
        MediaInterfaceFaultStatus = Col.IntegerField():cid(88):null():max_length(16),
        HostInterfaceFaultStatus = Col.IntegerField():cid(89):null():max_length(16),
        RxLoS = Col.IntegerField():cid(90):null():max_length(32),
        TxLoS = Col.IntegerField():cid(91):null():max_length(32),
        TxFault = Col.IntegerField():cid(92):null():max_length(32),
        PRBSTestSupported = Col.BooleandField():cid(93):null(),
        FiberDirtyDetected = Col.BooleandField():cid(94):persistence_key('protect_reset'):null(),
        FiberLoosenessDetected = Col.BooleandField():cid(95):persistence_key('protect_reset'):null(),
        ContaminationDetectionSupported = Col.BooleandField():cid(96):null(),
        NetworkPortLanes = Col.JsonField():cid(97):null(),
        AssetType = Col.TextField():cid(98):null(),
        AssetName = Col.TextField():cid(99):null(),
        InventorySerialNumber = Col.TextField():cid(100):null(),
        InventoryFirmwareVersion = Col.TextField():cid(101):null(),
        PCBVersion = Col.TextField():cid(102):null(),
        InventoryManufacturer = Col.TextField():cid(103):null(),
        AssetTag = Col.TextField():cid(104):null(),
        InventoryPartNumber = Col.TextField():cid(105):null(),
        ManufactureDate = Col.TextField():cid(106):null(),
        Slot = Col.TextField():cid(107):null(),
        Model = Col.TextField():cid(108):null(),
        UUID = Col.TextField():cid(109):null(),
        PortID = Col.IntegerField():cid(110):primary_key():max_length(8),
        NetworkAdapterId = Col.TextField():cid(111):primary_key(),
        PfID = Col.IntegerField():cid(112):null():max_length(8):default(255),
        CreatedByDeviceObject = Col.BooleandField():cid(113):null():default(false),
        LogicalId = Col.IntegerField():cid(114):null():max_length(8):default(255)
    }):create_if_not_exist(datas and datas['t_optical_module'])
    obj.OpticalModuleChannel = db:Table('t_optical_module_channel', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        BiasCurrentMilliAmps = Col.RealField():cid(2):null(),
        RXPowerMilliWatts = Col.RealField():cid(3):null(),
        TXPowerMilliWatts = Col.RealField():cid(4):null()
    }):create_if_not_exist(datas and datas['t_optical_module_channel'])
    obj.NcsiNCInfo = db:Table('t_ncsi_nc_info', {
        Id = Col.IntegerField():cid(1):primary_key():max_length(8),
        Enable = Col.BooleandField():cid(2):null(),
        SystemId = Col.IntegerField():cid(3):null():max_length(8),
        SlotId = Col.IntegerField():cid(4):null():max_length(8),
        DeviceType = Col.IntegerField():cid(5):null():max_length(8),
        Type = Col.TextField():cid(6):null(),
        EthId = Col.IntegerField():cid(7):null():max_length(8),
        ActiveStatus = Col.BooleandField():cid(8):null(),
        PortNum = Col.IntegerField():cid(9):null():max_length(8),
        ActivePort = Col.IntegerField():cid(10):null():max_length(8),
        Mac = Col.TextField():cid(11):null(),
        VlanState = Col.BooleandField():cid(12):null(),
        VlanId = Col.IntegerField():cid(13):null():max_length(16),
        NcsiCablePresent = Col.IntegerField():cid(14):null():max_length(8),
        NcsiCableSwitch = Col.IntegerField():cid(15):null():max_length(8),
        MultiVlanState = Col.BooleandField():cid(16):null(),
        NcsiEthId = Col.IntegerField():cid(17):null():max_length(8)
    }, 'protect_power_off'):create_if_not_exist(datas and datas['t_ncsi_nc_info'])
    obj.NcsiNCPortInfo = db:Table('t_ncsi_nc_port_info', {
        NCId = Col.IntegerField():cid(1):null():max_length(8),
        PortId = Col.IntegerField():cid(2):primary_key():max_length(8),
        PackageId = Col.IntegerField():cid(3):null():max_length(8),
        ChannelId = Col.IntegerField():cid(4):null():max_length(8),
        PortAvailable = Col.BooleandField():cid(5):null(),
        LinkStatusSrc = Col.IntegerField():cid(6):null():max_length(8),
        LinkStatus = Col.TextField():cid(7):null(),
        RxEnable = Col.BooleandField():cid(8):null(),
        Type = Col.TextField():cid(9):null(),
        Slikscreen = Col.TextField():cid(10):null(),
        MgmtPortId = Col.IntegerField():cid(11):null():max_length(8)
    }, 'protect_reset'):create_if_not_exist(datas and datas['t_ncsi_nc_port_info'])
    obj.PortUsageHistory = db:Table('t_network_port_usage_history', {
        Id = Col.IntegerField():cid(1):primary_key():persistence_key('protect_power_off'):max_length(8),
        NetworkAdapterId = Col.TextField():cid(2):primary_key():persistence_key('protect_power_off'),
        PortID = Col.IntegerField():cid(3):primary_key():persistence_key('protect_power_off'):max_length(8),
        Time = Col.IntegerField():cid(4):persistence_key('protect_power_off'):null():max_length(32),
        Percent = Col.IntegerField():cid(5):persistence_key('protect_power_off'):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_network_port_usage_history'])
    obj.NetworkBridge = db:Table('t_network_bridge', {
        Id = Col.TextField():cid(1):primary_key(),
        Name = Col.TextField():cid(2):primary_key(),
        Ports = Col.JsonField():cid(3):null()
    }):create_if_not_exist(datas and datas['t_network_bridge'])
    obj.NetworkBridgePort = db:Table('t_network_bridge_port', {
        NodeId = Col.TextField():cid(1):null(),
        BridgeId = Col.TextField():cid(2):primary_key(),
        Id = Col.IntegerField():cid(3):primary_key():max_length(8),
        Name = Col.TextField():cid(4):null()
    }):create_if_not_exist(datas and datas['t_network_bridge_port'])
    obj.NetworkBonding = db:Table('t_network_bonding', {
        Id = Col.TextField():cid(1):primary_key(),
        Name = Col.TextField():cid(2):primary_key(),
        Ports = Col.JsonField():cid(3):null()
    }):create_if_not_exist(datas and datas['t_network_bonding'])
    obj.NetworkBondingPort = db:Table('t_network_bonding_port', {
        NodeId = Col.TextField():cid(1):null(),
        TeamId = Col.TextField():cid(2):primary_key(),
        Id = Col.IntegerField():cid(3):primary_key():max_length(8),
        Name = Col.TextField():cid(4):null()
    }):create_if_not_exist(datas and datas['t_network_bonding_port'])
    obj.NCSIChannelMgmt = db:Table('t_ncsi_channel_mgmt', {
        PCIePresence = Col.IntegerField():cid(1):null():max_length(8),
        OCP1Presence = Col.IntegerField():cid(2):null():max_length(8),
        OCP2Presence = Col.IntegerField():cid(3):null():max_length(8),
        NCSIChannel = Col.IntegerField():cid(4):null():max_length(8),
        Id = Col.IntegerField():cid(5):primary_key():max_length(8)
    }):create_if_not_exist(datas and datas['t_ncsi_channel_mgmt'])

    obj.tables = db.tables
    return setmetatable(obj, Network_adapterDBDatabase)
end

function Network_adapterDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function Network_adapterDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function Network_adapterDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function Network_adapterDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function Network_adapterDBDatabase:exec(...)
    return self.db:exec(...)
end

return Network_adapterDBDatabase.new
