-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local def_types = {}

---@class def_types.RelatedNetworkPortLane
---@field NetworkPortId integer
---@field NetworkPortLaneId integer
local TRelatedNetworkPortLane = {}
TRelatedNetworkPortLane.__index = TRelatedNetworkPortLane
TRelatedNetworkPortLane.group = {}

local function TRelatedNetworkPortLane_from_obj(obj)
    return setmetatable(obj, TRelatedNetworkPortLane)
end

function TRelatedNetworkPortLane.new(NetworkPortId, NetworkPortLaneId)
    return TRelatedNetworkPortLane_from_obj({
        NetworkPortId = NetworkPortId or 255,
        NetworkPortLaneId = NetworkPortLaneId or 255
    })
end
---@param obj def_types.RelatedNetworkPortLane
function TRelatedNetworkPortLane:init_from_obj(obj)
    self.NetworkPortId = obj.NetworkPortId or 255
    self.NetworkPortLaneId = obj.NetworkPortLaneId or 255
end

function TRelatedNetworkPortLane:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedNetworkPortLane.group)
end

TRelatedNetworkPortLane.from_obj = TRelatedNetworkPortLane_from_obj

TRelatedNetworkPortLane.proto_property = {'NetworkPortId', 'NetworkPortLaneId'}

TRelatedNetworkPortLane.default = {0, 0}

TRelatedNetworkPortLane.struct = {
    {name = 'NetworkPortId', is_array = false, struct = nil},
    {name = 'NetworkPortLaneId', is_array = false, struct = nil}
}

function TRelatedNetworkPortLane:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkPortId', self.NetworkPortId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'NetworkPortLaneId', self.NetworkPortLaneId, 'uint8', false, errs, need_convert)

    TRelatedNetworkPortLane:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedNetworkPortLane.proto_property, errs, need_convert)
    return self
end

function TRelatedNetworkPortLane:unpack(_)
    return self.NetworkPortId, self.NetworkPortLaneId
end

def_types.RelatedNetworkPortLane = TRelatedNetworkPortLane

---@class def_types.RelatedProcessorPort
---@field ProcessorSilkText string
---@field PortId integer
local TRelatedProcessorPort = {}
TRelatedProcessorPort.__index = TRelatedProcessorPort
TRelatedProcessorPort.group = {}

local function TRelatedProcessorPort_from_obj(obj)
    return setmetatable(obj, TRelatedProcessorPort)
end

function TRelatedProcessorPort.new(ProcessorSilkText, PortId)
    return TRelatedProcessorPort_from_obj({ProcessorSilkText = ProcessorSilkText, PortId = PortId or 255})
end
---@param obj def_types.RelatedProcessorPort
function TRelatedProcessorPort:init_from_obj(obj)
    self.ProcessorSilkText = obj.ProcessorSilkText
    self.PortId = obj.PortId or 255
end

function TRelatedProcessorPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedProcessorPort.group)
end

TRelatedProcessorPort.from_obj = TRelatedProcessorPort_from_obj

TRelatedProcessorPort.proto_property = {'ProcessorSilkText', 'PortId'}

TRelatedProcessorPort.default = {'', 0}

TRelatedProcessorPort.struct = {
    {name = 'ProcessorSilkText', is_array = false, struct = nil}, {name = 'PortId', is_array = false, struct = nil}
}

function TRelatedProcessorPort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProcessorSilkText', self.ProcessorSilkText, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)

    TRelatedProcessorPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedProcessorPort.proto_property, errs, need_convert)
    return self
end

function TRelatedProcessorPort:unpack(_)
    return self.ProcessorSilkText, self.PortId
end

def_types.RelatedProcessorPort = TRelatedProcessorPort

---@class def_types.RelatedTransceiverLane
---@field TransceiverSilkText string
---@field TransceiverLaneId integer
local TRelatedTransceiverLane = {}
TRelatedTransceiverLane.__index = TRelatedTransceiverLane
TRelatedTransceiverLane.group = {}

local function TRelatedTransceiverLane_from_obj(obj)
    return setmetatable(obj, TRelatedTransceiverLane)
end

function TRelatedTransceiverLane.new(TransceiverSilkText, TransceiverLaneId)
    return TRelatedTransceiverLane_from_obj({
        TransceiverSilkText = TransceiverSilkText,
        TransceiverLaneId = TransceiverLaneId or 255
    })
end
---@param obj def_types.RelatedTransceiverLane
function TRelatedTransceiverLane:init_from_obj(obj)
    self.TransceiverSilkText = obj.TransceiverSilkText
    self.TransceiverLaneId = obj.TransceiverLaneId or 255
end

function TRelatedTransceiverLane:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedTransceiverLane.group)
end

TRelatedTransceiverLane.from_obj = TRelatedTransceiverLane_from_obj

TRelatedTransceiverLane.proto_property = {'TransceiverSilkText', 'TransceiverLaneId'}

TRelatedTransceiverLane.default = {'', 0}

TRelatedTransceiverLane.struct = {
    {name = 'TransceiverSilkText', is_array = false, struct = nil},
    {name = 'TransceiverLaneId', is_array = false, struct = nil}
}

function TRelatedTransceiverLane:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TransceiverSilkText', self.TransceiverSilkText, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'TransceiverLaneId', self.TransceiverLaneId, 'uint8', false, errs, need_convert)

    TRelatedTransceiverLane:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedTransceiverLane.proto_property, errs, need_convert)
    return self
end

function TRelatedTransceiverLane:unpack(_)
    return self.TransceiverSilkText, self.TransceiverLaneId
end

def_types.RelatedTransceiverLane = TRelatedTransceiverLane

return def_types
