-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNetworkPort = {}

---@class MNetworkPort.NpuBoardSilkNumber
---@field NpuBoardSilkNumber integer
local TNpuBoardSilkNumber = {}
TNpuBoardSilkNumber.__index = TNpuBoardSilkNumber
TNpuBoardSilkNumber.group = {}

local function TNpuBoardSilkNumber_from_obj(obj)
    return setmetatable(obj, TNpuBoardSilkNumber)
end

function TNpuBoardSilkNumber.new(NpuBoardSilkNumber)
    return TNpuBoardSilkNumber_from_obj({NpuBoardSilkNumber = NpuBoardSilkNumber or 255})
end
---@param obj MNetworkPort.NpuBoardSilkNumber
function TNpuBoardSilkNumber:init_from_obj(obj)
    self.NpuBoardSilkNumber = obj.NpuBoardSilkNumber or 255
end

function TNpuBoardSilkNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNpuBoardSilkNumber.group)
end

TNpuBoardSilkNumber.from_obj = TNpuBoardSilkNumber_from_obj

TNpuBoardSilkNumber.proto_property = {'NpuBoardSilkNumber'}

TNpuBoardSilkNumber.default = {0}

TNpuBoardSilkNumber.struct = {{name = 'NpuBoardSilkNumber', is_array = false, struct = nil}}

function TNpuBoardSilkNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NpuBoardSilkNumber', self.NpuBoardSilkNumber, 'uint8', true, errs, need_convert)

    TNpuBoardSilkNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNpuBoardSilkNumber.proto_property, errs, need_convert)
    return self
end

function TNpuBoardSilkNumber:unpack(_)
    return self.NpuBoardSilkNumber
end

MNetworkPort.NpuBoardSilkNumber = TNpuBoardSilkNumber

---@class MNetworkPort.PfId
---@field PfId integer
local TPfId = {}
TPfId.__index = TPfId
TPfId.group = {}

local function TPfId_from_obj(obj)
    return setmetatable(obj, TPfId)
end

function TPfId.new(PfId)
    return TPfId_from_obj({PfId = PfId or 255})
end
---@param obj MNetworkPort.PfId
function TPfId:init_from_obj(obj)
    self.PfId = obj.PfId or 255
end

function TPfId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfId.group)
end

TPfId.from_obj = TPfId_from_obj

TPfId.proto_property = {'PfId'}

TPfId.default = {0}

TPfId.struct = {{name = 'PfId', is_array = false, struct = nil}}

function TPfId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PfId', self.PfId, 'uint8', true, errs, need_convert)

    TPfId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfId.proto_property, errs, need_convert)
    return self
end

function TPfId:unpack(_)
    return self.PfId
end

MNetworkPort.PfId = TPfId

---@class MNetworkPort.UdieId
---@field UdieId integer
local TUdieId = {}
TUdieId.__index = TUdieId
TUdieId.group = {}

local function TUdieId_from_obj(obj)
    return setmetatable(obj, TUdieId)
end

function TUdieId.new(UdieId)
    return TUdieId_from_obj({UdieId = UdieId or 255})
end
---@param obj MNetworkPort.UdieId
function TUdieId:init_from_obj(obj)
    self.UdieId = obj.UdieId or 255
end

function TUdieId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUdieId.group)
end

TUdieId.from_obj = TUdieId_from_obj

TUdieId.proto_property = {'UdieId'}

TUdieId.default = {0}

TUdieId.struct = {{name = 'UdieId', is_array = false, struct = nil}}

function TUdieId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UdieId', self.UdieId, 'uint8', true, errs, need_convert)

    TUdieId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUdieId.proto_property, errs, need_convert)
    return self
end

function TUdieId:unpack(_)
    return self.UdieId
end

MNetworkPort.UdieId = TUdieId

---@class MNetworkPort.PhysicalId
---@field PhysicalId integer
local TPhysicalId = {}
TPhysicalId.__index = TPhysicalId
TPhysicalId.group = {}

local function TPhysicalId_from_obj(obj)
    return setmetatable(obj, TPhysicalId)
end

function TPhysicalId.new(PhysicalId)
    return TPhysicalId_from_obj({PhysicalId = PhysicalId or 255})
end
---@param obj MNetworkPort.PhysicalId
function TPhysicalId:init_from_obj(obj)
    self.PhysicalId = obj.PhysicalId or 255
end

function TPhysicalId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalId.group)
end

TPhysicalId.from_obj = TPhysicalId_from_obj

TPhysicalId.proto_property = {'PhysicalId'}

TPhysicalId.default = {0}

TPhysicalId.struct = {{name = 'PhysicalId', is_array = false, struct = nil}}

function TPhysicalId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalId', self.PhysicalId, 'uint8', true, errs, need_convert)

    TPhysicalId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalId.proto_property, errs, need_convert)
    return self
end

function TPhysicalId:unpack(_)
    return self.PhysicalId
end

MNetworkPort.PhysicalId = TPhysicalId

---@class MNetworkPort.CreatedByDeviceObject
---@field CreatedByDeviceObject boolean
local TCreatedByDeviceObject = {}
TCreatedByDeviceObject.__index = TCreatedByDeviceObject
TCreatedByDeviceObject.group = {}

local function TCreatedByDeviceObject_from_obj(obj)
    return setmetatable(obj, TCreatedByDeviceObject)
end

function TCreatedByDeviceObject.new(CreatedByDeviceObject)
    return TCreatedByDeviceObject_from_obj({CreatedByDeviceObject = CreatedByDeviceObject or false})
end
---@param obj MNetworkPort.CreatedByDeviceObject
function TCreatedByDeviceObject:init_from_obj(obj)
    self.CreatedByDeviceObject = obj.CreatedByDeviceObject or false
end

function TCreatedByDeviceObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreatedByDeviceObject.group)
end

TCreatedByDeviceObject.from_obj = TCreatedByDeviceObject_from_obj

TCreatedByDeviceObject.proto_property = {'CreatedByDeviceObject'}

TCreatedByDeviceObject.default = {false}

TCreatedByDeviceObject.struct = {{name = 'CreatedByDeviceObject', is_array = false, struct = nil}}

function TCreatedByDeviceObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CreatedByDeviceObject', self.CreatedByDeviceObject, 'bool', false, errs, need_convert)

    TCreatedByDeviceObject:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreatedByDeviceObject.proto_property, errs, need_convert)
    return self
end

function TCreatedByDeviceObject:unpack(_)
    return self.CreatedByDeviceObject
end

MNetworkPort.CreatedByDeviceObject = TCreatedByDeviceObject

---@class MNetworkPort.NetworkAdapterObjectName
---@field NetworkAdapterObjectName string
local TNetworkAdapterObjectName = {}
TNetworkAdapterObjectName.__index = TNetworkAdapterObjectName
TNetworkAdapterObjectName.group = {}

local function TNetworkAdapterObjectName_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterObjectName)
end

function TNetworkAdapterObjectName.new(NetworkAdapterObjectName)
    return TNetworkAdapterObjectName_from_obj({NetworkAdapterObjectName = NetworkAdapterObjectName or [=[]=]})
end
---@param obj MNetworkPort.NetworkAdapterObjectName
function TNetworkAdapterObjectName:init_from_obj(obj)
    self.NetworkAdapterObjectName = obj.NetworkAdapterObjectName or [=[]=]
end

function TNetworkAdapterObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterObjectName.group)
end

TNetworkAdapterObjectName.from_obj = TNetworkAdapterObjectName_from_obj

TNetworkAdapterObjectName.proto_property = {'NetworkAdapterObjectName'}

TNetworkAdapterObjectName.default = {''}

TNetworkAdapterObjectName.struct = {{name = 'NetworkAdapterObjectName', is_array = false, struct = nil}}

function TNetworkAdapterObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkAdapterObjectName', self.NetworkAdapterObjectName, 'string', false, errs,
        need_convert)

    TNetworkAdapterObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterObjectName.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterObjectName:unpack(_)
    return self.NetworkAdapterObjectName
end

MNetworkPort.NetworkAdapterObjectName = TNetworkAdapterObjectName

---@class MNetworkPort.AgentID
---@field AgentID string
local TAgentID = {}
TAgentID.__index = TAgentID
TAgentID.group = {}

local function TAgentID_from_obj(obj)
    return setmetatable(obj, TAgentID)
end

function TAgentID.new(AgentID)
    return TAgentID_from_obj({AgentID = AgentID or [=[]=]})
end
---@param obj MNetworkPort.AgentID
function TAgentID:init_from_obj(obj)
    self.AgentID = obj.AgentID or [=[]=]
end

function TAgentID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAgentID.group)
end

TAgentID.from_obj = TAgentID_from_obj

TAgentID.proto_property = {'AgentID'}

TAgentID.default = {''}

TAgentID.struct = {{name = 'AgentID', is_array = false, struct = nil}}

function TAgentID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AgentID', self.AgentID, 'string', false, errs, need_convert)

    TAgentID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAgentID.proto_property, errs, need_convert)
    return self
end

function TAgentID:unpack(_)
    return self.AgentID
end

MNetworkPort.AgentID = TAgentID

---@class MNetworkPort.PowerOn
---@field PowerOn integer
local TPowerOn = {}
TPowerOn.__index = TPowerOn
TPowerOn.group = {}

local function TPowerOn_from_obj(obj)
    return setmetatable(obj, TPowerOn)
end

function TPowerOn.new(PowerOn)
    return TPowerOn_from_obj({PowerOn = PowerOn})
end
---@param obj MNetworkPort.PowerOn
function TPowerOn:init_from_obj(obj)
    self.PowerOn = obj.PowerOn
end

function TPowerOn:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOn.group)
end

TPowerOn.from_obj = TPowerOn_from_obj

TPowerOn.proto_property = {'PowerOn'}

TPowerOn.default = {0}

TPowerOn.struct = {{name = 'PowerOn', is_array = false, struct = nil}}

function TPowerOn:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOn', self.PowerOn, 'uint8', true, errs, need_convert)

    TPowerOn:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOn.proto_property, errs, need_convert)
    return self
end

function TPowerOn:unpack(_)
    return self.PowerOn
end

MNetworkPort.PowerOn = TPowerOn

---@class MNetworkPort.NpuID
---@field NpuID integer
local TNpuID = {}
TNpuID.__index = TNpuID
TNpuID.group = {}

local function TNpuID_from_obj(obj)
    return setmetatable(obj, TNpuID)
end

function TNpuID.new(NpuID)
    return TNpuID_from_obj({NpuID = NpuID})
end
---@param obj MNetworkPort.NpuID
function TNpuID:init_from_obj(obj)
    self.NpuID = obj.NpuID
end

function TNpuID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNpuID.group)
end

TNpuID.from_obj = TNpuID_from_obj

TNpuID.proto_property = {'NpuID'}

TNpuID.default = {0}

TNpuID.struct = {{name = 'NpuID', is_array = false, struct = nil}}

function TNpuID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NpuID', self.NpuID, 'uint8', true, errs, need_convert)

    TNpuID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNpuID.proto_property, errs, need_convert)
    return self
end

function TNpuID:unpack(_)
    return self.NpuID
end

MNetworkPort.NpuID = TNpuID

---@class MNetworkPort.LinkStatusValue
---@field LinkStatusValue integer
local TLinkStatusValue = {}
TLinkStatusValue.__index = TLinkStatusValue
TLinkStatusValue.group = {}

local function TLinkStatusValue_from_obj(obj)
    return setmetatable(obj, TLinkStatusValue)
end

function TLinkStatusValue.new(LinkStatusValue)
    return TLinkStatusValue_from_obj({LinkStatusValue = LinkStatusValue})
end
---@param obj MNetworkPort.LinkStatusValue
function TLinkStatusValue:init_from_obj(obj)
    self.LinkStatusValue = obj.LinkStatusValue
end

function TLinkStatusValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatusValue.group)
end

TLinkStatusValue.from_obj = TLinkStatusValue_from_obj

TLinkStatusValue.proto_property = {'LinkStatusValue'}

TLinkStatusValue.default = {0}

TLinkStatusValue.struct = {{name = 'LinkStatusValue', is_array = false, struct = nil}}

function TLinkStatusValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatusValue', self.LinkStatusValue, 'uint8', true, errs, need_convert)

    TLinkStatusValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatusValue.proto_property, errs, need_convert)
    return self
end

function TLinkStatusValue:unpack(_)
    return self.LinkStatusValue
end

MNetworkPort.LinkStatusValue = TLinkStatusValue

return MNetworkPort
