-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNetworkAdapter = {}

---@class MNetworkAdapter.PowerScanner
---@field PowerScanner integer
local TPowerScanner = {}
TPowerScanner.__index = TPowerScanner
TPowerScanner.group = {}

local function TPowerScanner_from_obj(obj)
    return setmetatable(obj, TPowerScanner)
end

function TPowerScanner.new(PowerScanner)
    return TPowerScanner_from_obj({PowerScanner = PowerScanner or 255})
end
---@param obj MNetworkAdapter.PowerScanner
function TPowerScanner:init_from_obj(obj)
    self.PowerScanner = obj.PowerScanner or 255
end

function TPowerScanner:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerScanner.group)
end

TPowerScanner.from_obj = TPowerScanner_from_obj

TPowerScanner.proto_property = {'PowerScanner'}

TPowerScanner.default = {0}

TPowerScanner.struct = {{name = 'PowerScanner', is_array = false, struct = nil}}

function TPowerScanner:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerScanner', self.PowerScanner, 'uint8', true, errs, need_convert)

    TPowerScanner:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerScanner.proto_property, errs, need_convert)
    return self
end

function TPowerScanner:unpack(_)
    return self.PowerScanner
end

MNetworkAdapter.PowerScanner = TPowerScanner

---@class MNetworkAdapter.CreatedByDeviceObject
---@field CreatedByDeviceObject boolean
local TCreatedByDeviceObject = {}
TCreatedByDeviceObject.__index = TCreatedByDeviceObject
TCreatedByDeviceObject.group = {}

local function TCreatedByDeviceObject_from_obj(obj)
    return setmetatable(obj, TCreatedByDeviceObject)
end

function TCreatedByDeviceObject.new(CreatedByDeviceObject)
    return TCreatedByDeviceObject_from_obj({CreatedByDeviceObject = CreatedByDeviceObject or false})
end
---@param obj MNetworkAdapter.CreatedByDeviceObject
function TCreatedByDeviceObject:init_from_obj(obj)
    self.CreatedByDeviceObject = obj.CreatedByDeviceObject or false
end

function TCreatedByDeviceObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreatedByDeviceObject.group)
end

TCreatedByDeviceObject.from_obj = TCreatedByDeviceObject_from_obj

TCreatedByDeviceObject.proto_property = {'CreatedByDeviceObject'}

TCreatedByDeviceObject.default = {false}

TCreatedByDeviceObject.struct = {{name = 'CreatedByDeviceObject', is_array = false, struct = nil}}

function TCreatedByDeviceObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CreatedByDeviceObject', self.CreatedByDeviceObject, 'bool', false, errs, need_convert)

    TCreatedByDeviceObject:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreatedByDeviceObject.proto_property, errs, need_convert)
    return self
end

function TCreatedByDeviceObject:unpack(_)
    return self.CreatedByDeviceObject
end

MNetworkAdapter.CreatedByDeviceObject = TCreatedByDeviceObject

---@class MNetworkAdapter.SystemLoadedStatus
---@field SystemLoadedStatus integer
local TSystemLoadedStatus = {}
TSystemLoadedStatus.__index = TSystemLoadedStatus
TSystemLoadedStatus.group = {}

local function TSystemLoadedStatus_from_obj(obj)
    return setmetatable(obj, TSystemLoadedStatus)
end

function TSystemLoadedStatus.new(SystemLoadedStatus)
    return TSystemLoadedStatus_from_obj({SystemLoadedStatus = SystemLoadedStatus})
end
---@param obj MNetworkAdapter.SystemLoadedStatus
function TSystemLoadedStatus:init_from_obj(obj)
    self.SystemLoadedStatus = obj.SystemLoadedStatus
end

function TSystemLoadedStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemLoadedStatus.group)
end

TSystemLoadedStatus.from_obj = TSystemLoadedStatus_from_obj

TSystemLoadedStatus.proto_property = {'SystemLoadedStatus'}

TSystemLoadedStatus.default = {0}

TSystemLoadedStatus.struct = {{name = 'SystemLoadedStatus', is_array = false, struct = nil}}

function TSystemLoadedStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemLoadedStatus', self.SystemLoadedStatus, 'uint8', false, errs, need_convert)

    TSystemLoadedStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemLoadedStatus.proto_property, errs, need_convert)
    return self
end

function TSystemLoadedStatus:unpack(_)
    return self.SystemLoadedStatus
end

MNetworkAdapter.SystemLoadedStatus = TSystemLoadedStatus

---@class MNetworkAdapter.RefCPLDChip
---@field RefCPLDChip integer[]
local TRefCPLDChip = {}
TRefCPLDChip.__index = TRefCPLDChip
TRefCPLDChip.group = {}

local function TRefCPLDChip_from_obj(obj)
    return setmetatable(obj, TRefCPLDChip)
end

function TRefCPLDChip.new(RefCPLDChip)
    return TRefCPLDChip_from_obj({RefCPLDChip = RefCPLDChip})
end
---@param obj MNetworkAdapter.RefCPLDChip
function TRefCPLDChip:init_from_obj(obj)
    self.RefCPLDChip = obj.RefCPLDChip
end

function TRefCPLDChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefCPLDChip.group)
end

TRefCPLDChip.from_obj = TRefCPLDChip_from_obj

TRefCPLDChip.proto_property = {'RefCPLDChip'}

TRefCPLDChip.default = {{}}

TRefCPLDChip.struct = {{name = 'RefCPLDChip', is_array = true, struct = nil}}

function TRefCPLDChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefCPLDChip', self.RefCPLDChip, 'uint8', false, errs, need_convert)

    TRefCPLDChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefCPLDChip.proto_property, errs, need_convert)
    return self
end

function TRefCPLDChip:unpack(_)
    return self.RefCPLDChip
end

MNetworkAdapter.RefCPLDChip = TRefCPLDChip

---@class MNetworkAdapter.RefFruChip
---@field RefFruChip integer[]
local TRefFruChip = {}
TRefFruChip.__index = TRefFruChip
TRefFruChip.group = {}

local function TRefFruChip_from_obj(obj)
    return setmetatable(obj, TRefFruChip)
end

function TRefFruChip.new(RefFruChip)
    return TRefFruChip_from_obj({RefFruChip = RefFruChip})
end
---@param obj MNetworkAdapter.RefFruChip
function TRefFruChip:init_from_obj(obj)
    self.RefFruChip = obj.RefFruChip
end

function TRefFruChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefFruChip.group)
end

TRefFruChip.from_obj = TRefFruChip_from_obj

TRefFruChip.proto_property = {'RefFruChip'}

TRefFruChip.default = {{}}

TRefFruChip.struct = {{name = 'RefFruChip', is_array = true, struct = nil}}

function TRefFruChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefFruChip', self.RefFruChip, 'uint8', false, errs, need_convert)

    TRefFruChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefFruChip.proto_property, errs, need_convert)
    return self
end

function TRefFruChip:unpack(_)
    return self.RefFruChip
end

MNetworkAdapter.RefFruChip = TRefFruChip

---@class MNetworkAdapter.MPUBusyStatus
---@field MPUBusyStatus integer
local TMPUBusyStatus = {}
TMPUBusyStatus.__index = TMPUBusyStatus
TMPUBusyStatus.group = {}

local function TMPUBusyStatus_from_obj(obj)
    return setmetatable(obj, TMPUBusyStatus)
end

function TMPUBusyStatus.new(MPUBusyStatus)
    return TMPUBusyStatus_from_obj({MPUBusyStatus = MPUBusyStatus})
end
---@param obj MNetworkAdapter.MPUBusyStatus
function TMPUBusyStatus:init_from_obj(obj)
    self.MPUBusyStatus = obj.MPUBusyStatus
end

function TMPUBusyStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMPUBusyStatus.group)
end

TMPUBusyStatus.from_obj = TMPUBusyStatus_from_obj

TMPUBusyStatus.proto_property = {'MPUBusyStatus'}

TMPUBusyStatus.default = {0}

TMPUBusyStatus.struct = {{name = 'MPUBusyStatus', is_array = false, struct = nil}}

function TMPUBusyStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MPUBusyStatus', self.MPUBusyStatus, 'uint8', false, errs, need_convert)

    TMPUBusyStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMPUBusyStatus.proto_property, errs, need_convert)
    return self
end

function TMPUBusyStatus:unpack(_)
    return self.MPUBusyStatus
end

MNetworkAdapter.MPUBusyStatus = TMPUBusyStatus

---@class MNetworkAdapter.RefFrudata
---@field RefFrudata integer[]
local TRefFrudata = {}
TRefFrudata.__index = TRefFrudata
TRefFrudata.group = {}

local function TRefFrudata_from_obj(obj)
    return setmetatable(obj, TRefFrudata)
end

function TRefFrudata.new(RefFrudata)
    return TRefFrudata_from_obj({RefFrudata = RefFrudata})
end
---@param obj MNetworkAdapter.RefFrudata
function TRefFrudata:init_from_obj(obj)
    self.RefFrudata = obj.RefFrudata
end

function TRefFrudata:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefFrudata.group)
end

TRefFrudata.from_obj = TRefFrudata_from_obj

TRefFrudata.proto_property = {'RefFrudata'}

TRefFrudata.default = {{}}

TRefFrudata.struct = {{name = 'RefFrudata', is_array = true, struct = nil}}

function TRefFrudata:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefFrudata', self.RefFrudata, 'uint8', false, errs, need_convert)

    TRefFrudata:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefFrudata.proto_property, errs, need_convert)
    return self
end

function TRefFrudata:unpack(_)
    return self.RefFrudata
end

MNetworkAdapter.RefFrudata = TRefFrudata

---@class MNetworkAdapter.SpecialPcieCard
---@field SpecialPcieCard boolean
local TSpecialPcieCard = {}
TSpecialPcieCard.__index = TSpecialPcieCard
TSpecialPcieCard.group = {}

local function TSpecialPcieCard_from_obj(obj)
    return setmetatable(obj, TSpecialPcieCard)
end

function TSpecialPcieCard.new(SpecialPcieCard)
    return TSpecialPcieCard_from_obj({SpecialPcieCard = SpecialPcieCard or false})
end
---@param obj MNetworkAdapter.SpecialPcieCard
function TSpecialPcieCard:init_from_obj(obj)
    self.SpecialPcieCard = obj.SpecialPcieCard or false
end

function TSpecialPcieCard:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpecialPcieCard.group)
end

TSpecialPcieCard.from_obj = TSpecialPcieCard_from_obj

TSpecialPcieCard.proto_property = {'SpecialPcieCard'}

TSpecialPcieCard.default = {false}

TSpecialPcieCard.struct = {{name = 'SpecialPcieCard', is_array = false, struct = nil}}

function TSpecialPcieCard:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpecialPcieCard', self.SpecialPcieCard, 'bool', true, errs, need_convert)

    TSpecialPcieCard:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpecialPcieCard.proto_property, errs, need_convert)
    return self
end

function TSpecialPcieCard:unpack(_)
    return self.SpecialPcieCard
end

MNetworkAdapter.SpecialPcieCard = TSpecialPcieCard

---@class MNetworkAdapter.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MNetworkAdapter.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MNetworkAdapter.RefChip = TRefChip

---@class MNetworkAdapter.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction})
end
---@param obj MNetworkAdapter.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', true, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

MNetworkAdapter.DevFunction = TDevFunction

---@class MNetworkAdapter.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice})
end
---@param obj MNetworkAdapter.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', true, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

MNetworkAdapter.DevDevice = TDevDevice

---@class MNetworkAdapter.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus})
end
---@param obj MNetworkAdapter.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', true, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

MNetworkAdapter.DevBus = TDevBus

---@class MNetworkAdapter.Function
---@field Function integer
local TFunction = {}
TFunction.__index = TFunction
TFunction.group = {}

local function TFunction_from_obj(obj)
    return setmetatable(obj, TFunction)
end

function TFunction.new(Function)
    return TFunction_from_obj({Function = Function})
end
---@param obj MNetworkAdapter.Function
function TFunction:init_from_obj(obj)
    self.Function = obj.Function
end

function TFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunction.group)
end

TFunction.from_obj = TFunction_from_obj

TFunction.proto_property = {'Function'}

TFunction.default = {0}

TFunction.struct = {{name = 'Function', is_array = false, struct = nil}}

function TFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Function', self.Function, 'uint8', true, errs, need_convert)

    TFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunction.proto_property, errs, need_convert)
    return self
end

function TFunction:unpack(_)
    return self.Function
end

MNetworkAdapter.Function = TFunction

---@class MNetworkAdapter.Device
---@field Device integer
local TDevice = {}
TDevice.__index = TDevice
TDevice.group = {}

local function TDevice_from_obj(obj)
    return setmetatable(obj, TDevice)
end

function TDevice.new(Device)
    return TDevice_from_obj({Device = Device})
end
---@param obj MNetworkAdapter.Device
function TDevice:init_from_obj(obj)
    self.Device = obj.Device
end

function TDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevice.group)
end

TDevice.from_obj = TDevice_from_obj

TDevice.proto_property = {'Device'}

TDevice.default = {0}

TDevice.struct = {{name = 'Device', is_array = false, struct = nil}}

function TDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Device', self.Device, 'uint8', true, errs, need_convert)

    TDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevice.proto_property, errs, need_convert)
    return self
end

function TDevice:unpack(_)
    return self.Device
end

MNetworkAdapter.Device = TDevice

---@class MNetworkAdapter.Bus
---@field Bus integer
local TBus = {}
TBus.__index = TBus
TBus.group = {}

local function TBus_from_obj(obj)
    return setmetatable(obj, TBus)
end

function TBus.new(Bus)
    return TBus_from_obj({Bus = Bus})
end
---@param obj MNetworkAdapter.Bus
function TBus:init_from_obj(obj)
    self.Bus = obj.Bus
end

function TBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBus.group)
end

TBus.from_obj = TBus_from_obj

TBus.proto_property = {'Bus'}

TBus.default = {0}

TBus.struct = {{name = 'Bus', is_array = false, struct = nil}}

function TBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', true, errs, need_convert)

    TBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBus.proto_property, errs, need_convert)
    return self
end

function TBus:unpack(_)
    return self.Bus
end

MNetworkAdapter.Bus = TBus

---@class MNetworkAdapter.SocketId
---@field SocketId integer
local TSocketId = {}
TSocketId.__index = TSocketId
TSocketId.group = {}

local function TSocketId_from_obj(obj)
    return setmetatable(obj, TSocketId)
end

function TSocketId.new(SocketId)
    return TSocketId_from_obj({SocketId = SocketId or 0})
end
---@param obj MNetworkAdapter.SocketId
function TSocketId:init_from_obj(obj)
    self.SocketId = obj.SocketId or 0
end

function TSocketId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketId.group)
end

TSocketId.from_obj = TSocketId_from_obj

TSocketId.proto_property = {'SocketId'}

TSocketId.default = {0}

TSocketId.struct = {{name = 'SocketId', is_array = false, struct = nil}}

function TSocketId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketId', self.SocketId, 'uint8', true, errs, need_convert)

    TSocketId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketId.proto_property, errs, need_convert)
    return self
end

function TSocketId:unpack(_)
    return self.SocketId
end

MNetworkAdapter.SocketId = TSocketId

---@class MNetworkAdapter.Segment
---@field Segment integer
local TSegment = {}
TSegment.__index = TSegment
TSegment.group = {}

local function TSegment_from_obj(obj)
    return setmetatable(obj, TSegment)
end

function TSegment.new(Segment)
    return TSegment_from_obj({Segment = Segment or 0})
end
---@param obj MNetworkAdapter.Segment
function TSegment:init_from_obj(obj)
    self.Segment = obj.Segment or 0
end

function TSegment:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegment.group)
end

TSegment.from_obj = TSegment_from_obj

TSegment.proto_property = {'Segment'}

TSegment.default = {0}

TSegment.struct = {{name = 'Segment', is_array = false, struct = nil}}

function TSegment:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', true, errs, need_convert)

    TSegment:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegment.proto_property, errs, need_convert)
    return self
end

function TSegment:unpack(_)
    return self.Segment
end

MNetworkAdapter.Segment = TSegment

---@class MNetworkAdapter.ReadyToRemoveValue
---@field ReadyToRemoveValue integer
local TReadyToRemoveValue = {}
TReadyToRemoveValue.__index = TReadyToRemoveValue
TReadyToRemoveValue.group = {}

local function TReadyToRemoveValue_from_obj(obj)
    return setmetatable(obj, TReadyToRemoveValue)
end

function TReadyToRemoveValue.new(ReadyToRemoveValue)
    return TReadyToRemoveValue_from_obj({ReadyToRemoveValue = ReadyToRemoveValue})
end
---@param obj MNetworkAdapter.ReadyToRemoveValue
function TReadyToRemoveValue:init_from_obj(obj)
    self.ReadyToRemoveValue = obj.ReadyToRemoveValue
end

function TReadyToRemoveValue:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadyToRemoveValue.group)
end

TReadyToRemoveValue.from_obj = TReadyToRemoveValue_from_obj

TReadyToRemoveValue.proto_property = {'ReadyToRemoveValue'}

TReadyToRemoveValue.default = {0}

TReadyToRemoveValue.struct = {{name = 'ReadyToRemoveValue', is_array = false, struct = nil}}

function TReadyToRemoveValue:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadyToRemoveValue', self.ReadyToRemoveValue, 'uint8', false, errs, need_convert)

    TReadyToRemoveValue:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadyToRemoveValue.proto_property, errs, need_convert)
    return self
end

function TReadyToRemoveValue:unpack(_)
    return self.ReadyToRemoveValue
end

MNetworkAdapter.ReadyToRemoveValue = TReadyToRemoveValue

---@class MNetworkAdapter.CardPowerGood
---@field CardPowerGood integer
local TCardPowerGood = {}
TCardPowerGood.__index = TCardPowerGood
TCardPowerGood.group = {}

local function TCardPowerGood_from_obj(obj)
    return setmetatable(obj, TCardPowerGood)
end

function TCardPowerGood.new(CardPowerGood)
    return TCardPowerGood_from_obj({CardPowerGood = CardPowerGood})
end
---@param obj MNetworkAdapter.CardPowerGood
function TCardPowerGood:init_from_obj(obj)
    self.CardPowerGood = obj.CardPowerGood
end

function TCardPowerGood:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardPowerGood.group)
end

TCardPowerGood.from_obj = TCardPowerGood_from_obj

TCardPowerGood.proto_property = {'CardPowerGood'}

TCardPowerGood.default = {0}

TCardPowerGood.struct = {{name = 'CardPowerGood', is_array = false, struct = nil}}

function TCardPowerGood:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardPowerGood', self.CardPowerGood, 'uint8', false, errs, need_convert)

    TCardPowerGood:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardPowerGood.proto_property, errs, need_convert)
    return self
end

function TCardPowerGood:unpack(_)
    return self.CardPowerGood
end

MNetworkAdapter.CardPowerGood = TCardPowerGood

return MNetworkAdapter
