-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local network_adapter_class_types = require 'class.types.NetworkAdapter'
local network_port_class_types = require 'class.types.NetworkPort'
local vla_ns_class_types = require 'class.types.VLANs'
local vlan_class_types = require 'class.types.VLAN'
local i_pv4_address_class_types = require 'class.types.IPv4Address'
local i_pv6_address_class_types = require 'class.types.IPv6Address'
local vlani_pv4_address_class_types = require 'class.types.VLANIPv4Address'
local vlani_pv6_address_class_types = require 'class.types.VLANIPv6Address'
local optical_module_class_types = require 'class.types.OpticalModule'
local ncsi_nc_info_class_types = require 'class.types.NcsiNCInfo'
local ncsi_nc_port_info_class_types = require 'class.types.NcsiNCPortInfo'
local port_usage_history_class_types = require 'class.types.PortUsageHistory'
local net_work_adapter_reset_class_types = require 'class.types.NetWorkAdapterReset'
local network_bridge_class_types = require 'class.types.NetworkBridge'
local network_bridge_port_class_types = require 'class.types.NetworkBridgePort'
local network_bonding_class_types = require 'class.types.NetworkBonding'
local network_bonding_port_class_types = require 'class.types.NetworkBondingPort'
local ncsi_channel_mgmt_class_types = require 'class.types.NCSIChannelMgmt'
local kepler_systems_network_adapters_intf_types = require 'network_adapter.json_types.keplerSystemsNetworkAdapters'
local network_bondings_intf_types = require 'network_adapter.json_types.NetworkBondings'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'
local network_adapter_intf_types = require 'network_adapter.json_types.NetworkAdapter'
local network_adapter_metrics_intf_types = require 'network_adapter.json_types.NetworkAdapterMetrics'
local status_intf_types = require 'network_adapter.json_types.Status'
local hardware_intf_types = require 'network_adapter.json_types.Hardware'
local network_port_intf_types = require 'network_adapter.json_types.NetworkPort'
local metrics_intf_types = require 'network_adapter.json_types.Metrics'
local data_center_bridging_intf_types = require 'network_adapter.json_types.DataCenterBridging'
local lldp_receive_intf_types = require 'network_adapter.json_types.LLDPReceive'
local fibre_channel_intf_types = require 'network_adapter.json_types.FibreChannel'
local fault_intf_types = require 'network_adapter.json_types.Fault'
local network_port_related_items_intf_types = require 'network_adapter.json_types.NetworkPortRelatedItems'
local vla_ns_intf_types = require 'network_adapter.json_types.VLANs'
local vlan_intf_types = require 'network_adapter.json_types.VLAN'
local i_pv4_address_intf_types = require 'network_adapter.json_types.IPv4Address'
local i_pv6_address_intf_types = require 'network_adapter.json_types.IPv6Address'
local optical_module_intf_types = require 'network_adapter.json_types.OpticalModule'
local bias_current_intf_types = require 'network_adapter.json_types.BiasCurrent'
local power_intf_types = require 'network_adapter.json_types.Power'
local temperature_intf_types = require 'network_adapter.json_types.Temperature'
local voltage_intf_types = require 'network_adapter.json_types.Voltage'
local diagnose_intf_types = require 'network_adapter.json_types.Diagnose'
local optical_module_related_items_intf_types = require 'network_adapter.json_types.OpticalModuleRelatedItems'
local metric_intf_types = require 'network_adapter.json_types.Metric'
local channel_intf_types = require 'network_adapter.json_types.Channel'
local manufacture_intf_types = require 'network_adapter.json_types.Manufacture'
local ncsi_intf_types = require 'network_adapter.json_types.NCSI'
local network_bridge_intf_types = require 'network_adapter.json_types.NetworkBridge'
local contained_port_intf_types = require 'network_adapter.json_types.ContainedPort'
local network_bonding_intf_types = require 'network_adapter.json_types.NetworkBonding'
local prbs_test_intf_types = require 'network_adapter.json_types.PRBSTest'
local contamination_detection_intf_types = require 'network_adapter.json_types.ContaminationDetection'
local debug_systems_network_adapters_intf_types = require 'network_adapter.json_types.DebugSystemsNetworkAdapters'
local optical_modules_intf_types = require 'network_adapter.json_types.OpticalModules'

local NetworkAdapters = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkAdapters'] = {},
        ['bmc.kepler.Systems.NetworkBondings'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkAdapters'] = {
            ['GetNetCardPortNum'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Type'}, {['baseType'] = 'U8', ['param'] = 'SystemID'},
                    {['baseType'] = 'U8', ['param'] = 'SlotID'}
                },
                ['rsp'] = {
                    {['baseType'] = 'U8', ['param'] = 'NetcardExist'}, {['baseType'] = 'U8', ['param'] = 'PortNum'}
                }
            },
            ['GetPortSpeed'] = {
                ['req'] = {
                    {['baseType'] = 'U8', ['param'] = 'Type'}, {['baseType'] = 'U8', ['param'] = 'Slot'},
                    {['baseType'] = 'U8', ['param'] = 'PortID'}
                },
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'Status'}, {['baseType'] = 'U32', ['param'] = 'Speed'}}
            },
            ['GetNetworkAdapterNum'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'NetworkAdapterNum'}}
            },
            ['GetNetworkPortNum'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'NetworkPortNum'}}},
            ['GetBandwidthHistory'] = {['req'] = {}, ['rsp'] = {{['baseType'] = 'String', ['param'] = 'History'}}},
            ['ClearBandwidthHistory'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'BWUWaveTitle'}},
                ['rsp'] = {}
            },
            ['SetBandwidthThreshold'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'BandwidthThresholdPercent'}},
                ['rsp'] = {{['baseType'] = 'S32', ['param'] = 'Result'}}
            }
        },
        ['bmc.kepler.Systems.NetworkBondings'] = {
            ['CreateBond'] = {
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/Object', ['param'] = 'Request'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['DeleteBond'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Id'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            },
            ['SetLinkMonitorPeriodMS'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'Id'},
                    {['baseType'] = 'U32', ['minimum'] = 0, ['maximum'] = 999999999, ['param'] = 'LinkMonitorPeriodMS'}
                },
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'BasicSetting'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/NetworkAdapters'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkAdapters'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = kepler_systems_network_adapters_intf_types
        },
        ['bmc.kepler.Systems.NetworkBondings'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['CreateBond'] = privilege.BasicSetting,
                    ['DeleteBond'] = privilege.BasicSetting,
                    ['SetLinkMonitorPeriodMS'] = privilege.BasicSetting
                }
            },
            ['interface_types'] = network_bondings_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NetworkAdapter = {
    ['table_name'] = 't_network_adapter',
    ['alias_map'] = {
        ['InventorySerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryPCBVersion'] = {['original_name'] = 'PCBVersion', ['interface'] = 'bmc.kepler.Inventory.Hardware'},
        ['InventoryManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryModel'] = {['original_name'] = 'Model', ['interface'] = 'bmc.kepler.Inventory.Hardware'}
    },
    ['prop_configs'] = {
        ['CardPowerGood'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = network_adapter_class_types.CardPowerGood
        },
        ['ReadyToRemoveValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = network_adapter_class_types.ReadyToRemoveValue
        },
        ['Segment'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.Segment
        },
        ['SocketId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.SocketId
        },
        ['Bus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.Bus
        },
        ['Device'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.Device
        },
        ['Function'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.Function
        },
        ['DevBus'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.DevBus
        },
        ['DevDevice'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.DevDevice
        },
        ['DevFunction'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_adapter_class_types.DevFunction
        },
        ['RefChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = network_adapter_class_types.RefChip
        },
        ['SpecialPcieCard'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Boolean',
            ['readOnly'] = true,
            ['default'] = false,
            ['validator'] = network_adapter_class_types.SpecialPcieCard
        },
        ['RefFrudata'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.FrudataService.Frudata',
            ['validator'] = network_adapter_class_types.RefFrudata
        },
        ['MPUBusyStatus'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['validator'] = network_adapter_class_types.MPUBusyStatus
        },
        ['RefFruChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = network_adapter_class_types.RefFruChip
        },
        ['RefCPLDChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = network_adapter_class_types.RefCPLDChip
        },
        ['SystemLoadedStatus'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'ResetPer'},
            ['validator'] = network_adapter_class_types.SystemLoadedStatus
        },
        ['CreatedByDeviceObject'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = network_adapter_class_types.CreatedByDeviceObject
        },
        ['PowerScanner'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'CSR'},
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = network_adapter_class_types.PowerScanner
        }
    },
    ['default_props'] = {
        ['CardPowerGood'] = network_adapter_class_types.CardPowerGood.default[1],
        ['ReadyToRemoveValue'] = network_adapter_class_types.ReadyToRemoveValue.default[1],
        ['Segment'] = 0,
        ['SocketId'] = 0,
        ['Bus'] = network_adapter_class_types.Bus.default[1],
        ['Device'] = network_adapter_class_types.Device.default[1],
        ['Function'] = network_adapter_class_types.Function.default[1],
        ['DevBus'] = network_adapter_class_types.DevBus.default[1],
        ['DevDevice'] = network_adapter_class_types.DevDevice.default[1],
        ['DevFunction'] = network_adapter_class_types.DevFunction.default[1],
        ['RefChip'] = network_adapter_class_types.RefChip.default[1],
        ['SpecialPcieCard'] = false,
        ['RefFrudata'] = network_adapter_class_types.RefFrudata.default[1],
        ['MPUBusyStatus'] = network_adapter_class_types.MPUBusyStatus.default[1],
        ['RefFruChip'] = network_adapter_class_types.RefFruChip.default[1],
        ['RefCPLDChip'] = network_adapter_class_types.RefCPLDChip.default[1],
        ['SystemLoadedStatus'] = network_adapter_class_types.SystemLoadedStatus.default[1],
        ['CreatedByDeviceObject'] = false,
        ['PowerScanner'] = 255
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['ID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_adapter_intf_types.ID
            },
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_adapter_intf_types.NodeId
            },
            ['SystemID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.SystemID
            },
            ['SlotNumber'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.SlotNumber
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.Name
            },
            ['DisplayName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DisplayName
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.Manufacturer
            },
            ['Description'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.Description
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.Position
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.DeviceLocator
            },
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.Type
            },
            ['NetworkPortCount'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.NetworkPortCount
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.Model
            },
            ['ModelDescription'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ModelDescription
            },
            ['ChipManufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ChipManufacturer
            },
            ['ChipVendor'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ChipVendor
            },
            ['NetDevFuncCapabilities'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.NetDevFuncCapabilities
            },
            ['RootBDF'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.RootBDF
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.FirmwareVersion
            },
            ['VendorID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = '0xFFFF',
                ['validator'] = network_adapter_intf_types.VendorID
            },
            ['DeviceID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = '0xFFFF',
                ['validator'] = network_adapter_intf_types.DeviceID
            },
            ['SubsystemVendorID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = '0xFFFF',
                ['validator'] = network_adapter_intf_types.SubsystemVendorID
            },
            ['SubsystemDeviceID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = '0xFFFF',
                ['validator'] = network_adapter_intf_types.SubsystemDeviceID
            },
            ['BoardID'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = network_adapter_intf_types.BoardID
            },
            ['BoardIDHex'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = '0xFFFF',
                ['validator'] = network_adapter_intf_types.BoardIDHex
            },
            ['ComponentUniqueID'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ComponentUniqueID
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.PCBVersion
            },
            ['AssociatedResource'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.AssociatedResource
            },
            ['SupportedMctp'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.SupportedMctp
            },
            ['SupportedLLDP'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.SupportedLLDP
            },
            ['HotPluggable'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.HotPluggable
            },
            ['ReadyToRemove'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ReadyToRemove
            },
            ['AttentionHotPlugState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = network_adapter_intf_types.AttentionHotPlugState
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.SerialNumber
            },
            ['PreviousSerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['validator'] = network_adapter_intf_types.PreviousSerialNumber
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.TemperatureCelsius
            },
            ['TemperatureStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.TemperatureStatus
            },
            ['MaxOperatingTemperatureCelsius'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.MaxOperatingTemperatureCelsius
            },
            ['PredictiveFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.PredictiveFault
            },
            ['FruId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.FruId
            },
            ['DiagnosticFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.DiagnosticFault
            },
            ['ReplacedFlag'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ReplacedFlag
            },
            ['BandwidthThresholdPercent'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPer'},
                ['default'] = 100,
                ['validator'] = network_adapter_intf_types.BandwidthThresholdPercent
            },
            ['ParentCardSlotId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.ParentCardSlotId
            },
            ['PfMacInfo'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/PfMacInfoItem'},
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.PfMacInfo
            },
            ['BoardName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_intf_types.BoardName
            },
            ['DriverName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DriverName
            },
            ['DriverVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.DriverVersion
            },
            ['LLDPSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_adapter_intf_types.LLDPSupported
            }
        },
        ['bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics'] = {
            ['LinkSpeed'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_metrics_intf_types.LinkSpeed
            },
            ['LinkSpeedCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_metrics_intf_types.LinkSpeedCapability
            },
            ['LinkWidth'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_metrics_intf_types.LinkWidth
            },
            ['LinkWidthCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_adapter_metrics_intf_types.LinkWidthCapability
            },
            ['SFPMaxTemperatureCelsius'] = {
                ['baseType'] = 'S16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = network_adapter_metrics_intf_types.SFPMaxTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.NetworkAdapter.Status'] = {
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Health
            },
            ['FaultState'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.FaultState
            },
            ['PowerStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = status_intf_types.PowerStatus
            },
            ['FaultCode'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = status_intf_types.FaultCode}
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['AssetType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetType
            },
            ['AssetName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetName
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventorySerialNumber',
                ['validator'] = hardware_intf_types.SerialNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryFirmwareVersion',
                ['validator'] = hardware_intf_types.FirmwareVersion
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryPCBVersion',
                ['validator'] = hardware_intf_types.PCBVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryManufacturer',
                ['validator'] = hardware_intf_types.Manufacturer
            },
            ['AssetTag'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.AssetTag},
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.PartNumber
            },
            ['ManufactureDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.ManufactureDate
            },
            ['Slot'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.Slot},
            ['UUID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.UUID},
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryModel',
                ['validator'] = hardware_intf_types.Model
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['StartRemovingDevice'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'ID'}},
                ['rsp'] = {},
                ['privilege'] = {'BasicSetting'}
            },
            ['DumpBlackBox'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Path'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkAdapter'] = {
            ['property_defaults'] = {
                ['ID'] = network_adapter_intf_types.ID.default[1],
                ['NodeId'] = network_adapter_intf_types.NodeId.default[1],
                ['SystemID'] = network_adapter_intf_types.SystemID.default[1],
                ['SlotNumber'] = network_adapter_intf_types.SlotNumber.default[1],
                ['Name'] = network_adapter_intf_types.Name.default[1],
                ['DisplayName'] = network_adapter_intf_types.DisplayName.default[1],
                ['Manufacturer'] = network_adapter_intf_types.Manufacturer.default[1],
                ['Description'] = network_adapter_intf_types.Description.default[1],
                ['Position'] = network_adapter_intf_types.Position.default[1],
                ['DeviceLocator'] = network_adapter_intf_types.DeviceLocator.default[1],
                ['Type'] = network_adapter_intf_types.Type.default[1],
                ['NetworkPortCount'] = network_adapter_intf_types.NetworkPortCount.default[1],
                ['Model'] = network_adapter_intf_types.Model.default[1],
                ['ModelDescription'] = network_adapter_intf_types.ModelDescription.default[1],
                ['ChipManufacturer'] = network_adapter_intf_types.ChipManufacturer.default[1],
                ['ChipVendor'] = network_adapter_intf_types.ChipVendor.default[1],
                ['NetDevFuncCapabilities'] = network_adapter_intf_types.NetDevFuncCapabilities.default[1],
                ['RootBDF'] = network_adapter_intf_types.RootBDF.default[1],
                ['FirmwareVersion'] = network_adapter_intf_types.FirmwareVersion.default[1],
                ['VendorID'] = '0xFFFF',
                ['DeviceID'] = '0xFFFF',
                ['SubsystemVendorID'] = '0xFFFF',
                ['SubsystemDeviceID'] = '0xFFFF',
                ['BoardID'] = 65535,
                ['BoardIDHex'] = '0xFFFF',
                ['ComponentUniqueID'] = network_adapter_intf_types.ComponentUniqueID.default[1],
                ['PCBVersion'] = network_adapter_intf_types.PCBVersion.default[1],
                ['AssociatedResource'] = network_adapter_intf_types.AssociatedResource.default[1],
                ['SupportedMctp'] = network_adapter_intf_types.SupportedMctp.default[1],
                ['SupportedLLDP'] = network_adapter_intf_types.SupportedLLDP.default[1],
                ['HotPluggable'] = network_adapter_intf_types.HotPluggable.default[1],
                ['ReadyToRemove'] = network_adapter_intf_types.ReadyToRemove.default[1],
                ['AttentionHotPlugState'] = network_adapter_intf_types.AttentionHotPlugState.default[1],
                ['SerialNumber'] = network_adapter_intf_types.SerialNumber.default[1],
                ['PreviousSerialNumber'] = network_adapter_intf_types.PreviousSerialNumber.default[1],
                ['TemperatureCelsius'] = network_adapter_intf_types.TemperatureCelsius.default[1],
                ['TemperatureStatus'] = network_adapter_intf_types.TemperatureStatus.default[1],
                ['MaxOperatingTemperatureCelsius'] = network_adapter_intf_types.MaxOperatingTemperatureCelsius.default[1],
                ['PredictiveFault'] = network_adapter_intf_types.PredictiveFault.default[1],
                ['FruId'] = network_adapter_intf_types.FruId.default[1],
                ['DiagnosticFault'] = network_adapter_intf_types.DiagnosticFault.default[1],
                ['ReplacedFlag'] = network_adapter_intf_types.ReplacedFlag.default[1],
                ['BandwidthThresholdPercent'] = 100,
                ['ParentCardSlotId'] = network_adapter_intf_types.ParentCardSlotId.default[1],
                ['PfMacInfo'] = network_adapter_intf_types.PfMacInfo.default[1],
                ['BoardName'] = network_adapter_intf_types.BoardName.default[1],
                ['DriverName'] = network_adapter_intf_types.DriverName.default[1],
                ['DriverVersion'] = network_adapter_intf_types.DriverVersion.default[1],
                ['LLDPSupported'] = network_adapter_intf_types.LLDPSupported.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['StartRemovingDevice'] = privilege.BasicSetting}
            },
            ['interface_types'] = network_adapter_intf_types
        },
        ['bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics'] = {
            ['property_defaults'] = {
                ['LinkSpeed'] = network_adapter_metrics_intf_types.LinkSpeed.default[1],
                ['LinkSpeedCapability'] = network_adapter_metrics_intf_types.LinkSpeedCapability.default[1],
                ['LinkWidth'] = network_adapter_metrics_intf_types.LinkWidth.default[1],
                ['LinkWidthCapability'] = network_adapter_metrics_intf_types.LinkWidthCapability.default[1],
                ['SFPMaxTemperatureCelsius'] = network_adapter_metrics_intf_types.SFPMaxTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_adapter_metrics_intf_types
        },
        ['bmc.kepler.Systems.NetworkAdapter.Status'] = {
            ['property_defaults'] = {
                ['Health'] = status_intf_types.Health.default[1],
                ['FaultState'] = status_intf_types.FaultState.default[1],
                ['PowerStatus'] = 255,
                ['FaultCode'] = status_intf_types.FaultCode.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = status_intf_types
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['property_defaults'] = {
                ['AssetType'] = hardware_intf_types.AssetType.default[1],
                ['AssetName'] = hardware_intf_types.AssetName.default[1],
                ['SerialNumber'] = hardware_intf_types.SerialNumber.default[1],
                ['FirmwareVersion'] = hardware_intf_types.FirmwareVersion.default[1],
                ['PCBVersion'] = hardware_intf_types.PCBVersion.default[1],
                ['Manufacturer'] = hardware_intf_types.Manufacturer.default[1],
                ['AssetTag'] = hardware_intf_types.AssetTag.default[1],
                ['PartNumber'] = hardware_intf_types.PartNumber.default[1],
                ['ManufactureDate'] = hardware_intf_types.ManufactureDate.default[1],
                ['Slot'] = hardware_intf_types.Slot.default[1],
                ['UUID'] = hardware_intf_types.UUID.default[1],
                ['Model'] = hardware_intf_types.Model.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = hardware_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NetworkPort = {
    ['table_name'] = 't_network_port',
    ['alias_map'] = {
        ['LLDPReceivePortId'] = {
            ['original_name'] = 'PortId',
            ['interface'] = 'bmc.kepler.Systems.NetworkPort.LLDPReceive'
        }
    },
    ['prop_configs'] = {
        ['LinkStatusValue'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_port_class_types.LinkStatusValue
        },
        ['NpuID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_port_class_types.NpuID
        },
        ['PowerOn'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['validator'] = network_port_class_types.PowerOn
        },
        ['AgentID'] = {['baseType'] = 'String', ['default'] = '', ['validator'] = network_port_class_types.AgentID},
        ['NetworkAdapterObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = network_port_class_types.NetworkAdapterObjectName
        },
        ['CreatedByDeviceObject'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = network_port_class_types.CreatedByDeviceObject
        },
        ['PhysicalId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = network_port_class_types.PhysicalId
        },
        ['UdieId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = network_port_class_types.UdieId
        },
        ['PfId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = network_port_class_types.PfId
        },
        ['NpuBoardSilkNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = network_port_class_types.NpuBoardSilkNumber
        }
    },
    ['default_props'] = {
        ['LinkStatusValue'] = network_port_class_types.LinkStatusValue.default[1],
        ['NpuID'] = network_port_class_types.NpuID.default[1],
        ['PowerOn'] = network_port_class_types.PowerOn.default[1],
        ['AgentID'] = '',
        ['NetworkAdapterObjectName'] = '',
        ['CreatedByDeviceObject'] = false,
        ['PhysicalId'] = 255,
        ['UdieId'] = 255,
        ['PfId'] = 255,
        ['NpuBoardSilkNumber'] = 255
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkPort'] = {
            ['SystemID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPerRetain'},
                ['validator'] = network_port_intf_types.SystemID
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_port_intf_types.Name
            },
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_port_intf_types.Type
            },
            ['PortID'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = network_port_intf_types.PortID
            },
            ['PermanentMACAddress'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PermanentPer'},
                ['default'] = '00:00:00:00:00:00',
                ['validator'] = network_port_intf_types.PermanentMACAddress
            },
            ['MACAddress'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'PoweroffPerRetain'},
                ['default'] = '00:00:00:00:00:00',
                ['validator'] = network_port_intf_types.MACAddress
            },
            ['LinkStatus'] = {
                ['enum'] = {'LinkUp', 'NoLink', 'LinkDown', 'N/A', 'Connected', 'Disconnected'},
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['validator'] = network_port_intf_types.LinkStatus
            },
            ['OSLinkStatus'] = {
                ['baseType'] = 'String',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = network_port_intf_types.OSLinkStatus
            },
            ['LinkStatusNumeric'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = network_port_intf_types.LinkStatusNumeric
            },
            ['IPv6DefaultGateway'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.IPv6DefaultGateway
            },
            ['WorkMode'] = {
                ['enum'] = {'Loop', 'NonLoop'},
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['default'] = 'NonLoop',
                ['validator'] = network_port_intf_types.WorkMode
            },
            ['FunctionType'] = {
                ['enum'] = {'Virtual', 'Physical'},
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 'Physical',
                ['validator'] = network_port_intf_types.FunctionType
            },
            ['BDF'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_port_intf_types.BDF
            },
            ['AutoConnectOnBoot'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.AutoConnectOnBoot
            },
            ['NetDevFuncType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 1,
                ['validator'] = network_port_intf_types.NetDevFuncType
            },
            ['MediumType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Copper', 'FiberOptic'},
                ['usage'] = {'CSR'},
                ['default'] = 'Copper',
                ['validator'] = network_port_intf_types.MediumType
            },
            ['SpeedMbps'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['default'] = 4294967295,
                ['validator'] = network_port_intf_types.SpeedMbps
            },
            ['FullDuplex'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.FullDuplex
            },
            ['AutoSpeedNegotiation'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.AutoSpeedNegotiation
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.FirmwareVersion
            },
            ['DriverName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.DriverName
            },
            ['DriverVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.DriverVersion
            },
            ['LLDPEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['validator'] = network_port_intf_types.LLDPEnabled
            },
            ['SupportedLinkCapability'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_port_intf_types.SupportedLinkCapability
            },
            ['NetworkAdapterId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_port_intf_types.NetworkAdapterId
            },
            ['LinkMonitorPeriodMS'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['validator'] = network_port_intf_types.LinkMonitorPeriodMS
            },
            ['UUID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = network_port_intf_types.UUID},
            ['WorkloadType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = network_port_intf_types.WorkloadType
            },
            ['MTUSize'] = {['baseType'] = 'U16', ['readOnly'] = true, ['validator'] = network_port_intf_types.MTUSize},
            ['NodeId'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = network_port_intf_types.NodeId}
        },
        ['bmc.kepler.Systems.NetworkPort.Metrics'] = {
            ['RXFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXFrames
            },
            ['TXFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXFrames
            },
            ['PacketsDropped'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.PacketsDropped
            },
            ['RXUnicastFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXUnicastFrames
            },
            ['RXMulticastFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXMulticastFrames
            },
            ['RXBroadcastFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXBroadcastFrames
            },
            ['TXUnicastFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXUnicastFrames
            },
            ['TXMulticastFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXMulticastFrames
            },
            ['TXBroadcastFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXBroadcastFrames
            },
            ['RXFCSErrors'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXFCSErrors
            },
            ['RXUndersizeFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXUndersizeFrames
            },
            ['RXOversizeFrames'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXOversizeFrames
            },
            ['TXSingleCollisions'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXSingleCollisions
            },
            ['TXMultipleCollisions'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXMultipleCollisions
            },
            ['TXLateCollisions'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXLateCollisions
            },
            ['TXExcessiveCollisions'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXExcessiveCollisions
            },
            ['RXFrameAlignmentErrors'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXFrameAlignmentErrors
            },
            ['RXPauseXOFFFrames'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXPauseXOFFFrames
            },
            ['RXPauseXONFrames'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXPauseXONFrames
            },
            ['TXPauseXOFFFrames'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXPauseXOFFFrames
            },
            ['TXPauseXONFrames'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.TXPauseXONFrames
            },
            ['RXFalseCarrierErrors'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = metrics_intf_types.RXFalseCarrierErrors
            },
            ['BandwidthUsagePercent'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.BandwidthUsagePercent
            }
        },
        ['bmc.kepler.Systems.NetworkPort.DataCenterBridging'] = {
            ['Up2cos'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['validator'] = data_center_bridging_intf_types.Up2cos
            },
            ['Uppgid'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['validator'] = data_center_bridging_intf_types.Uppgid
            },
            ['Pgpct'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['validator'] = data_center_bridging_intf_types.Pgpct
            },
            ['PgStrict'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['validator'] = data_center_bridging_intf_types.PgStrict
            },
            ['Pfcmap'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = data_center_bridging_intf_types.Pfcmap
            }
        },
        ['bmc.kepler.Systems.NetworkPort.LLDPReceive'] = {
            ['ChassisId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = lldp_receive_intf_types.ChassisId
            },
            ['ChassisIdSubtype'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = lldp_receive_intf_types.ChassisIdSubtype
            },
            ['PortId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'LLDPReceivePortId',
                ['validator'] = lldp_receive_intf_types.PortId
            },
            ['PortIdSubtype'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = lldp_receive_intf_types.PortIdSubtype
            },
            ['SystemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = lldp_receive_intf_types.SystemName
            },
            ['ManagementVlanId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['validator'] = lldp_receive_intf_types.ManagementVlanId
            }
        },
        ['bmc.kepler.Systems.NetworkPort.FibreChannel'] = {
            ['FCId'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = fibre_channel_intf_types.FCId},
            ['WWNN'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = fibre_channel_intf_types.WWNN},
            ['PermanentWWNN'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = fibre_channel_intf_types.PermanentWWNN
            },
            ['WWPN'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = fibre_channel_intf_types.WWPN},
            ['PermanentWWPN'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = fibre_channel_intf_types.PermanentWWPN
            },
            ['SpeedGbps'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = fibre_channel_intf_types.SpeedGbps
            }
        },
        ['bmc.kepler.Systems.NetworkPort.Fault'] = {
            ['LinkDown'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = fault_intf_types.LinkDown}
        },
        ['bmc.kepler.Systems.NetworkPort.RelatedItems'] = {
            ['TransceiverLanes'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/RelatedTransceiverLane'},
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = network_port_related_items_intf_types.TransceiverLanes
            },
            ['ProcessorPorts'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/RelatedProcessorPort'},
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = network_port_related_items_intf_types.ProcessorPorts
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkPort'] = {
            ['Configure'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/Object', ['param'] = 'Request'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkPort'] = {
            ['property_defaults'] = {
                ['SystemID'] = network_port_intf_types.SystemID.default[1],
                ['Name'] = network_port_intf_types.Name.default[1],
                ['Type'] = network_port_intf_types.Type.default[1],
                ['PortID'] = network_port_intf_types.PortID.default[1],
                ['PermanentMACAddress'] = '00:00:00:00:00:00',
                ['MACAddress'] = '00:00:00:00:00:00',
                ['LinkStatus'] = network_port_intf_types.LinkStatus.default[1],
                ['OSLinkStatus'] = network_port_intf_types.OSLinkStatus.default[1],
                ['LinkStatusNumeric'] = 255,
                ['IPv6DefaultGateway'] = network_port_intf_types.IPv6DefaultGateway.default[1],
                ['WorkMode'] = 'NonLoop',
                ['FunctionType'] = 'Physical',
                ['BDF'] = network_port_intf_types.BDF.default[1],
                ['AutoConnectOnBoot'] = network_port_intf_types.AutoConnectOnBoot.default[1],
                ['NetDevFuncType'] = 1,
                ['MediumType'] = 'Copper',
                ['SpeedMbps'] = 4294967295,
                ['FullDuplex'] = network_port_intf_types.FullDuplex.default[1],
                ['AutoSpeedNegotiation'] = network_port_intf_types.AutoSpeedNegotiation.default[1],
                ['FirmwareVersion'] = network_port_intf_types.FirmwareVersion.default[1],
                ['DriverName'] = network_port_intf_types.DriverName.default[1],
                ['DriverVersion'] = network_port_intf_types.DriverVersion.default[1],
                ['LLDPEnabled'] = network_port_intf_types.LLDPEnabled.default[1],
                ['SupportedLinkCapability'] = network_port_intf_types.SupportedLinkCapability.default[1],
                ['NetworkAdapterId'] = network_port_intf_types.NetworkAdapterId.default[1],
                ['LinkMonitorPeriodMS'] = network_port_intf_types.LinkMonitorPeriodMS.default[1],
                ['UUID'] = network_port_intf_types.UUID.default[1],
                ['WorkloadType'] = network_port_intf_types.WorkloadType.default[1],
                ['MTUSize'] = network_port_intf_types.MTUSize.default[1],
                ['NodeId'] = network_port_intf_types.NodeId.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['Configure'] = privilege.BasicSetting}},
            ['interface_types'] = network_port_intf_types
        },
        ['bmc.kepler.Systems.NetworkPort.Metrics'] = {
            ['property_defaults'] = {
                ['RXFrames'] = metrics_intf_types.RXFrames.default[1],
                ['TXFrames'] = metrics_intf_types.TXFrames.default[1],
                ['PacketsDropped'] = metrics_intf_types.PacketsDropped.default[1],
                ['RXUnicastFrames'] = metrics_intf_types.RXUnicastFrames.default[1],
                ['RXMulticastFrames'] = metrics_intf_types.RXMulticastFrames.default[1],
                ['RXBroadcastFrames'] = metrics_intf_types.RXBroadcastFrames.default[1],
                ['TXUnicastFrames'] = metrics_intf_types.TXUnicastFrames.default[1],
                ['TXMulticastFrames'] = metrics_intf_types.TXMulticastFrames.default[1],
                ['TXBroadcastFrames'] = metrics_intf_types.TXBroadcastFrames.default[1],
                ['RXFCSErrors'] = metrics_intf_types.RXFCSErrors.default[1],
                ['RXUndersizeFrames'] = metrics_intf_types.RXUndersizeFrames.default[1],
                ['RXOversizeFrames'] = metrics_intf_types.RXOversizeFrames.default[1],
                ['TXSingleCollisions'] = metrics_intf_types.TXSingleCollisions.default[1],
                ['TXMultipleCollisions'] = metrics_intf_types.TXMultipleCollisions.default[1],
                ['TXLateCollisions'] = metrics_intf_types.TXLateCollisions.default[1],
                ['TXExcessiveCollisions'] = metrics_intf_types.TXExcessiveCollisions.default[1],
                ['RXFrameAlignmentErrors'] = metrics_intf_types.RXFrameAlignmentErrors.default[1],
                ['RXPauseXOFFFrames'] = metrics_intf_types.RXPauseXOFFFrames.default[1],
                ['RXPauseXONFrames'] = metrics_intf_types.RXPauseXONFrames.default[1],
                ['TXPauseXOFFFrames'] = metrics_intf_types.TXPauseXOFFFrames.default[1],
                ['TXPauseXONFrames'] = metrics_intf_types.TXPauseXONFrames.default[1],
                ['RXFalseCarrierErrors'] = metrics_intf_types.RXFalseCarrierErrors.default[1],
                ['BandwidthUsagePercent'] = metrics_intf_types.BandwidthUsagePercent.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metrics_intf_types
        },
        ['bmc.kepler.Systems.NetworkPort.DataCenterBridging'] = {
            ['property_defaults'] = {
                ['Up2cos'] = data_center_bridging_intf_types.Up2cos.default[1],
                ['Uppgid'] = data_center_bridging_intf_types.Uppgid.default[1],
                ['Pgpct'] = data_center_bridging_intf_types.Pgpct.default[1],
                ['PgStrict'] = data_center_bridging_intf_types.PgStrict.default[1],
                ['Pfcmap'] = data_center_bridging_intf_types.Pfcmap.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = data_center_bridging_intf_types
        },
        ['bmc.kepler.Systems.NetworkPort.LLDPReceive'] = {
            ['property_defaults'] = {
                ['ChassisId'] = lldp_receive_intf_types.ChassisId.default[1],
                ['ChassisIdSubtype'] = lldp_receive_intf_types.ChassisIdSubtype.default[1],
                ['PortId'] = lldp_receive_intf_types.PortId.default[1],
                ['PortIdSubtype'] = lldp_receive_intf_types.PortIdSubtype.default[1],
                ['SystemName'] = lldp_receive_intf_types.SystemName.default[1],
                ['ManagementVlanId'] = lldp_receive_intf_types.ManagementVlanId.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = lldp_receive_intf_types
        },
        ['bmc.kepler.Systems.NetworkPort.FibreChannel'] = {
            ['property_defaults'] = {
                ['FCId'] = fibre_channel_intf_types.FCId.default[1],
                ['WWNN'] = fibre_channel_intf_types.WWNN.default[1],
                ['PermanentWWNN'] = fibre_channel_intf_types.PermanentWWNN.default[1],
                ['WWPN'] = fibre_channel_intf_types.WWPN.default[1],
                ['PermanentWWPN'] = fibre_channel_intf_types.PermanentWWPN.default[1],
                ['SpeedGbps'] = fibre_channel_intf_types.SpeedGbps.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = fibre_channel_intf_types
        },
        ['bmc.kepler.Systems.NetworkPort.Fault'] = {
            ['property_defaults'] = {['LinkDown'] = fault_intf_types.LinkDown.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = fault_intf_types
        },
        ['bmc.kepler.Systems.NetworkPort.RelatedItems'] = {
            ['property_defaults'] = {
                ['TransceiverLanes'] = network_port_related_items_intf_types.TransceiverLanes.default[1],
                ['ProcessorPorts'] = network_port_related_items_intf_types.ProcessorPorts.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_port_related_items_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VLANs = {
    ['prop_configs'] = {
        ['NetworkPortObjectName'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vla_ns_class_types.NetworkPortObjectName
        }
    },
    ['default_props'] = {['NetworkPortObjectName'] = ''},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkPort.VLANs'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkPort.VLANs'] = {
            ['CreateVLAN'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/Object', ['param'] = 'Request'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/VLANs'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkPort.VLANs'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['CreateVLAN'] = privilege.BasicSetting}},
            ['interface_types'] = vla_ns_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VLAN = {
    ['table_name'] = 't_network_vlan',
    ['prop_configs'] = {
        ['PortID'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = vlan_class_types.PortID},
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = vlan_class_types.NetworkAdapterId
        },
        ['NetworkAdapterObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vlan_class_types.NetworkAdapterObjectName
        },
        ['NetworkPortObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vlan_class_types.NetworkPortObjectName
        }
    },
    ['default_props'] = {
        ['PortID'] = vlan_class_types.PortID.default[1],
        ['NetworkAdapterId'] = vlan_class_types.NetworkAdapterId.default[1],
        ['NetworkAdapterObjectName'] = '',
        ['NetworkPortObjectName'] = ''
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkPort.VLAN'] = {
            ['VLANId'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = vlan_intf_types.VLANId
            },
            ['VLANEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = vlan_intf_types.VLANEnabled
            },
            ['VLANPriority'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = vlan_intf_types.VLANPriority},
            ['AutoConnectOnBoot'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = vlan_intf_types.AutoConnectOnBoot
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.NetworkPort.VLAN'] = {
            ['ConfigureVLAN'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/Object', ['param'] = 'Request'}},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            },
            ['DeleteVLAN'] = {
                ['privilege'] = {'BasicSetting'},
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/VLANs/:ID3'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkPort.VLAN'] = {
            ['property_defaults'] = {
                ['VLANId'] = vlan_intf_types.VLANId.default[1],
                ['VLANEnabled'] = vlan_intf_types.VLANEnabled.default[1],
                ['VLANPriority'] = vlan_intf_types.VLANPriority.default[1],
                ['AutoConnectOnBoot'] = vlan_intf_types.AutoConnectOnBoot.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['ConfigureVLAN'] = privilege.BasicSetting, ['DeleteVLAN'] = privilege.BasicSetting}
            },
            ['interface_types'] = vlan_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local IPv4Address = {
    ['table_name'] = 't_network_ipv4_address',
    ['prop_configs'] = {
        ['PortID'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = i_pv4_address_class_types.PortID},
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = i_pv4_address_class_types.NetworkAdapterId
        },
        ['NetworkAdapterObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = i_pv4_address_class_types.NetworkAdapterObjectName
        },
        ['NetworkPortObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = i_pv4_address_class_types.NetworkPortObjectName
        }
    },
    ['default_props'] = {
        ['PortID'] = i_pv4_address_class_types.PortID.default[1],
        ['NetworkAdapterId'] = i_pv4_address_class_types.NetworkAdapterId.default[1],
        ['NetworkAdapterObjectName'] = '',
        ['NetworkPortObjectName'] = ''
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPv4Address'] = {
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = i_pv4_address_intf_types.Address
            },
            ['SubnetMask'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = i_pv4_address_intf_types.SubnetMask
            },
            ['Gateway'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = i_pv4_address_intf_types.Gateway
            },
            ['AddressOrigin'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Static', 'DHCP'},
                ['validator'] = i_pv4_address_intf_types.AddressOrigin
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/IPv4Addresses/:ID3'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPv4Address'] = {
            ['property_defaults'] = {
                ['Address'] = i_pv4_address_intf_types.Address.default[1],
                ['SubnetMask'] = i_pv4_address_intf_types.SubnetMask.default[1],
                ['Gateway'] = i_pv4_address_intf_types.Gateway.default[1],
                ['AddressOrigin'] = i_pv4_address_intf_types.AddressOrigin.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = i_pv4_address_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local IPv6Address = {
    ['table_name'] = 't_network_ipv6_address',
    ['prop_configs'] = {
        ['PortID'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = i_pv6_address_class_types.PortID},
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = i_pv6_address_class_types.NetworkAdapterId
        },
        ['NetworkAdapterObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = i_pv6_address_class_types.NetworkAdapterObjectName
        },
        ['NetworkPortObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = i_pv6_address_class_types.NetworkPortObjectName
        }
    },
    ['default_props'] = {
        ['PortID'] = i_pv6_address_class_types.PortID.default[1],
        ['NetworkAdapterId'] = i_pv6_address_class_types.NetworkAdapterId.default[1],
        ['NetworkAdapterObjectName'] = '',
        ['NetworkPortObjectName'] = ''
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPv6Address'] = {
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = i_pv6_address_intf_types.Address
            },
            ['PrefixLength'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = i_pv6_address_intf_types.PrefixLength
            },
            ['AddressState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Deprecated', 'Failed', 'Preferred', 'Tentative'},
                ['validator'] = i_pv6_address_intf_types.AddressState
            },
            ['AddressOrigin'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'DHCPv6', 'LinkLocal', 'SLAAC', 'Static'},
                ['validator'] = i_pv6_address_intf_types.AddressOrigin
            },
            ['Gateway'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['validator'] = i_pv6_address_intf_types.Gateway
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/IPv6Addresses/:ID3'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPv6Address'] = {
            ['property_defaults'] = {
                ['Address'] = i_pv6_address_intf_types.Address.default[1],
                ['PrefixLength'] = i_pv6_address_intf_types.PrefixLength.default[1],
                ['AddressState'] = i_pv6_address_intf_types.AddressState.default[1],
                ['AddressOrigin'] = i_pv6_address_intf_types.AddressOrigin.default[1],
                ['Gateway'] = i_pv6_address_intf_types.Gateway.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = i_pv6_address_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VLANIPv4Address = {
    ['table_name'] = 't_network_vlan_ipv4_address',
    ['prop_configs'] = {
        ['PortID'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = vlani_pv4_address_class_types.PortID},
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = vlani_pv4_address_class_types.NetworkAdapterId
        },
        ['VLANId'] = {['primaryKey'] = true, ['baseType'] = 'U16', ['validator'] = vlani_pv4_address_class_types.VLANId},
        ['NetworkAdapterObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vlani_pv4_address_class_types.NetworkAdapterObjectName
        },
        ['NetworkPortObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vlani_pv4_address_class_types.NetworkPortObjectName
        }
    },
    ['default_props'] = {
        ['PortID'] = vlani_pv4_address_class_types.PortID.default[1],
        ['NetworkAdapterId'] = vlani_pv4_address_class_types.NetworkAdapterId.default[1],
        ['VLANId'] = vlani_pv4_address_class_types.VLANId.default[1],
        ['NetworkAdapterObjectName'] = '',
        ['NetworkPortObjectName'] = ''
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPv4Address'] = {
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = i_pv4_address_intf_types.Address
            },
            ['SubnetMask'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = i_pv4_address_intf_types.SubnetMask
            },
            ['Gateway'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = i_pv4_address_intf_types.Gateway
            },
            ['AddressOrigin'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Static', 'DHCP'},
                ['validator'] = i_pv4_address_intf_types.AddressOrigin
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/VLANs/:ID3/IPv4Addresses/:ID4'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPv4Address'] = {
            ['property_defaults'] = {
                ['Address'] = i_pv4_address_intf_types.Address.default[1],
                ['SubnetMask'] = i_pv4_address_intf_types.SubnetMask.default[1],
                ['Gateway'] = i_pv4_address_intf_types.Gateway.default[1],
                ['AddressOrigin'] = i_pv4_address_intf_types.AddressOrigin.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = i_pv4_address_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local VLANIPv6Address = {
    ['table_name'] = 't_network_vlan_ipv6_address',
    ['prop_configs'] = {
        ['PortID'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = vlani_pv6_address_class_types.PortID},
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = vlani_pv6_address_class_types.NetworkAdapterId
        },
        ['VLANId'] = {['primaryKey'] = true, ['baseType'] = 'U16', ['validator'] = vlani_pv6_address_class_types.VLANId},
        ['NetworkAdapterObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vlani_pv6_address_class_types.NetworkAdapterObjectName
        },
        ['NetworkPortObjectName'] = {
            ['baseType'] = 'String',
            ['default'] = '',
            ['validator'] = vlani_pv6_address_class_types.NetworkPortObjectName
        }
    },
    ['default_props'] = {
        ['PortID'] = vlani_pv6_address_class_types.PortID.default[1],
        ['NetworkAdapterId'] = vlani_pv6_address_class_types.NetworkAdapterId.default[1],
        ['VLANId'] = vlani_pv6_address_class_types.VLANId.default[1],
        ['NetworkAdapterObjectName'] = '',
        ['NetworkPortObjectName'] = ''
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.IPv6Address'] = {
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = i_pv6_address_intf_types.Address
            },
            ['PrefixLength'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = i_pv6_address_intf_types.PrefixLength
            },
            ['AddressState'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Deprecated', 'Failed', 'Preferred', 'Tentative'},
                ['validator'] = i_pv6_address_intf_types.AddressState
            },
            ['AddressOrigin'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'DHCPv6', 'LinkLocal', 'SLAAC', 'Static'},
                ['validator'] = i_pv6_address_intf_types.AddressOrigin
            },
            ['Gateway'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['validator'] = i_pv6_address_intf_types.Gateway
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/VLANs/:ID3/IPv6Addresses/:ID4'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.IPv6Address'] = {
            ['property_defaults'] = {
                ['Address'] = i_pv6_address_intf_types.Address.default[1],
                ['PrefixLength'] = i_pv6_address_intf_types.PrefixLength.default[1],
                ['AddressState'] = i_pv6_address_intf_types.AddressState.default[1],
                ['AddressOrigin'] = i_pv6_address_intf_types.AddressOrigin.default[1],
                ['Gateway'] = i_pv6_address_intf_types.Gateway.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = i_pv6_address_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local OpticalModule = {
    ['table_name'] = 't_optical_module',
    ['alias_map'] = {
        ['BC_TXLowerThresholdCritical'] = {
            ['original_name'] = 'TXLowerThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.BiasCurrent'
        },
        ['BC_TXUpperThresholdCritical'] = {
            ['original_name'] = 'TXUpperThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.BiasCurrent'
        },
        ['Power_TXLowerThresholdCritical'] = {
            ['original_name'] = 'TXLowerThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.Power'
        },
        ['Power_TXUpperThresholdCritical'] = {
            ['original_name'] = 'TXUpperThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.Power'
        },
        ['Temp_LowerThresholdCritical'] = {
            ['original_name'] = 'LowerThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.Temperature'
        },
        ['Temp_UpperThresholdCritical'] = {
            ['original_name'] = 'UpperThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.Temperature'
        },
        ['Vol_LowerThresholdCritical'] = {
            ['original_name'] = 'LowerThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.Voltage'
        },
        ['Vol_UpperThresholdCritical'] = {
            ['original_name'] = 'UpperThresholdCritical',
            ['interface'] = 'bmc.kepler.Systems.OpticalModule.Voltage'
        },
        ['InventorySerialNumber'] = {
            ['original_name'] = 'SerialNumber',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryFirmwareVersion'] = {
            ['original_name'] = 'FirmwareVersion',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryManufacturer'] = {
            ['original_name'] = 'Manufacturer',
            ['interface'] = 'bmc.kepler.Inventory.Hardware'
        },
        ['InventoryPartNumber'] = {['original_name'] = 'PartNumber', ['interface'] = 'bmc.kepler.Inventory.Hardware'}
    },
    ['prop_configs'] = {
        ['PortID'] = {['primaryKey'] = true, ['baseType'] = 'U8', ['validator'] = optical_module_class_types.PortID},
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = optical_module_class_types.NetworkAdapterId
        },
        ['PfID'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = optical_module_class_types.PfID
        },
        ['CreatedByDeviceObject'] = {
            ['baseType'] = 'Boolean',
            ['default'] = false,
            ['validator'] = optical_module_class_types.CreatedByDeviceObject
        },
        ['LogicalId'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['readOnly'] = true,
            ['default'] = 255,
            ['validator'] = optical_module_class_types.LogicalId
        }
    },
    ['default_props'] = {
        ['PortID'] = optical_module_class_types.PortID.default[1],
        ['NetworkAdapterId'] = optical_module_class_types.NetworkAdapterId.default[1],
        ['PfID'] = 255,
        ['CreatedByDeviceObject'] = false,
        ['LogicalId'] = 255
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.OpticalModule'] = {
            ['Name'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = optical_module_intf_types.Name},
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.Manufacturer
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.PartNumber
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.SerialNumber
            },
            ['RevisionNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.RevisionNumber
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.ProductionDate
            },
            ['TransceiverType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.TransceiverType
            },
            ['FiberConnectionType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.FiberConnectionType
            },
            ['WaveLengthNanometer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.WaveLengthNanometer
            },
            ['Type'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = optical_module_intf_types.Type},
            ['SupportedSpeedsMbps'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.SupportedSpeedsMbps
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'ResetPer'},
                ['validator'] = optical_module_intf_types.Presence
            },
            ['Health'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = optical_module_intf_types.Health},
            ['Identifier'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.Identifier
            },
            ['ConnectorType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.ConnectorType
            },
            ['MediumType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Optical', 'Electric', 'Copper', 'Aoc', 'Interface', 'Baset', ''},
                ['validator'] = optical_module_intf_types.MediumType
            },
            ['TransmissionDistance'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = optical_module_intf_types.TransmissionDistance
            },
            ['RxLossState'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = optical_module_intf_types.RxLossState
            },
            ['TxLossState'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = optical_module_intf_types.TxLossState
            },
            ['TxFaultState'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = optical_module_intf_types.TxFaultState
            },
            ['TypeMatch'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['validator'] = optical_module_intf_types.TypeMatch
            },
            ['SpeedMatch'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['validator'] = optical_module_intf_types.SpeedMatch
            },
            ['FaultState'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = optical_module_intf_types.FaultState
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = optical_module_intf_types.TemperatureCelsius
            },
            ['PowerState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = optical_module_intf_types.PowerState
            },
            ['IsSupportedType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = optical_module_intf_types.IsSupportedType
            },
            ['HostSNR'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = optical_module_intf_types.HostSNR
            },
            ['MediaSNR'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = optical_module_intf_types.MediaSNR
            },
            ['RxSNR'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = optical_module_intf_types.RxSNR
            },
            ['Accessible'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = optical_module_intf_types.Accessible
            },
            ['ModuleState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = optical_module_intf_types.ModuleState
            },
            ['ChannelNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = optical_module_intf_types.ChannelNum
            },
            ['RelatedNetworkPorts'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = optical_module_intf_types.RelatedNetworkPorts
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = optical_module_intf_types.Id
            },
            ['SilkText'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = optical_module_intf_types.SilkText
            }
        },
        ['bmc.kepler.Systems.OpticalModule.BiasCurrent'] = {
            ['TXBiasCurrentMilliAmps'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['validator'] = bias_current_intf_types.TXBiasCurrentMilliAmps
            },
            ['TXBiasCurrent1MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent1MilliAmps
            },
            ['TXBiasCurrent2MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent2MilliAmps
            },
            ['TXBiasCurrent3MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent3MilliAmps
            },
            ['TXBiasCurrent4MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent4MilliAmps
            },
            ['TXBiasCurrent5MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent5MilliAmps
            },
            ['TXBiasCurrent6MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent6MilliAmps
            },
            ['TXBiasCurrent7MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent7MilliAmps
            },
            ['TXBiasCurrent8MilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrent8MilliAmps
            },
            ['TXBiasCurrentStatus'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = bias_current_intf_types.TXBiasCurrentStatus
            },
            ['TXLowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'BC_TXLowerThresholdCritical',
                ['default'] = 65535,
                ['validator'] = bias_current_intf_types.TXLowerThresholdCritical
            },
            ['TXUpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'BC_TXUpperThresholdCritical',
                ['default'] = 65535,
                ['validator'] = bias_current_intf_types.TXUpperThresholdCritical
            },
            ['BiasCurrentTXUpperThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = bias_current_intf_types.BiasCurrentTXUpperThresholdWarning
            },
            ['BiasCurrentTXLowerThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = bias_current_intf_types.BiasCurrentTXLowerThresholdWarning
            }
        },
        ['bmc.kepler.Systems.OpticalModule.Power'] = {
            ['RXInputPowerMilliWatts'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['validator'] = power_intf_types.RXInputPowerMilliWatts
            },
            ['RXInputPowerStatus'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = power_intf_types.RXInputPowerStatus
            },
            ['RXLowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = 65535,
                ['validator'] = power_intf_types.RXLowerThresholdCritical
            },
            ['RXUpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = 65535,
                ['validator'] = power_intf_types.RXUpperThresholdCritical
            },
            ['TXOutputPowerMilliWatts'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['validator'] = power_intf_types.TXOutputPowerMilliWatts
            },
            ['TXOutputPowerStatus'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = power_intf_types.TXOutputPowerStatus
            },
            ['TXLowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'Power_TXLowerThresholdCritical',
                ['default'] = 65535,
                ['validator'] = power_intf_types.TXLowerThresholdCritical
            },
            ['TXUpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'Power_TXUpperThresholdCritical',
                ['default'] = 65535,
                ['validator'] = power_intf_types.TXUpperThresholdCritical
            },
            ['PowerTXUpperThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = power_intf_types.PowerTXUpperThresholdWarning
            },
            ['PowerTXLowerThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = power_intf_types.PowerTXLowerThresholdWarning
            },
            ['PowerRXUpperThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = power_intf_types.PowerRXUpperThresholdWarning
            },
            ['PowerRXLowerThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = power_intf_types.PowerRXLowerThresholdWarning
            },
            ['PowerClass'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = power_intf_types.PowerClass
            },
            ['PowerCapacityWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['validator'] = power_intf_types.PowerCapacityWatts
            }
        },
        ['bmc.kepler.Systems.OpticalModule.Temperature'] = {
            ['ReadingCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.ReadingCelsius
            },
            ['LowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['alias'] = 'Temp_LowerThresholdCritical',
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.LowerThresholdCritical
            },
            ['UpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'Temp_UpperThresholdCritical',
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.UpperThresholdCritical
            },
            ['TemperatureLowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.TemperatureLowerThresholdCritical
            },
            ['TemperatureUpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.TemperatureUpperThresholdCritical
            },
            ['TemperatureLowerThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.TemperatureLowerThresholdWarning
            },
            ['TemperatureUpperThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = temperature_intf_types.TemperatureUpperThresholdWarning
            }
        },
        ['bmc.kepler.Systems.OpticalModule.Voltage'] = {
            ['SupplyVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.SupplyVoltage
            },
            ['LowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'Vol_LowerThresholdCritical',
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.LowerThresholdCritical
            },
            ['UpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['alias'] = 'Vol_UpperThresholdCritical',
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.UpperThresholdCritical
            },
            ['VoltageLowerThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.VoltageLowerThresholdCritical
            },
            ['VoltageUpperThresholdCritical'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.VoltageUpperThresholdCritical
            },
            ['VoltageLowerThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.VoltageLowerThresholdWarning
            },
            ['VoltageUpperThresholdWarning'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 65535,
                ['validator'] = voltage_intf_types.VoltageUpperThresholdWarning
            }
        },
        ['bmc.kepler.Systems.OpticalModule.Diagnose'] = {
            ['RxLossOfLock'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.RxLossOfLock
            },
            ['TxLossOfLock'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.TxLossOfLock
            },
            ['LaserRuntimeSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.LaserRuntimeSeconds
            },
            ['LaserTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.LaserTemperatureCelsius
            },
            ['PowerOnCount'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.PowerOnCount
            },
            ['UptimeSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.UptimeSeconds
            },
            ['PowerStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.PowerStatus
            },
            ['OdspDieTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.OdspDieTemperatureCelsius
            },
            ['OdspHighTempRuntimeSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.OdspHighTempRuntimeSeconds
            },
            ['SelfTestStatus'] = {
                ['baseType'] = 'U64',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.SelfTestStatus
            },
            ['MediaInterfaceFaultStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.MediaInterfaceFaultStatus
            },
            ['HostInterfaceFaultStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.HostInterfaceFaultStatus
            },
            ['RxLoS'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.RxLoS
            },
            ['TxLoS'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.TxLoS
            },
            ['TxFault'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.TxFault
            },
            ['PRBSTestSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = diagnose_intf_types.PRBSTestSupported
            },
            ['FiberDirtyDetected'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['usage'] = {'ResetPer'},
                ['validator'] = diagnose_intf_types.FiberDirtyDetected
            },
            ['FiberLoosenessDetected'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['usage'] = {'ResetPer'},
                ['validator'] = diagnose_intf_types.FiberLoosenessDetected
            },
            ['ContaminationDetectionSupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = diagnose_intf_types.ContaminationDetectionSupported
            }
        },
        ['bmc.kepler.Systems.OpticalModule.RelatedItems'] = {
            ['NetworkPortLanes'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/RelatedNetworkPortLane'},
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = optical_module_related_items_intf_types.NetworkPortLanes
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Inventory.Hardware'] = {
            ['AssetType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetType
            },
            ['AssetName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.AssetName
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventorySerialNumber',
                ['validator'] = hardware_intf_types.SerialNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryFirmwareVersion',
                ['validator'] = hardware_intf_types.FirmwareVersion
            },
            ['PCBVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.PCBVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryManufacturer',
                ['validator'] = hardware_intf_types.Manufacturer
            },
            ['AssetTag'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.AssetTag},
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['alias'] = 'InventoryPartNumber',
                ['validator'] = hardware_intf_types.PartNumber
            },
            ['ManufactureDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = hardware_intf_types.ManufactureDate
            },
            ['Slot'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.Slot},
            ['Model'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.Model},
            ['UUID'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = hardware_intf_types.UUID}
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/DataCollectionItem'}, ['param'] = 'Val'}
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Classification'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Identification'},
                    {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}}, ['rsp'] = {}}
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/OpticalModule'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.OpticalModule'] = {
            ['property_defaults'] = {
                ['Name'] = optical_module_intf_types.Name.default[1],
                ['Manufacturer'] = optical_module_intf_types.Manufacturer.default[1],
                ['PartNumber'] = optical_module_intf_types.PartNumber.default[1],
                ['SerialNumber'] = optical_module_intf_types.SerialNumber.default[1],
                ['RevisionNumber'] = optical_module_intf_types.RevisionNumber.default[1],
                ['ProductionDate'] = optical_module_intf_types.ProductionDate.default[1],
                ['TransceiverType'] = optical_module_intf_types.TransceiverType.default[1],
                ['FiberConnectionType'] = optical_module_intf_types.FiberConnectionType.default[1],
                ['WaveLengthNanometer'] = optical_module_intf_types.WaveLengthNanometer.default[1],
                ['Type'] = optical_module_intf_types.Type.default[1],
                ['SupportedSpeedsMbps'] = optical_module_intf_types.SupportedSpeedsMbps.default[1],
                ['Presence'] = optical_module_intf_types.Presence.default[1],
                ['Health'] = optical_module_intf_types.Health.default[1],
                ['Identifier'] = optical_module_intf_types.Identifier.default[1],
                ['ConnectorType'] = optical_module_intf_types.ConnectorType.default[1],
                ['MediumType'] = optical_module_intf_types.MediumType.default[1],
                ['TransmissionDistance'] = optical_module_intf_types.TransmissionDistance.default[1],
                ['RxLossState'] = optical_module_intf_types.RxLossState.default[1],
                ['TxLossState'] = optical_module_intf_types.TxLossState.default[1],
                ['TxFaultState'] = optical_module_intf_types.TxFaultState.default[1],
                ['TypeMatch'] = true,
                ['SpeedMatch'] = true,
                ['FaultState'] = optical_module_intf_types.FaultState.default[1],
                ['TemperatureCelsius'] = 65535,
                ['PowerState'] = optical_module_intf_types.PowerState.default[1],
                ['IsSupportedType'] = optical_module_intf_types.IsSupportedType.default[1],
                ['HostSNR'] = optical_module_intf_types.HostSNR.default[1],
                ['MediaSNR'] = optical_module_intf_types.MediaSNR.default[1],
                ['RxSNR'] = optical_module_intf_types.RxSNR.default[1],
                ['Accessible'] = optical_module_intf_types.Accessible.default[1],
                ['ModuleState'] = 255,
                ['ChannelNum'] = optical_module_intf_types.ChannelNum.default[1],
                ['RelatedNetworkPorts'] = optical_module_intf_types.RelatedNetworkPorts.default[1],
                ['Id'] = 255,
                ['SilkText'] = optical_module_intf_types.SilkText.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = optical_module_intf_types
        },
        ['bmc.kepler.Systems.OpticalModule.BiasCurrent'] = {
            ['property_defaults'] = {
                ['TXBiasCurrentMilliAmps'] = bias_current_intf_types.TXBiasCurrentMilliAmps.default[1],
                ['TXBiasCurrent1MilliAmps'] = bias_current_intf_types.TXBiasCurrent1MilliAmps.default[1],
                ['TXBiasCurrent2MilliAmps'] = bias_current_intf_types.TXBiasCurrent2MilliAmps.default[1],
                ['TXBiasCurrent3MilliAmps'] = bias_current_intf_types.TXBiasCurrent3MilliAmps.default[1],
                ['TXBiasCurrent4MilliAmps'] = bias_current_intf_types.TXBiasCurrent4MilliAmps.default[1],
                ['TXBiasCurrent5MilliAmps'] = bias_current_intf_types.TXBiasCurrent5MilliAmps.default[1],
                ['TXBiasCurrent6MilliAmps'] = bias_current_intf_types.TXBiasCurrent6MilliAmps.default[1],
                ['TXBiasCurrent7MilliAmps'] = bias_current_intf_types.TXBiasCurrent7MilliAmps.default[1],
                ['TXBiasCurrent8MilliAmps'] = bias_current_intf_types.TXBiasCurrent8MilliAmps.default[1],
                ['TXBiasCurrentStatus'] = bias_current_intf_types.TXBiasCurrentStatus.default[1],
                ['TXLowerThresholdCritical'] = 65535,
                ['TXUpperThresholdCritical'] = 65535,
                ['BiasCurrentTXUpperThresholdWarning'] = 65535,
                ['BiasCurrentTXLowerThresholdWarning'] = 65535
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = bias_current_intf_types
        },
        ['bmc.kepler.Systems.OpticalModule.Power'] = {
            ['property_defaults'] = {
                ['RXInputPowerMilliWatts'] = power_intf_types.RXInputPowerMilliWatts.default[1],
                ['RXInputPowerStatus'] = power_intf_types.RXInputPowerStatus.default[1],
                ['RXLowerThresholdCritical'] = 65535,
                ['RXUpperThresholdCritical'] = 65535,
                ['TXOutputPowerMilliWatts'] = power_intf_types.TXOutputPowerMilliWatts.default[1],
                ['TXOutputPowerStatus'] = power_intf_types.TXOutputPowerStatus.default[1],
                ['TXLowerThresholdCritical'] = 65535,
                ['TXUpperThresholdCritical'] = 65535,
                ['PowerTXUpperThresholdWarning'] = 65535,
                ['PowerTXLowerThresholdWarning'] = 65535,
                ['PowerRXUpperThresholdWarning'] = 65535,
                ['PowerRXLowerThresholdWarning'] = 65535,
                ['PowerClass'] = 255,
                ['PowerCapacityWatts'] = power_intf_types.PowerCapacityWatts.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = power_intf_types
        },
        ['bmc.kepler.Systems.OpticalModule.Temperature'] = {
            ['property_defaults'] = {
                ['ReadingCelsius'] = 65535,
                ['LowerThresholdCritical'] = 65535,
                ['UpperThresholdCritical'] = 65535,
                ['TemperatureLowerThresholdCritical'] = 65535,
                ['TemperatureUpperThresholdCritical'] = 65535,
                ['TemperatureLowerThresholdWarning'] = 65535,
                ['TemperatureUpperThresholdWarning'] = 65535
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = temperature_intf_types
        },
        ['bmc.kepler.Systems.OpticalModule.Voltage'] = {
            ['property_defaults'] = {
                ['SupplyVoltage'] = 65535,
                ['LowerThresholdCritical'] = 65535,
                ['UpperThresholdCritical'] = 65535,
                ['VoltageLowerThresholdCritical'] = 65535,
                ['VoltageUpperThresholdCritical'] = 65535,
                ['VoltageLowerThresholdWarning'] = 65535,
                ['VoltageUpperThresholdWarning'] = 65535
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = voltage_intf_types
        },
        ['bmc.kepler.Systems.OpticalModule.Diagnose'] = {
            ['property_defaults'] = {
                ['RxLossOfLock'] = diagnose_intf_types.RxLossOfLock.default[1],
                ['TxLossOfLock'] = diagnose_intf_types.TxLossOfLock.default[1],
                ['LaserRuntimeSeconds'] = diagnose_intf_types.LaserRuntimeSeconds.default[1],
                ['LaserTemperatureCelsius'] = diagnose_intf_types.LaserTemperatureCelsius.default[1],
                ['PowerOnCount'] = diagnose_intf_types.PowerOnCount.default[1],
                ['UptimeSeconds'] = diagnose_intf_types.UptimeSeconds.default[1],
                ['PowerStatus'] = diagnose_intf_types.PowerStatus.default[1],
                ['OdspDieTemperatureCelsius'] = diagnose_intf_types.OdspDieTemperatureCelsius.default[1],
                ['OdspHighTempRuntimeSeconds'] = diagnose_intf_types.OdspHighTempRuntimeSeconds.default[1],
                ['SelfTestStatus'] = diagnose_intf_types.SelfTestStatus.default[1],
                ['MediaInterfaceFaultStatus'] = diagnose_intf_types.MediaInterfaceFaultStatus.default[1],
                ['HostInterfaceFaultStatus'] = diagnose_intf_types.HostInterfaceFaultStatus.default[1],
                ['RxLoS'] = diagnose_intf_types.RxLoS.default[1],
                ['TxLoS'] = diagnose_intf_types.TxLoS.default[1],
                ['TxFault'] = diagnose_intf_types.TxFault.default[1],
                ['PRBSTestSupported'] = diagnose_intf_types.PRBSTestSupported.default[1],
                ['FiberDirtyDetected'] = diagnose_intf_types.FiberDirtyDetected.default[1],
                ['FiberLoosenessDetected'] = diagnose_intf_types.FiberLoosenessDetected.default[1],
                ['ContaminationDetectionSupported'] = diagnose_intf_types.ContaminationDetectionSupported.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = diagnose_intf_types
        },
        ['bmc.kepler.Systems.OpticalModule.RelatedItems'] = {
            ['property_defaults'] = {
                ['NetworkPortLanes'] = optical_module_related_items_intf_types.NetworkPortLanes.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = optical_module_related_items_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Inventory.Hardware'] = {
            ['property_defaults'] = {
                ['AssetType'] = hardware_intf_types.AssetType.default[1],
                ['AssetName'] = hardware_intf_types.AssetName.default[1],
                ['SerialNumber'] = hardware_intf_types.SerialNumber.default[1],
                ['FirmwareVersion'] = hardware_intf_types.FirmwareVersion.default[1],
                ['PCBVersion'] = hardware_intf_types.PCBVersion.default[1],
                ['Manufacturer'] = hardware_intf_types.Manufacturer.default[1],
                ['AssetTag'] = hardware_intf_types.AssetTag.default[1],
                ['PartNumber'] = hardware_intf_types.PartNumber.default[1],
                ['ManufactureDate'] = hardware_intf_types.ManufactureDate.default[1],
                ['Slot'] = hardware_intf_types.Slot.default[1],
                ['Model'] = hardware_intf_types.Model.default[1],
                ['UUID'] = hardware_intf_types.UUID.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = hardware_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local OpticalModuleChannel = {
    ['table_name'] = 't_optical_module_channel',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.OpticalModule.Channel'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = channel_intf_types.Id
            },
            ['BiasCurrentMilliAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = channel_intf_types.BiasCurrentMilliAmps
            },
            ['RXPowerMilliWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = channel_intf_types.RXPowerMilliWatts
            },
            ['TXPowerMilliWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = channel_intf_types.TXPowerMilliWatts
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID1/Ports/:ID2/OpticalModule/Channel/:ID3'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.OpticalModule.Channel'] = {
            ['property_defaults'] = {
                ['Id'] = channel_intf_types.Id.default[1],
                ['BiasCurrentMilliAmps'] = channel_intf_types.BiasCurrentMilliAmps.default[1],
                ['RXPowerMilliWatts'] = channel_intf_types.RXPowerMilliWatts.default[1],
                ['TXPowerMilliWatts'] = channel_intf_types.TXPowerMilliWatts.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = channel_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NcsiNCInfo = {
    ['table_name'] = 't_ncsi_nc_info',
    ['prop_configs'] = {
        ['Id'] = {['baseType'] = 'U8', ['primaryKey'] = true, ['validator'] = ncsi_nc_info_class_types.Id},
        ['Enable'] = {['baseType'] = 'Boolean', ['validator'] = ncsi_nc_info_class_types.Enable},
        ['SystemId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.SystemId},
        ['SlotId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.SlotId},
        ['DeviceType'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.DeviceType},
        ['Type'] = {['baseType'] = 'String', ['validator'] = ncsi_nc_info_class_types.Type},
        ['EthId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.EthId},
        ['ActiveStatus'] = {['baseType'] = 'Boolean', ['validator'] = ncsi_nc_info_class_types.ActiveStatus},
        ['PortNum'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.PortNum},
        ['ActivePort'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.ActivePort},
        ['Mac'] = {['baseType'] = 'String', ['validator'] = ncsi_nc_info_class_types.Mac},
        ['VlanState'] = {['baseType'] = 'Boolean', ['validator'] = ncsi_nc_info_class_types.VlanState},
        ['VlanId'] = {['baseType'] = 'U16', ['validator'] = ncsi_nc_info_class_types.VlanId},
        ['NcsiCablePresent'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.NcsiCablePresent},
        ['NcsiCableSwitch'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.NcsiCableSwitch},
        ['MultiVlanState'] = {['baseType'] = 'Boolean', ['validator'] = ncsi_nc_info_class_types.MultiVlanState},
        ['NcsiEthId'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = ncsi_nc_info_class_types.NcsiEthId}
    },
    ['default_props'] = {
        ['Id'] = ncsi_nc_info_class_types.Id.default[1],
        ['Enable'] = ncsi_nc_info_class_types.Enable.default[1],
        ['SystemId'] = ncsi_nc_info_class_types.SystemId.default[1],
        ['SlotId'] = ncsi_nc_info_class_types.SlotId.default[1],
        ['DeviceType'] = ncsi_nc_info_class_types.DeviceType.default[1],
        ['Type'] = ncsi_nc_info_class_types.Type.default[1],
        ['EthId'] = ncsi_nc_info_class_types.EthId.default[1],
        ['ActiveStatus'] = ncsi_nc_info_class_types.ActiveStatus.default[1],
        ['PortNum'] = ncsi_nc_info_class_types.PortNum.default[1],
        ['ActivePort'] = ncsi_nc_info_class_types.ActivePort.default[1],
        ['Mac'] = ncsi_nc_info_class_types.Mac.default[1],
        ['VlanState'] = ncsi_nc_info_class_types.VlanState.default[1],
        ['VlanId'] = ncsi_nc_info_class_types.VlanId.default[1],
        ['NcsiCablePresent'] = ncsi_nc_info_class_types.NcsiCablePresent.default[1],
        ['NcsiCableSwitch'] = ncsi_nc_info_class_types.NcsiCableSwitch.default[1],
        ['MultiVlanState'] = ncsi_nc_info_class_types.MultiVlanState.default[1],
        ['NcsiEthId'] = ncsi_nc_info_class_types.NcsiEthId.default[1]
    }
}

local NcsiNCPortInfo = {
    ['table_name'] = 't_ncsi_nc_port_info',
    ['prop_configs'] = {
        ['NCId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_port_info_class_types.NCId},
        ['PortId'] = {['baseType'] = 'U8', ['primaryKey'] = true, ['validator'] = ncsi_nc_port_info_class_types.PortId},
        ['PackageId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_port_info_class_types.PackageId},
        ['ChannelId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_port_info_class_types.ChannelId},
        ['PortAvailable'] = {['baseType'] = 'Boolean', ['validator'] = ncsi_nc_port_info_class_types.PortAvailable},
        ['LinkStatusSrc'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_port_info_class_types.LinkStatusSrc},
        ['LinkStatus'] = {['baseType'] = 'String', ['validator'] = ncsi_nc_port_info_class_types.LinkStatus},
        ['RxEnable'] = {['baseType'] = 'Boolean', ['validator'] = ncsi_nc_port_info_class_types.RxEnable},
        ['Type'] = {['baseType'] = 'String', ['validator'] = ncsi_nc_port_info_class_types.Type},
        ['Slikscreen'] = {['baseType'] = 'String', ['validator'] = ncsi_nc_port_info_class_types.Slikscreen},
        ['MgmtPortId'] = {['baseType'] = 'U8', ['validator'] = ncsi_nc_port_info_class_types.MgmtPortId}
    },
    ['default_props'] = {
        ['NCId'] = ncsi_nc_port_info_class_types.NCId.default[1],
        ['PortId'] = ncsi_nc_port_info_class_types.PortId.default[1],
        ['PackageId'] = ncsi_nc_port_info_class_types.PackageId.default[1],
        ['ChannelId'] = ncsi_nc_port_info_class_types.ChannelId.default[1],
        ['PortAvailable'] = ncsi_nc_port_info_class_types.PortAvailable.default[1],
        ['LinkStatusSrc'] = ncsi_nc_port_info_class_types.LinkStatusSrc.default[1],
        ['LinkStatus'] = ncsi_nc_port_info_class_types.LinkStatus.default[1],
        ['RxEnable'] = ncsi_nc_port_info_class_types.RxEnable.default[1],
        ['Type'] = ncsi_nc_port_info_class_types.Type.default[1],
        ['Slikscreen'] = ncsi_nc_port_info_class_types.Slikscreen.default[1],
        ['MgmtPortId'] = ncsi_nc_port_info_class_types.MgmtPortId.default[1]
    }
}

local DftNCSI = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/PrepareTest/DftNCSI/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NCSI = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Debug.Systems.NCSI'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Debug.Systems.NCSI'] = {
            ['SendCmdOverMCTP'] = {
                ['req'] = {
                    {['baseType'] = 'String', ['param'] = 'NodeId'}, {['baseType'] = 'U8', ['param'] = 'Command'},
                    {['baseType'] = 'String', ['param'] = 'Payload'}
                },
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'Data'}}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Debug/Systems/:SystemId/NCSI'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Debug.Systems.NCSI'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = ncsi_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PortUsageHistory = {
    ['table_name'] = 't_network_port_usage_history',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = port_usage_history_class_types.Id
        },
        ['NetworkAdapterId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = port_usage_history_class_types.NetworkAdapterId
        },
        ['PortID'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = port_usage_history_class_types.PortID
        },
        ['Time'] = {
            ['baseType'] = 'U32',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = port_usage_history_class_types.Time
        },
        ['Percent'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['validator'] = port_usage_history_class_types.Percent
        }
    },
    ['default_props'] = {
        ['Id'] = port_usage_history_class_types.Id.default[1],
        ['NetworkAdapterId'] = port_usage_history_class_types.NetworkAdapterId.default[1],
        ['PortID'] = port_usage_history_class_types.PortID.default[1],
        ['Time'] = port_usage_history_class_types.Time.default[1],
        ['Percent'] = port_usage_history_class_types.Percent.default[1]
    }
}

local NetWorkAdapterReset = {
    ['table_name'] = 't_network_adapter_reset',
    ['prop_configs'] = {
        ['PerId'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = net_work_adapter_reset_class_types.PerId
        },
        ['Key'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['validator'] = net_work_adapter_reset_class_types.Key
        },
        ['Value'] = {['baseType'] = 'String', ['validator'] = net_work_adapter_reset_class_types.Value}
    },
    ['default_props'] = {
        ['PerId'] = net_work_adapter_reset_class_types.PerId.default[1],
        ['Key'] = net_work_adapter_reset_class_types.Key.default[1],
        ['Value'] = net_work_adapter_reset_class_types.Value.default[1]
    }
}

local NetworkBridge = {
    ['table_name'] = 't_network_bridge',
    ['prop_configs'] = {['Ports'] = {['baseType'] = 'String[]', ['validator'] = network_bridge_class_types.Ports}},
    ['default_props'] = {['Ports'] = network_bridge_class_types.Ports.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkBridge'] = {
            ['Id'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_bridge_intf_types.Id
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_bridge_intf_types.Name
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/NetworkBridges/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkBridge'] = {
            ['property_defaults'] = {
                ['Id'] = network_bridge_intf_types.Id.default[1],
                ['Name'] = network_bridge_intf_types.Name.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_bridge_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NetworkBridgePort = {
    ['table_name'] = 't_network_bridge_port',
    ['prop_configs'] = {
        ['BridgeId'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = network_bridge_port_class_types.BridgeId
        },
        ['Id'] = {['baseType'] = 'U8', ['primaryKey'] = true, ['validator'] = network_bridge_port_class_types.Id},
        ['Name'] = {['baseType'] = 'String', ['validator'] = network_bridge_port_class_types.Name}
    },
    ['default_props'] = {
        ['BridgeId'] = network_bridge_port_class_types.BridgeId.default[1],
        ['Id'] = network_bridge_port_class_types.Id.default[1],
        ['Name'] = network_bridge_port_class_types.Name.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.ContainedPort'] = {
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = contained_port_intf_types.NodeId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkBridges/:ID/Ports/:PortID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.ContainedPort'] = {
            ['property_defaults'] = {['NodeId'] = contained_port_intf_types.NodeId.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = contained_port_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NetworkBonding = {
    ['table_name'] = 't_network_bonding',
    ['prop_configs'] = {['Ports'] = {['baseType'] = 'String[]', ['validator'] = network_bonding_class_types.Ports}},
    ['default_props'] = {['Ports'] = network_bonding_class_types.Ports.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.NetworkBonding'] = {
            ['Id'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_bonding_intf_types.Id
            },
            ['Name'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['primaryKey'] = true,
                ['validator'] = network_bonding_intf_types.Name
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/NetworkBondings/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.NetworkBonding'] = {
            ['property_defaults'] = {
                ['Id'] = network_bonding_intf_types.Id.default[1],
                ['Name'] = network_bonding_intf_types.Name.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = network_bonding_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local NetworkBondingPort = {
    ['table_name'] = 't_network_bonding_port',
    ['prop_configs'] = {
        ['TeamId'] = {
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = network_bonding_port_class_types.TeamId
        },
        ['Id'] = {['baseType'] = 'U8', ['primaryKey'] = true, ['validator'] = network_bonding_port_class_types.Id},
        ['Name'] = {['baseType'] = 'String', ['validator'] = network_bonding_port_class_types.Name}
    },
    ['default_props'] = {
        ['TeamId'] = network_bonding_port_class_types.TeamId.default[1],
        ['Id'] = network_bonding_port_class_types.Id.default[1],
        ['Name'] = network_bonding_port_class_types.Name.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.ContainedPort'] = {
            ['NodeId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = contained_port_intf_types.NodeId
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemID/NetworkBondings/:ID/Ports/:PortID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.ContainedPort'] = {
            ['property_defaults'] = {['NodeId'] = contained_port_intf_types.NodeId.default[1]},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = contained_port_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PRBSTest = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Managers.DiagnosticService.PRBSTest'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Managers.DiagnosticService.PRBSTest'] = {
            ['QueryInfo'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'TestObjects'}},
                ['rsp'] = {{['baseType'] = 'String', ['param'] = 'TestInfos'}},
                ['privilege'] = {'DiagnoseMgmt'}
            },
            ['Config'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'Configurations'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/OperationResults'},
                        ['param'] = 'OperationResults'
                    }
                },
                ['privilege'] = {'DiagnoseMgmt'}
            },
            ['ClearStatistics'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'TestObjects'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/OperationResults'},
                        ['param'] = 'OperationResults'
                    }
                },
                ['privilege'] = {'DiagnoseMgmt'}
            },
            ['Shutdown'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'TestObjects'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/OperationResults'},
                        ['param'] = 'OperationResults'
                    }
                },
                ['privilege'] = {'DiagnoseMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Managers/:Id/DiagnosticService/PRBSTest'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Managers.DiagnosticService.PRBSTest'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['methods'] = {
                    ['QueryInfo'] = privilege.DiagnoseMgmt,
                    ['Config'] = privilege.DiagnoseMgmt,
                    ['ClearStatistics'] = privilege.DiagnoseMgmt,
                    ['Shutdown'] = privilege.DiagnoseMgmt
                }
            },
            ['interface_types'] = prbs_test_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local ContaminationDetection = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'] = {
            ['GetResults'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'DetectorIds'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/Detections'}, ['param'] = 'Detections'}
                },
                ['privilege'] = {'DiagnoseMgmt'}
            },
            ['Initiate'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/Configuration'},
                        ['param'] = 'Configuration'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/OperationResults'},
                        ['param'] = 'OperationResults'
                    }
                },
                ['privilege'] = {'DiagnoseMgmt'}
            },
            ['Start'] = {
                ['req'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/Detectors'}, ['param'] = 'Detectors'}
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/OperationResults'},
                        ['param'] = 'OperationResults'
                    }
                },
                ['privilege'] = {'DiagnoseMgmt'}
            },
            ['Shutdown'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'DetectorIds'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/OperationResults'},
                        ['param'] = 'OperationResults'
                    }
                },
                ['privilege'] = {'DiagnoseMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Managers/:Id/DiagnosticService/ContaminationDetection'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['methods'] = {
                    ['GetResults'] = privilege.DiagnoseMgmt,
                    ['Initiate'] = privilege.DiagnoseMgmt,
                    ['Start'] = privilege.DiagnoseMgmt,
                    ['Shutdown'] = privilege.DiagnoseMgmt
                }
            },
            ['interface_types'] = contamination_detection_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local NCSIChannelMgmt = {
    ['table_name'] = 't_ncsi_channel_mgmt',
    ['prop_configs'] = {
        ['PCIePresence'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ncsi_channel_mgmt_class_types.PCIePresence
        },
        ['OCP1Presence'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ncsi_channel_mgmt_class_types.OCP1Presence
        },
        ['OCP2Presence'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ncsi_channel_mgmt_class_types.OCP2Presence
        },
        ['NCSIChannel'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['validator'] = ncsi_channel_mgmt_class_types.NCSIChannel
        },
        ['Id'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = ncsi_channel_mgmt_class_types.Id
        }
    },
    ['default_props'] = {
        ['PCIePresence'] = ncsi_channel_mgmt_class_types.PCIePresence.default[1],
        ['OCP1Presence'] = ncsi_channel_mgmt_class_types.OCP1Presence.default[1],
        ['OCP2Presence'] = ncsi_channel_mgmt_class_types.OCP2Presence.default[1],
        ['NCSIChannel'] = ncsi_channel_mgmt_class_types.NCSIChannel.default[1],
        ['Id'] = ncsi_channel_mgmt_class_types.Id.default[1]
    }
}

local NetworkAdaptersDebug = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Debug.Systems.NetworkAdapters'] = {},
        ['bmc.kepler.Debug.Systems.OpticalModules'] = {
            ['ExtremeValueLogIntervalSeconds'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = false,
                ['minimum'] = 15,
                ['maximum'] = 3600,
                ['default'] = 3600,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = optical_modules_intf_types.ExtremeValueLogIntervalSeconds
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {['bmc.kepler.Debug.Systems.NetworkAdapters'] = {['Dump'] = {['req'] = {}, ['rsp'] = {}}}},
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Debug/Systems/:SystemId/NetworkAdaptersDebug'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Debug.Systems.NetworkAdapters'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.DiagnoseMgmt},
            ['interface_types'] = debug_systems_network_adapters_intf_types
        },
        ['bmc.kepler.Debug.Systems.OpticalModules'] = {
            ['property_defaults'] = {['ExtremeValueLogIntervalSeconds'] = 3600},
            ['privileges'] = {
                ['path'] = privilege.DiagnoseMgmt,
                ['props'] = {
                    ['ExtremeValueLogIntervalSeconds'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.DiagnoseMgmt
                    }
                }
            },
            ['interface_types'] = optical_modules_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.DiagnoseMgmt},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('NetworkAdapters', NetworkAdapters):set_bus(bus)
    class('NetworkAdapter', NetworkAdapter):set_bus(bus)
    class('NetworkPort', NetworkPort):set_bus(bus)
    class('VLANs', VLANs):set_bus(bus)
    class('VLAN', VLAN):set_bus(bus)
    class('IPv4Address', IPv4Address):set_bus(bus)
    class('IPv6Address', IPv6Address):set_bus(bus)
    class('VLANIPv4Address', VLANIPv4Address):set_bus(bus)
    class('VLANIPv6Address', VLANIPv6Address):set_bus(bus)
    class('OpticalModule', OpticalModule):set_bus(bus)
    class('OpticalModuleChannel', OpticalModuleChannel):set_bus(bus)
    class('NcsiNCInfo', NcsiNCInfo):set_bus(bus)
    class('NcsiNCPortInfo', NcsiNCPortInfo):set_bus(bus)
    class('DftNCSI', DftNCSI):set_bus(bus)
    class('NCSI', NCSI):set_bus(bus)
    class('PortUsageHistory', PortUsageHistory):set_bus(bus)
    class('NetWorkAdapterReset', NetWorkAdapterReset):set_bus(bus)
    class('NetworkBridge', NetworkBridge):set_bus(bus)
    class('NetworkBridgePort', NetworkBridgePort):set_bus(bus)
    class('NetworkBonding', NetworkBonding):set_bus(bus)
    class('NetworkBondingPort', NetworkBondingPort):set_bus(bus)
    class('PRBSTest', PRBSTest):set_bus(bus)
    class('ContaminationDetection', ContaminationDetection):set_bus(bus)
    class('NCSIChannelMgmt', NCSIChannelMgmt):set_bus(bus)
    class('NetworkAdaptersDebug', NetworkAdaptersDebug):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersGetNetCardPortNum(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].GetNetCardPortNum = function(obj, ctx, ...)
        local req = kepler_systems_network_adapters_intf_types.GetNetCardPortNumReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.GetNetCardPortNumRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersGetPortSpeed(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].GetPortSpeed = function(obj, ctx, ...)
        local req = kepler_systems_network_adapters_intf_types.GetPortSpeedReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.GetPortSpeedRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersGetNetworkAdapterNum(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].GetNetworkAdapterNum = function(obj, ctx, ...)
        local req = kepler_systems_network_adapters_intf_types.GetNetworkAdapterNumReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.GetNetworkAdapterNumRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersGetNetworkPortNum(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].GetNetworkPortNum = function(obj, ctx, ...)
        local req = kepler_systems_network_adapters_intf_types.GetNetworkPortNumReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.GetNetworkPortNumRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersGetBandwidthHistory(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].GetBandwidthHistory = function(obj, ctx, ...)
        local req = kepler_systems_network_adapters_intf_types.GetBandwidthHistoryReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.GetBandwidthHistoryRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersClearBandwidthHistory(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].ClearBandwidthHistory = function(obj, ctx, ...)
        local req =
            kepler_systems_network_adapters_intf_types.ClearBandwidthHistoryReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.ClearBandwidthHistoryRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterskeplerSystemsNetworkAdaptersSetBandwidthThreshold(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkAdapters'].SetBandwidthThreshold = function(obj, ctx, ...)
        local req =
            kepler_systems_network_adapters_intf_types.SetBandwidthThresholdReq.new(...):validate(nil, nil, true)
        local rsp =
            kepler_systems_network_adapters_intf_types.SetBandwidthThresholdRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdaptersNetworkBondingsCreateBond(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkBondings'].CreateBond = function(obj, ctx, ...)
        local req = network_bondings_intf_types.CreateBondReq.new(...):validate(nil, nil, true)
        local rsp = network_bondings_intf_types.CreateBondRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdaptersNetworkBondingsDeleteBond(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkBondings'].DeleteBond = function(obj, ctx, ...)
        local req = network_bondings_intf_types.DeleteBondReq.new(...):validate(nil, nil, true)
        local rsp = network_bondings_intf_types.DeleteBondRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdaptersNetworkBondingsSetLinkMonitorPeriodMS(cb)
    class('NetworkAdapters')['bmc.kepler.Systems.NetworkBondings'].SetLinkMonitorPeriodMS = function(obj, ctx, ...)
        local req = network_bondings_intf_types.SetLinkMonitorPeriodMSReq.new(...):validate(nil, nil, true)
        local rsp = network_bondings_intf_types.SetLinkMonitorPeriodMSRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterNetworkAdapterStartRemovingDevice(cb)
    class('NetworkAdapter')['bmc.kepler.Systems.NetworkAdapter'].StartRemovingDevice = function(obj, ctx, ...)
        local req = network_adapter_intf_types.StartRemovingDeviceReq.new(...):validate(nil, nil, true)
        local rsp = network_adapter_intf_types.StartRemovingDeviceRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdapterNetworkAdapterDumpBlackBox(cb)
    class('NetworkAdapter')['bmc.kepler.Systems.NetworkAdapter'].DumpBlackBox = function(obj, ctx, ...)
        local req = network_adapter_intf_types.DumpBlackBoxReq.new(...):validate(nil, nil, true)
        local rsp = network_adapter_intf_types.DumpBlackBoxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkPortNetworkPortConfigure(cb)
    class('NetworkPort')['bmc.kepler.Systems.NetworkPort'].Configure = function(obj, ctx, ...)
        local req = network_port_intf_types.ConfigureReq.new(...):validate(nil, nil, true)
        local rsp = network_port_intf_types.ConfigureRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVLANsVLANsCreateVLAN(cb)
    class('VLANs')['bmc.kepler.Systems.NetworkPort.VLANs'].CreateVLAN = function(obj, ctx, ...)
        local req = vla_ns_intf_types.CreateVLANReq.new(...):validate(nil, nil, true)
        local rsp = vla_ns_intf_types.CreateVLANRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVLANVLANConfigureVLAN(cb)
    class('VLAN')['bmc.kepler.Systems.NetworkPort.VLAN'].ConfigureVLAN = function(obj, ctx, ...)
        local req = vlan_intf_types.ConfigureVLANReq.new(...):validate(nil, nil, true)
        local rsp = vlan_intf_types.ConfigureVLANRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplVLANVLANDeleteVLAN(cb)
    class('VLAN')['bmc.kepler.Systems.NetworkPort.VLAN'].DeleteVLAN = function(obj, ctx, ...)
        local req = vlan_intf_types.DeleteVLANReq.new(...):validate(nil, nil, true)
        local rsp = vlan_intf_types.DeleteVLANRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOpticalModuleMetricGetData(cb)
    class('OpticalModule')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOpticalModuleMetricGetItems(cb)
    class('OpticalModule')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOpticalModuleMetricSynDataAcquisitionEnable(cb)
    class('OpticalModule')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftNCSIManufactureStart(cb)
    class('DftNCSI')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftNCSIManufactureStop(cb)
    class('DftNCSI')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftNCSIManufactureGetResult(cb)
    class('DftNCSI')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNCSINCSISendCmdOverMCTP(cb)
    class('NCSI')['bmc.kepler.Debug.Systems.NCSI'].SendCmdOverMCTP = function(obj, ctx, ...)
        local req = ncsi_intf_types.SendCmdOverMCTPReq.new(...):validate(nil, nil, true)
        local rsp = ncsi_intf_types.SendCmdOverMCTPRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPRBSTestPRBSTestQueryInfo(cb)
    class('PRBSTest')['bmc.kepler.Managers.DiagnosticService.PRBSTest'].QueryInfo = function(obj, ctx, ...)
        local req = prbs_test_intf_types.QueryInfoReq.new(...):validate(nil, nil, true)
        local rsp = prbs_test_intf_types.QueryInfoRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPRBSTestPRBSTestConfig(cb)
    class('PRBSTest')['bmc.kepler.Managers.DiagnosticService.PRBSTest'].Config = function(obj, ctx, ...)
        local req = prbs_test_intf_types.ConfigReq.new(...):validate(nil, nil, true)
        local rsp = prbs_test_intf_types.ConfigRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPRBSTestPRBSTestClearStatistics(cb)
    class('PRBSTest')['bmc.kepler.Managers.DiagnosticService.PRBSTest'].ClearStatistics = function(obj, ctx, ...)
        local req = prbs_test_intf_types.ClearStatisticsReq.new(...):validate(nil, nil, true)
        local rsp = prbs_test_intf_types.ClearStatisticsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPRBSTestPRBSTestShutdown(cb)
    class('PRBSTest')['bmc.kepler.Managers.DiagnosticService.PRBSTest'].Shutdown = function(obj, ctx, ...)
        local req = prbs_test_intf_types.ShutdownReq.new(...):validate(nil, nil, true)
        local rsp = prbs_test_intf_types.ShutdownRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplContaminationDetectionContaminationDetectionGetResults(cb)
    class('ContaminationDetection')['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'].GetResults =
        function(obj, ctx, ...)
            local req = contamination_detection_intf_types.GetResultsReq.new(...):validate(nil, nil, true)
            local rsp = contamination_detection_intf_types.GetResultsRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplContaminationDetectionContaminationDetectionInitiate(cb)
    class('ContaminationDetection')['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'].Initiate = function(
        obj, ctx, ...)
        local req = contamination_detection_intf_types.InitiateReq.new(...):validate(nil, nil, true)
        local rsp = contamination_detection_intf_types.InitiateRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplContaminationDetectionContaminationDetectionStart(cb)
    class('ContaminationDetection')['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'].Start = function(
        obj, ctx, ...)
        local req = contamination_detection_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = contamination_detection_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplContaminationDetectionContaminationDetectionShutdown(cb)
    class('ContaminationDetection')['bmc.kepler.Managers.DiagnosticService.ContaminationDetection'].Shutdown = function(
        obj, ctx, ...)
        local req = contamination_detection_intf_types.ShutdownReq.new(...):validate(nil, nil, true)
        local rsp = contamination_detection_intf_types.ShutdownRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplNetworkAdaptersDebugDebugSystemsNetworkAdaptersDump(cb)
    class('NetworkAdaptersDebug')['bmc.kepler.Debug.Systems.NetworkAdapters'].Dump = function(obj, ctx, ...)
        local req = debug_systems_network_adapters_intf_types.DumpReq.new(...):validate(nil, nil, true)
        local rsp = debug_systems_network_adapters_intf_types.DumpRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
