*openUBMC 网卡南向设备驱动适配增强详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware_sig</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>范滔+Tao_A</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025.11.13</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
当前网卡已适配了南向驱动机制，但其中有些机制仍然缺失，需要补全，保证后续网卡按南向驱动机制交付出来后的功能和当前CSR1.0版本没有任何区别

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
网卡南向驱动适配特性增强包括下面几点：<br>
1、实现从北向设置lldp的开关；

2、驱动层lldp初始化功能补齐；

3、完成LLDP整个功能需要下沉设备树，网卡lldp over mctp走mctp vdpci(0x7e)通道；

4、网卡热插拔时网卡对象卸载相关功能补齐；

5、兼容EEPROM对象Frudata和设备驱动访问不一致场景；

6、BMA获取信息的能力补齐；

7、部件驱动实现的信息获取和解析流程、部件功能，需要和原有组件业务对比分析，是否存在缺失或者数据解析错误；

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
1、redfish设置lldp使能开启/关闭；<br>
2、redfish查询lldp报文信息，网页查询网卡连接视图；<br>
3、网卡热插拔后，网卡相关资源树对象卸载，无法查到；<br>
4、BMA获取的信息用于传感器显示、告警等；<br>
5、查询网卡eeprom信息；

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 完成LLDP整个功能需要下沉设备树 | 网卡初始化时完成lldp over mctp 通道使能并解析收到的lldp报文 |
| 2 | BMA获取信息的能力补齐 | 某些不支持带外功能的网卡，从BMA获取的数据需要同步更新到设备树对象上 |
# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
1、lldp接收并解析报文功能：<br>
初始化时，如果网卡支持lldp over mctp功能则创建lldp协议（0x7e）对应的endpoint，监听该endpoint的dbus消息，消息里即为lldp报文的原始二进制数据，收到消息后按照lldp报文协议解析报文，将解析后的数据更新到对应网口的资源树上，然后设置每个网口的lldp over mctp使能为开启，开启后才能接收lldp报文，lldp报文内容主要包括：ChassisId，ChassisIdSubtype,PortId,PortIdSubtype,SystemName,ManagementVlanId;<br>
2、热插拔对象卸载：<br>
网卡拔掉后，Connctor连接器变为不在位，设备管理框架将设备树对象卸载，应用层监听到卸载信号后找到对应的资源树对象，将资源树对象卸载；<br>
3、BMA获取信息的能力补齐：<br>
当BMA获取到对应资源树对象的信息后，需要找到该资源树对象对应的设备树对象path，再根据path和interface获取到对应的设备树对象，将信息同步更新到设备树对象上；
#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
**LLDP 报文处理流程**
```mermaid
sequenceDiagram
    participant Init as 初始化流程
    participant Check as 能力检测
    participant MCTP as MCTP 服务
    participant DBus as DBus 消息
    participant Parser as LLDP 解析器
    participant Resource as 网口资源树

    Init->>Check: 启动阶段检查网卡能力
    Check-->>Init: 不支持则跳过
    Check->>MCTP: 支持则创建协议 0x7E Endpoint
    MCTP->>DBus: 监听 Endpoint 消息
    DBus->>Parser: 传递原始 LLDP 报文
    Parser->>Resource: 解析报文并更新资源树
    Resource->>MCTP: 设置网口 LLDP over MCTP 接收开关
```

**热插拔对象卸载流程**
```mermaid
sequenceDiagram
    participant HW as 连接器
    participant DeviceMgr as 设备管理框架
    participant App as 应用层
    participant Resource as 资源树

    HW-->>DeviceMgr: Connector 状态变为不在位
    DeviceMgr->>DeviceMgr: 卸载对应设备树对象
    DeviceMgr-->>App: 发布设备卸载事件
    App->>Resource: 找到对应资源树对象并卸载
    Resource->>Resource: 清理关联数据
```

**BMA 信息同步流程**
```mermaid
sequenceDiagram
    participant BMA as BMA 客户端
    participant Resource as 资源树
    participant MGMT as 管理对象
    participant Device as 设备树对象

    BMA->>Resource: 获取资源树对象信息
    Resource->>MGMT: 上报对象标识
    MGMT->>MGMT: 根据映射定位 path 与 interface
    MGMT->>Device: 访问设备树对象并完成写入
    Device->>Device: 更新设备树对象数据
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
NA
### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及
### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
不涉及
### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持设置查询网口LLDP Tx使能功能 | NA | NA | NA | NA | NA | NA | √ |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
之前redfish设置LLDP使能实现错误，发送了错误的命令字，当前纠正为正确的命令字
### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 | 前置条件 | 场景 | 预期 |
| ---- | ---- | ---- |  ---- |
| 1 | 网卡支持南向驱动，网卡正常，网口接交换机| redfish查询LLDP获取的信息 | redfish能查询到网口LLDP报文信息 |
| 2 | 网卡支持南向驱动，网卡正常，网口接交换机| web查询LLDP获取的信息 | web页面网口连接视图能查到信息 |
| 3 | 网卡支持南向驱动，网卡正常，网口接交换机 | 网线从交换机某个端口插到另一个端口 | 查询到的信息随着端口变化 |
| 4 | 网卡支持南向驱动 | 模拟网卡拔掉 | 查看应用层资源树，网卡相关对象被卸载 |
| 5 | 网卡支持南向驱动，网卡支持eeprom | cli命令查询网卡fru信息 | 能查到eeprom中的信息 |
## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
不涉及
### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
不涉及
### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
redfish接口、cli接口、web页面
### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及
### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及
### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 开启lldp over mctp使能 | 开启使能时，ncsi的endpoint还没创建成功 | 使能失败，无法接收lldp报文 | 重试5次，每次等待1分钟 | --- | --- | --- | --- |
### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 正常权限 |  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 设置有操作日志 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |  |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1 网卡南向设备驱动适配增强
### 3.1.1 功能实现设计
N/A
### 3.1.2 功能详细设计
1、lldp接收并解析报文功能：<br>
初始化时，如果网卡支持lldp over mctp功能则创建lldp协议（0x7e）对应的endpoint，监听该endpoint的dbus消息，消息里即为lldp报文的原始二进制数据，收到消息后按照lldp报文协议解析报文，将解析后的数据更新到对应网口的资源树上，然后设置每个网口的lldp over mctp使能为开启，开启后才能接收lldp报文，lldp报文内容主要包括：ChassisId，ChassisIdSubtype,PortId,PortIdSubtype,SystemName,ManagementVlanId;<br>
2、热插拔对象卸载：<br>
网卡拔掉后，Connctor连接器变为不在位，设备管理框架将设备树对象卸载，应用层监听到卸载信号后找到对应的资源树对象，将资源树对象卸载；<br>
3、BMA获取信息的能力补齐：<br>
当BMA获取到对应资源树对象的信息后，需要找到该资源树对象对应的设备树对象path，再根据path和interface获取到对应的设备树对象，将信息同步更新到设备树对象上；
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| network_adapter | UT | 验证支持 LLDP over MCTP 的网卡在初始化时创建 Endpoint 并监听报文 | test_lldp_endpoint_creation | 打桩返回网卡支持 LLDP over MCTP | 调用初始化流程 | 成功创建协议 0x7E Endpoint 并注册消息回调 |
| network_adapter | UT | 验证网卡不支持 LLDP over MCTP 时跳过创建流程 | test_lldp_endpoint_skip | 打桩返回网卡不支持 LLDP over MCTP | 调用初始化流程 | 不创建 Endpoint，记录提示日志 |
| network_adapter | UT | 验证 LLDP 报文接收、解析正确 | test_parse_lldp_packet | 模拟准备lldp报文数据 | 调用解析函数 | 解析出的内容符合预期 |
| device_manager | UT | 验证连接器下线时设备树对象卸载并通知应用层 | test_hotplug_device_unload | 构造连接器状态变化事件 | 模拟 connector 变为 not_present | 设备树对象卸载，事件发送到应用层 |
| network_adapter | UT | 验证应用层监听卸载事件后清理资源树对象 | test_resource_tree_unmount | 打桩发布设备卸载事件 | 监听事件并执行卸载处理 | 对应资源树对象被移除且关联信息清理 |
| mgmt_service | UT | 验证BMA更新信息后，设备树对象的属性也对应更新 | test_bma_sync_property | 准备设备树对象 | 调用更新流程 | 设备树对象属性更新成功 |

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
N/A