*openUBMC 支持设置/获取Hi182x网卡主动发送LLDP报文使能命令字详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware_sig</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>范滔+Tao_A</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025.10.27</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
网卡的LLDP Tx使能是网卡的一个配置项，开启后网卡才能对外发送LLDP报文，BMC侧可以通过协议获取每个网口的LLDP Tx使能状态或者手动设置每个网口的LLDP Tx使能，这些信息由BMC提供redfish接口查询和设置，达到管理网卡LLDP Tx功能。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
支持设置/获取Hi182x网卡主动发送LLDP报文使能命令字

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
1、北向redfish接口支持设置LldpEnabled属性，对应后端实现设置命令字;

2、支持获取使能属性，若带内使能被设置，带外需要更新状态，对应后端实现获取命令字，北向redfish接口可查询;

3、主动发送LLDP报文使能开启后，能正常收到报文并解析更新属性；

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 获取网口的LLDP Tx使能 | BMC获取到网口的LLDP Tx使能后保存起来，redfish接口可以查到 |
| 2 | 设置网口的LLDP Tx使能 | BMC可以通过redfish接口设置每个网口的LLDP Tx使能 |
# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
设置流程：<br>
1、用户调用redfish接口发送请求设置网口的LLDPEnabled属性，network_adapter组件监听网口LLDPEnabled属性变更；<br>
2、network_adapter处理设置请求，判断当前网口是否走设备树流程；<br>
3、如果是设备树网卡的话，则应用层network_adapter再调用设备树层提供的RPC方法，去设置LLDP Tx使能，如果是非设备树网卡，则直接在应用层network_adapter处理；<br>
4、两种情况最终都是先判断网卡是否支持LLDP，不支持则报错，并返回错误给接口层，若支持则走ncsi_huawei协议去给网卡发送命令开启或关闭LLDP Tx使能，命令设置成功，接口返回成功，失败则返回失败；<br>
获取流程：<br>
network_adapter组件启动周期任务给网卡发送命令获取每个网口的LLDP Tx使能，更新网口LLDPEnabled资源树

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

**设置LLDP Tx使能流程：**

```mermaid
sequenceDiagram
    participant User as 用户
    participant Redfish as Redfish接口
    participant NetAdapter as network_adapter<br/>(应用层)
    participant DevTree as component_drivers<br/>(设备树层)
    participant NCSI as ncsi_over_mctp_huawei<br/>(协议库)
    participant NIC as Hi182x网卡

    User->>Redfish: PATCH LLDPEnabled=true/false
    Redfish->>NetAdapter: 设置LLDPEnabled属性
    NetAdapter->>NetAdapter: 监听属性变更
    NetAdapter->>NetAdapter: 判断是否为设备树网卡
    
    alt 设备树网卡
        NetAdapter->>DevTree: 调用RPC设置LLDP使能
        DevTree->>DevTree: 判断网卡是否支持LLDP
        alt 不支持LLDP
            DevTree-->>NetAdapter: 返回错误
            NetAdapter-->>Redfish: 返回错误
            Redfish-->>User: 返回失败响应
        else 支持LLDP
            DevTree->>NCSI: 设置LLDP Tx使能
            NCSI->>NIC: 发送NCSI命令字<br/>(设置LLDP Tx使能)
            NIC-->>NCSI: 返回响应
            NCSI-->>DevTree: 返回结果
            alt 设置成功
                DevTree->>DevTree: 更新LLDPEnabled属性
                DevTree-->>NetAdapter: 返回成功
                NetAdapter-->>Redfish: 返回成功
                Redfish-->>User: 返回成功响应
            else 设置失败
                DevTree-->>NetAdapter: 返回失败
                NetAdapter-->>Redfish: 返回错误
                Redfish-->>User: 返回失败响应
            end
        end
    else 非设备树网卡
        NetAdapter->>NetAdapter: 判断网卡是否支持LLDP
        alt 不支持LLDP
            NetAdapter-->>Redfish: 返回错误
            Redfish-->>User: 返回失败响应
        else 支持LLDP
            NetAdapter->>NCSI: 设置LLDP Tx使能
            NCSI->>NIC: 发送NCSI命令字
            NIC-->>NCSI: 返回响应
            NCSI-->>NetAdapter: 返回结果
            alt 设置成功
                NetAdapter->>NetAdapter: 更新LLDPEnabled属性
                NetAdapter-->>Redfish: 返回成功
                Redfish-->>User: 返回成功响应
            else 设置失败
                NetAdapter-->>Redfish: 返回错误
                Redfish-->>User: 返回失败响应
            end
        end
    end
```

**获取LLDP Tx使能流程：**

**设备树网卡获取流程：**

```mermaid
sequenceDiagram
    participant Timer1 as 设备树定时器
    participant DevTree as component_drivers<br/>(设备树层)
    participant NCSI as ncsi_over_mctp_huawei<br/>(协议库)
    participant NIC as Hi182x网卡
    participant NetAdapter as network_adapter<br/>(应用层)

    Timer1->>DevTree: 触发周期任务
    DevTree->>DevTree: 遍历所有网口
    
    loop 每个网口
        DevTree->>NCSI: 获取LLDP Tx使能
        NCSI->>NIC: 发送NCSI命令字<br/>(获取LLDP Tx使能)
        NIC-->>NCSI: 返回LLDP Tx使能状态
        NCSI-->>DevTree: 返回enabled值
        DevTree->>DevTree: 更新LLDPEnabled属性
        DevTree->>NetAdapter: 通知属性变化
        NetAdapter->>NetAdapter: 监听到属性变化
        NetAdapter->>NetAdapter: 更新应用层资源树属性
    end
```

**非设备树网卡获取流程：**

```mermaid
sequenceDiagram
    participant Timer2 as 应用层定时器
    participant NetAdapter as network_adapter<br/>(应用层)
    participant NCSI as ncsi_over_mctp_huawei<br/>(协议库)
    participant NIC as 网卡

    Timer2->>NetAdapter: 触发周期任务
    NetAdapter->>NetAdapter: 遍历所有网口
    
    loop 每个网口
        NetAdapter->>NCSI: 获取LLDP Tx使能
        NCSI->>NIC: 发送NCSI命令字
        NIC-->>NCSI: 返回状态
        NCSI-->>NetAdapter: 返回enabled值
        NetAdapter->>NetAdapter: 更新LLDPEnabled属性
    end
```


#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

**系统启动流程：**

```mermaid
graph TD
    A[系统启动] --> B[component_drivers启动]
    A --> C[network_adapter启动]
    
    B --> D[初始化Hi182x网卡驱动]
    D --> E[启动设备树层定时器]
    E --> F[周期获取LLDP状态]
    
    C --> G[初始化网口管理模块]
    G --> H[注册属性变更监听器]
    H --> I{判断网卡类型}
    
    I -->|设备树网卡| J[监听设备树属性变化]
    I -->|非设备树网卡| K[启动应用层定时器]
    K --> L[周期获取LLDP状态]
```

**运行期交互架构：**

```mermaid
graph LR
    A[Redfish接口层] <--> B[network_adapter应用层]
    B <--> C{网卡类型判断}
    
    C -->|设备树网卡| D[component_drivers设备树层]
    C -->|非设备树网卡| E[NCSI协议库]
    
    D <--> E
    E <--> F[Hi182x网卡硬件]
    
    style A fill:#e1f5ff
    style B fill:#fff4e1
    style D fill:#e8f5e9
    style E fill:#fce4ec
    style F fill:#f3e5f5
```

**LLDP使能设置运行流程：**

```mermaid
flowchart TD
    Start([用户设置LLDP使能]) --> A{网卡类型?}
    
    A -->|设备树网卡| B[应用层接收请求]
    A -->|非设备树网卡| C[应用层接收请求]
    
    B --> D{网卡支持LLDP?}
    C --> E{网卡支持LLDP?}
    
    D -->|否| F1[返回错误]
    D -->|是| G[调用设备树RPC]
    
    E -->|否| F2[返回错误]
    E -->|是| H[直接调用NCSI协议]
    
    G --> I[设备树层发送NCSI命令]
    H --> J[发送NCSI命令]
    
    I --> K{设置成功?}
    J --> L{设置成功?}
    
    K -->|是| M1[更新设备树属性]
    K -->|否| N1[返回失败]
    
    L -->|是| M2[更新应用层属性]
    L -->|否| N2[返回失败]
    
    M1 --> O1[返回成功]
    M2 --> O2[返回成功]
    
    F1 --> End([结束])
    F2 --> End
    N1 --> End
    N2 --> End
    O1 --> End
    O2 --> End
    
    style Start fill:#e3f2fd
    style End fill:#e3f2fd
    style F1 fill:#ffcdd2
    style F2 fill:#ffcdd2
    style N1 fill:#ffcdd2
    style N2 fill:#ffcdd2
    style O1 fill:#c8e6c9
    style O2 fill:#c8e6c9
```

**LLDP使能获取运行流程：**

```mermaid
flowchart TD
    Start1([定时器触发]) --> A1{网卡类型?}
    
    A1 -->|设备树网卡| B1[设备树层定时器]
    A1 -->|非设备树网卡| C1[应用层定时器]
    
    B1 --> D1[设备树层获取LLDP状态]
    C1 --> E1[应用层获取LLDP状态]
    
    D1 --> F1[更新设备树属性]
    E1 --> G1[更新应用层属性]
    
    F1 --> H1[触发属性变更事件]
    H1 --> I1[应用层监听到变化]
    I1 --> J1[同步更新应用层属性]
    
    J1 --> End1([等待下次触发])
    G1 --> End1
    
    style Start1 fill:#e3f2fd
    style End1 fill:#e3f2fd
    style F1 fill:#fff9c4
    style G1 fill:#fff9c4
    style J1 fill:#c8e6c9
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及
### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
不涉及
### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持设置查询网口LLDP Tx使能功能 | NA | NA | NA | NA | NA | NA | √ |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
之前redfish设置LLDP使能实现错误，发送了错误的命令字，当前纠正为正确的命令字
### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 | 场景 | 预期 |
| ---- | ---- | ---- |
| 1 | 网卡正常，redfish设置LLDP Tx使能开启/关闭 | 设置成功，带内查询为LLDP Tx使能为开启/关闭 |
| 2 | 网卡正常，网口接交换机，redfish查询LLDP获取的信息 | redfish能查询到网口LLDP报文信息 |
| 3 | 网卡下电，redfish设置LLDP Tx使能开启/关闭 | 设置失败，接口报错 |
| 4 | redfish设置LLDP Tx使能开启/关闭成功后，os上下电 | 配置保留 |
| 5 | 不支持LLDP的网卡，redfish设置LLDP Tx使能开启/关闭 | 设置失败，接口报错 |
## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
不涉及
### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
不涉及
### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
设置后可通过带内hinic命令查询LLDP Tx使能状态
### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及
### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及
### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 数据获取异常状态 |给网卡发送命令，网卡异常响应超时或报文异常|设置结果未知|一般|redfish接口设置报错||||
### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 正常权限 |  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 设置有操作日志 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |  |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1 支持设置/获取Hi182x网卡主动发送LLDP报文使能命令字
### 3.1.1 功能实现设计
北向接口调用redifsh请求，network_adapter处理请求给网卡下发相关命令,使能或关闭网口的LLDP tx；<br>
network_adapter循环获取LLDP tx使能状态并更新资源树属性；
### 3.1.2 功能详细设计
设置流程:<br>
1、用户调用redfish接口发送请求设置网口的LLDPEnabled属性，network_adapter组件监听网口LLDPEnabled属性变更；<br>
2、network_adapter处理设置请求，判断当前网口是否走设备树流程；<br>
3、如果是设备树网卡的话，则应用层network_adapter再调用设备树层提供的RPC方法，去设置LLDP Tx使能，如果是非设备树网卡，则直接在应用层network_adapter处理；<br>
4、两种情况最终都是先判断网卡是否支持LLDP，不支持则报错，并返回错误给接口层，若支持则走ncsi_huawei协议去给网卡发送命令开启或关闭LLDP Tx使能，命令设置成功，接口返回成功，失败则返回失败；<br>
获取流程：<br>
network_adapter组件启动周期任务给网卡发送命令获取每个网口的LLDP Tx使能，更新网口LLDPEnabled资源树
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| network_adapter | UT | 测试device_path为nil时的错误处理 | test_set_lldp_tx_enabled_device_path_nil | ORM对象device_path为nil | 修改LLDPEnabled属性 | 记录失败日志并抛出异常 |
| network_adapter | UT | 测试获取device_obj失败时的错误处理 | test_set_lldp_tx_enabled_device_obj_nil | 打桩get_device_obj返回nil | 修改LLDPEnabled属性 | 记录失败日志并抛出异常 |
| network_adapter | UT | 测试调用SetLLDPTxEnable方法抛出异常时的错误处理 | test_set_lldp_tx_enabled_call_method_error | 打桩call_method抛出异常 | 修改LLDPEnabled属性 | 记录失败日志并抛出异常 |
| network_adapter | UT | 测试SetLLDPTxEnable方法返回false时的错误处理 | test_set_lldp_tx_enabled_call_method_return_false | 打桩call_method返回false | 修改LLDPEnabled属性 | 记录失败日志并抛出异常 |
| network_adapter | UT | 测试成功启用LLDP TX | test_set_lldp_tx_enabled_success_enable | 打桩正常响应 | 修改LLDPEnabled为true | 调用SetLLDPTxEnable成功并记录成功日志 |
| network_adapter | UT | 测试成功禁用LLDP TX | test_set_lldp_tx_enabled_success_disable | 打桩正常响应 | 修改LLDPEnabled为false | 调用SetLLDPTxEnable成功并记录成功日志 |
| network_adapter | UT | 测试有NetworkPort接口时注册回调 | test_register_callback_with_interface | ORM对象有NetworkPort接口 | 调用register_property_changed_callback | 成功注册两个信号连接 |
| network_adapter | UT | 测试无NetworkPort接口时注册回调 | test_register_callback_without_interface | ORM对象无NetworkPort接口 | 调用register_property_changed_callback | 只注册on_property_changed信号 |
#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
N/A