*openUBMC 支持自研网卡标卡告警详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware_sig</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>许烁+xushuo25</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025.11.09</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->

支持网卡标卡PCIE卡电源故障08000041告警

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->

1、复用已有0x08000041告警码：

2、新增属性关联BIOS启动状态并在CSR中可引用；

3、CSR新增实现读取网卡GPIO管脚获取网卡电源状态；

4、VPD仓新增0x08000041告警条件关联BIOS启动状态和网卡电源状态，在BIOS启动完成后才认为获取的网卡电源状态是有效值；

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->

1.网管、运维人员通过BMC告警上报可以发现网卡电源故障

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->

| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 网卡电源状态故障告警 | 自研网卡标卡PCIE卡电源故障时触发08000041告警 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

Hi182x网卡SR新增对象读取网卡GPIO管脚状态获取电源状态，网卡对象新增私有属性同步网卡电源状态，资源树新增网卡电源健康状态属性PowerStatus，在业务侧依据网卡电源状态和BIOS状态更新，依据PowerStatus的值判断是否触发告警

新增资源协作接口属性PowerStatus评审链接：https://discuss.openubmc.cn/t/topic/3137

NetworkAdapter新增私有属性PowerScanner评审链接：https://discuss.openubmc.cn/t/topic/3370

### 2.1.1 方案详细设计

#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

1.Hi182x网卡SR新增私有对象Scanner_PowerGood对象，用于获取网卡GPIO管脚状态，

2.NetworkAdapter对象新增一个私有属性PowerScanner，该属性值同步Scanner_PowerGood对象获取的网卡电源状态值，

3.资源树新增网卡电源健康状态属性PowerStatus

3.network_adapter组件业务侧监听BIOS状态，根据BIOS状态值和PowerScanner值更新PowerStatus的值

4.Event组件获取资源树PowerStatus的值，根据该值判断是否触发告警。

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->

```mermaid
graph TD
    subgraph 框架加载VPD
        A[Scanner_PowerGood对象读取GPIO管脚状态] -->|同步更新| B[NetworkAdapter对象PowerScanner属性]
    end

    subgraph network_adapter组件
        C[register_listen_callback函数] -->|注册监听| D[监听BIOS和GPIO管脚电源状态]
        D -->|调用| E[update_power_status函数]
    end

    subgraph mdb_interface组件
        F[PowerStatus协作接口属性]
    end

    subgraph Event组件
        G[事件监控器] -->|读取PowerStatus| H[状态分析判断]
        H -->|异常状态| I[触发告警]
        H -->|正常状态| J[不触发告警]
    end

    B -->|提供GPIO状态值| D
    E -->|更新| F
    F -->|状态值变化通知| G
    
    %% 样式定义
    style A fill:#e1f5fe
    style B fill:#e1f5fe
    style C fill:#f3e5f5
    style D fill:#f3e5f5
    style E fill:#f3e5f5
    style F fill:#e8f5e8
    style G fill:#fff3e0
    style H fill:#fff3e0
    style I fill:#ffebee
    style J fill:#e8f5e8
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

```mermaid
sequenceDiagram
    participant VPD as 框架加载VPD
    participant NetworkAdapter as network_adapter组件
    participant MDB as mdb_interface组件
    participant Event as Event组件

    Note over VPD: Scanner_PowerGood读取GPIO状态
    VPD->>NetworkAdapter: 同步更新PowerScanner属性
    
    Note over NetworkAdapter: BIOS状态和GPIO状态监听回调触发
    NetworkAdapter->>NetworkAdapter: update_power_status函数执行
    NetworkAdapter->>MDB: 更新PowerStatus协作接口属性
    
    MDB->>Event: 状态值变化通知
    Event->>Event: 状态分析判断
    
    alt 异常状态
        Event->>Event: 触发告警
    else 正常状态
        Event->>Event: 不触发告警
    end
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->

不涉及

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->

不涉及新增依赖

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->

不涉及

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->

不涉及

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->

不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->

不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->

不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->

复用已有的告警码：0x08000041

告警事件：PCIeCardPwrFail

告警码：0x08000041

告警KeyId：PcieCard.PCIeCardPwrFail

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->

不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->

| 用例编号 | 描述 | 用例步骤 | 用例预期 |
| ---- | ---- | ------------------- | ----------------------- |
| 1 | OS上电，模拟电源故障触发告警 | 1.OS上电，设置Scanner_PowerGood.Value为0，查看告警信息和网卡PowerStatus | 1.可以正常触发PCIE卡电源故障08000041告警，网卡PowerStatus值为0 |
| 2 | OS上电，模拟电源故障告警消除 | 1.OS上电，设置Scanner_PowerGood.Value为0，查看告警信息和网卡PowerStatus 2.OS上电状态下，设置Scanner_PowerGood.Value为1，查看告警信息和网卡PowerStatus | 1.首先正常触发PCIE卡电源故障08000041告警，网卡PowerStatus值为0 2.PCIE卡电源故障08000041告警正常消除，且网卡PowerStatus值为1 |
| 3 | OS上电，设置异常值 | 1.OS上电，设置Scanner_PowerGood.Value为异常值（非0,1或255），查看告警信息和网卡PowerStatus以及日志 | 1.无电源故障告警，且网卡PowerStatus值为255，日志记录异常值 |
| 4 | OS下电，电源故障告警无法产生 | 1.OS下电，设置Scanner_PowerGood.Value为0，查看告警信息和网卡PowerStatus | 1.不产生PCIE卡电源故障08000041告警且网卡PowerStatus状态值为255 |
| 5 | OS下电，模拟电源故障，重新上电 | 1.OS下电，设置Scanner_PowerGood.Value为0，查看告警信息和网卡PowerStatus 2.OS重新上电，查看告警信息和网卡PowerStatus值 | 1.不产生PCIE卡电源故障08000041告警且网卡PowerStatus状态值为255 2.OS上电后，网卡电源故障告警重新产生且PowerStatus为0 |
| 6 | OS下电，电源故障告警消除 | 1.OS上电，设置Scanner_PowerGood.Value为0，查看告警信息和网卡PowerStatus 2.OS下电，查看告警信息和网卡PowerStatus | 1.正常触发PCIE卡电源故障08000041告警且网卡PowerStatus状态值为0 2.PCIE卡电源故障08000041告警消失且网卡PowerStatus为255 |
| 7 | OS下电，设置异常值 | 1.OS下电，设置Scanner_PowerGood.Value为异常值（非0,1或255），查看告警信息和网卡PowerStatus | 1.无电源故障告警，且网卡PowerStatus值为255，日志记录异常值 |
| 8 | 模拟网卡电源故障状态下，OS重启 | 1.在网卡电源故障状态下执行OS重启 2.重启完成后查看告警信息 | 1.网卡电源故障告警先消失，随着OS启动完成后再次产生告警 |
| 9 | OS重启，不产生误告警 | 1.OS重启，查看告警信息 | 1.没有误告警信息 |
| 10 | BMC重启，不产生误告警 | 1.BMC重启，查看告警信息 | 1.没有误告警信息 |
| 11 | 环境AC，不产生误告警 | 1.环境AC，查看告警信息 | 1.没有误告警信息 |

## 2.2 非功能质量属性设计

### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->

不涉及

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->

不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->

可通过资源树设置网卡电源健康状态的值触发网卡电源故障告警进行验证。

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->

涉及Hi182x网卡新增网卡电源健康状态属性PowerStatus

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

不涉及

### 2.2.6 可靠性分析

| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 硬件状态获取失败 | GPIO管脚状态获取失败 | 高 | 高 | 设置默认值255 | 需实现 |  |  |
| 2 | AC场景 |无误告警|不影响||||||
| 3 | BMC场景 |无误告警|不影响||||||
| 4 | 服务重启 |无误告警|不影响||||||

### 2.2.7 安全性分析

| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） |  不涉及|  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 记录维护日志 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |  |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 |不涉及  |  |

# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->

## 3.1【功能编号】支持自研网卡标卡电源故障告警功能实现

### 3.1.1 功能实现设计

Hi182x网卡新增一个PowerStatus值，表示网卡电源状态，根据BIOS状态和GPIO网卡管脚状态确认网卡电源状态值，告警触发条件关联PowerStatus值，判断是否触发电源故障告警。

### 3.1.2 功能详细设计

1.在配置了PCA9555_PCIE对象的Hi182x网卡SR新增对象Scanner_PowerGood对象，用于获取网卡GPIO管脚状态，

2.在对应网卡CSR文件的NetworkAdapter对象新增一个私有属性PowerScanner，该属性值同步Scanner_PowerGood对象获取的网卡电源状态值，

3.资源树新增网卡电源健康状态属性PowerStatus，表示网卡电源健康状态，值为0表示状态正常，为1表示异常，默认值为255，表示不支持或无法获取到网卡电源值。

3.network_adapter组件业务侧监听BIOS状态，根据BIOS状态值和PowerScanner值更新PowerStatus的值

4.Event组件获取资源树PowerStatus的值，根据该值判断是否触发告警。

### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->

#### 3.1.3.1 单元测试

<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->

| 用例名称 | 测试场景 | 说明 | 执行步骤 | 预期结果 |
| --- | --- | --- | --- | --- |
| test_update_power_status_invalid_powerscanner | PowerScanner异常值 | 模拟PowerScanner为异常值（不是0或1） | 设置PowerScanner为2（异常值），smbios_status为3（启动完成），PowerStatus为255 | 调用update_power_status后PowerStatus更新为255 |
| test_update_power_status_valid_powerscanner_smbios_3 | 上电状态网卡电源正常 | 模拟上电状态下获取到网卡电源正常状态 | 设置PowerScanner为1（电源正常），smbios_status为3（启动完成），PowerStatus为255 | 调用update_power_status后PowerStatus更新为1 |
| test_update_power_status_powerscanner_zero | 上电状态网卡电源故障 | 模拟上电状态下获取到网卡电源故障状态 | 设置PowerScanner为0（电源故障），smbios_status为3（启动完成），PowerStatus为255 | 调用update_power_status后PowerStatus更新为0 |
| test_update_power_status_valid_powerscanner_smbios_not_3 | 下电状态网卡电源故障告警无法产生 | 模拟下电状态下网卡电源故障 | 设置PowerScanner为1（有效值），smbios_status为4（BIOS下电），PowerStatus为255 | 调用update_power_status后PowerStatus更新为255 |
| test_update_power_status_powerscanner_default_255 | 上电状态网卡电源状态异常值 | 模拟上电状态下网卡电源状态值无法获取 | 设置PowerScanner为255（无法获取到），smbios_status为3（启动完成），PowerStatus为255 | 调用update_power_status后PowerStatus更新为255 |
| test_set_smbios_status_empty_list | GetSmBiosObjects返回空 | 模拟GetSmBiosObjects返回nil的情况 | 设置GetSmBiosObjects返回nil，smbios_status为0 | 调用set_smbios_status后smbios_status保持0不变 |
| test_set_smbios_status_empty_table | GetSmBiosObjects返回空表 | 模拟GetSmBiosObjects返回空表的情况 | 设置GetSmBiosObjects返回{}，smbios_status为0 | 调用set_smbios_status后smbios_status保持0不变 |
| test_set_smbios_status_with_object | GetSmBiosObjects返回有对象 | 模拟GetSmBiosObjects返回有对象的情况 | 设置GetSmBiosObjects返回包含SmBiosStatus=3（启动完成）的对象，smbios_status为0 | 调用set_smbios_status后smbios_status更新为3 |
| test_set_smbios_status_multiple_objects | GetSmBiosObjects返回多个对象 | 模拟GetSmBiosObjects返回多个对象的情况（只取第一个） | 设置GetSmBiosObjects返回两个对象（第一个SmBiosStatus=3（启动完成），第二个SmBiosStatus=1），smbios_status为0 | 调用set_smbios_status后smbios_status更新为第一个对象的SmBiosStatus值3 |
| test_set_smbios_status_pcall_failed | GetSmBiosObjects抛出异常 | 模拟GetSmBiosObjects抛出异常的情况 | 设置GetSmBiosObjects抛出异常'GetSmBiosObjects failed'，NodeId为'TestAdapter'，smbios_status为0 | 调用set_smbios_status后记录错误日志'get SmBios objects failed: TestAdapter'，smbios_status保持0不变 |
| test_set_smbios_status_no_smbiosstatus_field | smbios_obj没有SmBiosStatus字段 | 模拟smbios_obj没有SmBiosStatus字段的情况 | 设置GetSmBiosObjects返回没有SmBiosStatus字段的对象，smbios_status为0 | 调用set_smbios_status后如果出错，smbios_status保持0不变 |


#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->

不涉及