*openUBMC 支持BF3相关命令IPMI命令*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>张志洋+Minwell</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/11/18</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/11/11</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>Minwell</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
ibmc当下缺少对于BF3的Host Access、Extended Host Privilege与Mode的查询与设定能力，需要该能力的支持


## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
该需求主要包括相关的ipmi命令供外部调用与相应的遵循硬件定义规范的内部实现
支持BF3的相关ipmi命令包括：
新增 3 个 BF3 相关 IPMI 命令，明确命令权限、格式、参数及响应规则，确保命令可正常执行 Set/Get 操作。
1、新增IPMI命令用于Set/Get Host Access To BF3
2、新增IPMI命令用于Set/Get Extended Host Privilege
3、新增IPMI命令用于Set/Get BF3 Mode
## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
### 1.3.1 场景触发条件及对象
使用对象为具备Administrator权限的开发、测试、运维人员，在BMC已正常启动并运行的前提下，通过支持IPMI协议的工具（如ipmitool）或自定义IPMI客户端，对BF3组件的访问权限、扩展权限及工作模式进行配置或查询。使用对象需熟悉IPMI命令的基本使用方法及BF3组件的相关配置含义。
### 1.3.2 使用时间及频度
使用时间：系统运行期间持续监控，故障诊断时查询历史数据
#### 1.3.3 主要场景及子场景
- BF3的Host Access场景：子场景包括查询当前BF3的Host Access（Get操作）、设置BF3的Host Access为启用或禁用（Set操作）。
- BF3的Extended Host Privilege场景：子场景包括查询当前BF3的Extended Host Privilege、设置BF3的Extended Host Privilege为启用或禁用（Set操作）。
- BF3的Mode场景：子场景包括查询当前BF3的Mode（NIC模式或DPU模式，Get操作）、设置BF3的Mode为NIC模式或DPU模式（Set操作）。
## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | Set/Get Host Access To BF3   | 支持Administrator权限用户通过IPMI命令（命令码0x3e 0x67）执行Set和Get操作；Get操作请求长度1字节（含操作码0x02），响应长度2字节（含完成码和状态值）；Set操作请求长度2字节（含操作码0x01和状态值），响应长度1字节（含完成码）；状态值0x00表示禁用，0x01表示启用。 |
| 2 | Set/Get Extended Host Privilege        | 支持Administrator权限用户通过IPMI命令（命令码0x3e 0x68）执行Set和Get操作；Get操作请求长度1字节（含操作码0x02），响应长度2字节（含完成码和状态值）；Set操作请求长度2字节（含操作码0x01和状态值），响应长度1字节（含完成码）；状态值0x00表示禁用，0x01表示启用。  |
| 3 | Set/Get BF3 mode     | 支持Administrator权限用户通过IPMI命令（命令码0x3e 0x69）执行Set和Get操作；Get操作请求长度1字节（含操作码0x02），响应长度2字节（含完成码和模式值）；Set操作请求长度2字节（含操作码0x01和模式值），响应长度1字节（含完成码）；模式值0x00表示NIC模式，0x01表示DPU模式。 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->
在network_adapter模块中完成IPMI命令的注册与解析，通过标准协议与BF3硬件驱动进行交互，实现命令的执行与结果反馈。
### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
方案核心关键点包括IPMI命令注册、命令解析、硬件交互、响应构建四个个部分。实现策略如下：首先在network_adapater模块的IPMI命令注册模块中，分别注册三个功能对应的IPMI命令（命令码0x3e 0x67、0x3e 0x68、0x3e 0x69），并指定命令的权限要求为Administrator；当外部发起IPMI命令请求时，先校验请求者权限，通过后解析操作类型（Set或Get）及相关参数（仅Set操作有）；随后调用network_adapter组件内的内部代码实现，根据硬件规范将解析后的命令转换为硬件可识别的指令并发送至BF3硬件，同时接收硬件返回的执行结果；最后由将执行结果按照IPMI协议规范封装为响应数据包，反馈给外部请求者。

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
1、在 ipmi.json 中新增相应ipmi命令的req和rsp定义
2、在 network_adapter_app.lua 中注册相应的ipmi命令，并将ipmi的参数传递给device_manager.lua中的映射代码
3、在 device_manager.lua 中增加相应的将ipmi查询与设定命令映射到network_adapter.lua中的代码 
4、在 network_adapter.lua 中增加相应的调用BF3配置文件中的硬件查询与设定指令代码
5、在 BF3 配置文件中新增相应硬件查询与设定操作指令

```mermaid
graph TD
    subgraph "核心模块：network_adapter 组件"
        A["IPMI命令注册子模块"] --> B["命令解析子模块"]
        B --> C["硬件交互子模块"]
        C --> D["响应构建子模块"]
        
        A1["注册命令：0x3e 0x67/0x68/0x69"]
        A2["权限要求：Administrator"]
        A --> A1
        A --> A2
    end
    
    subgraph "配置文件层"
        E["ipmi.json"] --> E1["新增req/rsp命令定义"]
        F["BF3配置文件"] --> F1["新增硬件查询/设定指令"]
    end
    
    subgraph "代码实现层"
        G["network_adapter_app.lua"] --> G1["注册IPMI命令"]
        G --> G2["传递参数至device_manager.lua"]
        
        H["device_manager.lua"] --> H1["映射IPMI命令至network_adapter.lua"]
        
        I["network_adapter.lua"] --> I1["调用BF3配置文件指令"]
        I --> I2["转换命令为硬件可识别格式"]
    end
    
    %% 依赖关系
    E --> G1
    F --> I1
    G --> H
    H --> I
    I --> C
    A --> G
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
整体视图
```mermaid
sequenceDiagram
    外部请求者->>+BMC: 发送BF3相关ipmi命令
    BMC->>+network_adapter: 分发ipmi命令
    network_adapter->>+BF3: 下发硬件操作指令
    BF3-->>-network_adapter: 返回操作结果
    network_adapter-->>-BMC: 返回ipmi命令结果
    BMC-->>-外部请求者: 返回结果
```
network_adapter内部运行视图
```mermaid
sequenceDiagram
    network_adapter_app.lua->>+device_manager.lua: 传输ipmi指令参数
    device_manager.lua->>+network_adapter.lua: 调用具体的查询与设定代码
    network_adapter.lua->>+BF3网卡: 下发BF3配置文件中硬件操作指令
    BF3网卡-->>-network_adapter.lua: 返回操作结果
    network_adapter.lua-->>-device_manager.lua: 返回结果
    device_manager.lua-->>-network_adapter_app.lua: 返回结果
```
### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
无
### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
依赖BF3的对于本次使用的硬件操作相关命令的支持

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| Set/Get Host Access To BF3| NA | NA | NA | NA | 新增IPMI命令 | NA | NA |
| Set/Get Extended Host Privilege| NA | NA | NA | NA | 新增IPMI命令 | NA | NA |
| Set/Get BF3 Mode| NA | NA | NA | NA | 新增IPMI命令 | NA | NA |
### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
当前功能对现有在网的功能无影响。新增的IPMI命令为某伙伴定制ipmi命令，不涉及其他功能
### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及
### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及
### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及
### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及
### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及
### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 |	用例名称 |	参与者 |	前置条件 |	操作步骤  |	预期结果 |
| ---- | ---- | ---- | --- | ------ | ---------------- | 
| 1 |	Get Host Access To BF3 |	Administrator权限用户 | 1.BMC运行正常；2.用户具备Administrator权限；3.BF3硬件正常	 | 1、用户执行Get Host Access To BF3的IPMI命令 2. 等待接口响应	| 用户获取到Host对BF3的当前访问状态 |
| 2 |	 Set Host Access To BF3为启用 |	Administrator权限用户 | 1.BMC运行正常；2.用户具备Administrator权限；3.BF3硬件正常	 | 1、用户执行Set Host Access To BF3为启用的IPMI命令 2. 等待接口响应	| Host对BF3的访问状态设置为启用 |
| 3 |	Get Extended Host Privilege |	Administrator权限用户 | 1.BMC运行正常；2.用户具备Administrator权限；3.BF3硬件正常	 | 1、用户执行Get Extended Host Privilege的IPMI命令 2. 等待接口响应	| 用户获取到Host对BF3的当前扩展Host权限状态 |
| 4 |	 Set Extended Host Privilege为启用 |	Administrator权限用户 | 1.BMC运行正常；2.用户具备Administrator权限；3.BF3硬件正常	 | 1、用户执行Set Extended Host Privilege为启用的IPMI命令 2. 等待接口响应	| BF3的扩展Host权限状态设置为启用 |
| 5 |	Get BF3 mode |	Administrator权限用户 | 1.BMC运行正常；2.用户具备Administrator权限；3.BF3硬件正常	 | 1、用户执行Get BF3 mode的IPMI命令 2. 等待接口响应	| 用户获取到BF3的当前工作模式 |
| 6 |	Set BF3 mode为DPU模式 |	Administrator权限用户 | 1.BMC运行正常；2.用户具备Administrator权限；3.BF3硬件正常	 | 1、用户执行Set BF3 mode为DPU模式的IPMI命令 2. 等待接口响应	| BF3的工作模式设置为DPU模式 |
| 7 |	非管理员用户调用上述命令 |	非Administrator权限用户 | 1.BMC运行正常；2.用户不具备Administrator权限；3.BF3硬件正常	 | 再次执行上述六个用例	| 执行失败 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
本方案采用模块化设计，新增的 `ProcessorMetrics` 与 `MemoryMetrics` 查询接口及 OperatingSpeedMHz 属性相关代码独立于现有功能模块。后续若需新增类似的处理器性能指标属性或其他资源的 metrics 查询接口，可参照本方案的实现方式，在现有框架下进行扩展，无需对整体架构进行大规模调整，具有良好的扩展性。
### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
本方案中涉及的 Redfish 接口开发规范、数据采集与处理机制等均为通用处理方式。其中，数据采集模块的调用方式、接口响应格式的定义等可在其他类似的资源监控功能开发中重用，数据处理管道可被其他数据处理需求重用
### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
可直接验证
### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及
### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | BF3硬件故障 | BF3硬件通信接口故障，无法接收IPMI命令或返回执行结果 |	IPMI命令执行失败，响应返回错误，无法完成BF3配置或查询 |	一般 |	故障时返回特定完成码标识硬件通信失败，并记录日志
| 2 | 数据获取异常状态 | Get操作时BF3硬件返回的状态/模式值超出定义范围（非0x00或0x01）  |	IPMI命令执行失败，响应返回错误，无法完成BF3配置或查询 |		一般 |	接受异常返回时，统一返回特定完成码

### 2.2.7 安全性分析
| 安全合规项 |	是否涉及 |	现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） |	是 |	采用 ipmi 命令的访问控制机制，通过用户认证和授权管理，限制对查询接口的访问权限，只有授权用户才能进行查询操作 |
| 敏感数据	| 否 |	无 |
| 日志（操作日志、维护日志、安全日志、运行日志） |	否 |	无 |
| 文档 |	是 |	提供完善的接口文档，说明接口的使用方法、安全注意事项等 |
| 加密及算法 |	否	| 无 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 |	否 |	无 |
| 新增对外接口入参校验	| 是	| 对接口的查询参数进行校验，防止无效参数或恶意参数导致的系统异常 | 
| 新增开源及三方软件引入 |	否 |	无 |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->

## 3.1【功能编号】支持BF3相关命令
### 3.1.1 功能实现设计
方案核心关键点包括IPMI命令注册、命令解析、硬件交互、响应构建四个个部分。实现策略如下：首先在network_adapater模块的IPMI命令注册模块中，分别注册三个功能对应的IPMI命令（命令码0x3e 0x67、0x3e 0x68、0x3e 0x69），并指定命令的权限要求为Administrator；当外部发起IPMI命令请求时，先校验请求者权限，通过后解析操作类型（Set或Get）及相关参数（仅Set操作有）；随后调用network_adapter组件内的内部代码实现，根据硬件规范将解析后的命令转换为硬件可识别的指令并发送至BF3硬件，同时接收硬件返回的执行结果；最后由将执行结果按照IPMI协议规范封装为响应数据包，反馈给外部请求者。

具体命令请求与相应格式参照
[官方文档](https://docs.nvidia.com/networking/display/bluefieldbsp4100/nc-si+oem+commands#src-3593242548_safe-id-TkNTSU9FTUNvbW1hbmRzLVNldEV4dGVybmFsSG9zdFByaXZpbGVnZXMoQ29tbWFuZD0weDEyLFBhcmFtZXRlcj0weDMyKVt0b2JlcHV0aW5Nb2Rlc29mT3BlcmF0aW9udjQuMTAuMCMuTW9kZXNvZk9wZXJhdGlvbnY0LjEwLjAtVXNpbmdQbGF0Zm9ybS1CTUNOQy1TSU9FTUNvbW1hbmRzKG1vdmluZ3RvYW5kZnJvbXplcm90cnVzdCld)
| ipmi命令|对应章节 |
|------|------|
|Get Host Access To BF3|Get Host PCIe rshim access to BlueField DPU CPU (Command=0x13, Parameter=0x19)|
|Set Host Access To BF3| Set Host PCIe rshim access to BlueField DPU CPU (Command=0x12, Parameter=0x19) |
|Get Extended Host Privilege| Get External Host Privileges (Command=0x13, Parameter=0x32)|
|Set Extended Host Privilege|Set External Host Privileges (Command=0x12, Parameter=0x32)|
|Get BF3 Mode|Get BlueField Mode (Command=0x13, Parameter=0x33)|
|Set BF3 Mode|Set BlueField DPU Mode (Command=0x12, Parameter=0x33)|



### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
| 用例类型 |	用例名称  |	预期结果 |
| ---- | ------ | ---------------- | 
| ut |	Get Host Access To BF3 | 获取到Host对BF3的当前访问状态 |
| ut |	 Set Host Access To BF3为启用 | Host对BF3的访问状态设置为启用 |
| ut |	Get Extended Host Privilege 	| 用户获取到Host对BF3的当前扩展Host权限状态 |
| ut |	 Set Extended Host Privilege为启用 	| BF3的扩展Host权限状态设置为启用 |
| ut |	Get BF3 mode 	| 用户获取到BF3的当前工作模式 |
| ut |	Set BF3 mode为DPU模式 | BF3的工作模式设置为DPU模式 |
| ut |	非管理员用户调用上述命令| 执行失败 |
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
参上
#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及