# network_adapter

## 1 功能简介
network_adapter主要负责网卡信息的获取与管理，网口的NCSI功能；
网卡信息的获取来源分为两种：1、带外通过mctp、smbus等协议获取 2、带内通过iBMA上报的信息获取；
网口的NCSI功能主要是对支持NCSI功能的网卡进行NCSI channel相关的配置，使得BMC能通过网卡的NCSI通路与外界通信.

### 1.1 代码目录结构

```
├── src
│   ├── lualib
│   │   ├── bma
│   │   │   ├── handles
│   │   │   │   ├── handler_base.lua               -- 处理BMA上报信息的基本函数
│   │   │   │   ├── handler_eth_statistics.lua     -- 处理BMA上报的网口统计信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_eth.lua                -- 处理BMA上报的网口基本信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_optical_diag.lua       -- 处理BMA上报的光模块诊断信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_optical.lua            -- 处理BMA上报的光模块基本信息，包含添加、更新、重置等操作
│   │   │   │   ├── handler_vlan.lua               -- 处理BMA上报的vlan信息，包含添加、更新、重置等操作
│   │   │   │   └── init.lua
│   │   │   ├── bma_mdb_mgmt.lua                   -- BMA资源管理的基本函数
│   │   │   └── init.lua
│   │   ├── debug
│   │   │   └── init.lua                           -- Ncsi over mctp的调试命令接口函数
│   │   ├── device
│   │   │   ├── class
│   │   │   │   ├── vlan
│   │   │   │   │   ├── init.lua                   -- VLAN对象的生成和基本信息获取设置
│   │   │   │   │   ├── ipv4_address.lua           -- VLAN的ipv4对象的生成和基本信息获取设置
│   │   │   │   │   └── ipv6_address.lua           -- VLAN的ipv6对象的生成和基本信息获取设置
│   │   │   │   ├── ipv4_address.lua               -- ipv4对象的生成和基本信息获取设置，对比上面少了VLAN
│   │   │   │   ├── ipv6_address.lua               -- ipv6对象的生成和基本信息获取设置，对比上面少了VLAN
│   │   │   │   ├── log_collector.lua              -- 日志收集相关，包含创建删除日志路径，日志收集信号触发
│   │   │   │   ├── log_netcard_info.lua           -- 日志记录网卡信息
│   │   │   │   ├── network_adapter.lua            -- 网卡相关业务代码
│   │   │   │   ├── network_port.lua               -- 网口相关业务代码
│   │   │   │   └── optical_module.lua             -- 光模块相关业务代码
│   │   │   └── device_manager.lua                 -- 设备管理相关，包含method、ipmi命令的实现
│   │   ├── hardware_config
│   │   │   ├── CX4.lua                            -- CX4型号网卡（例如SP333、SP380）协议的使用，当前仅支持ncsi over mctp
│   │   │   ├── CX5.lua                            -- CX5型号网卡（例如SP351、SP382）协议的使用，当前仅支持ncsi over mctp，比CX4少了lldp
│   │   │   ├── CX6-DX.lua                         -- CX6-DX型号网卡（例如MCX623105AN-VDAT）协议的使用，与CX5完全一致
│   │   │   ├── Gemini.lua                         -- 尝试实现的SDI卡协议使用，std_smbus
│   │   │   ├── Hi182X.lua                         -- 182X系列网卡（SP580）协议的使用，支持smbus、ncsi/pldm over mctp
│   │   ├── imu
│   │   │   └── init.lua                           -- 从IMU获取PCI配置（含四元组）信息
│   │   ├── infrastructure
│   │   │   └── fructl.lua                         -- 获取fructl相关属性
│   │   ├── ncsi
│   │   │   ├── ncsi_comm.lua                      -- ncsi数据处理
│   │   │   ├── ncsi_core.lua                      -- ncsi协议接口，lua层处理c库接口
│   │   │   ├── ncsi_info.lua                      -- ncsi数据处理
│   │   │   ├── ncsi_lldp.lua                      -- lldp相关
│   │   │   ├── ncsi_service.lua                   -- ncsi初始化
│   │   │   └── ncsi_worker.lua                    -- 接收ncsi报文
│   │   ├── network_adapter_app.lua
│   ├── lualib-src
│   │   ├── ncsi_protocol
│   │   │   ├── CMakeLists.txt
│   │   │   ├── l_ncsi_protocol.c
│   │   └── CMakeLists.txt
│   └── service
│       └── main.lua
```
### 1.2 组件内主要类

1. NetworkAdapter：网卡设备信息
2. NetworkPort：网口设备信息
3. OpticalModule：光模块设备信息

NetworkAdapter拥有N个NetworkPort,
每个NetworkPort拥有0/1个OpticalModule,
通过 "@Parent"属性关联上

### 1.3 已适配网卡

1. NIC卡：板载网卡（Lom卡），灵活IO插卡
2. PCIE标卡：pcie网卡，需要Riser卡
3. SDI卡：比较特殊的智能网卡
4. OCP卡：由Open Compute Project（开放计算项目）推出的一种服务器网络接口卡
5. FC卡：光纤通道网卡

------------

## 2 关键特性
### 2.1 带外协议获取网卡信息
网卡协议：
[NCSI标准协议](https://www.dmtf.org/sites/default/files/standards/documents/DSP0222_1.0.0.pdf)
[mctp标准协议](https://www.dmtf.org/sites/default/files/standards/documents/DSP0236_1.3.1.pdf)
[LLDP官方网站](https://lldpd.github.io/)
[smbus协议](http://www.smbus.org/specs/)
**ncsi over mctp over pcie**
绝大多数网卡都支持该协议，可以获取以下信息：网卡的厂商信息、网卡芯片温度、网卡支持的最大带宽能力、网卡支持的最大速率能力、网卡实际带宽、网卡实际速率、网卡故障状态、网口的报文收发信息、网口的链路状态、网口总线信息、光模块温度、网口工作的mac地址、网口的永久mac地址、光模块信息等
**pldm over mctp over pcie**
仅涉及SDI5x/SDI6x收集黑匣子日志，未来计划FC卡通过该协议获取带外信息
**smbus**
仅182x网卡支持，可以获取以下信息：网卡健康状态、网卡故障状态、网卡芯片温度、网卡错误日志、网卡临终遗言日志、网卡运行日志、光模块温度、网口链接状态、网口mac地址等
**std_smbus**
当前预留，给后续SDI的mcu交互使用
**lldp**
接收LLDP信息，获取以下信息：从网络交换机接收到的Chassis ID、从网络交换机接收到的Chassis ID类型、从网络交换机接收到的端口ID、从网络交换机接收到的端口ID类型、网络交换机名称、从网络交换机接收到的VLAN ID
### 2.2 带内iBMA获取网卡信息
网口信息通过以下路径传递到network_adapter：带内->sms接口->host_agent->network_adapter，network_adapter通过监听host_agent与网口相关的资源树对象的变化，包括上树、修改、下树等信号，对网口信息进行汇总管理，其中信息包括但不限于网口连接状态、网口速率、网口IPv4、IPv6、mac地址、BDF、网卡固件版本、bond网口、bridge网口、光模块相关信息等

------------

### 2.3 网卡NCSI功能
部分网卡（PCIe卡、OCP卡）具备[NCSI](https://www.cnblogs.com/servlet-context/p/18317045)功能，简单理解即BMC可通过NCSI通道与网卡相连，实现BMC的带外通信。NCSI通道的报文分为两种：NCSI控制报文和网络透传报文，BMC想实现NCSI网口的带外通信功能，需要发送NCSI控制报文对网卡进行NCSI相关配置，以实现NCSI通道可以进行网络透传报文传输，另外还需要与bmc_network组件进行交互实现BMC的NCSI网口带外通信，主要分为以下几点：
1、初始化时识别网卡是否具备NCSI功能，识别到NCSI网口后上报给bmc_network注册一个NCSI网口，并实时更新NCSI网口的link状态变化
2、bmc_network切换到NCSI网口时发送信号给network_adapter，network_adapter将使能网口对应的NCSI通道的Tx，从NCSI网口切换回专用网口时，关闭原NCSI通道的Tx
3、bmc_network设置NCSI的VLAN后发送信号给network_adapter，network_adapter配置NCSI通道的vlan_filter，允许该VLAN的报文在NCSI通道传输

------------

## 3 对外接口
### 3.1 RPC方法
| 接口                                  | 方法                    | 描述                            |
| :----------------------------------: | :--------------------: | :----------------------------: |
| bmc.kepler.Systems.NetworkAdapters   | GetNetCardPortNum      | 获取网卡对应的网口数量             |
| bmc.kepler.Systems.NetworkAdapters   | GetPortSpeed           | 获取网口速率                     |
| bmc.kepler.Systems.NetworkAdapters   | GetNetworkAdapterNum   | 获取网卡数量                     |
| bmc.kepler.Systems.NetworkAdapters   | GetNetworkPortNum      | 获取网口总数量                    |
| bmc.kepler.Systems.NetworkAdapters   | GetPortSpeed           | 获取网口速率                     |
| bmc.kepler.Systems.NetworkAdapters   | GetBandwidthHistory    | 获取各个网卡的端口带宽占用率历史数据 |
| bmc.kepler.Systems.NetworkAdapters   | ClearBandwidthHistory  | 清空各个网卡的端口带宽占用率历史数据 |
| bmc.kepler.Systems.NetworkAdapters   | SetBandwidthThreshold  | 设置网络带宽占用率门限             |
| bmc.kepler.Systems.NetworkAdapter    | StartRemovingDevice    | 热拔出网卡                       |
| bmc.kepler.Systems.NetworkAdapter    | DumpBlackBox           | 收集SDI卡黑匣子日志               |
| bmc.kepler.Systems.NetworkPort       | Configure              | 配置网口信息                     |
| bmc.kepler.Systems.NetworkPort.VLANs | CreateVLAN             | 创建网口VLAN                     |
| bmc.kepler.Systems.NetworkPort.VLAN  | ConfigureVLAN          | 修改VLAN配置                     |
| bmc.kepler.Systems.NetworkPort.VLAN  | DeleteVLAN             | 删除VLAN                        |
| bmc.kepler.Systems.NetworkBondings   | CreateBond             | 创建bond                        |
| bmc.kepler.Systems.NetworkBondings   | DeleteBond             | 删除bond                        |
| bmc.kepler.Systems.NetworkBondings   | SetLinkMonitorPeriodMS | 设置连接状态检测周期               |
| bmc.kepler.Debug.Systems.NCSI        | SendCmdOverMCTP        | 用于调试NCSIoverMCTP命令         |
| bmc.kepler.Debug.Systems.NetworkAdapters        | Dump        | Debug命令收集网卡基本信息         |
### 3.2 IPMI命令
| 命令                             | 描述                            |
| :-----------------------------: | :-----------------------------: |
| WriteMacAddress                 | 设置网口的mac地址你，通常是bios调用 |
| GetMacAddress                   | 获取网口的mac地址                 |
| GetBusinessPortInfo             | 查询网口的信息                    |
| SetIPMCConfiguration            | 设置NCSI channel的Rx             |
| GetIPMCConfiguration            | 获取NCSI channel的Rx             |
| GetNetworkAdapterModelByLOM     | 通过BDF进行板载网卡芯片型号查询     |
| GetNetworkAdapterModelByOCPCard | 通过BDF进行OCP扣卡芯片型号查询      |

### 3.3 资源协作接口属性
#### 1.NetworkAdapters
    路径名："/bmc/kepler/Systems/:SystemId/NetworkAdapters"
    privilege: ReadOnly
##### 接口："bmc.kepler.Systems.NetworkAdapters" 
##### 属性：无
##### 接口："bmc.kepler.Systems.NetworkBondings" 
##### 属性：无

#### 2.NetworkAdapter
    路径名："/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID"
    privilege: ReadOnly
    table名: "t_network_adapter"
##### 接口："bmc.kepler.Systems.NetworkAdapter" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|ID|网卡ID|--|--|--|--|String|--|--|
|SystemID|系统ID|--|--|--|--|U8|--|--|
|Name|网卡型号名称|--|--|--|--|String|--|--|
|DisplayName|网卡显示名称|--|--|--|--|String|--|--|
|Manufacturer|厂商名称|--|--|--|--|String|--|--|
|Description|网卡描述|--|--|--|--|String|--|--|
|Position|网卡容器信息|--|--|--|--|String|--|--|
|DeviceLocator|网卡丝印信息|--|--|--|--|String|--|--|
|Type|网卡类型|--|--|--|--|U8|--|--|
|NetworkPortCount|网口个数|--|--|--|--|U8|--|--|
|Model|芯片型号|--|--|--|--|String|--|--|
|ChipVendor|芯片厂商|--|--|--|--|String|--|--|
|ModelDescription|芯片型号描述|--|--|--|--|String|--|--|
|ChipManufacturer|芯片厂商|--|--|--|--|String|--|--|
|DriverName|驱动名称|--|--|--|--|String|--|--|
|DriverVersion|驱动版本|--|--|--|--|String|--|--|
|SlotNumber|槽位号|--|--|--|--|U8|--|--|
|NetDevFuncCapabilities|网卡支持的协议，0:Disabled 1:Ethernet 2:FC 4:iSCSI 8:FCoE 16:OPA 32:IB|--|--|--|--|U8|--|--|
|RootBDF|网卡BDF信息|--|--|--|--|String|--|--|
|FirmwareVersion|固件版本|--|--|--|--|String|--|--|
|VendorID|厂商ID|--|--|--|--|String|--|--|
|DeviceID|设备ID|--|--|--|--|String|--|--|
|SubsystemVendorID|子系统厂商ID|--|--|--|--|String|--|--|
|SubsystemDeviceID|子系统设备ID|--|--|--|--|String|--|--|
|BoardID|单板ID|--|--|--|--|U16|--|--|
|BoardName|单板名称|--|--|--|--|String|--|--|
|BoardIDHex|十六进制单板ID|--|--|--|--|String|--|--|
|ComponentUniqueID|组件唯一标识|--|--|--|--|String|--|--|
|PCBVersion|PCB版本|--|--|--|--|String|--|--|
|AssociatedResource|网卡资源归属|--|--|--|--|String|--|--|
|SupportedMctp|网卡是否支持MCTP|--|--|--|--|Boolean|--|--|
|HotPluggable|网卡是否支持热插拔|--|--|--|--|Boolean|--|--|
|ReadyToRemove|热拔出是否已准备好|--|--|--|--|Boolean|--|--|
|AttentionHotPlugState|热插拔状态：0 - 不可操作；1 - 可拔出；2 - 可插入；其他 - 未知|--|--|--|--|U8|--|--|
|SerialNumber|序列号|--|--|--|--|String|--|--|
|PreviousSerialNumber|更换前的序列号|--|--|--|--|String|--|--|
|TemperatureCelsius|芯片温度|--|--|--|--|S16|--|--|
|TemperatureStatus|芯片温度状态：0 - 正常；1 - 失效|--|--|--|--|U8|--|--|
|MaxOperatingTemperatureCelsius|网卡在稳态下支持的最大温度|--|--|--|--|U16|--|--|
|LLDPSupported|网卡是否支持LLDP|--|--|--|--|Boolean|--|--|
|FruId|网卡电子标签|--|--|--|--|U8|--|--|
|PredictiveFault|预测故障标志位|--|--|--|--|U8|--|--|
|DiagnosticFault|故障诊断定位标志位|--|--|--|--|U8|--|--|
|ReplacedFlag|网卡更换标志位|--|--|--|--|U8|--|--|
|SupportedLLDP|网卡是否支持LLDP|--|--|--|--|Boolean|--|--|
|ParentCardSlotId|关联上一级卡的槽位号|--|--|--|--|U8|--|--|
|PfMacInfo|Physical Function Mac信息|--|--|--|PfMacInfoItem|Array|--|--|
|BandwidthThresholdPercent|网络带宽占用率门限|--|--|--|--|U16|--|--|
|NodeId|网卡NodeId|--|--|--|--|String|--|--|


##### 接口："bmc.kepler.Systems.NetworkAdapter.NetworkAdapterMetrics" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|LinkWidthCapability|网卡支持的最大带宽能力|--|--|--|--|String|--|--|
|LinkSpeedCapability|网卡支持的最大速率能力|--|--|--|--|String|--|--|
|LinkWidth|网卡实际带宽|--|--|--|--|String|--|--|
|LinkSpeed|网卡实际速率|--|--|--|--|String|--|--|
|SFPMaxTemperatureCelsius|光模块最大温度,用于调速,单位:摄氏度|--|摄氏度|--|--|S16|--|--|

##### 接口："bmc.kepler.Systems.NetworkAdapter.Status" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Health|网卡健康状态, 0:OK, 1:Minor, 2:Major, 3:Critical|--|--|--|--|U8|--|--|
|FaultCode|异常码|--|--|--|--|String|--|--|
|FaultState|故障状态，用于告警配置|--|--|--|--|U32|--|--|
|PowerStatus|Hi182x网卡电源状态，用于告警配置，1:正常, 0:异常, 255:未知|--|--|--|--|U8|--|--|

##### 接口："bmc.kepler.Inventory.Hardware" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|AssetType|硬件资产类型|--|--|--|--|String|--|--|
|AssetName|硬件资产名称|--|--|--|--|String|--|--|
|SerialNumber|硬件资产序列号|--|--|--|--|String|--|--|
|FirmwareVersion|硬件资产固件版本|--|--|--|--|String|--|--|
|PCBVersion|硬件资产PCB版本|--|--|--|--|String|--|--|
|Manufacturer|硬件资产制造商|--|--|--|--|String|--|--|
|AssetTag|硬件资产标签|--|--|--|--|String|--|--|
|PartNumber|硬件资产部件编号|--|--|--|--|String|--|--|
|ManufactureDate|硬件资产生产日期|--|--|--|--|String|--|--|
|Slot|硬件槽位号|--|--|--|--|String|--|--|
|UUID|硬件UUID号|--|--|--|--|String|--|--|
|Model|硬件资产型号|--|--|--|--|String|--|--|

#### 3.NetworkPort
     路径名：":parent/Ports/:ID"
     privilege: ReadOnly
     table名: "t_network_port"
     parent: "NetworkAdapter"
##### 接口："bmc.kepler.Systems.NetworkPort" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|SystemID|系统ID|--|--|--|--|U8|--|--|
|NodeId|网口NodeId|--|--|--|--|String|--|--|
|Name|网口名称|--|--|--|--|String|--|--|
|Type|网口类型|--|--|--|--|U8|--|--|
|PortID|网口ID|--|--|--|--|U8|--|--|
|PermanentMACAddress|永久MAC地址|--|--|--|--|String|--|--|
|MACAddress|MAC地址|--|--|--|--|String|--|--|
|LinkStatus|链路状态|LinkUp,NoLink,LinkDown,N/A,Connected,Disconnected|--|--|--|String|--|--|
|LinkStatusNumeric|链路状态|--|--|--|--|U8|--|--|
|IPv6DefaultGateway|IPv6默认网关|--|--|--|--|String|--|--|
|WorkMode|工作模式|Loop,NonLoop|--|--|--|String|--|--|
|FunctionType|网口类型:物理,虚拟|Virtual,Physical|--|--|--|String|--|--|
|BDF|网口BDF|--|--|--|--|String|--|--|
|AutoConnectOnBoot|开机是否自动启用网络连接|--|--|--|--|Boolean|--|--|
|NetDevFuncType|网络设备功能类型，0:Disabled 1:Ethernet 2:FC 4:iSCSI 8:FCoE 16:OPA 32:IB|--|--|--|--|U8|--|--|
|MediumType|网口介质类型|Copper,FiberOptic|--|--|--|String|--|--|
|SpeedMbps|链路速率|--|Mbps|--|--|U32|--|--|
|FullDuplex|是否开启全双工|--|--|--|--|Boolean|--|--|
|AutoSpeedNegotiation|是否处于自协商模式|--|--|--|--|Boolean|--|--|
|FirmwareVersion|固件版本|--|--|--|--|String|--|--|
|DriverName|驱动名称|--|--|--|--|String|--|--|
|DriverVersion|驱动版本|--|--|--|--|String|--|--|
|LLDPEnabled|网口LLDP使能 false:关闭使能 true:打开使能|--|--|--|--|Boolean|--|--|
|SupportedLinkCapability|支持的传输速率|--|--|--|--|String|--|--|
|NetworkAdapterId|对应的网卡ID属性|--|--|--|--|String|--|--|
|LinkMonitorPeriodMS|网口链路监测周期，单位毫秒|--|毫秒|--|--|U32|--|--|
|UUID|网口全球唯一标识，用于IB卡。只读属性，默认为空。|--|--|--|--|String|--|--|
|WorkloadType|工作负载类型，0：负载服务器os；1：负载智能网卡的os；2：服务器os及智能网卡os均卸载|--|--|--|--|U8|--|--|

##### 接口："bmc.kepler.Systems.NetworkPort.Metrics" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|RXFrames|收到的帧数量|--|--|--|--|String|--|--|
|TXFrames|发送的帧数量|--|--|--|--|String|--|--|
|PacketsDropped|丢包总数|--|--|--|--|U64|--|--|
|RXUnicastFrames|收到的单播帧数量|--|--|--|--|String|--|--|
|RXMulticastFrames|收到的多播帧数量|--|--|--|--|String|--|--|
|RXBroadcastFrames|收到的广播帧数量|--|--|--|--|String|--|--|
|TXUnicastFrames|发送的单播帧数量|--|--|--|--|String|--|--|
|TXMulticastFrames|发送的多播帧数量|--|--|--|--|String|--|--|
|TXBroadcastFrames|发送的广播帧数量|--|--|--|--|String|--|--|
|RXFCSErrors|接收到的校验错误帧数量|--|--|--|--|String|--|--|
|RXUndersizeFrames|接收到的超小帧数量|--|--|--|--|String|--|--|
|RXOversizeFrames|接收到的超长帧数量|--|--|--|--|String|--|--|
|TXSingleCollisions|发送的单碰撞帧数量|--|--|--|--|String|--|--|
|TXMultipleCollisions|发送的多碰撞帧数量|--|--|--|--|String|--|--|
|TXLateCollisions|发送的延迟碰撞帧数量|--|--|--|--|String|--|--|
|TXExcessiveCollisions|发送的超量碰撞帧数量|--|--|--|--|String|--|--|
|RXFrameAlignmentErrors|接收的对齐错误的帧数量|--|--|--|--|String|--|--|
|BandwidthUsagePercent|网络带宽占用率|--|--|--|--|Double|--|--|

##### 接口："bmc.kepler.Systems.NetworkPort.DataCenterBridging" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Up2cos|DCB 信息中的 Up2cos|--|--|--|--|U8[]|--|--|
|Uppgid|DCB 信息中的 Uppgid|--|--|--|--|U8[]|--|--|
|Pgpct|DCB 信息中的 Pgpct|--|--|--|--|U8[]|--|--|
|PgStrict|DCB 信息中的 PgStrict|--|--|--|--|U8[]|--|--|
|Pfcmap|DCB 信息中的 Pfcmap|--|--|--|--|U8|--|--|

##### 接口："bmc.kepler.Systems.NetworkPort.LLDPReceive" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|ChassisId|从网络交换机接收到的Chassis ID|--|--|--|--|String|--|--|
|ChassisIdSubtype|从网络交换机接收到的Chassis ID类型|--|--|--|--|String|--|--|
|PortId|从网络交换机接收到的端口ID|--|--|--|--|String|--|--|
|PortIdSubtype|从网络交换机接收到的端口ID类型|--|--|--|--|String|--|--|
|SystemName|网络交换机名称|--|--|--|--|String|--|--|
|ManagementVlanId|从网络交换机接收到的VLAN ID|--|--|--|--|U16|--|--|

##### 接口："bmc.kepler.Systems.NetworkPort.FibreChannel" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|FCId|FC ID信息|--|--|--|--|String|--|--|
|WWNN|当前生效WWNN号|--|--|--|--|String|--|--|
|PermanentWWNN|出厂WWNN号|--|--|--|--|String|--|--|
|WWPN|当前生效WWPN号|--|--|--|--|String|--|--|
|PermanentWWPN|出厂WWPN号|--|--|--|--|String|--|--|
|SpeedGbps|端口链接速率，用于FC卡|--|Gb|--|--|U32|--|--|

#### 4.VLANs
     路径名：":parent/VLANs"
     privilege: ReadOnly
     parent: "NetworkPort"

##### 接口："bmc.kepler.Systems.NetworkPort.VLANs" 
##### 属性：无

#### 5.VLAN
     路径名：":parent/VLANs/:ID"
     privilege: ReadOnly
     parent: "NetworkPort"
     table名: "t_network_vlan"

##### 接口："bmc.kepler.Systems.NetworkPort.VLAN" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|VLANId|VLAN ID|--|--|--|--|U16|--|--|
|VLANEnabled|VLAN是否启用|--|--|--|--|Boolean|--|--|
|VLANPriority|VLAN优先级|--|--|--|--|U8|--|--|
|AutoConnectOnBoot|VLAN是否在系统启动时自动创建和启用|--|--|--|--|Boolean|--|--|

#### 6.IPv4Address
      路径名：":parent/IPv4Addresses/:ID"
      privilege: ReadOnly
      parent: "NetworkPort"
      table名: "t_network_ipv4_address"

##### 接口："bmc.kepler.Systems.IPv4Address" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Address|IP地址|--|--|--|--|String|--|--|
|SubnetMask|子网掩码|--|--|--|--|String|--|--|
|Gateway|网关|--|--|--|--|String|--|--|
|AddressOrigin|地址模式|Static,DHCP|--|--|--|String|--|--|

#### 7.IPv6Address
       路径名：":parent/IPv6Addresses/:ID"
       privilege: ReadOnly
       parent: "NetworkPort"
       table名: "t_network_ipv6_address"

##### 接口："bmc.kepler.Systems.IPv6Address" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Address|IP地址|--|--|--|--|String|--|--|
|PrefixLength|前缀长度|--|--|--|--|String|--|--|
|AddressState|地址状态|Deprecated,Failed,Preferred,Tentative|--|--|--|String|--|--|
|AddressOrigin|地址来源|DHCPv6,LinkLocal,SLAAC,Static|--|--|--|String|--|--|
|Gateway|网关|--|--|--|--|String[]|--|--|

#### 8.VLANIPv4Address
       路径名：":parent/IPv4Addresses/:ID"
       privilege: ReadOnly
       parent: "VLAN"
       table名: "t_network_vlan_ipv4_address"
##### 接口："bmc.kepler.Systems.IPv4Address" 
##### 属性：同IPv4Address对象

#### 9.VLANIPv6Address
       路径名：":parent/IPv6Addresses/:ID"
       privilege: ReadOnly
       parent: "VLAN"
       table名: "t_network_vlan_ipv6_address"
##### 接口："bmc.kepler.Systems.IPv6Address" 
##### 属性：同IPv6Address对象

#### 10.OpticalModule
        路径名：":parent/OpticalModule"
        privilege: ReadOnly
        parent: "NetworkPort"
        table名: "t_optical_module"

##### 接口："bmc.kepler.Systems.OpticalModule" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Name|名称|--|--|--|--|String|--|--|
|Manufacturer|厂商名称|--|--|--|--|String|--|--|
|PartNumber|厂商部件名称|--|--|--|--|String|--|--|
|SerialNumber|序列号|--|--|--|--|String|--|--|
|RevisionNumber|产品修订版本号, ASCII字符串, 长度为2字符|--|--|--|--|String|--|--|
|ProductionDate|生产日期|--|--|--|--|String|--|--|
|TransceiverType|收发器类型|--|--|--|--|String|--|--|
|FiberConnectionType|传输模式|--|--|--|--|String|--|--|
|WaveLengthNanometer|波长，单位纳米|--|纳米|--|--|String|--|--|
|Type|类型|--|--|--|--|String|--|--|
|SupportedSpeedsMbps|支持的速率|--|--|--|--|Double[]|--|--|
|Health|健康状态|--|--|--|--|U8|--|--|
|Identifier|识别码|--|--|--|--|String|--|--|
|ConnectorType|连接器类型|--|--|--|--|String|--|--|
|MediumType|介质类型|Optical,Electric,Copper,Aoc,Interface,Baset|--|--|--|String|--|--|
|TransmissionDistance|传输距离|--|--|--|--|String|--|--|
|RxLossState|发送端信号是否丢失|--|--|--|--|Boolean|--|--|
|TxLossState|接收端信号是否丢失|--|--|--|--|Boolean|--|--|
|TxFaultState|接收端是否故障|--|--|--|--|Boolean|--|--|
|TypeMatch|类型是否匹配|--|--|--|--|Boolean|--|--|
|SpeedMatch|速率是否匹配|--|--|--|--|Boolean|--|--|
|FaultState|故障状态|--|--|--|--|U32|--|--|
|TemperatureCelsius|光模块温度（用于告警）|--|--|--|--|Double|--|--|
|PowerState|功率异常标志位（用于告警）|--|--|--|--|U8|--|--|
|IsSupportedType|网卡支持速率与光模块速率不匹配标志位（用于告警）|--|--|--|--|U8|--|--|
|Presence|光模块是否在位|--|--|--|--|U8|--|--|
|ChannelNum|光模块内部通道数|--|--|--|--|U8|--|--|
|RxSNR|端口接收信噪比|--|--|--|--|Double[]|--|--|
|HostSNR|主机侧信噪比|--|--|--|--|Double[]|--|--|
|MediaSNR|介质侧信噪比|--|--|--|--|Double[]|--|--|
|Accessible|光模块是否可访问,0为不可访问,1为可访问|--|--|--|--|U8|--|--|
|ModuleState|光模块当前运行状态, 默认值为255, 1: ModuleLowPwr, 2: ModulePwrUp, 3: ModuleReady, 4: ModulePwrDn, 5: ModuleFault, 其余取值为光模块厂家自定义状态|--|--|--|--|U8|--|--|
|RelatedNetworkPorts|光模块关联的网口Id|--|--|--|--|U8[]|--|--|

##### 接口："bmc.kepler.Systems.OpticalModule.BiasCurrent" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|TXBiasCurrentMilliAmps|读取的电流，单位毫安|--|毫安|--|--|Double[]|--|--|
|TXBiasCurrent1MilliAmps|读取的通道1的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent2MilliAmps|读取的通道2的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent3MilliAmps|读取的通道3的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent4MilliAmps|读取的通道4的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent5MilliAmps|读取的通道5的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent6MilliAmps|读取的通道6的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent7MilliAmps|读取的通道7的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrent8MilliAmps|读取的通道8的电流，单位毫安|--|毫安|--|--|Double|--|--|
|TXBiasCurrentStatus|偏置电流异常状态;每个bit对应一个通道,某个bit取值1表示是对应偏置电流通道故障;当前光模块最多8通道,属性预留32位便于扩展|--|--|--|--|U32|--|--|
|TXLowerThresholdCritical|发送偏置电流告警下限阈值|--|--|--|--|Double|--|--|
|TXUpperThresholdCritical|发送偏置电流告警上限阈值|--|--|--|--|Double|--|--|
|BiasCurrentTXUpperThresholdWarning|发送偏置电流警告上限阈值|--|--|--|--|Double|--|--|
|BiasCurrentTXLowerThresholdWarning|发送偏置电流警告下限阈值|--|--|--|--|Double|--|--|

##### 接口："bmc.kepler.Systems.OpticalModule.Power" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|RXInputPowerMilliWatts|读取的接收功率，单位毫瓦|--|毫瓦|--|--|Double[]|--|--|
|RXInputPowerStatus|接收功率异常状态;每个bit对应一个通道,某个bit取值1表示是对应接收功率通道故障;当前光模块最多8通道,属性预留32位便于扩展|--|--|--|--|U32|--|--|
|RXLowerThresholdCritical|接收功率告警下限阈值|--|--|--|--|Double|--|--|
|RXUpperThresholdCritical|接收功率告警上限阈值|--|--|--|--|Double|--|--|
|TXOutputPowerMilliWatts|读取的发送功率，单位毫瓦|--|毫瓦|--|--|Double[]|--|--|
|TXOutputPowerStatus|发送功率异常状态;每个bit对应一个通道,某个bit取值1表示是对应发送功率通道故障;当前光模块最多8通道,属性预留32位便于扩展|--|--|--|--|U32|--|--|
|TXLowerThresholdCritical|发送功率告警下限阈值|--|--|--|--|Double|--|--|
|TXUpperThresholdCritical|发送功率告警上限阈值|--|--|--|--|Double|--|--|
|PowerTXUpperThresholdWarning|发送功率警告上限阈值|--|--|--|--|Double|--|--|
|PowerTXLowerThresholdWarning|发送功率警告下限阈值|--|--|--|--|Double|--|--|
|PowerRXUpperThresholdWarning|接收功率警告上限阈值|--|--|--|--|Double|--|--|
|PowerRXLowerThresholdWarning|接收功率警告下限阈值|--|--|--|--|Double|--|--|
|PowerClass|光模块功耗分类, 默认值为255, 分类对应功耗由光模块协议定义|--|--|--|--|U8|--|--|
|PowerCapacityWatts|光模块允许的最大额定功耗|--|瓦|--|--|Double|--|--|

##### 接口："bmc.kepler.Systems.OpticalModule.Temperature" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|ReadingCelsius|读取的芯片温度|--|--|--|--|Double|--|--|
|LowerThresholdCritical|下限阈值|--|--|--|--|Double|--|--|
|UpperThresholdCritical|上限阈值|--|--|--|--|Double|--|--|
|TemperatureLowerThresholdCritical|低温告警阈值|--|--|--|--|Double|--|--|
|TemperatureUpperThresholdCritical|高温告警阈值|--|--|--|--|Double|--|--|
|TemperatureLowerThresholdWarning|低温警告阈值|--|--|--|--|Double|--|--|
|TemperatureUpperThresholdWarning|高温警告阈值|--|--|--|--|Double|--|--|

##### 接口："bmc.kepler.Systems.OpticalModule.Voltage" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|SupplyVoltage|供电电压|--|--|--|--|Double|--|--|
|LowerThresholdCritical|下限阈值|--|--|--|--|Double|--|--|
|UpperThresholdCritical|上限阈值|--|--|--|--|Double|--|--|
|VoltageLowerThresholdCritical|低压告警阈值|--|--|--|--|Double|--|--|
|VoltageUpperThresholdCritical|高压告警阈值|--|--|--|--|Double|--|--|
|VoltageLowerThresholdWarning|低压警告阈值|--|--|--|--|Double|--|--|
|VoltageUpperThresholdWarning|高压警告阈值|--|--|--|--|Double|--|--|

##### 接口："bmc.kepler.Systems.OpticalModule.Diagnose" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|RxLossOfLock|接受方向的CDR失败状态|--|--|--|--|U8|--|--|
|TxLossOfLock|发送方向的CDR失败状态|--|--|--|--|U8|--|--|
|LaserRuntimeSeconds|激光器运行时间,单位:秒|--|秒|--|--|U32|--|--|
|LaserTemperatureCelsius|激光器管芯温度|--|--|--|--|Double|--|--|
|PowerOnCount|模块上电次数|--|--|--|--|U16|--|--|
|UptimeSeconds|模块上电时间,单位:秒|--|秒|--|--|U32|--|--|
|PowerStatus|模块上电状态|--|--|--|--|U16|--|--|
|OdspDieTemperatureCelsius|ODSP结温|--|--|--|--|Double|--|--|
|OdspHighTempRuntimeSeconds|ODSP高温运行时间,单位:秒|--|秒|--|--|U32|--|--|
|SelfTestStatus|光模块自体诊断告警状态,轻微隐患和严重故障各32bit|--|--|--|--|U64|--|--|
|MediaInterfaceFaultStatus|光链路告警状态,轻微隐患和严重故障各8bit,每个bit分别代表通道1至8状态,0代表正常,1代表有错误信息|--|--|--|--|U16|--|--|
|HostInterfaceFaultStatus|电链路告警状态,轻微隐患和严重故障各8bit,每个bit分别代表通道1至8状态,0代表正常,1代表有错误信息|--|--|--|--|U16|--|--|
|RxLoS|接收端LoS(信号丢失);每个bit对应一个通道,某个bit取值1表示是对应通道故障;当前光模块最多8通道,属性预留32位便于扩展|--|--|--|--|U32|--|--|
|TxLoS|发送端LoS(信号丢失);每个bit对应一个通道,某个bit取值1表示是对应通道故障;当前光模块最多8通道,属性预留32位便于扩展|--|--|--|--|U32|--|--|
|TxFault|发送错误;每个bit对应一个通道,某个bit取值1表示是对应通道故障;当前光模块最多8通道,属性预留32位便于扩展|--|--|--|--|U32|--|--|
|PRBSTestSupported|此光模块是否支持PRBS压测|--|--|--|--|Boolean|--|--|
|FiberDirtyDetected|光模块是否脏污|--|--|--|--|Boolean|--|--|
|FiberLoosenessDetected|光模块是否松动|--|--|--|--|Boolean|--|--|

##### 接口："bmc.kepler.Metric" 
##### 属性：无

##### 接口："bmc.kepler.Inventory.Hardware" 
##### 属性：同NetworkAdapter对象

#### 11.OpticalModuleChannel
        路径名：":parent/Channel/:ID"
        privilege: ReadOnly
        parent: "OpticalModule"
        table名: "t_optical_module_channel"
##### 接口："bmc.kepler.Systems.OpticalModule.Channel" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Id|光模块RX/TX通道号|--|--|--|--|U8|--|--|
|BiasCurrentMilliAmps|通道的偏置电流，单位毫安|--|毫安|--|--|Double|--|--|
|RXPowerMilliWatts|通道的接收功率，单位毫瓦|--|毫瓦|--|--|Double|--|--|
|TXPowerMilliWatts|通道的发送功率，单位毫瓦|--|毫瓦|--|--|Double|--|--|

#### 12.DftNCSI
        路径名："/bmc/kepler/Manufacture/PrepareTest/DftNCSI/${Id}"
        privilege: ReadOnly

##### 接口："bmc.kepler.Manufacture" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Type|装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试|--|--|--|--|U8|--|--|
|Id|装备测试项id|--|--|--|--|U8|--|--|
|Slot|槽位号|--|--|--|--|U32|--|--|
|DeviceNum|设备id|--|--|--|--|U8|--|--|
|Param|测试项传入的参数|--|--|--|--|U8[]|--|--|
|ItemName|设备名称|--|--|--|--|String|--|--|
|PrompteReady|测试前交互提示|--|--|--|--|String|--|--|
|PrompteFinish|测试完成交互提示|--|--|--|--|String|--|--|
|ProcessPeriod|测试所需时间|--|--|--|--|U16|--|--|
|Status|当前测试状态|Complete,Testing,Unstart|--|--|--|String|--|--|

#### 13.NCSI
        路径名："/bmc/kepler/Debug/Systems/${SystemId}/NCSI"
        privilege: ReadOnly
##### 接口："bmc.kepler.Debug.Systems.NCSI" 
##### 属性：无

#### 14.NetworkBridge
    路径名："/bmc/kepler/Systems/:SystemId/NetworkBridges/:ID"
    privilege: ReadOnly
    table名: t_network_bridge
##### 接口："bmc.kepler.Systems.NetworkBridge" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|Id|网桥ID|--|--|--|--|String|--|--|
|Name|网桥名称|--|--|--|--|String|--|--|

#### 15.NetworkBridgePort
    路径名："/bmc/kepler/Systems/:SystemID/NetworkBridges/:ID/Ports/:PortID"
    privilege: ReadOnly
    table名: t_network_bridge_port
##### 接口："bmc.kepler.Systems.ContainedPort" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求|
|--|--|--|--|--|--|--|--|--| 
|NodeId|包含物理网口ID|--|--|--|--|String|--|--|

#### 16.NetworkBonding
    路径名："/bmc/kepler/Systems/:SystemId/NetworkBondings/:ID"
    privilege: ReadOnly
    table名: t_network_bonding
##### 接口："bmc.kepler.Systems.NetworkBonding" 
##### 属性：
|字段|说明|约束|单位|互斥关系|依赖关系|格式样例|唯一性要求|兼容性要求| 
|--|--|--|--|--|--|--|--|--| 
|Id|Bonding ID, 由BMA获取bonding资源时生成|--|--|--|--|String|--|--| 
|Name|Bonding 名称, 在创建bonding资源时生成|--|--|--|--|String|--|--|
    
#### 17.NetworkBondingPort
    路径名："/bmc/kepler/Systems/:SystemID/NetworkBondings/:ID/Ports/:PortID"
    privilege: ReadOnly
    table名: t_network_bonding_port
##### 接口："bmc.kepler.Systems.ContainedPort" 
##### 属性：同NetworkBridgePort对象

#### 18.PRBSTest
    路径名："/bmc/kepler/Managers/:Id/DiagnosticService/PRBSTest"
##### 接口："bmc.kepler.Managers.DiagnosticService.PRBSTest" 
##### 属性：无

#### 19.NetworkAdaptersDebug
    路径名："/bmc/kepler/Debug/Systems/${SystemId}/NetworkAdaptersDebug"
    privilege: SecurityMgmt
##### 接口："bmc.kepler.Debug.Systems.NetworkAdapters" 
##### 属性：无

## 4 配置介绍
### 4.1 关键类定义
#### 4.1.1 NetworkAdapter（网卡类）
| 属性                    | 说明                                                  |
| ---------------------- | ---------------------------------------------------- |
| ID                     | 全局唯一                                               |
| NodeId                 | 与ID相同，全局唯一                                      |
| SlotNumber             | 槽位号                                                |
| Name                   | 网卡名称                                               |
| Manufacturer           | 厂商名称                                               |
| Description            | 网卡描述                                               |
| DeviceLocator          | 网卡丝印信息                                           |
| Type                   | 网卡类型:1-Lom,3-PCIe,10-OCP                           |
| <strong>Model</strong> | <strong>芯片型号，芯片型号决定了该网卡支持哪些协议</strong> |
| ChipManufacturer       | 芯片厂商                                               |
| VendorID               | 厂商ID                                                |
| DeviceID               | 设备ID                                                |
| SubsystemVendorID      | 子系统厂商ID                                           |
| SubsystemDeviceID      | 子系统设备ID                                           |
| PCBVersion             | PCB版本                                               |
#### 4.1.1 NetworkPort（网口类）
| 属性                      | 说明                                                |
| ------------------------ | --------------------------------------------------- |
| <strong>@Parent</strong> | <strong>父对象（即网卡），表示该网口属于哪张网卡</strong> |
| NodeId                   | 全局唯一                                             |
| Name                     | 网口名称                                             |
| Type                     | 网口类型                                             |
| Name                     | 网卡名称                                             |
| PortID                   | 网口ID                                              |
| MACAddress               | MAC地址                                             |
| PermanentMACAddress      | 永久MAC地址                                          |
| LinkStatus               | 网口状态                                             |
