-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ipmi = require 'manufacture.ipmi.cmds.GetTestItemCount'
local factory = require 'factory'
local mc_ipmi = require 'ipmi'
local log = require 'mc.logging'

local cc = mc_ipmi.types.Cc

local ipmi_handler = {}

function ipmi_handler.get_test_item_count(req, ctx)
    log:debug("entry to get test item count")
    local manufacture_service = factory.get_obj("manufacture_service")
    local count = manufacture_service:get_type_total(req.Type, ctx.HostId or 0)
    log:notice("get dft item type = %d num is %d", req.Type, count)
    return ipmi.GetTestItemCountRsp.new(cc.Success, count)
end

return ipmi_handler