-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


-- Create: 2023-05-16

local class = require 'mc.class'
local ipmi_message = require 'manufacture.ipmi.ipmi'
local ipmi_get_process_time = require 'ipmi_dft_cmd.get_process_time'
local ipmi_test_count = require 'ipmi_dft_cmd.test_count'
local ipmi_clear_cmos = require 'ipmi_dft_cmd.clear_cmos'
local ipmi_get_test_type = require 'ipmi_dft_cmd.get_test_type'
local ipmi_set_test_type = require 'ipmi_dft_cmd.set_test_type'
local ipmi_set_chip_info = require 'ipmi_dft_cmd.set_chip_info'
local ipmi_get_chip_info = require 'ipmi_dft_cmd.get_chip_info'
local ipmi_ddr_test = require 'ipmi_dft_cmd.ipmi_ddr_test'
local manufacture_dft = require 'manufacture_dft'
local object_manage = require 'mc.mdb.object_manage'
local log = require 'mc.logging'
local manufacture_app = class()
function manufacture_app.new(app)
    return setmetatable({app = app}, manufacture_app)
end

function manufacture_app:register_ipmi()
    self.app:register_ipmi_cmd(ipmi_message.GetProcessTime, ipmi_get_process_time.get_process_time)
    self.app:register_ipmi_cmd(ipmi_message.SetChipInfo, ipmi_set_chip_info.set_chip_info)
    self.app:register_ipmi_cmd(ipmi_message.GetChipInfo, ipmi_get_chip_info.get_chip_info)
    self.app:register_ipmi_cmd(ipmi_message.SetTestCount, ipmi_test_count.set_test_count)
    self.app:register_ipmi_cmd(ipmi_message.GetTestCount, ipmi_test_count.get_test_count)
    self.app:register_ipmi_cmd(ipmi_message.ClearCmos, ipmi_clear_cmos.clear_cmos)
    self.app:register_ipmi_cmd(ipmi_message.GetTestType, ipmi_get_test_type.get_test_type)
    self.app:register_ipmi_cmd(ipmi_message.SetTestType, ipmi_set_test_type.set_test_type)
    self.app:register_ipmi_cmd(ipmi_message.SetDdrTestConfiguration, ipmi_ddr_test.set_test_configuration)
    self.app:register_ipmi_cmd(ipmi_message.GetDdrTestResult, ipmi_ddr_test.get_test_result)
end

function manufacture_app:on_add_object(class_name, object, position)
    if class_name == 'DftCfgMgmt' then
        log:notice('package name is (%s)', object.DftPackageFilename)
        manufacture_dft:enter_fs_st( object.DftPackageFilename)
    end
end

function manufacture_app:init()
    self:register_ipmi()
    ipmi_ddr_test.restore_default_env()
    object_manage.on_add_object(self.app.bus, function(class_name, object, position)
        self:on_add_object(class_name, object, position)
    end)
end

return manufacture_app