-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetworkAdapter = {}

---@class NetworkAdapter.DumpBlackBoxRsp
---@field TaskId integer
local TDumpBlackBoxRsp = {}
TDumpBlackBoxRsp.__index = TDumpBlackBoxRsp
TDumpBlackBoxRsp.group = {}

local function TDumpBlackBoxRsp_from_obj(obj)
    return setmetatable(obj, TDumpBlackBoxRsp)
end

function TDumpBlackBoxRsp.new(TaskId)
    return TDumpBlackBoxRsp_from_obj({TaskId = TaskId})
end
---@param obj NetworkAdapter.DumpBlackBoxRsp
function TDumpBlackBoxRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDumpBlackBoxRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpBlackBoxRsp.group)
end

TDumpBlackBoxRsp.from_obj = TDumpBlackBoxRsp_from_obj

TDumpBlackBoxRsp.proto_property = {'TaskId'}

TDumpBlackBoxRsp.default = {0}

TDumpBlackBoxRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDumpBlackBoxRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDumpBlackBoxRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpBlackBoxRsp.proto_property, errs, need_convert)
    return self
end

function TDumpBlackBoxRsp:unpack(_)
    return self.TaskId
end

NetworkAdapter.DumpBlackBoxRsp = TDumpBlackBoxRsp

---@class NetworkAdapter.DumpBlackBoxReq
---@field Path string
local TDumpBlackBoxReq = {}
TDumpBlackBoxReq.__index = TDumpBlackBoxReq
TDumpBlackBoxReq.group = {}

local function TDumpBlackBoxReq_from_obj(obj)
    return setmetatable(obj, TDumpBlackBoxReq)
end

function TDumpBlackBoxReq.new(Path)
    return TDumpBlackBoxReq_from_obj({Path = Path})
end
---@param obj NetworkAdapter.DumpBlackBoxReq
function TDumpBlackBoxReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TDumpBlackBoxReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpBlackBoxReq.group)
end

TDumpBlackBoxReq.from_obj = TDumpBlackBoxReq_from_obj

TDumpBlackBoxReq.proto_property = {'Path'}

TDumpBlackBoxReq.default = {''}

TDumpBlackBoxReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TDumpBlackBoxReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)

    TDumpBlackBoxReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpBlackBoxReq.proto_property, errs, need_convert)
    return self
end

function TDumpBlackBoxReq:unpack(_)
    return self.Path
end

NetworkAdapter.DumpBlackBoxReq = TDumpBlackBoxReq

---@class NetworkAdapter.StartRemovingDeviceRsp
local TStartRemovingDeviceRsp = {}
TStartRemovingDeviceRsp.__index = TStartRemovingDeviceRsp
TStartRemovingDeviceRsp.group = {}

local function TStartRemovingDeviceRsp_from_obj(obj)
    return setmetatable(obj, TStartRemovingDeviceRsp)
end

function TStartRemovingDeviceRsp.new()
    return TStartRemovingDeviceRsp_from_obj({})
end
---@param obj NetworkAdapter.StartRemovingDeviceRsp
function TStartRemovingDeviceRsp:init_from_obj(obj)

end

function TStartRemovingDeviceRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRemovingDeviceRsp.group)
end

TStartRemovingDeviceRsp.from_obj = TStartRemovingDeviceRsp_from_obj

TStartRemovingDeviceRsp.proto_property = {}

TStartRemovingDeviceRsp.default = {}

TStartRemovingDeviceRsp.struct = {}

function TStartRemovingDeviceRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartRemovingDeviceRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRemovingDeviceRsp.proto_property, errs, need_convert)
    return self
end

function TStartRemovingDeviceRsp:unpack(_)
end

NetworkAdapter.StartRemovingDeviceRsp = TStartRemovingDeviceRsp

---@class NetworkAdapter.StartRemovingDeviceReq
---@field ID string
local TStartRemovingDeviceReq = {}
TStartRemovingDeviceReq.__index = TStartRemovingDeviceReq
TStartRemovingDeviceReq.group = {}

local function TStartRemovingDeviceReq_from_obj(obj)
    return setmetatable(obj, TStartRemovingDeviceReq)
end

function TStartRemovingDeviceReq.new(ID)
    return TStartRemovingDeviceReq_from_obj({ID = ID})
end
---@param obj NetworkAdapter.StartRemovingDeviceReq
function TStartRemovingDeviceReq:init_from_obj(obj)
    self.ID = obj.ID
end

function TStartRemovingDeviceReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRemovingDeviceReq.group)
end

TStartRemovingDeviceReq.from_obj = TStartRemovingDeviceReq_from_obj

TStartRemovingDeviceReq.proto_property = {'ID'}

TStartRemovingDeviceReq.default = {''}

TStartRemovingDeviceReq.struct = {{name = 'ID', is_array = false, struct = nil}}

function TStartRemovingDeviceReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ID', self.ID, 'string', false, errs, need_convert)

    TStartRemovingDeviceReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRemovingDeviceReq.proto_property, errs, need_convert)
    return self
end

function TStartRemovingDeviceReq:unpack(_)
    return self.ID
end

NetworkAdapter.StartRemovingDeviceReq = TStartRemovingDeviceReq

NetworkAdapter.interface = mdb.register_interface('bmc.kepler.Systems.NetworkAdapter', {
    ID = {'s', nil, true, nil},
    SystemID = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    DisplayName = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Description = {'s', nil, true, nil},
    Position = {'s', nil, true, nil},
    DeviceLocator = {'s', nil, true, nil},
    Type = {'y', nil, true, nil},
    NetworkPortCount = {'y', nil, true, nil},
    Model = {'s', nil, true, nil},
    ChipVendor = {'s', nil, true, nil},
    ModelDescription = {'s', nil, true, nil},
    ChipManufacturer = {'s', nil, true, nil},
    DriverName = {'s', nil, true, nil},
    DriverVersion = {'s', nil, true, nil},
    SlotNumber = {'y', nil, true, nil},
    NetDevFuncCapabilities = {'y', nil, true, nil},
    RootBDF = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    VendorID = {'s', nil, true, nil},
    DeviceID = {'s', nil, true, nil},
    SubsystemVendorID = {'s', nil, true, nil},
    SubsystemDeviceID = {'s', nil, true, nil},
    BoardID = {'q', nil, true, nil},
    BoardName = {'s', nil, true, nil},
    BoardIDHex = {'s', nil, true, nil},
    ComponentUniqueID = {'s', nil, true, nil},
    PCBVersion = {'s', nil, true, nil},
    AssociatedResource = {'s', nil, true, nil},
    SupportedMctp = {'b', nil, true, nil},
    HotPluggable = {'b', nil, true, nil},
    ReadyToRemove = {'b', nil, true, nil},
    AttentionHotPlugState = {'y', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    PreviousSerialNumber = {'s', nil, true, nil},
    TemperatureCelsius = {'n', {['volatile'] = true, ['emitsChangedSignal'] = 'true'}, true, nil},
    TemperatureStatus = {'y', nil, true, nil},
    MaxOperatingTemperatureCelsius = {'q', nil, true, nil},
    LLDPSupported = {'b', nil, true, nil},
    FruId = {'y', nil, true, nil},
    PredictiveFault = {'y', nil, false, nil},
    DiagnosticFault = {'y', nil, false, nil},
    ReplacedFlag = {'y', nil, true, nil},
    SupportedLLDP = {'b', nil, true, nil},
    ParentCardSlotId = {'y', nil, true, nil},
    PfMacInfo = {'a(qqs)', nil, true, nil},
    BandwidthThresholdPercent = {'q', nil, true, nil},
    NodeId = {'s', nil, true, nil}
}, {
    StartRemovingDevice = {'a{ss}s', '', TStartRemovingDeviceReq, TStartRemovingDeviceRsp},
    DumpBlackBox = {'a{ss}s', 'u', TDumpBlackBoxReq, TDumpBlackBoxRsp}
}, {})

return NetworkAdapter
