-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Manufacture = {}

---@class Manufacture.GetResultRsp
---@field Status string
---@field Description string
local TGetResultRsp = {}
TGetResultRsp.__index = TGetResultRsp
TGetResultRsp.group = {}

local function TGetResultRsp_from_obj(obj)
    return setmetatable(obj, TGetResultRsp)
end

function TGetResultRsp.new(Status, Description)
    return TGetResultRsp_from_obj({Status = Status, Description = Description})
end
---@param obj Manufacture.GetResultRsp
function TGetResultRsp:init_from_obj(obj)
    self.Status = obj.Status
    self.Description = obj.Description
end

function TGetResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultRsp.group)
end

TGetResultRsp.from_obj = TGetResultRsp_from_obj

TGetResultRsp.proto_property = {'Status', 'Description'}

TGetResultRsp.default = {'', ''}

TGetResultRsp.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'Description', is_array = false, struct = nil}
}

function TGetResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Description', self.Description, 'string', false, errs, need_convert)

    if self.Status ~= nil then
        validate.Enum(prefix .. 'Status', self.Status, '', {'Succeed', 'Failed', 'Non'}, errs, need_convert)
    end

    TGetResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetResultRsp:unpack(_)
    return self.Status, self.Description
end

Manufacture.GetResultRsp = TGetResultRsp

---@class Manufacture.GetResultReq
local TGetResultReq = {}
TGetResultReq.__index = TGetResultReq
TGetResultReq.group = {}

local function TGetResultReq_from_obj(obj)
    return setmetatable(obj, TGetResultReq)
end

function TGetResultReq.new()
    return TGetResultReq_from_obj({})
end
---@param obj Manufacture.GetResultReq
function TGetResultReq:init_from_obj(obj)

end

function TGetResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultReq.group)
end

TGetResultReq.from_obj = TGetResultReq_from_obj

TGetResultReq.proto_property = {}

TGetResultReq.default = {}

TGetResultReq.struct = {}

function TGetResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultReq.proto_property, errs, need_convert)
    return self
end

function TGetResultReq:unpack(_)
end

Manufacture.GetResultReq = TGetResultReq

---@class Manufacture.StopRsp
local TStopRsp = {}
TStopRsp.__index = TStopRsp
TStopRsp.group = {}

local function TStopRsp_from_obj(obj)
    return setmetatable(obj, TStopRsp)
end

function TStopRsp.new()
    return TStopRsp_from_obj({})
end
---@param obj Manufacture.StopRsp
function TStopRsp:init_from_obj(obj)

end

function TStopRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStopRsp.group)
end

TStopRsp.from_obj = TStopRsp_from_obj

TStopRsp.proto_property = {}

TStopRsp.default = {}

TStopRsp.struct = {}

function TStopRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStopRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStopRsp.proto_property, errs, need_convert)
    return self
end

function TStopRsp:unpack(_)
end

Manufacture.StopRsp = TStopRsp

---@class Manufacture.StopReq
local TStopReq = {}
TStopReq.__index = TStopReq
TStopReq.group = {}

local function TStopReq_from_obj(obj)
    return setmetatable(obj, TStopReq)
end

function TStopReq.new()
    return TStopReq_from_obj({})
end
---@param obj Manufacture.StopReq
function TStopReq:init_from_obj(obj)

end

function TStopReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStopReq.group)
end

TStopReq.from_obj = TStopReq_from_obj

TStopReq.proto_property = {}

TStopReq.default = {}

TStopReq.struct = {}

function TStopReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStopReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStopReq.proto_property, errs, need_convert)
    return self
end

function TStopReq:unpack(_)
end

Manufacture.StopReq = TStopReq

---@class Manufacture.StartRsp
local TStartRsp = {}
TStartRsp.__index = TStartRsp
TStartRsp.group = {}

local function TStartRsp_from_obj(obj)
    return setmetatable(obj, TStartRsp)
end

function TStartRsp.new()
    return TStartRsp_from_obj({})
end
---@param obj Manufacture.StartRsp
function TStartRsp:init_from_obj(obj)

end

function TStartRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartRsp.group)
end

TStartRsp.from_obj = TStartRsp_from_obj

TStartRsp.proto_property = {}

TStartRsp.default = {}

TStartRsp.struct = {}

function TStartRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartRsp.proto_property, errs, need_convert)
    return self
end

function TStartRsp:unpack(_)
end

Manufacture.StartRsp = TStartRsp

---@class Manufacture.StartReq
local TStartReq = {}
TStartReq.__index = TStartReq
TStartReq.group = {}

local function TStartReq_from_obj(obj)
    return setmetatable(obj, TStartReq)
end

function TStartReq.new()
    return TStartReq_from_obj({})
end
---@param obj Manufacture.StartReq
function TStartReq:init_from_obj(obj)

end

function TStartReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartReq.group)
end

TStartReq.from_obj = TStartReq_from_obj

TStartReq.proto_property = {}

TStartReq.default = {}

TStartReq.struct = {}

function TStartReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartReq.proto_property, errs, need_convert)
    return self
end

function TStartReq:unpack(_)
end

Manufacture.StartReq = TStartReq

Manufacture.interface = mdb.register_interface('bmc.kepler.Manufacture', {
    Type = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Id = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Slot = {'u', {['emitsChangedSignal'] = 'false'}, true, nil},
    DeviceNum = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    Param = {'ay', {['emitsChangedSignal'] = 'false'}, false, nil},
    ItemName = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    PrompteReady = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    PrompteFinish = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ProcessPeriod = {'q', {['emitsChangedSignal'] = 'false'}, true, nil},
    Status = {'s', {['emitsChangedSignal'] = 'false'}, true, 'Unstart'}
}, {
    Start = {'a{ss}', '', TStartReq, TStartRsp},
    Stop = {'a{ss}', '', TStopReq, TStopRsp},
    GetResult = {'a{ss}', 'ss', TGetResultReq, TGetResultRsp}
}, {})

return Manufacture
