-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ManagerVersion = {}

---@class ManagerVersion.GetReleaseVersionRsp
---@field ActiveReleaseVersion string
---@field BackupReleaseVersion string
---@field AvailableReleaseVersion string
local TGetReleaseVersionRsp = {}
TGetReleaseVersionRsp.__index = TGetReleaseVersionRsp
TGetReleaseVersionRsp.group = {}

local function TGetReleaseVersionRsp_from_obj(obj)
    return setmetatable(obj, TGetReleaseVersionRsp)
end

function TGetReleaseVersionRsp.new(ActiveReleaseVersion, BackupReleaseVersion, AvailableReleaseVersion)
    return TGetReleaseVersionRsp_from_obj({
        ActiveReleaseVersion = ActiveReleaseVersion,
        BackupReleaseVersion = BackupReleaseVersion,
        AvailableReleaseVersion = AvailableReleaseVersion
    })
end
---@param obj ManagerVersion.GetReleaseVersionRsp
function TGetReleaseVersionRsp:init_from_obj(obj)
    self.ActiveReleaseVersion = obj.ActiveReleaseVersion
    self.BackupReleaseVersion = obj.BackupReleaseVersion
    self.AvailableReleaseVersion = obj.AvailableReleaseVersion
end

function TGetReleaseVersionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReleaseVersionRsp.group)
end

TGetReleaseVersionRsp.from_obj = TGetReleaseVersionRsp_from_obj

TGetReleaseVersionRsp.proto_property = {'ActiveReleaseVersion', 'BackupReleaseVersion', 'AvailableReleaseVersion'}

TGetReleaseVersionRsp.default = {'', '', ''}

TGetReleaseVersionRsp.struct = {
    {name = 'ActiveReleaseVersion', is_array = false, struct = nil},
    {name = 'BackupReleaseVersion', is_array = false, struct = nil},
    {name = 'AvailableReleaseVersion', is_array = false, struct = nil}
}

function TGetReleaseVersionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ActiveReleaseVersion', self.ActiveReleaseVersion, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'BackupReleaseVersion', self.BackupReleaseVersion, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'AvailableReleaseVersion', self.AvailableReleaseVersion, 'string', false, errs,
        need_convert)

    TGetReleaseVersionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReleaseVersionRsp.proto_property, errs, need_convert)
    return self
end

function TGetReleaseVersionRsp:unpack(_)
    return self.ActiveReleaseVersion, self.BackupReleaseVersion, self.AvailableReleaseVersion
end

ManagerVersion.GetReleaseVersionRsp = TGetReleaseVersionRsp

---@class ManagerVersion.GetReleaseVersionReq
local TGetReleaseVersionReq = {}
TGetReleaseVersionReq.__index = TGetReleaseVersionReq
TGetReleaseVersionReq.group = {}

local function TGetReleaseVersionReq_from_obj(obj)
    return setmetatable(obj, TGetReleaseVersionReq)
end

function TGetReleaseVersionReq.new()
    return TGetReleaseVersionReq_from_obj({})
end
---@param obj ManagerVersion.GetReleaseVersionReq
function TGetReleaseVersionReq:init_from_obj(obj)

end

function TGetReleaseVersionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReleaseVersionReq.group)
end

TGetReleaseVersionReq.from_obj = TGetReleaseVersionReq_from_obj

TGetReleaseVersionReq.proto_property = {}

TGetReleaseVersionReq.default = {}

TGetReleaseVersionReq.struct = {}

function TGetReleaseVersionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetReleaseVersionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReleaseVersionReq.proto_property, errs, need_convert)
    return self
end

function TGetReleaseVersionReq:unpack(_)
end

ManagerVersion.GetReleaseVersionReq = TGetReleaseVersionReq

ManagerVersion.interface = mdb.register_interface('bmc.kepler.UpdateService.ManagerVersion', {
    PlatformMajorVersion = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    MajorVersion = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    MinorVersion = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    Version = {'s', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {GetReleaseVersion = {'a{ss}', 'sss', TGetReleaseVersionReq, TGetReleaseVersionRsp}}, {})

return ManagerVersion
