-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local DPUCard = {}

---@class DPUCard.SystemBootStatus: Enum
local ESystemBootStatus = create_enum_type('SystemBootStatus')
ESystemBootStatus.default = ESystemBootStatus.new(2147483647)
ESystemBootStatus.struct = nil
ESystemBootStatus.OSBootNotStarted = ESystemBootStatus.new(0)
ESystemBootStatus.OSBootStarting = ESystemBootStatus.new(1)
ESystemBootStatus.OSBootFailed = ESystemBootStatus.new(2)
ESystemBootStatus.OSBootCompleted = ESystemBootStatus.new(3)
ESystemBootStatus.OSBootTimeout = ESystemBootStatus.new(4)
ESystemBootStatus.NoBootableDevice = ESystemBootStatus.new(5)

DPUCard.SystemBootStatus = ESystemBootStatus

---@class DPUCard.SetLLDPStatusRsp
local TSetLLDPStatusRsp = {}
TSetLLDPStatusRsp.__index = TSetLLDPStatusRsp
TSetLLDPStatusRsp.group = {}

local function TSetLLDPStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetLLDPStatusRsp)
end

function TSetLLDPStatusRsp.new()
    return TSetLLDPStatusRsp_from_obj({})
end
---@param obj DPUCard.SetLLDPStatusRsp
function TSetLLDPStatusRsp:init_from_obj(obj)

end

function TSetLLDPStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLLDPStatusRsp.group)
end

TSetLLDPStatusRsp.from_obj = TSetLLDPStatusRsp_from_obj

TSetLLDPStatusRsp.proto_property = {}

TSetLLDPStatusRsp.default = {}

TSetLLDPStatusRsp.struct = {}

function TSetLLDPStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetLLDPStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLLDPStatusRsp.proto_property, errs, need_convert)
    return self
end

function TSetLLDPStatusRsp:unpack(_)
end

DPUCard.SetLLDPStatusRsp = TSetLLDPStatusRsp

---@class DPUCard.SetLLDPStatusReq
---@field PortId integer
---@field Status integer
local TSetLLDPStatusReq = {}
TSetLLDPStatusReq.__index = TSetLLDPStatusReq
TSetLLDPStatusReq.group = {}

local function TSetLLDPStatusReq_from_obj(obj)
    return setmetatable(obj, TSetLLDPStatusReq)
end

function TSetLLDPStatusReq.new(PortId, Status)
    return TSetLLDPStatusReq_from_obj({PortId = PortId, Status = Status})
end
---@param obj DPUCard.SetLLDPStatusReq
function TSetLLDPStatusReq:init_from_obj(obj)
    self.PortId = obj.PortId
    self.Status = obj.Status
end

function TSetLLDPStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLLDPStatusReq.group)
end

TSetLLDPStatusReq.from_obj = TSetLLDPStatusReq_from_obj

TSetLLDPStatusReq.proto_property = {'PortId', 'Status'}

TSetLLDPStatusReq.default = {0, 0}

TSetLLDPStatusReq.struct = {
    {name = 'PortId', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TSetLLDPStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetLLDPStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLLDPStatusReq.proto_property, errs, need_convert)
    return self
end

function TSetLLDPStatusReq:unpack(_)
    return self.PortId, self.Status
end

DPUCard.SetLLDPStatusReq = TSetLLDPStatusReq

---@class DPUCard.GetLLDPStatusRsp
---@field Status integer
local TGetLLDPStatusRsp = {}
TGetLLDPStatusRsp.__index = TGetLLDPStatusRsp
TGetLLDPStatusRsp.group = {}

local function TGetLLDPStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetLLDPStatusRsp)
end

function TGetLLDPStatusRsp.new(Status)
    return TGetLLDPStatusRsp_from_obj({Status = Status})
end
---@param obj DPUCard.GetLLDPStatusRsp
function TGetLLDPStatusRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TGetLLDPStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLLDPStatusRsp.group)
end

TGetLLDPStatusRsp.from_obj = TGetLLDPStatusRsp_from_obj

TGetLLDPStatusRsp.proto_property = {'Status'}

TGetLLDPStatusRsp.default = {0}

TGetLLDPStatusRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TGetLLDPStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TGetLLDPStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLLDPStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetLLDPStatusRsp:unpack(_)
    return self.Status
end

DPUCard.GetLLDPStatusRsp = TGetLLDPStatusRsp

---@class DPUCard.GetLLDPStatusReq
---@field PortId integer
local TGetLLDPStatusReq = {}
TGetLLDPStatusReq.__index = TGetLLDPStatusReq
TGetLLDPStatusReq.group = {}

local function TGetLLDPStatusReq_from_obj(obj)
    return setmetatable(obj, TGetLLDPStatusReq)
end

function TGetLLDPStatusReq.new(PortId)
    return TGetLLDPStatusReq_from_obj({PortId = PortId})
end
---@param obj DPUCard.GetLLDPStatusReq
function TGetLLDPStatusReq:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TGetLLDPStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLLDPStatusReq.group)
end

TGetLLDPStatusReq.from_obj = TGetLLDPStatusReq_from_obj

TGetLLDPStatusReq.proto_property = {'PortId'}

TGetLLDPStatusReq.default = {0}

TGetLLDPStatusReq.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TGetLLDPStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)

    TGetLLDPStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLLDPStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetLLDPStatusReq:unpack(_)
    return self.PortId
end

DPUCard.GetLLDPStatusReq = TGetLLDPStatusReq

---@class DPUCard.ImportPublicKeyRsp
local TImportPublicKeyRsp = {}
TImportPublicKeyRsp.__index = TImportPublicKeyRsp
TImportPublicKeyRsp.group = {}

local function TImportPublicKeyRsp_from_obj(obj)
    return setmetatable(obj, TImportPublicKeyRsp)
end

function TImportPublicKeyRsp.new()
    return TImportPublicKeyRsp_from_obj({})
end
---@param obj DPUCard.ImportPublicKeyRsp
function TImportPublicKeyRsp:init_from_obj(obj)

end

function TImportPublicKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportPublicKeyRsp.group)
end

TImportPublicKeyRsp.from_obj = TImportPublicKeyRsp_from_obj

TImportPublicKeyRsp.proto_property = {}

TImportPublicKeyRsp.default = {}

TImportPublicKeyRsp.struct = {}

function TImportPublicKeyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportPublicKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportPublicKeyRsp.proto_property, errs, need_convert)
    return self
end

function TImportPublicKeyRsp:unpack(_)
end

DPUCard.ImportPublicKeyRsp = TImportPublicKeyRsp

---@class DPUCard.ImportPublicKeyReq
---@field Type string
---@field Content string
local TImportPublicKeyReq = {}
TImportPublicKeyReq.__index = TImportPublicKeyReq
TImportPublicKeyReq.group = {}

local function TImportPublicKeyReq_from_obj(obj)
    return setmetatable(obj, TImportPublicKeyReq)
end

function TImportPublicKeyReq.new(Type, Content)
    return TImportPublicKeyReq_from_obj({Type = Type, Content = Content})
end
---@param obj DPUCard.ImportPublicKeyReq
function TImportPublicKeyReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Content = obj.Content
end

function TImportPublicKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportPublicKeyReq.group)
end

TImportPublicKeyReq.from_obj = TImportPublicKeyReq_from_obj

TImportPublicKeyReq.proto_property = {'Type', 'Content'}

TImportPublicKeyReq.default = {'', ''}

TImportPublicKeyReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Content', is_array = false, struct = nil}
}

function TImportPublicKeyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Content', self.Content, 'string', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {'URI', 'text'}, errs, need_convert)
    end

    TImportPublicKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportPublicKeyReq.proto_property, errs, need_convert)
    return self
end

function TImportPublicKeyReq:unpack(_)
    return self.Type, self.Content
end

DPUCard.ImportPublicKeyReq = TImportPublicKeyReq

---@class DPUCard.SetBootOptionRsp
local TSetBootOptionRsp = {}
TSetBootOptionRsp.__index = TSetBootOptionRsp
TSetBootOptionRsp.group = {}

local function TSetBootOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetBootOptionRsp)
end

function TSetBootOptionRsp.new()
    return TSetBootOptionRsp_from_obj({})
end
---@param obj DPUCard.SetBootOptionRsp
function TSetBootOptionRsp:init_from_obj(obj)

end

function TSetBootOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionRsp.group)
end

TSetBootOptionRsp.from_obj = TSetBootOptionRsp_from_obj

TSetBootOptionRsp.proto_property = {}

TSetBootOptionRsp.default = {}

TSetBootOptionRsp.struct = {}

function TSetBootOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBootOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionRsp:unpack(_)
end

DPUCard.SetBootOptionRsp = TSetBootOptionRsp

---@class DPUCard.SetBootOptionReq
---@field Mode integer
---@field Enabled integer
local TSetBootOptionReq = {}
TSetBootOptionReq.__index = TSetBootOptionReq
TSetBootOptionReq.group = {}

local function TSetBootOptionReq_from_obj(obj)
    return setmetatable(obj, TSetBootOptionReq)
end

function TSetBootOptionReq.new(Mode, Enabled)
    return TSetBootOptionReq_from_obj({Mode = Mode, Enabled = Enabled})
end
---@param obj DPUCard.SetBootOptionReq
function TSetBootOptionReq:init_from_obj(obj)
    self.Mode = obj.Mode
    self.Enabled = obj.Enabled
end

function TSetBootOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionReq.group)
end

TSetBootOptionReq.from_obj = TSetBootOptionReq_from_obj

TSetBootOptionReq.proto_property = {'Mode', 'Enabled'}

TSetBootOptionReq.default = {0, 0}

TSetBootOptionReq.struct = {
    {name = 'Mode', is_array = false, struct = nil}, {name = 'Enabled', is_array = false, struct = nil}
}

function TSetBootOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs, need_convert)

    if self.Mode ~= nil then
        validate.Enum(prefix .. 'Mode', self.Mode, '', {0, 1, 2}, errs, need_convert)
    end
    if self.Enabled ~= nil then
        validate.Enum(prefix .. 'Enabled', self.Enabled, '', {0, 1}, errs, need_convert)
    end

    TSetBootOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionReq.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionReq:unpack(_)
    return self.Mode, self.Enabled
end

DPUCard.SetBootOptionReq = TSetBootOptionReq

---@class DPUCard.SetPowerStateRsp
local TSetPowerStateRsp = {}
TSetPowerStateRsp.__index = TSetPowerStateRsp
TSetPowerStateRsp.group = {}

local function TSetPowerStateRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerStateRsp)
end

function TSetPowerStateRsp.new()
    return TSetPowerStateRsp_from_obj({})
end
---@param obj DPUCard.SetPowerStateRsp
function TSetPowerStateRsp:init_from_obj(obj)

end

function TSetPowerStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerStateRsp.group)
end

TSetPowerStateRsp.from_obj = TSetPowerStateRsp_from_obj

TSetPowerStateRsp.proto_property = {}

TSetPowerStateRsp.default = {}

TSetPowerStateRsp.struct = {}

function TSetPowerStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPowerStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerStateRsp:unpack(_)
end

DPUCard.SetPowerStateRsp = TSetPowerStateRsp

---@class DPUCard.SetPowerStateReq
---@field PowerState integer
local TSetPowerStateReq = {}
TSetPowerStateReq.__index = TSetPowerStateReq
TSetPowerStateReq.group = {}

local function TSetPowerStateReq_from_obj(obj)
    return setmetatable(obj, TSetPowerStateReq)
end

function TSetPowerStateReq.new(PowerState)
    return TSetPowerStateReq_from_obj({PowerState = PowerState})
end
---@param obj DPUCard.SetPowerStateReq
function TSetPowerStateReq:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TSetPowerStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerStateReq.group)
end

TSetPowerStateReq.from_obj = TSetPowerStateReq_from_obj

TSetPowerStateReq.proto_property = {'PowerState'}

TSetPowerStateReq.default = {0}

TSetPowerStateReq.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TSetPowerStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', false, errs, need_convert)

    TSetPowerStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerStateReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerStateReq:unpack(_)
    return self.PowerState
end

DPUCard.SetPowerStateReq = TSetPowerStateReq

---@class DPUCard.ResetRsp
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new()
    return TResetRsp_from_obj({})
end
---@param obj DPUCard.ResetRsp
function TResetRsp:init_from_obj(obj)

end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {}

TResetRsp.default = {}

TResetRsp.struct = {}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
end

DPUCard.ResetRsp = TResetRsp

---@class DPUCard.ResetReq
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new()
    return TResetReq_from_obj({})
end
---@param obj DPUCard.ResetReq
function TResetReq:init_from_obj(obj)

end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {}

TResetReq.default = {}

TResetReq.struct = {}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
end

DPUCard.ResetReq = TResetReq

---@class DPUCard.SetDpuNmiRsp
local TSetDpuNmiRsp = {}
TSetDpuNmiRsp.__index = TSetDpuNmiRsp
TSetDpuNmiRsp.group = {}

local function TSetDpuNmiRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuNmiRsp)
end

function TSetDpuNmiRsp.new()
    return TSetDpuNmiRsp_from_obj({})
end
---@param obj DPUCard.SetDpuNmiRsp
function TSetDpuNmiRsp:init_from_obj(obj)

end

function TSetDpuNmiRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuNmiRsp.group)
end

TSetDpuNmiRsp.from_obj = TSetDpuNmiRsp_from_obj

TSetDpuNmiRsp.proto_property = {}

TSetDpuNmiRsp.default = {}

TSetDpuNmiRsp.struct = {}

function TSetDpuNmiRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDpuNmiRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuNmiRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuNmiRsp:unpack(_)
end

DPUCard.SetDpuNmiRsp = TSetDpuNmiRsp

---@class DPUCard.SetDpuNmiReq
---@field SlotId integer
local TSetDpuNmiReq = {}
TSetDpuNmiReq.__index = TSetDpuNmiReq
TSetDpuNmiReq.group = {}

local function TSetDpuNmiReq_from_obj(obj)
    return setmetatable(obj, TSetDpuNmiReq)
end

function TSetDpuNmiReq.new(SlotId)
    return TSetDpuNmiReq_from_obj({SlotId = SlotId})
end
---@param obj DPUCard.SetDpuNmiReq
function TSetDpuNmiReq:init_from_obj(obj)
    self.SlotId = obj.SlotId
end

function TSetDpuNmiReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuNmiReq.group)
end

TSetDpuNmiReq.from_obj = TSetDpuNmiReq_from_obj

TSetDpuNmiReq.proto_property = {'SlotId'}

TSetDpuNmiReq.default = {0}

TSetDpuNmiReq.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSetDpuNmiReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)

    TSetDpuNmiReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuNmiReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuNmiReq:unpack(_)
    return self.SlotId
end

DPUCard.SetDpuNmiReq = TSetDpuNmiReq

DPUCard.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard', {
    BootSourceOverrideMode = {'y', nil, true, nil},
    PxeOption = {'s', nil, false, nil},
    UUID = {'s', nil, true, nil},
    StorageIpAddr = {'s', nil, true, nil},
    StorageIpVlan = {'q', nil, true, nil},
    M2SlotMaxCount = {'y', nil, true, nil},
    M2SlotPresence = {'y', nil, true, nil},
    NetworkAdapterMaxCount = {'y', nil, true, nil},
    NetworkAdapterPresence = {'y', nil, true, nil},
    MCUVersion = {'s', nil, true, nil},
    SRVersion = {'s', nil, true, nil},
    UID = {'s', nil, true, nil},
    PfMacInfo = {'a(qqs)', nil, true, nil},
    BootSourceOverrideEnabled = {'y', nil, true, nil},
    Model = {'s', nil, true, nil},
    SystemLoadedStatus = {'i', {['emitsChangedSignal'] = 'true'}, true, nil},
    MRCLogLevel = {'y', nil, false, nil},
    UEFILogLevel = {'y', nil, false, nil},
    LogicVersion = {'s', nil, true, nil},
    MultiLogicVersion = {'a{ss}', {['emitsChangedSignal'] = 'false'}, true, nil},
    CPLDCount = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PowerState = {'s', {['emitsChangedSignal'] = 'true'}, true, 'Off'},
    VrdVersion = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    MPUBusyStatus = {'y', {['emitsChangedSignal'] = 'true'}, false, nil},
    OSSupported = {'b', {['emitsChangedSignal'] = 'false'}, true, true}
}, {
    SetDpuNmi = {'a{ss}y', '', TSetDpuNmiReq, TSetDpuNmiRsp},
    Reset = {'a{ss}', '', TResetReq, TResetRsp},
    SetPowerState = {'a{ss}y', '', TSetPowerStateReq, TSetPowerStateRsp},
    SetBootOption = {'a{ss}yy', '', TSetBootOptionReq, TSetBootOptionRsp},
    ImportPublicKey = {'a{ss}ss', '', TImportPublicKeyReq, TImportPublicKeyRsp},
    GetLLDPStatus = {'a{ss}y', 'y', TGetLLDPStatusReq, TGetLLDPStatusRsp},
    SetLLDPStatus = {'a{ss}yy', '', TSetLLDPStatusReq, TSetLLDPStatusRsp}
}, {})

return DPUCard
